/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *UTctime (time_t *timer, int format)

Purpose:
  Convert a time value to a date/time string

Description:
  This routine converts a time value to date/time string in a number of
  standard formats.  Formats 0, 1 and 2 are in local time.  Format 0 is the
  standard C-language format (without the trailing newline character).
  Format 1 includes the time zone abbreviation.  Formats 0 and 1 use English
  abbreviations for the day of the week and the month.  Format 2 avoids
  language dependent names (except for the time-zone code).  Format 3 gives the
  date and time in GMT (Universal Coordinated Time).  All fields are fixed
  length, except possibly the time zone abbreviation.  The conversion process
  produces no more than 29 characters plus the terminating null character.
  This length allows for at least a 4 character representation of the time
  zone abbreviation.

  Format  Example                       time zone    length
    0    Sun Sep 16 01:03:52 1973      local time   24 characters + null
    1    Sun Sep 16 01:03:52 EST 1973  local time   28* characters + null
    2    1994/01/23 09:59:53 EST       local time   23* characters + null
    3    1994/01/23 14:59:53 UTC       GMT          23 characters + null
              (*) the time zone length can vary

Parameters:
  <-  char UTctime[]
      Pointer to a character string for the date and time.  This string is null
      terminated.  This string is at most 29 characters long, not including the
      terminating null character.  This is a pointer to an internal static
      storage area; each call to this routine overlays this storage.
   -> time_t *timer
      Input time value
   -> int format
      Date / time format code, taking on values from 0 to 3

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.10 $  $Date: 1995/05/12 11:34:08 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTctime.c 1.10 1995/05/12 AFsp-V2R1 $";

#include <time.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#define MAXDATE	29

char *
UTctime (timer, format)

     time_t *timer;
     int format;

{
  char *stdtime;
  static char Datetime[MAXDATE+1];

  switch (format) {

  case (0):
  default:
    stdtime = asctime (localtime (timer));
    STcopyNMax (stdtime, Datetime, 24, MAXDATE);
    break;

  case (1):
    stdtime = asctime (localtime (timer));
    STcopyNMax (stdtime, Datetime, 20, MAXDATE);
    strftime (&Datetime[20], MAXDATE - 20, "%Z %Y", localtime (timer));
    break;

  case (2):
    strftime (Datetime, MAXDATE, "%Y/%m/%d %H:%M:%S %Z", localtime (timer));
    break;

  case (3):
    strftime (Datetime, MAXDATE, "%Y/%m/%d %H:%M:%S UTC", gmtime (timer));
    break;
  }

  return Datetime;
}
