/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *UTuserName (void)

Purpose:
  Get the user name and host name

Description:
  This routine returns the user name and host name.  The returned string is of
  the form user@host, with the host or @user parts omitted if unavailable.

Parameters:
  <-  char UTuserName[]
      Pointer to a character string containing the user name.  This string is
      null terminated.  This is a pointer to an internal static storage area;
      each call to this routine overlays this storage.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.24 $  $Date: 1995/05/26 00:31:06 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTuserName.c 1.24 1995/05/26 AFsp-V2R1 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS 1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  define MAXHOSTNAMELEN	0	/* Null host name for MS-DOS */
#endif

#ifndef MAXHOSTNAMELEN
#  include <sys/param.h>	/* MAXHOSTNAMELEN on many systems */
#  ifndef MAXHOSTNAMELEN
#    include <netdb.h>		/* For Solaris */
#  endif
#endif

#define MAXLEN	MAXHOSTNAMELEN+16+1	/* 16 chars for the user part */

char *
UTuserName ()

{
  int n;
  static char User[MAXLEN+1];

  n = STcopyMax (UTgetUser (), User, MAXLEN);
  User[n] = '@';
  STcopyMax (UTgetHost (), &User[n+1], MAXLEN-(n+1));
  if (User[n+1] == '\0')
    User[n] = '\0';

  return User;
}
