/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecPair (const char String[], const char Delim[], char Type,
                 void *Val1, void *Val2)

Purpose:
  Decode a data specification for a pair of numeric values

Description:
  This routine decodes a string specifying a pair of integer values.  The pair
  is specified as "V" or "V1:V2", for example "-23 : 45". The delimiter is
  shown as ":" in the example, but a general delimiter string can be specified
  in the argument list.  Optional white-space (as defined by isspace) can
  surround the values.

Parameters:
  <-  int STdecPair
      Number of values read, 0, 1 or 2.  If an error is encountered while
      reading the second value, the return code is set to -1.
   -> const char String[]
      Input string
   -> const char Delim[];
      Delimiter string.  This value is used in STfindToken to separate the
      two values.
   -> char Type
      Code for the data type, 'D' for double, 'F' for float, 'I' for int, 'L'
      for long int.
  <-  void *Val1
      First value
  <-  void *Val2
      Second value

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.3 $  $Date: 1996/05/31 19:12:31 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecPair.c 1.3 1996/05/31 AFsp-V2R1 $";

#include <string.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#define MAXC	80

int
STdecPair (String, Delim, Type, Val1, Val2)

     const char String[];
     const char Delim[];
     char Type;
     void *Val1;
     void *Val2;

{
  char *token;
  int nc;
  const char *p;
  int status, N;
  char cbuf[MAXC+1];

/* Allocate temporary string space */
  nc = strlen (String);
  if (nc > MAXC)
    token = (char *) UTmalloc (nc + 1);
  else
    token = cbuf;

/* Decode the first value of the pair */
  N = 0;
  p = STfindToken (String, Delim, "", token, 1, nc);
  status = STdec1val (token, Type, Val1);

/* Decode the second value of the pair */
  if (status == 0) {
    ++N;
    if (p != NULL) {
      status = STdec1val (p, Type, Val2);
      if (status != 0)
	N = -1;
      else 
	++N;
    }
  }

  if (token != cbuf)
    UTfree ((void *) token);

  return N;
}
