/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecNval (const char String[], int Nmin, int Nmax, char Type, void *Val,
                 int *N)

Purpose:
  Decode numeric values (variable number)

Description:
  This routine decodes a string containing numeric data.  Multiple data items
  data items in the string are separated by commas or white-space (as defined
  by the sscanf routine).  The data type can be specified.  If the number of
  data values in the string is less than a given minimum number or a decoding
  error is detected, an error message is printed and an error indication is
  returned.  A warning messages is printed if extra data follows the requested
  values (this data is ignored).

Parameters:
  <-  int STdecNval
      Returned value,
        0 - no error
        1 - error, too few values or data format error.
   -> const char String[]
      Input string
   -> int Nmin
      Minimum number of values to be read (may be zero)
   -> int Nmax
      Maximum number of values to be read
   -> char Type
      Code for the data type, 'D' for double, 'F' for float, 'I' for int, 'L'
      for long int.
  <-  void *Val
      Array of Nmax elements used to store the decoded values.  Only the first
      N values are modified.
  <-  int *N
      Actual number of values decoded.  In the case of an error, N indicates
      the number of values successfully decoded.  In that case, N may be less
      than Nmin.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.2 $  $Date: 1996/07/10 18:48:02 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecNval.c 1.2 1996/07/10 AFsp-V2R1 $";

#include <string.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#define MAXC	256

int
STdecNval (String, Nmin, Nmax, Type, Val, N)

     const char String[];
     int Nmin;
     int Nmax;
     char Type;
     void *Val;
     int *N;

{

  char *token;
  int nc, n;
  const char *p;
  int status;
  void *v;
  char cbuf[MAXC+1];

/* Allocate temporary string space */
  nc = strlen (String);
  if (nc > MAXC)
    token = (char *) UTmalloc (nc + 1);
  else
    token = cbuf;

/* Find the substrings */
  p = String;
  n = 0;
  status = 0;
  while	 (p != NULL && n < Nmax) {
    p = STfindToken (p, ",", "", token, 2, nc);
    if (token[0] != '\0') {

      if (Type == 'D')
	v = (void *) (((double *) Val) + n);
      else if (Type == 'F')
	v = (void *) (((float *) Val) + n);
      else if (Type == 'I')
	v = (void *) (((int *) Val) + n);
      else if (Type == 'L')
	v = (void *) (((long int *) Val) + n);

      /* Non-null token string */
      status = STdec1val (token, Type, v);
      if (status != 0)
	break;
      ++n;
    }
    else {
      /* Null token string */
      if (p != NULL || n != 0 || Nmin != 0) {
	status = 1;
	UTwarn ("STdecNval - Empty data string");
      }
      break;
    }
  }

/* Check the number of values found */
  if (status == 0) {
    if (n < Nmin) {
      status = 1;
      UTwarn ("STdecNval - Too few data values");
    }
    if (p != NULL && n >= Nmax)
      UTwarn ("STdecNval - Extra data ignored");
  }

  if (token != cbuf)
    UTfree ((void *) token);
  *N = n;

  return status;
}
