/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdec1val (const char String[], char Type, void *Val)

Purpose:
  Decode a numeric value

Description:
  This routine decodes a string containing a numeric value.  The data type can
  be specified.  If a decoding error is detected, a warning message is printed
  and an error status value is returned.  A warning message is printed if
  extra data follows the requested value (this data is ignored).

Parameters:
  <-  int STdec1val
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
   -> char Type
      Code for the data type, 'D' for double, 'F' for float, 'I' for int, 'L'
      for long int.
  <-  void *Val
      Returned value of the type indicated by Type.  This value is not changed
      if an error status is returned.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.1 $  $Date: 1996/05/31 19:12:00 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdec1val.c 1.1 1996/05/31 AFsp-V2R1 $";

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#define MAXC	20

int
STdec1val (String, Type, Val)

     const char String[];
     char Type;
     void *Val;

{
  char c;
  int nc, status, m;
  const char *p;
  char *token;
  char cbuf[MAXC+1];
  double dv;
  float fv;
  int iv;
  long int lv;
  

  /* Trim white space */
  String = (const char *) STtrimIws (String);
  nc = strlen (String);
  for (p = String+(nc-1); nc > 0; --nc, --p) {
    if (! isspace (*p))
      break;
  }
  if (nc > MAXC)
    token = (char *) UTmalloc (nc + 1);
  else
    token = cbuf;
  STcopyNMax (String, token, nc, nc);

  status = 0;

  if (token[0] == '\0') {
    UTwarn ("STdec1val - Empty data string");
    status = 1;
  }

  else {
    c = '\0';

    /* Extra check: djgpp sscanf returns m=1, for String="xx" */
    if (Type == 'I') {
      m = sscanf (token, "%d%c", &iv, &c);
      status = (m != 1 || c != '\0');
      if (status == 0)
	*((int *) Val) = iv;
    }
    else if (Type == 'D') {
      m = sscanf (token, "%lg%c", &dv, &c);
      status = (m != 1 || c != '\0');
      if (status == 0)
	*((double *) Val) = dv;
    }
    else if (Type == 'F') {
      m = sscanf (token, "%g%c", &fv, &c);
      status = (m != 1 || c != '\0');
      if (status == 0)
	*((float *) Val) = fv;
    }
    else if (Type == 'L') {
      m = sscanf (token, "%ld%c", &lv, &c);
      status = (m != 1 || c != '\0');
      if (status == 0)
	*((long int *) Val) = lv;
    }
    else
      UThalt ("STdec1val: Invalid data type code");

    if (status != 0) {
      if (strlen (token) > 23)
	UTwarn ("STdec1val - Data format error: \"%.20s...\"", token);
      else
	UTwarn ("STdec1val - Data format error: \"%s\"", token);
    }
  }

  if (token != cbuf)
    UTfree ((void *) token);

  return status;
}
