/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecIrange (const char String[], int *Ival1, int *Ival2)

Purpose:
  Decode a range specification for integer values

Description:
  This routine decodes a string specifying a range of integer values.  The
  range is specified in the form "Iv" or "Iv1:Iv2", for example "-23 : 45".
  Optional white-space (as defined by isspace) can surround the values.  For
  the case of a single value Iv, this is equivalent to the range "Iv:Iv".  If
  an error is encountered, neither output value is set.

Parameters:
  <-  int STdecIrange
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  int *Ival1
      First value
  <-  int *Ival2
      Second value

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.19 $  $Date: 1996/05/31 19:11:01 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecIrange.c 1.19 1996/05/31 AFsp-V2R1 $";

#include <math.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdecIrange (String, Ival1, Ival2)

     const char String[];
     int *Ival1;
     int *Ival2;

{
  int N;
  int ival1, ival2;

  /* Decode the range values */
  N = STdecPair (String, ":", 'I', (void *) (&ival1), (void *) (&ival2));

  if (N == 1)
    ival2 = ival1;
  if (N > 0) {
    *Ival1 = ival1;
    *Ival2 = ival2;
  }

  return (N <= 0);
}
