/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecDfrac (const char String[], double *Dval1, double *Dval2)

Purpose:
  Decode a ratio specification of two double values

Description:
  This routine decodes a string specifying a ratio of double values.  The
  ratio is specified in the form "V" or "V1/V2", for example "-23.1 / 45".
  Optional white-space (as defined by isspace) can surround the values.  For
  the case of a single value V, this is equivalent to the ratio "V/1".  If an
  error is encountered, neither output value is set.

Parameters:
  <-  int STdecRfrac
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  double *Dval1
      First value
  <-  double *Dval2
      Second value

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.2 $  $Date: 1996/05/31 19:09:39 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecDfrac.c 1.2 1996/05/31 AFsp-V2R1 $";

#include <math.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdecDfrac (String, Dval1, Dval2)

     const char String[];
     double *Dval1;
     double *Dval2;

{
  int N;
  double dval1, dval2;

  /* Decode the ratio values */
  N = STdecPair (String, "/", 'D', (void *) (&dval1), (void *) (&dval2));

  if (N == 1)
    dval2 = 1.0;
  if (N > 0) {
    *Dval1 = dval1;
    *Dval2 = dval2;
  }

  return (N <= 0);
}
