/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STcatMax (const char Si[], char So[], int Maxchar)

Purpose:
  Concatenate at most N characters to a string

Description:
  This routine appends characters from the input string to the end of the
  second string.  Characters are appended until a null is seen in the input
  string or the number of characters in the second string is Maxchar.  Then a
  trailing null character is appended to the output string.  If not all
  characters from the input string can be copied into the output string, a
  string truncated warning message is printed.

Parameters:
  <-  int STcatMax
      Number of characters in the output string
   -> const char Si[]
      Input character string to be appended to So
  <-> char So[]
      Output character string.  This string is always null terminated, with at
      most Maxchar characters not including the terminating null character.  If
      the sum of the input string lengths is more than Maxchar, only the first
      Maxchar characters appear in So and a warning message is printed.
   -> int Maxchar
      Maximum number of characters (not including the trailing null character)
      to be placed in So.  Note that So may be longer than Maxchar if it is so
      before calling this routine.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.16 $  $Date: 1995/05/12 10:16:37 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STcatMax.c 1.16 1995/05/12 AFsp-V2R1 $";

#include <string.h>
#include <libtsp.h>

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))

int
STcatMax (Si, So, Maxchar)

     const char Si[];
     char So[];
     int Maxchar;

{
  char *so;
  int n;

  /* Save the initial output pointer */
  so = So;

  /* Find the end of So */
  for (n = 0; n < Maxchar && *so != '\0'; n++)
    so++;

  /* Check for the possibility that So is already at its maximum length */
  if (n < Maxchar-1 || *so == '\0') {
    /* Copy to So for a length of at most Maxchar-1 characters */
    for (; n < Maxchar && *Si != '\0'; n++)
      *so++ = *Si++;

    /* Add a trailing null */
    *so = '\0';
  }

  /* Check for truncation */
  if (*Si != '\0')
    UTwarn ("STcatMax - String truncated, string: \"%.*s...\"",
	    MINV (20, n), So);

  /* Return the number of characters in So */
  return n;
}
