/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void FLwriteFile (FILE *fp, long int offs, const void *ptr, size_t elem_size,
		    size_t count)

Purpose:
  Write raw data to a file

Description:
  This routine writes raw data to a file.  This routine provides a random
  access interface to fwrite, with error checking.  If any error is detected,
  execution is terminated.

Parameters:
   -> FILE *fp
      File pointer associated with the file
   -> long int offs
      Byte offset in the file
   -> const void *ptr
      Data buffer
   -> size_t elem_size
      Size of each data element in the input buffer
   -> size_t count
      Number of data elements to be written

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.10 $  $Date: 1996/05/06 18:15:04 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLwriteFile.c 1.10 1996/05/06 AFsp-V2R1 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifndef SEEK_SET	/* normally defined in stdio.h */
#  include <unistd.h>
#endif

void
FLwriteFile (fp, offs, ptr, elem_size, count)

     FILE *fp;
     long int offs;
     const void *ptr;
     size_t elem_size;
     size_t count;

{
  int Nval;

  if (fseek (fp, offs, SEEK_SET) != 0)
    UTerror ("FLwriteFile: Seek error");

  Nval = fwrite ((const char *) ptr, elem_size, count, fp);
						/* Sun CC needs cast */
  if (Nval < count)
    UTerror ("FLwriteFile: Write error");

  return;
}
