/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLjoinNames (const char Dname[], const char Bname[], char Fname[])

Purpose:
  Form a file name from a directory path and a base name

Description:
  This routine takes an input file path and appends file name components to
  form a file name string.  This routine can be used to form a name from a
  directory string and a file name string.  It joins these components together
  separated by a / character (\ character for MS-DOS).  However, the /
  character is omitted if either input part is empty or if the directory part
  already ends in a /.  The operations are arranged so that the output file
  name can overlay either of the input strings.

  If the second component (the base name) starts with a /, indicating the
  root directory, this name alone appears in the output string.

Parameters:
  <-  int FLjoinNames
      Number of characters in the output string
   -> const char Dname[]
      Input character string with the path name
   -> const char Bname[]
      Input character string with the base name of the file
  <-  char Fname[]
      Output string formed by joining the two input strings.  This string is at
      most FILENAME_MAX characters long not including the terminating null
      character.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.9 $  $Date: 1995/05/20 10:12:12 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLjoinNames.c 1.9 1995/05/20 AFsp-V2R1 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS 1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  ifndef unix
#    define MSDOS_SEP	/* Use MS-DOS directory separators */
#  endif
#endif

#ifdef MSDOS_SEP
#  define DIR_SEP_CHAR		'\\'
#  define DIR_SEP_STR		"\\"
#else
#  define DIR_SEP_CHAR		'/'
#  define DIR_SEP_STR		"/"
#endif

int
FLjoinNames (Dname, Bname, Fname)

     const char Dname[];
     const char Bname[];
     char Fname[];

{
  char tname[FILENAME_MAX+2];	/* One extra: catch names that are too long */
  int n;

  /* Test for a root directory specification in Bname */
  if (Bname[0] == DIR_SEP_CHAR)

    /* Basename alone appears in the output string */
    n = STcopyMax (Bname, Fname, FILENAME_MAX);

  else {

    /* Form the combined name in temporary storage */
    n = STcopyMax (Dname, tname, FILENAME_MAX+1);
    if (n > 0 && Bname[0] != '\0' && tname[n-1] != DIR_SEP_CHAR)
      STcatMax (DIR_SEP_STR, tname, FILENAME_MAX+1);
    n = STcatMax (Bname, tname, FILENAME_MAX+1);
    if (n > FILENAME_MAX)
      UThalt ("FLjoinNames: File name too long");

    n = STcopyMax (tname, Fname, FILENAME_MAX);
  }

  return n;
}
