/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFwriteF4 (AFILE *AFp, const float Fbuff[], int Nval)

Purpose:
  Write 32-bit float data to an audio file (float input values)

Description:
  This routine writes a specified number of 32-bit float samples to an audio
  file.  The input to this routine is a buffer of float values.  The file must
  have been opened using subroutine AFopenWrite.

Parameters:
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenWrite
   -> const float Fbuff[]
      Array of floats with the samples to be written
   -> int Nval
      Number of samples to be written

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.14 $  $Date: 1996/08/14 18:16:30 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFwriteF4.c 1.14 1996/08/14 AFsp-V2R1 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>
#include <libtsp/UTtypes.h>

#define LW		FDL_FLOAT32
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192

void
AFwriteF4 (AFp, Fbuff, Nval)

     AFILE *AFp;
     const float Fbuff[];
     int Nval;

{
  int is, N, i;
  long int offs;
  float4_t Buf[NBBUF/LW];
  float4_t *B;
  unsigned char *cp;
  unsigned char t;

/* Write data to the audio file */
  offs = AFp->End;
  is = 0;
  while (is < Nval) {
    N = MINV (NBBUF / LW, Nval - is);
    B = Buf;
    for (i = 0; i < N; ++i) {
      *B = AFp->ScaleF * Fbuff[i+is];
      if (AFp->Swapb == DS_SWAP) {
	cp = (unsigned char *) B;
	t = cp[3]; cp[3] = cp[0]; cp[0] = t;
	t = cp[2]; cp[2] = cp[1]; cp[1] = t;
      }
      ++B;
    }
    FLwriteFile (AFp->fp, offs, (void *) Buf, (size_t) LW, (size_t) N);
    is = is + N;
    offs = offs + LW * N;
  }

  /* Update the file position */
  AFp->End = offs;

  return;
}
