/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void AFupdWVhead (const AFILE *AFp)

Purpose:
  Update header information in a RIFF WAVE file

Description:
  This routine updates the data length fields of a RIFF WAVE file.  The file is
  assumed to have been opened with routine AFopenWrite.

Parameters:
   -> const AFILE *AFp
      Audio file pointer for an audio file opened by AFopenWrite

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.6 $  $Date: 1996/05/06 18:12:58 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFupdWVhead.c 1.6 1996/05/06 AFsp-V2R1 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>
#include <libtsp/WVpar.h>

#define WHEAD_V(fp,offs,value,swap) \
			AFwriteHead (fp, (long int) (offs), \
				     (void *) &(value), \
				     sizeof (value), 1, swap)

void
AFupdWVhead (AFp)

     const AFILE *AFp;

{
  uint4_t Size;

/* Checks */
  if (AFp->Op != FO_WO)
    UThalt ("AFupdWVhead: File not opened for write");
  if (AFp->Ftype != FT_WAVE)
    UThalt ("AFupdWVhead: Not a RIFF WAVE file");

/* Update the RIFF chunk cksize field */
  Size = (uint4_t) AFp->End - 8;
  WHEAD_V (AFp->fp, 4L, Size, DS_EL);			/* File length - 8 */

/* Update the data chunk cksize field */
  Size = (uint4_t) (AFp->End - AFp->Start);
  WHEAD_V (AFp->fp, AFp->Start - 4, Size, DS_EL);	/* Data length */

  return;
}
