/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AFreadI2 (AFILE *AFp, long int offs, float Fbuff[], int Nreq)

Purpose:
  Read 16-bit integer data from an audio file (return float values)

Description:
  This routine reads a specified number of 16-bit integer samples from an audio
  file.  The data in the file is converted to float format on output. The file
  must have been opened using subroutine AFopenRead.

Parameters:
  <-  int AFreadI2
      Number of data values transferred from the file.  On reaching the end of
      the file, this value may be less than Nreq.
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenRead
   -> long int offs
      Offset into the file in samples.  The parameter offs must be non-
      negative.
  <-  float Fbuff[]
      Array of floats to receive the samples
   -> int Nreq
      Number of samples requested.  Nreq may be zero.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.20 $  $Date: 1996/08/14 18:03:45 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFreadI2.c 1.20 1996/08/14 AFsp-V2R1 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>
#include <libtsp/UTtypes.h>

#define LW		FDL_INT16
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192

int
AFreadI2 (AFp, offs, Fbuff, Nreq)

     AFILE *AFp;
     long int offs;
     float Fbuff[];
     int Nreq;

{
  long int offsb;
  int Nd, is, n, i, Nval;
  int2_t Buf[NBBUF/LW];
  int2_t *B;
  unsigned char *cp;
  unsigned char t;

  offsb = AFp->Start + LW * offs;
  Nd = (int) MINV (Nreq, (AFp->End - offsb) / LW);  /* Nd can be negative */
  for (is = 0; is < Nd; ) {

    /* Read data from the audio file */
    n = MINV (NBBUF / LW, Nd - is);
    Nval = FLreadFile (AFp->fp, (long int) (offsb + is * LW), (void *) Buf,
		       (size_t) LW, (size_t) n);
    if (Nval != n)
      UThalt ("AFreadI2: Unexpected end-of-file");

    /* Byte swap and convert to float */
    B = Buf;
    for (i = 0; i < Nval; ++i) {
      if (AFp->Swapb == DS_SWAP) {
	cp = (unsigned char *) B;
	t = cp[1]; cp[1] = cp[0]; cp[0] = t;
      }
      Fbuff[is] = AFp->ScaleF * (*B);
      ++is;
      ++B;
    }
  }

  return is;
}
