/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  AFILE *AFgetNHpar (FILE *fp, const char Fname[], long int *Nsamp,
                     long int *Nchan, float *Sfreq, FILE *fpout)

Purpose:
  Get file format information for a headerless audio file

Description:
  This routine gets file information for an audio file with a non-standard
  header or with no header.  File format information is passed to this routine
  by calling AFSetNH before calling this routine.  This information is used to
  set the file data format information in the audio file pointer structure and
  to set the returned argument values.  A banner identifying the audio file
  and its parameters is printed.

Parameters:
  <-  AFILE *AFgetNHpar
      Audio file pointer for the audio file
   -> FILE *fp
      File pointer for the file
   -> const char Fname[]
      File name
  <-  long int *Nsamp
      Total number of samples in the file (all channels)
  <-  long int *Nchan
      Number of channels
  <-  float *Sfreq
      Sampling frequency
   -> FILE *fpout
      File pointer for printing the audio file identification information.  If
      fpout is NULL, no information is printed.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.33 $  $Date: 1996/08/14 17:57:04 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFgetNHpar.c 1.33 1996/08/14 AFsp-V2R1 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>

#ifndef SEEK_SET	/* normally defined in stdio.h */
#  include <unistd.h>
#endif

AFILE *
AFgetNHpar (fp, Fname, Nsamp, Nchan, Sfreq, fpout)

     FILE *fp;
     const char Fname[];
     long int *Nsamp;
     long int *Nchan;
     float *Sfreq;
     FILE *fpout;

{
  struct AF_NHpar *Fdef;
  AFILE *AFp;
  int Lw;
  long int Nsampx, Ldata;

/* Get the file data parameters */
  Fdef = AFgetNH ();

/* Set up the decoding parameters */
  switch (Fdef->Format) {
  case FD_MULAW8:
    Lw = FDL_MULAW8;
    break;
  case FD_ALAW8:
    Lw = FDL_ALAW8;
    break;
  case FD_UINT8:
    Lw = FDL_UINT8;
    break;
  case FD_INT8:
    Lw = FDL_INT8;
    break;
  case FD_INT16:
    Lw = FDL_INT16;
    break;
  case FD_FLOAT32:
    Lw = FDL_FLOAT32;
    break;
  case FD_TEXT:
    Lw = FDL_TEXT;
    break;
  case FD_UNDEF:
    UThalt ("AFgetNHpar: Default data format not defined");
    break;
  default:
    UThalt ("AFgetNHpar: Unsupported data encoding");
    break;
  }

/* Data length */
  Ldata = FLfileSize (fp) - Fdef->Start;

  if (Fdef->Format == FD_TEXT) {
    if (fseek (fp, Fdef->Start, SEEK_SET) != 0)
      UThalt ("AFgetNHpar: Error from fseek");
    Nsampx = 0;
    while (FLgetLine (fp) != NULL)
      ++Nsampx;
    if (fseek (fp, Fdef->Start, SEEK_SET) != 0)
      UThalt ("AFgetNHpar: Error from fseek");
  }
  else
    Nsampx = Ldata / Lw;

/* Set the parameters for file access */
  AFp = AFsetAFp (fp, FO_RO, FT_NH, Fdef->Format, Fdef->Swapb, Fdef->ScaleF,
		  Fdef->Nchan, Fdef->Start, Ldata, Nsampx);

/* Check and print the header information */
  AFprintAFh (AFp, Fname, "", Fdef->Sfreq, fpout);

/* Set the return parameters */
  *Nsamp = Nsampx;
  *Nchan = Fdef->Nchan;
  *Sfreq = Fdef->Sfreq;

  return AFp;
}
