/*------------- Telecommunications & Signal Processing Lab -------------
                           McGill University

Routine:
  void IAoptions (int argc, const char *argv[], const char *NHparms[MAXFILE],
                  int *Icode, const char *Fname[MAXFILE], int *Nfiles)

Purpose:
  Decode options for InfoAudio

Description:
  This routine decodes options for InfoAudio.

Parameters:
   -> int argc
      Number of command line arguments
   -> const char *argv[]
      Array of pointers to argument strings
  <-  const char *NHparms[MAXIFILE]
      Parameters for headerless input files, default NULL
  <-  int *Icode
      Flag to select the amount of output, default 7
  <-  const char *Fname[MAXFILE]
      File names
  <-  int *Nfiles
      Number of input file names

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.18 $  $Date: 1996/08/19 17:38:43 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: IAoptions.c 1.18 1996/08/19 AFsp-V2R1 $";

#include <stdlib.h>		/* prototype for exit */
#include <stdio.h>
#include <libtsp.h>
#include "InfoAudio.h"

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS	0	/* Normally in stdlib.h */
#endif

#define ERRSTOP(text,par)	UThalt ("%s: %s: \"%s\"", PROGRAM, text, par)
#define NELEM(array)	((sizeof array) / (sizeof array[0]))

/* Option tables and usage message */
#define LOPT	(NELEM (OptTable) / 2)
static const char *nullTable[] = { NULL };
static const char *OptTable[] = {
  "-P#", "--p*arameters=",
  "-i#", "--info_code=",
  "-h", "--h*elp",
  "-v", "--v*ersion",
  "--",
  NULL
};
static const char Usage[] = "\
Usage: %s [options] AFile\n\
Options:\n\
  -P PARMS, --parameters=PARMS  Parameters for headerless input files.\n\
  -i ICODE, --info_code=ICODE Information to be printed (ICODE: 1+2+4).\n\
  -h, --help                  Print a list of options and exit.\n\
  -v, --version               Print the version number and exit.";

void
IAoptions (argc, argv, NHparms, Icode, Fname, Nfiles)

     int argc;
     const char *argv[];
     const char *NHparms[MAXFILE];
     int *Icode;
     const char *Fname[MAXFILE];
     int *Nfiles;

{
  int Index;
  const char *OptArg;
  const char **optt;

  int n, nn;
  int nF;
  int icode;
  const char *NHp;

/* Default values */
  NHp = NULL;
  icode = 7;

/* Initialization */
  UTsetProg (PROGRAM);
  nF = 0;

/* Decode options */
  Index = 1;
  optt = OptTable;
  while (Index < argc) {
    n = UTgetOption (&Index, argc, argv, optt, &OptArg);
    nn = ((n + 3) / 2) - 1;	/* n = -2 ==> nn = -1 */
    switch (nn) {
    case 0:
      /* Filename argument */
      ++nF;
      if (nF <= MAXFILE)
 	Fname[nF-1] = OptArg;
      else
	UThalt ("%s: Too many filenames specified", PROGRAM);
      NHparms[nF-1] = NHp;
      break;
    case 1:
      /* Headerless input parameters */
      NHp = OptArg;
      break;
    case 2:
      /* Info code parameter */
      if (STdec1int (OptArg, &icode) || icode < 0 || icode > 7)
	ERRSTOP ("Invalid info code parameter", OptArg);
      break;
    case LOPT-2:
      /* Help */
      UTwarn (Usage, PROGRAM);
      exit (EXIT_SUCCESS);
      break;
    case LOPT-1:
      /* Version */
      printf ("%s: %s\n", PROGRAM, VERSION);
      exit (EXIT_SUCCESS);
      break;
    case LOPT:
      /* Stop interpreting options */
      optt = nullTable;
      break;
    default:
      /* Option error */
      UThalt (Usage, PROGRAM);
      break;
    }
  }

/* Error check */
  if (nF < 1)
    UThalt ("%s: No input file specified", PROGRAM);

/* Return parameter */
  *Icode = icode;
  *Nfiles = nF;

  return;
}
