/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AOdecFType (const char string[])

Purpose:
  Decode an audio file type specification

Description:
  This routine decodes an audio file type specification, returning the
  corresponding file type code.  In the case of an invalid specification, this
  routine stops with an error message.  For the purpose of the error message,
  the program name must have been set using the routine UTsetProg.

Parameters:
  <-  int AOdecFType
      File type code
   -> const char string[]
      Input audio file type specifier

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.1 $  $Date: 1996/08/16 15:25:36 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AOdecFType.c 1.1 1996/08/16 AFsp-V2R1 $";

#include <libtsp.h>
#include <libtsp/AFpar.h>
#include "AO.h"

#define NELEM(array)	((sizeof array) / (sizeof array[0]))

static const char *FTypeTab[] = {
  "AF*sp", "S*un", "s*un",
  "W*AVE", "w*ave",
  "AI*FF-C", "ai*ff-c",
  "raw", "raw_n*ative",
  "raw_s*wap",
  "raw_b*ig-endian",
  "raw_l*ittle-endian",
  NULL
};
#define NFTYPE		(NELEM (FTypeTab) - 1)
static const int FTypeCode[NFTYPE] = {
  FW_AFSP, FW_SUN, FW_SUN,
  FW_WAVE, FW_WAVE,
  FW_AIFF_C, FW_AIFF_C,
  FW_NH, FW_NH_NATIVE,
  FW_NH_SWAP,
  FW_NH_EB,
  FW_NH_EL
};

int
AOdecFType (string)

     const char string[];

{
  int n;
  char *Pgm;

  n = STkeyMatch (string, FTypeTab);
  if (n < 0 || n >= NFTYPE) {
    Pgm = UTgetProg ();
    if (Pgm == '\0')
      Pgm = "AOdecDFormat";
    UThalt ("%s: Invalid file type specification: \"%s\"", Pgm, string);
  }

  return FTypeCode[n];
}
