/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AOdecDFormat (const char string[])

Purpose:
  Decode an audio file data format specification

Description:
  This routine decodes an audio file data format specification, returning the
  corresponding data format code.  In the case of an invalid specification,
  this routine stops with an error message.  For the purpose of the error
  message, the program name must have been set using the routine UTsetProg.

Parameters:
  <-  int AOdecDFormat
      Data format code
   -> const char string[]
      Input data format specifier

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.1 $  $Date: 1996/08/16 15:25:01 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AOdecDFormat.c 1.1 1996/08/16 AFsp-V2R1 $";

#include <libtsp.h>
#include <libtsp/AFpar.h>
#include "AO.h"

#define NELEM(array)	((sizeof array) / (sizeof array[0]))

static const char *DFormatTab[] = {
  "m*u-law8",
  "A*-law8",
  "u*nsigned8",
  "integer8",
  "i*nteger16",
  "f*loat32",
  "t*ext",
  NULL
};
#define NDFORMAT		(NELEM (DFormatTab) - 1)
static const int DFormatCode[NDFORMAT] = {
  FD_MULAW8,
  FD_ALAW8,
  FD_UINT8,
  FD_INT8,
  FD_INT16,
  FD_FLOAT32,
  FD_TEXT
};

int
AOdecDFormat (string)

     const char string[];

{
  int n;
  char *Pgm;

  n = STkeyMatch (string, DFormatTab);
  if (n < 0 || n >= NDFORMAT) {
    Pgm = UTgetProg ();
    if (Pgm == '\0')
      Pgm = "AOdecDFormat";
    UThalt ("%s: Invalid data format specification: \"%s\"", Pgm, string);
  }

  return DFormatCode[n];
}
