/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  CompAudio.h

Description:
  Declarations for CompAudio

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.24 $  $Date: 1996/08/13 02:13:38 $

----------------------------------------------------------------------*/

#ifndef CompAudio_h_
#define CompAudio_h_

#define PROGRAM "CompAudio"
#define VERSION	"v1r11  1996/08/12"

#ifndef sun
#  include <float.h>
#else
#  include <values.h>
#  define FLT_MAX		MAXFLOAT
#  define DBL_MAX		MAXDOUBLE
#endif

struct Stats_F {
  long int N;
  double Sx;
  double Sx2;
  float Vmin;
  float Vmax;
  long int Novload;
  long int Nrun;
  long int Nanomal;
  int Inrange;
};

struct Stats_T {
  double Sxy;
  long int Ndiff;
  float Diffmax;
  long int Nrun;
  long int Nsseg;
  long int Nseg;
  double SNRlog;
};

#include <libtsp.h>			/* typedef for AFILE */

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes */
void
CASNR p_((const struct Stats_F *StatsA, const struct Stats_F *StatsB,
	  const struct Stats_T *StatsT, double *SNR, double *SNRG, double *SF,
	  double *SSNR));
void
CAcomp p_((AFILE *AFpA, AFILE *AFpB, long int Nsseg, int delayL, int delayU,
	   int *delayM, const struct Stats_F *StatsA,
	   const struct Stats_F *StatsB, struct Stats_T *StatsT));
void
CAcorr p_((AFILE *AFpA, AFILE *AFpB, int delay, long int Nsseg,
	   struct Stats_T *Stats));
void
CAoptions p_((int argc, const char *argv[], int *delayL, int *delayU,
	      long int *Nsseg, const char *NHparms[2], const char *Fname[2]));
void
CAprcorr p_((const struct Stats_F *StatsA, const struct Stats_F *StatsB,
	     const struct Stats_T *StatsT));
void
CAprstat p_((const struct Stats_F *Stats));
void
CAstats p_((AFILE *AFp, struct Stats_F *Stats));

#ifdef __cplusplus
}
#endif

#endif /* CompAudio_h_ */
