/*------------- Telecommunications & Signal Processing Lab --------------
                          McGill University
Routine:
  void CAprcorr (const struct Stats_F *StatsA, const struct Stats_F *StatsB,
  		 const struct Stats_T *StatsT)

Purpose:
  Print SNR values for two files

Description:
  This routine prints SNR values for two files.  Three types of SNR are
  printed: the conventional SNR, gain adjusted SNR and segmental SNR.  In
  addition, the number of differing samples and maximum difference is printed.

Parameters:
   -> const struct Stats_F *StatsA
      Structure containing the statistics for file A
   -> const struct Stats_F *StatsB
      Structure containing the statistics for file B
   -> const struct Stats_T *StatsT
      Structure containing the cross-statistics

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.10 $  $Date: 1996/06/01 02:42:03 $

-----------------------------------------------------------------------*/

static char rcsid[] = "$Id: CAprcorr.c 1.10 1996/06/01 AFsp-V2R1 $";

#include <math.h>	/* log10 */
#include <stdio.h>
#include "CompAudio.h"

#define DB(x)		(10.0 * log10 (x))

void
CAprcorr (StatsA, StatsB, StatsT)

     const struct Stats_F *StatsA;
     const struct Stats_F *StatsB;
     const struct Stats_T *StatsT;

{
  double SNR, SNRG, SF, SSNR;

/* Calculate the SNR values */
  CASNR (StatsA, StatsB, StatsT, &SNR, &SNRG, &SF, &SSNR);

  /* Ordinary SNR */
  printf (" SNR      = %-8.5g dB\n", DB (SNR));

  /* Gain optimized SNR */
  if (SNRG != DBL_MAX) {
    printf (" SNR      = %-8.5g dB", DB (SNRG));
    printf ("  (Gain factor for File B = %.5g)\n", SF);
  }
  else
    printf (" File A = %.5g * File B\n", SF);

  /* Segmental SNR */
  if (SSNR >= 0.0)
    printf (" Seg. SNR = %-8.5g dB (%ld sample segments)\n",
	    DB (SSNR), StatsT->Nsseg);

/* Number of differing samples */
  printf (" No. differing samples = %ld", StatsT->Ndiff);
  if (StatsT->Nrun == 1)
    printf (" (%ld run)\n", StatsT->Nrun);
  else
    printf (" (%ld runs)\n", StatsT->Nrun);
  printf (" Max. difference = %.5g\n", StatsT->Diffmax);

  return;
}
