/*------------- Telecommunications & Signal Processing Lab -------------
                           McGill University

Routine:
  void CAoptions (int argc, const char *argv[], int *delayL, int *delayU,
	          long int *Nsseg, const char *NHparms[2],
		  const char *Fname[2])

Purpose:
  Decode options for CompAudio

Description:
  This routine decodes options for CompAudio.

Parameters:
   -> int argc
      Number of command line arguments
   -> const char *argv[]
      Array of pointers to argument strings
  <-  int *delayL
      Starting delay
  <-  int *delayU
      End delay
  <-  long int *Nsseg
      Number of samples per segment (zero if unspecified)
  <-  const char *NHparms[2]
      Parameters for headerless input files, default NULL
  <-  const char *Fname[2]
      Input file name

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.26 $  $Date: 1996/06/01 02:36:27 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: CAoptions.c 1.26 1996/06/01 AFsp-V2R1 $";

#include <stdlib.h>		/* prototype for exit */
#include <stdio.h>
#include <libtsp.h>
#include "CompAudio.h"

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS	0	/* Normally in stdlib.h */
#endif

#define ERRSTOP(text,par)	UThalt ("%s: %s: \"%s\"", PROGRAM, text, par)
#define NELEM(array)	((sizeof array) / (sizeof array[0]))

/* Option tables and usage message */
#define LOPT	(NELEM (OptTable) / 2)
static const char *nullTable[] = { NULL };
static const char *OptTable[] = {
  "-d#", "--d*elay=",
  "-s#", "--s*egment=",
  "-P#", "--p*arameters=",
  "-h", "--h*elp",
  "-v", "--v*ersion",
  "--",
  NULL
};
static const char Usage[] = "\
Usage: %s [options] AFileA [AFileB]\n\
Options:\n\
  -d DL:DU, --delay=DL:DU     Specify a delay range.\n\
  -s SAMP, --segment=SAMP     Segment length (samples).\n\
  -P PARMS, --parameters=PARMS  Parameters for headerless input files.\n\
  -h, --help                  Print this message and exit.\n\
  -v, --version               Print the version number and exit.";

void
CAoptions (argc, argv, delayL, delayU, Nsseg, NHparms, Fname)

     int argc;
     const char *argv[];
     int *delayL;
     int *delayU;
     long int *Nsseg;
     const char *NHparms[2];
     const char *Fname[2];
{
  int Index;
  const char *OptArg;
  const char **optt;

  int n, nn;
  int nF;
  const char *NHp;
  int delL;
  int delU;
  long int nsseg;

/* Default values */
  delL = 0;
  delU = 0;
  NHp = NULL;
  nsseg = 0;

/* Initialization */
  UTsetProg (PROGRAM);
  nF = 0;

/* Decode options */
  Index = 1;
  optt = OptTable;
  while (Index < argc) {
    n = UTgetOption (&Index, argc, argv, optt, &OptArg);
    nn = ((n + 3) / 2) - 1;	/* n = -2 ==> nn = -1 */
    switch (nn) {
    case 0:
      /* Filename argument */
      ++nF;
      if (nF <= 2) {
	NHparms[nF-1] = NHp;
	Fname[nF-1] = OptArg;
      }
      else
	UThalt ("%s: Too many filenames specified", PROGRAM);
      break;
    case 1:
      /* Delay specification */
      if (STdecIrange (OptArg, &delL, &delU) || delL > delU)
	ERRSTOP ("Invalid range specification", OptArg);
      break;
    case 2:
      /* Segment length */
      if (STdec1long (OptArg, &nsseg) || nsseg < 0)
	ERRSTOP ("Invalid segment length", OptArg);
      break;
    case 3:
      /* Headerless input parameters */
      NHp = OptArg;
      break;
    case LOPT-2:
      /* Help */
      UTwarn (Usage, PROGRAM);
      exit (EXIT_SUCCESS);
      break;
    case LOPT-1:
      /* Version */
      printf ("%s: %s\n", PROGRAM, VERSION);
      exit (EXIT_SUCCESS);
      break;
    case LOPT:
      /* Stop interpreting options */
      optt = nullTable;
      break;
    default:
      /* Option error */
      UThalt (Usage, PROGRAM);
      break;
    }
  }

/* Error check*/
  if (nF < 1)
    UThalt ("%s: No files specified", PROGRAM);

/* Return values */
  if (nF == 1)
    Fname[1] = NULL;
  *delayL = delL;
  *delayU = delU;
  *Nsseg = nsseg;

  return;
}
