/***************************************************************************
 ** $Id: voice_recognition.h,v 1.7 2003/12/06 18:52:36 wiecko Exp $
                          klearnnotes2
                          voice_recognition.h -  description
                             -------------------
    begin                : Thu Oct 23 03:55:46 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VOICE_RECOGNITION_H
#define VOICE_RECOGNITION_H
#include <qtranslator.h>

// cmd_X defines label by which cvoicecontrol infroms the main program
// about user input; this is actual 'label' in the 'model'

// txt_X is what user sees in the listview

// sug_X is a suggestion for recording

#define cmd_no      "NO"
#define txt_no      QT_TR_NOOP("NO")
#define sug_no      QT_TR_NOOP("try recording 'button NO' or 'click on NO'")
#define cmd_yes     "YES"
#define txt_yes     QT_TR_NOOP("YES")
#define sug_yes     QT_TR_NOOP("try recording 'button YES' or 'click on YES'")
#define cmd_quit    "QUIT_program"
#define txt_quit    QT_TR_NOOP("QUIT program")
#define sug_quit    QT_TR_NOOP("just record 'QUIT program'")
#define cmd_help    "HELP"
#define txt_help    QT_TR_NOOP("HELP")
#define sug_help    QT_TR_NOOP("try recording 'HELP' or 'get HELP'")

#define cmd_quieter "QUIETER"
#define txt_quieter QT_TR_NOOP("QUIETER")
#define sug_quieter QT_TR_NOOP("try recording 'QUIETER' or 'sound QUIETER'")
#define cmd_louder  "LOUDER"
#define txt_louder  QT_TR_NOOP("LOUDER")
#define sug_louder  QT_TR_NOOP("try recording 'LOUDER' or 'sound LOUDER'")
#define cmd_sndSetup "SOUND_SETUP"
#define txt_sndSetup QT_TR_NOOP("open SOUND SETUP dialog")
#define sug_sndSetup QT_TR_NOOP("just record 'sound SETUP'")
#define cmd_sndOn   "SOUND_ON"
#define txt_sndOn   QT_TR_NOOP("turn SOUND ON")
#define sug_sndOn   QT_TR_NOOP("just record 'sound ON'")
#define cmd_sndOff  "SOUND_OFF"
#define txt_sndOff  QT_TR_NOOP("turn SOUND OFF")
#define sug_sndOff  QT_TR_NOOP("just record 'sound OFF'")

#define cmd_none    "all_NOTES_NOT_ACTIVE"
#define txt_none    QT_TR_NOOP("set all NOTES NOT ACTIVE")
#define sug_none    QT_TR_NOOP("just record 'all notes NOT active'")
#define cmd_all     "all_NOTES_ACTIVE"
#define txt_all     QT_TR_NOOP("set all NOTES ACTIVE")
#define sug_all     QT_TR_NOOP("just record 'all notes active'")
#define cmd_length  "test_LENGTH"
#define txt_length  QT_TR_NOOP("open TEST LENGTH dialog")
#define sug_length  QT_TR_NOOP("just record 'test LENGTH'")
#define cmd_next    "NEXT_exercise"
#define txt_next    QT_TR_NOOP("NEXT exercise")
#define sug_next    QT_TR_NOOP("just record 'NEXT exercise'")
#define cmd_treble  "TREBLE_clef"
#define txt_treble  QT_TR_NOOP("choose TREBLE clef")
#define sug_treble  QT_TR_NOOP("just record 'TREBLE clef'")
#define cmd_bass    "BASS_clef"
#define txt_bass    QT_TR_NOOP("choose BASS clef")
#define sug_bass    QT_TR_NOOP("just record 'BASS clef'")

#define cmd_stop    "STOP_test"
#define txt_stop    QT_TR_NOOP("STOP test")
#define sug_stop    QT_TR_NOOP("just record 'test-STOP' ('ST' in the\nbeginning may be mis-recognized!)")
#define cmd_start   "START_test"
#define txt_start   QT_TR_NOOP("START test")
#define sug_start   QT_TR_NOOP("just record 'test-START' ('ST' in the\nbeginning may be mis-recognized!)")

#define NUMCOMMANDS 17
// head-items (directory-like containters for commandItems):
#define NUMHEADS 4

// similar definitions for notes with sharps/flats:
// 
// how to take care of german/english notation automatically?
//
// Notes with sharps:
#define cmd_csharp   "csharp"
#define txt_csharp   QT_TR_NOOP("C sharp")
#define cmd_dsharp   "dsharp"
#define txt_dsharp   QT_TR_NOOP("D sharp")
#define cmd_fsharp   "fsharp"
#define txt_fsharp   QT_TR_NOOP("F sharp")
#define cmd_gsharp   "gsharp"
#define txt_gsharp   QT_TR_NOOP("G sharp")
#define cmd_asharp   "asharp"
#define txt_asharp   QT_TR_NOOP("A sharp")
// Notes with flats:
#define cmd_dflat   "dflat"
#define txt_dflat   QT_TR_NOOP("D flat")
#define cmd_eflat   "eflat"
#define txt_eflat   QT_TR_NOOP("E flat")
#define cmd_gflat   "gflat"
#define txt_gflat   QT_TR_NOOP("G flat")
#define cmd_aflat   "aflat"
#define txt_aflat   QT_TR_NOOP("A flat")
#define cmd_hflat   "hflat"
#define txt_hflat   QT_TR_NOOP("H flat")
#define cmd_bflat   "bflat"
#define txt_bflat   QT_TR_NOOP("B flat")



#include <qvariant.h>
#include <kdialogbase.h>
#include <qpixmap.h>
#include <kfiledialog.h>
#include <qlistview.h>
/***************************************************************************
 based on microphone_config.h from cvoicecontrol-0.9alpha by Daniel Kiecza
***************************************************************************/

#ifndef MICROPHONE_CONFIG_H
#define MICROPHONE_CONFIG_H

extern "C" {
#include "mixer.h"
#include "audio.h"
#include "model.h"
}
#include <time.h>

extern MixerDevices *mixer_devices;
extern AudioDevices *audio_devices;

/*****
      fraction of max level (=32768) below which the signal is
      considered to represent silence
*****/
extern float silence ;/*   = 0.02;*/
/*****
      fraction of max level (=32768) below which the signal is
      considered to represent (too) low volume speech
*****/
extern float low_volume ;/*= 0.15;*/
/*****
      fraction of max level (=32768) above which the signal is
      considered to represent (too) high volume speech
*****/
extern float high_volume ;/*= 0.75;*/

#define MIN_REASONABLE_MIC_LEVEL   20
#define MAX_REASONABLE_IGAIN_LEVEL 50

#endif
//************ end - Kiecza's microphone_config.h

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QLabel;
class QPushButton;
class QSpinBox;
class QComboBox;
class QMessageBox;



#define MAXPAGE 10
// max number of pages in this wizard

//unsigned char *getUtterance(int *length);

class dVoiceMicroSetup : public KDialogBase
{ 
  Q_OBJECT

    public:
  dVoiceMicroSetup(QWidget* parent = 0,
		   const char* name = 0, bool modal = FALSE);
  ~dVoiceMicroSetup();

  protected slots:
    virtual void slotOK();
  virtual void slotCancel();
  virtual void slotClose();
  virtual void slotUser1();
  virtual void slotUser2();
  virtual void slotUser3();

  virtual void constructorPart2();
  // page 1:
  virtual void CB_mixer_activated(int);
  virtual void CB_audio_activated(int);
  // page 2:
  virtual void adjust_miclevel();
  // page 3:
  virtual void PBthreshold_clicked();
  // page 4:
  virtual void PBcharacter_clicked();
  // page 5:
  virtual void PBsave_clicked();

 protected:
  virtual void setupPage(int newPageNumber);
  virtual void infoPopup(const QString txt,
			 const QString tit=QT_TR_NOOP("Microphone setup:")) ;
  virtual void warningPopup(const QString txt,
			    const QString tit=QT_TR_NOOP("Microphone setup:"));
  virtual void exitWithError(const QString* txt);



  enum state {inactive, invalid, ok};

  enum state status[7];/* = {invalid, invalid, inactive, inactive, inactive,
			  inactive, invalid};*/
  // inactive = not available for user yet
  // invalid  = available, but not set right
  // ok = available and set right

  QVBox * dialogMicroBox;
  QFrame* leftFrame;
  QFrame* rightFrame[MAXPAGE]; //frames for pages
  QString* warntxt[MAXPAGE];  //warning-on-cancel txts
  QString* infotxt[MAXPAGE];  //info(left label) txts
  QString* titletxt[MAXPAGE]; //title txts

  QVBoxLayout * rightLayout;  // layout inside rightFrame; recycled ;)


  int currentPage;
  int endPage; // has to be smaller than MAXPAGE!


  // page 1:
  QComboBox*   CB_mixer ;
  QLabel* comments_mixer;
  QComboBox*   CB_audio ;
  QLabel* comments_audio;

  // page2:
  bool mixerIgainEnabled;// set by CB_mixer setup!
  int mic_level; /***** initial values for Microphone and */
  int igain_level;  /***** Input Gain level */
  int max_sample; /***** max 16-bit sample value coming from the sound card :*/
  /**** temporary variables: */
  int count;
  int max_gain;
  QPushButton* PBadjust_igain;
  QPushButton* PBadjust_miclevel;
  QLabel* comment_miclevel;
  QLabel* label_miclevel_value;

  //page3:
  QPushButton* PBthreshold;
  QLabel* comment_threshold;

  //page4:
  QPushButton* PBcharacter;

  //page5:
  QPushButton* PBsave;

  QLabel* title;
  QLabel* info;

  QHBoxLayout* tmpHLayout;//recycled
  QLabel* tmpLabel; //recycled
  QString tmpString;
};

/***************************************************************************
 based on model_editor.h from cvoicecontrol-0.9alpha by Daniel Kiecza
***************************************************************************/
#define MIN_NR_SAMPLES_PER_ITEM 4

#include "keypressed.h"
#include "klearnnotes2.h"

class dModelEditor: public KDialogBase
{ 
  Q_OBJECT

    public:
  dModelEditor(const QString filename="", KLearnNotes2* parent = 0,
	       const char* name = 0, bool modal = FALSE);
  ~dModelEditor();

  virtual void setKeypressed(bool pressed);

  protected slots:
    virtual void constructorPart2();
  virtual void slotClose();
  virtual void slotOk();
  virtual void slotCancel();
  virtual void slotUser1();// About
  virtual void slotUser2(); // Save as...
  virtual void slotUser3(); // Save
  virtual void PBloadModel_clicked();
  virtual void PBsaveAs_clicked();
  virtual void PBsave_clicked();
  virtual void startNewModel();

  // page 2 only:
  virtual void selectedNoteChanged(QListViewItem * newItem);
  virtual void PBplay2_clicked();
  virtual void PBdelete2_clicked();
  virtual void PBdeleteAll2_clicked();
  virtual void PBrecord2_clicked();
  //  virtual void PBrecord2_clicked_Part2();

  //page 3 only:
  virtual void selectedCommandChanged(QListViewItem * tmpSignalItem);
  virtual void PBplay3_clicked();
  virtual void PBdeleteAll3_clicked();
  virtual void PBdelete3_clicked();
  virtual void PBrecord3_clicked();


 protected: 
  virtual bool isHead(QListViewItem * listItem);
  virtual int safeResetModel();
  virtual void exitWithError(const QString* txt) ;
  virtual void infoPopup(const QString txt,
			 const QString tit=QT_TR_NOOP("Voice speaker model editor:")); 
  virtual void warningPopup(const QString txt,
			    const QString tit=QT_TR_NOOP("Voice speaker model editor:"));
  int playSample(ModelItemSample *sample);
  ModelItemSample *recordSample();
  unsigned char * getUtterance(int *length); // moved from Kiecza's audio.c
  //       to make it react to Qt Cancel

  virtual void loadFile(const QString qsFileName);
  virtual void save(QString qsFileName);

  virtual void debugModel();// writes model info to stdout
  virtual int noteItemNumber(QListViewItem * it); // number of item in model
  virtual int commandItemNumber(QListViewItem * it); // number of item in model
  virtual int sampleNumber(ModelItem *,QString);// number of sample in modelitem
  virtual void addMissingItems();
  virtual void deleteEmptyItems();
  virtual void updateModelViews();

  virtual void initKeyPressed();
  virtual int keyPressed();
  virtual void endKeyPressed();
  int keypressed;
  KeyPressDialog* cancelDialog;


  Model *model;            /***** speaker model */
  char *model_file_name ;  /***** name of speaker model file */
  QString modelFileName; 
  int modified;            /***** tells whether the model has been modified */
  KLearnNotes2* papa;



  // PAGE 1:
  QFrame *page1;
  QVBoxLayout *page1Layout;
  QHBoxLayout* tmpLayout;// recycle!
  QLabel* modelLabel;
  QLabel* lModelFile;

  QPushButton* PBnewModel;
  QPushButton* PBloadModel;
  QPushButton* PBsaveModel;
  QPushButton* PBsaveModelAs;

  // PAGE 2:
  QListView * noteList;
  QListViewItem* noteItems[7];


  QFrame *page2;
  QHBoxLayout *page2Layout;
  QVBoxLayout * rightLayout2;
  QLabel* lComments2;
  QListView* samplesList2;

  QPushButton* PBrecord2;
  QLabel* lRecordLeft2;
  QPushButton* PBplay2;
  QPushButton* PBdelete2;

  // PAGE 3:
  QListView * commandList;
  QListViewItem* commandItems[NUMCOMMANDS];
  QString* commandStrings[NUMCOMMANDS][3];
  QListViewItem* head[NUMHEADS];

  QFrame *page3;
  QHBoxLayout *page3Layout;
  QVBoxLayout * rightLayout3;
  QLabel* lComments3;
  QListView* samplesList3;
  QPushButton* PBrecord3;
  QLabel* lRecordLeft3;
  QPushButton* PBplay3;
  QPushButton* PBdelete3;

  QListViewItem* lastNoteItem;
  QListViewItem* lastCommandItem;

};

#endif // VOICE_RECOGNITION_H
