/***************************************************************************
 ** $Id: randomobject.h,v 1.2 2003/12/06 18:52:36 wiecko Exp $
                          klearnnotes2
                          randomobject.h -  description
                             -------------------
    begin                : Sat Nov 29 01:54:17 CET 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLN_RANDOMOBJECT
#define KLN_RANDOMOBJECT

class RandomObject
{
 public:
  RandomObject(); //the creator
  ~RandomObject(); //the destructor

  void resetStats();

  void addCorrect(int t); // add one correct answer to the statistics
  void addWrong(  int t);// add one wrong answer to the statistics
  //                  t=time spent on this answer

  int getCorrect();
  int getWrong();
  int getTime();
  double getSpeed();
  double getProbab(); // gives statProbab: a weight determining 
                      // probability of re-asking question about this object;
                      // increased by wrong or slow answers;
                      // decreased by right and fast answers;

 protected:
  void updateStats(); //used whenever an answer is given

  int statOK;
  int statWR;
  int statTIME;
  double statSPEED;
  double statPROBAB;  // a weight determining probability of
                      // re-asking question about this note;
                      // increased by wrong or slow answers;
                      // decreased by right and fast answers;

};


void RandomObject_init(RandomObject* suggestion[], const int maxSug,
		       RandomObject* questions[], int numObjects);

void RandomObject_next(int quenum, RandomObject* lastObject[],
		       RandomObject* newObject[],
		       RandomObject* suggestion[],
		       const int maxSug,
		       RandomObject* questions[], int numObjects);

void RandomObject_schedule(int quenum,RandomObject* object[],
			   RandomObject* suggestion[], const int maxSug);

#endif
