/***************************************************************************
 ** $Id: randomobject.cpp,v 1.2 2003/12/06 18:52:36 wiecko Exp $
                          klearnnotes2
                          randomobject.cpp -  description
                             -------------------
    begin                : Sat Nov 29 01:54:17 CET 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "globals.h"
#include "randomobject.h"
#include <kapp.h> //random
#include "klearnnotes2-defs.h"

RandomObject::RandomObject()
{
  resetStats(); // BUT resetStats() has to be run in a beginning of any test
  //               anyway!
}
RandomObject::~RandomObject() {}


void RandomObject::resetStats()
{
  statOK=0;
  statWR=0;
  statTIME=0;
  statSPEED=1;
  statPROBAB=1;
}

double RandomObject::getProbab() {  return statPROBAB;}
double RandomObject::getSpeed()  {  return statSPEED;}
int RandomObject::getWrong()  {  return statWR;}
int RandomObject::getCorrect(){  return statOK;}
int RandomObject::getTime()   {  return statTIME;}

void RandomObject::addCorrect(int t)
{
  statOK++;
  statTIME+=t;
  updateStats();
}

void RandomObject::addWrong(int t)
{
  statWR++;
  statTIME+=t;
  updateStats();
}

void RandomObject::updateStats()
{
  // IMPORTANT: 
  // for this to make sense, force-scheduled frist run is obligatory;
  // it should ask question about each object considered;
  // this sets up stats for all RandomObjects in a group, and therefore
  // * no initial values are needed
  // * overall scale does not count
  //   (they would if there were both 'un-run' and 'run' objects)
  if (statTIME>0) 
    {
      statSPEED=double(statOK+statWR)/double(statTIME);
    }
  if (statSPEED>0)
    {
      statPROBAB=KLNmath_power(double(5),statWR)*
	KLNmath_power(double(0.75),statOK)/statSPEED;
    }else{
      printerror("Sth. wrong: note's speed==0  ?????");
      statPROBAB=KLNmath_power(double(5),statWR)*
	KLNmath_power(double(0.75),statOK);
    }
}


void RandomObject_init(RandomObject* suggestion[], const int maxSug,
		       RandomObject* questions[], int numObjects)
  // initialize a matrix of suggestions to NULL,
  // and first, force-scheduled run
{
  for (int i=0;i<maxSug;i++)
    suggestion[i]=NULL;

  // force-scheduling of first run of questions:
  int tmp[defMAXall]; // for deleting the scheduled number from 
  //                     the matrix of available ones
  int whichone;
  for(int i =0;i<numObjects;i++) tmp[i]=i;
  for(int i =0;i<numObjects;i++)
    {
      whichone=KApplication::random() % (numObjects-i);
      suggestion[i+1]=questions[tmp[whichone]];
      // i+1 because it will be called sug[queNum],and queNum starts from 1
      for(int j=whichone;j<numObjects-i-1;j++)
	tmp[j]=tmp[j+1];
    }
}



void RandomObject_next(int quenum, RandomObject* lastObject[], 
		       RandomObject* newObject[],
		       RandomObject*suggestion[], const int maxSug,
		       RandomObject*questions[], int numObjects)
{
  if (suggestion[quenum%maxSug]!=NULL)
    {
      //      debuginfo("USING A FORCE-SCHEDULED NOTE");
      newObject[0]=suggestion[quenum%maxSug];
      suggestion[quenum%maxSug]=NULL;
    }
  else
    {
      //      debuginfo("USING A RANDOM NOTE");
      //
      //***** wise RANDOM start *****
      // 
      double weight=0;
      for (int i = 0 ; i< numObjects; i++)
	weight+=questions[i]->getProbab();
      double regions[defMAXall]; //weights for not-so-random notes generation
      regions[0]=questions[0]->getProbab()/weight*10000;
      for (int i = 1; i <numObjects; i++)
	regions[i]=regions[i-1]+
	  questions[i]->getProbab()/weight*  10000;
      int objectIndex;
      double tmpnum;
      do {
	tmpnum = KApplication::random() % 10000 ;
	objectIndex=0;
	for (int i = 0; i <numObjects-1; i++)
	  if (tmpnum>regions[i])
	    objectIndex=i+1;
      } while( questions[objectIndex] == lastObject[0] );
      newObject[0]=questions[objectIndex];
      //
      //***** wise RANDOM end *****
      //
    }
}



void RandomObject_schedule(int quenum,RandomObject* object[],
			   RandomObject*suggestion[], const int maxSug)
{
  // scheduling up2 3 same questions:
  int prop=2;//the first after 2 questions from now
  while((!(suggestion[(quenum+prop)%maxSug]==NULL))&&(prop<maxSug))
    prop++;//but if sth. else is scheduled for `now+2' we schedule
  //         for next available free slot
  if (prop<maxSug) //did `until' broke NOT because excess of maxSug?
    {
      //if yes, it found a free slot:
      suggestion[(quenum+prop)%maxSug]=object[0];
      prop+=3;
      while((!(suggestion[(quenum+prop)%maxSug]==NULL))&&(prop<maxSug))
	prop++;
      if (prop<maxSug)
	{
	  suggestion[(quenum+prop)%maxSug]=object[0];
	  prop+=3;
	  while((!(suggestion[(quenum+prop)%maxSug]==NULL))&&(prop<maxSug))
	    prop++;
	  if (prop<maxSug)
	    suggestion[(quenum+prop)%maxSug]=object[0];
	  }
      }
  //    debuginfo("DONE UPDATING SCHEDULE TABLE");
}
