/***************************************************************************
 ** $Id: midi_setup.cpp,v 1.7 2003/12/20 03:31:03 wiecko Exp $
                          klearnnotes2
                          midi_setup.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klearnnotes2.h"
#include "midi_setup.h"
#include "midi.h"

#include <qvariant.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qtranslator.h>


MIDI_setup::MIDI_setup(QPixmap pix, QWidget* parent,  const char* name, 
		       bool modal, WFlags fl )
  : QDialog( parent, name, modal, fl )
  // note: pix is a pixmap for What'sThis button
{
  if ( !name )
    setName( "MIDI_setup" );
  //  resize( 580, 226 ); 
  setCaption( tr( "MIDI sound setup" ) );
  MIDI_setupLayout = new QGridLayout( this, 1, 1, 11, 6, "MIDI_setupLayout"); 

  TextLabel1 = new QLabel( this, "TextLabel1" );
  TextLabel1->setText( tr( "MIDI device &number" ) );
  MIDI_setupLayout->addWidget( TextLabel1, 0, 0 );
  SpinBox2 = new QSpinBox( this, "SpinBox2" );
  SpinBox2->setMaxValue( 5 );
  SpinBox2->setMinValue( 0 );
  SpinBox2->setValue(midiCurrentDevice  );
  QWhatsThis::add( SpinBox2, tr( "If you do have a midi sequencer but you "
				     "don't hear sound - experiment with this"
				     " setting. Check if you hear sound after "
				     "pressing \"Test\"." ) );
  MIDI_setupLayout->addWidget( SpinBox2, 0, 1 );
  TextLabel1->setBuddy(SpinBox2);
  TextLabel2 = new QLabel( this, "TextLabel2" );
  TextLabel2->setText( "" );
  MIDI_setupLayout->addMultiCellWidget( TextLabel2, 0, 0, 2, 4 );
  PushButton1 = new QPushButton( this, "PushButton1" );
  PushButton1->setText( tr( "Test" ) );
  QWhatsThis::add( PushButton1, tr("You should hear 2 chords!"));
  MIDI_setupLayout->addWidget( PushButton1, 0, 5 );


  TextLabel10 = new QLabel( this, "TextLabel10" );
  TextLabel10->setText( tr( "Number of &channels" ) );
  MIDI_setupLayout->addWidget( TextLabel10, 1, 0 );
  SpinBox6 = new QSpinBox( this, "SpinBox6" );
  SpinBox6->setMaxValue( 16 );
  SpinBox6->setValue( midiMaxChan );
  QWhatsThis::add( SpinBox6, tr("If you hear a few notes, then you "
				    "don't hear next few notes, then again "
				    "you hear a few notes and so on, try "
				    "lowering this number below the default "
				    "16."));
  MIDI_setupLayout->addWidget( SpinBox6, 1, 1 );
  TextLabel10->setBuddy(SpinBox6);


   TextLabel3 = new QLabel( this, "TextLabel3" );
   TextLabel3->setText( tr( "Master &Volume" ) );
   MIDI_setupLayout->addWidget( TextLabel3, 3, 0 );
   SpinBox1 = new QSpinBox( this, "SpinBox1" );
   SpinBox1->setMaxValue( 100 );
   SpinBox1->setValue( mixerMasterVolume() );
   SpinBox1->setEnabled( mixerIsOpen() );
   MIDI_setupLayout->addWidget( SpinBox1, 3, 1 );
   TextLabel3->setBuddy(SpinBox1);
   TextLabel4 = new QLabel( this, "TextLabel4" );
   TextLabel4->setText( tr( "%" ) );
   MIDI_setupLayout->addWidget( TextLabel4, 3, 2 );
   QWhatsThis::add( SpinBox1, tr("This is volume affecting all sound output, "
				 "e.g. music form CD, mp3 players, MIDI. "
				 "To get maximum volume both: Master Volume "
				 "and Midi Volume have to be at 100%."));


   TextLabel13 = new QLabel( this, "TextLabe1l3" );
   TextLabel13->setText( tr( "MIDI Vo&lume" ) );
   MIDI_setupLayout->addWidget( TextLabel13, 4, 0 );
   SpinBox11 = new QSpinBox( this, "SpinBox11" );
   SpinBox11->setMaxValue( 100 );
   SpinBox11->setValue( midiCurrentVolume );
   MIDI_setupLayout->addWidget( SpinBox11, 4, 1 );
   TextLabel13->setBuddy(SpinBox11);
   TextLabel14 = new QLabel( this, "TextLabel14" );
   TextLabel14->setText( tr( "%" ) );
   MIDI_setupLayout->addWidget( TextLabel14, 4, 2 );
   QWhatsThis::add( SpinBox11, tr("This is volume affecting only MIDI output;"
				  "all sound output (e.g. music form CD, "
				  "mp3 players) is not affected. "
				  "To get maximum volume both: Master Volume "
				  "and Midi Volume have to be at 100%."));





  TextLabel5 = new QLabel( this, "TextLabel5" );
  TextLabel5->setText( tr( "Note &length" ) );
  MIDI_setupLayout->addWidget( TextLabel5, 5, 0 );
  SpinBox3 = new QSpinBox( this, "SpinBox3" );
  SpinBox3->setMaxValue( 150 );
  SpinBox3->setMinValue( 20 );
  SpinBox3->setValue( midiNoteLength );
  MIDI_setupLayout->addWidget( SpinBox3, 5, 1 );
  TextLabel5->setBuddy(SpinBox3);
  TextLabel6 = new QLabel( this, "TextLabel6" );
  TextLabel6->setText( tr( "ms" ) );
  MIDI_setupLayout->addWidget( TextLabel6, 5, 2 );
  QWhatsThis::add( SpinBox3, tr(" length of a note played; \n"
				" test it with the TEST button"));

  TextLabel7 = new QLabel( this, "TextLabel7" );
  TextLabel7->setText( tr( "MIDI patc&h" ) );
  MIDI_setupLayout->addWidget( TextLabel7, 6, 0 );
  SpinBox4 = new QSpinBox( this, "SpinBox4" );
  SpinBox4->setMaxValue( 127 );
  SpinBox4->setValue( midiPatch );
  MIDI_setupLayout->addWidget( SpinBox4, 6, 1 );
  TextLabel7->setBuddy(SpinBox4);
  QWhatsThis::add( SpinBox4, tr("(0-127); 0=piano, 24=guitar" ) );


  TextLabel9 = new QLabel( this, "TextLabel9" );
  TextLabel9->setText( tr( "Octave &bias" ) );
  MIDI_setupLayout->addWidget( TextLabel9, 7, 0 );
  SpinBox5 = new QSpinBox( this, "SpinBox5" );
  SpinBox5->setMaxValue( 0 );
  SpinBox5->setMinValue( -1 );
  SpinBox5->setValue(OCTAVEbias  );
  QWhatsThis::add( SpinBox5, tr("Standard notation for the guitar uses treble "
		   "clef, but each note means an one octave lower note."
		   "<UL>"
		   "<LI>If you set it to 0 you will hear standard sounds."
		   "<LI>If you set it to -1 you will hear sounds which "
		   "your guitar should make (i.e. one octave lower)"
		   "</UL>"
		   "<EM>Note: </EM> If you want to learn notes for the bass "
		   "clef, setting this to 0 is strongly recommended! "
		   "(with -1 sounds in the bass clef are REALLY low).")) ;
  MIDI_setupLayout->addWidget( SpinBox5, 7, 1 );
  TextLabel9->setBuddy(SpinBox5);
  PushButton6 = new QPushButton( this, "PushButton6" );
  PushButton6->setText( " " );
  PushButton6->setPixmap(pix);
  MIDI_setupLayout->addWidget( PushButton6, 7, 5 ,Qt::AlignLeft);


  PushButton2 = new QPushButton( this, "PushButton2" );
  PushButton2->setText( tr( "Set &Guitar defaults" ) );
  MIDI_setupLayout->addWidget( PushButton2, 8, 0 );
  PushButton3 = new QPushButton( this, "PushButton3" );
  PushButton3->setText( tr( "Set non-guitar &defaults" ) );
  MIDI_setupLayout->addMultiCellWidget( PushButton3, 8, 8, 1, 2 );
  PushButton4 = new QPushButton( this, "PushButton4" );
  PushButton4->setText( tr( "OK" ) );
  MIDI_setupLayout->addWidget( PushButton4, 8, 3 );
  PushButton5 = new QPushButton( this, "PushButton5" );
  PushButton5->setText( tr( "Cancel" ) );
  MIDI_setupLayout->addWidget( PushButton5, 8, 4 );

  // signals and slots connections
  connect(PushButton2,SIGNAL(clicked()),this,       SLOT(PB_guitar_clicked()));
  connect(PushButton3,SIGNAL(clicked()),this,    SLOT(PB_nonguitar_clicked()));
  connect(PushButton4,SIGNAL(clicked()),this,        SLOT(PB_OK_clicked()));
  connect(PushButton5,SIGNAL(clicked()),this,       SLOT(PB_cancel_clicked()));
  connect(SpinBox2,   SIGNAL(valueChanged(int)),this,SLOT(SB_device_changed(int)));
  connect(SpinBox6,   SIGNAL(valueChanged(int)),this,SLOT(SB_channels_changed(int)));
  connect(SpinBox1,SIGNAL(valueChanged(int)),this,SLOT(SB_master_volume_changed(int)));
  connect(SpinBox11,SIGNAL(valueChanged(int)),this,SLOT(SB_midi_volume_changed(int)));
  connect(SpinBox3,   SIGNAL(valueChanged(int)),this,SLOT(SB_notelength_changed(int)));
  connect(SpinBox4,   SIGNAL(valueChanged(int)),this,SLOT(SB_midi_patch_changed(int)));
  connect(SpinBox5,   SIGNAL(valueChanged(int)),this,SLOT(SB_octave_changed(int)));
  connect(PushButton1,SIGNAL(clicked()),this,        SLOT(PB_test_clicked()));
  connect(PushButton6,SIGNAL(clicked()),this,        SLOT(PB_what_clicked()));
  connect(SpinBox6,   SIGNAL(valueChanged(int)),this,SLOT(SB_octave_changed(int)));

  // remember old settings:
  olddevice=midiCurrentDevice;
  oldchan=midiMaxChan;
  oldMasterVolume=mixerMasterVolume();
  oldMidiVolume=mixerMidiVolume();
  oldlength=midiNoteLength;
  oldpatch=midiPatch;
  oldoctave=OCTAVEbias;
}

MIDI_setup::~MIDI_setup() { }

void MIDI_setup::PB_guitar_clicked()
{
  SpinBox4->setValue(24);
  SB_midi_patch_changed(24);
  SpinBox5->setValue(-1);
  SB_octave_changed(-1);
}

void MIDI_setup::PB_nonguitar_clicked()
{
  SpinBox4->setValue(0);
  SB_midi_patch_changed(0);
  SpinBox5->setValue(0);
  SB_octave_changed(0);
}

void MIDI_setup::PB_OK_clicked()
{
  accept();
}

void MIDI_setup::PB_cancel_clicked()
{
  //restore settings
  midiCurrentDevice= olddevice ;
  midiMaxChan= oldchan;
  mixerSetMasterVolume(oldMasterVolume);
  mixerSetMidiVolume(oldMidiVolume);
  midiNoteLength= oldlength;
  midiPatch= oldpatch;
  OCTAVEbias= oldoctave;
  reject();
}

void MIDI_setup::SB_device_changed( int newdevice)
{
  midiCurrentDevice=newdevice;
}

void MIDI_setup::SB_channels_changed(int newchan)
{
  midiMaxChan=newchan;
}

void MIDI_setup::SB_master_volume_changed( int newVol)
{
   mixerSetMasterVolume(newVol);
}

void MIDI_setup::SB_midi_volume_changed( int newVol)
{
   mixerSetMidiVolume(newVol);
}


void MIDI_setup::SB_notelength_changed( int newLen)
{
  midiNoteLength=newLen;
}

void MIDI_setup::SB_midi_patch_changed( int newPatch)
{
  midiPatch=newPatch;
  midi_setupPatches();
}

void MIDI_setup::SB_octave_changed( int newBias)
{
  OCTAVEbias=newBias;
}

void MIDI_setup::PB_test_clicked()
{
  //play some music: 2 chords:
  //  CEG
  //   EGC1
  int c=60;
  int d=c+2;
  int e=d+2;
  int f=e+1;
  int g=f+2;
  int a=g+2;
  int h=a+2;
  int c1=h+1;
  midi_addANote2chord(g);
  midi_addANote2chord(e);
  midi_addANote2chord(c);
  midi_playChord();
  midi_addANote2chord(c1);
  midi_addANote2chord(g);
  midi_addANote2chord(e);
  midi_playChord();
}

void MIDI_setup::PB_what_clicked()
{
  QWhatsThis::enterWhatsThisMode();
}
