/***************************************************************************
 ** $Id: midi.cpp,v 1.4 2003/12/20 03:31:03 wiecko Exp $
                          klearnnotes2
                          midi.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// standard code from <linux/soundcard.h>
int midifd = -1;
SEQ_DEFINEBUF(1024);
void seqbuf_dump()
{
  if (_seqbufptr)
    write (midifd, _seqbuf, _seqbufptr);
  _seqbufptr = 0;
}
// std.code - END

int mixerfd=-1;

//void debugtxt(const char* tekst)
//  // debug info to stdout
//{
//  printf("DEBUG MIDI: %s \n",tekst);
//}

#define maxNotesInAChord 40 
//                       ^ this size should be >= no. of channels
int notesToPlay[maxNotesInAChord]; // notes in one chord;
int noOfNotesToPlay;

int midiMaxChan=defMIDIchan; // channel modulus

int midiCurrentDevice=defMIDIdevNum;
int midiCurrentVolume=defMIDIvol; 
int midiCurrentMasterVolume=defMASTERvol;
int midiNoteLength=defNOTElength;
int midiPatch=defMIDIpatch;

static bool tryToSuspendArts=true;


void midi_addANote2chord(int note)  // this only adds a note to notesToPlay
{
  if(midifd==-1)//device is NOT opened
    return;
  notesToPlay[noOfNotesToPlay]=note;
  noOfNotesToPlay=(noOfNotesToPlay+1)%maxNotesInAChord;
}

void midi_playChord() // ... and this plays them all
{
  if((noOfNotesToPlay>0)&&midiIsOn())
    {
      int mypid; // FORK FORK FORK 
      if ((mypid=fork())==0)
	{  
	  //	  debugtxt("Playing FORKED...");
	  int newVel=60;
	  int midiCurrentChannel=0;
	  for(int i=0;i<noOfNotesToPlay;i++)
	    {
	      SEQ_START_NOTE(midiCurrentDevice, midiCurrentChannel,
			     notesToPlay[i], newVel);
	      midiCurrentChannel=(midiCurrentChannel+1)%midiMaxChan;
	      // notes are added to different channels
	    }
	  SEQ_DELTA_TIME(midiNoteLength);
	  seqbuf_dump();        
	  ioctl(midifd, SNDCTL_SEQ_SYNC);
	  midiCurrentChannel=0;
	  for(int i=0;i<noOfNotesToPlay;i++)
	    {
	      SEQ_STOP_NOTE(midiCurrentDevice, midiCurrentChannel,
			    notesToPlay[i], 64);
	      // Uses 0x80, true MIDI note-off 
	      midiCurrentChannel=(midiCurrentChannel+1)%midiMaxChan;
	    }
	  seqbuf_dump();
	  ioctl(midifd, SNDCTL_SEQ_SYNC);
	  //	  debugtxt("... FORKED ending.");
	  _exit(0);  // EXIT CHILD PROCESS AFTER PLAYING A CHORD
	}
    }
  noOfNotesToPlay=0;
}


void midi_setupPatches()
{
  for(int i =0; i< midiMaxChan; i++)
    SEQ_SET_PATCH(midiCurrentDevice,i,midiPatch);
}

bool midi_turnOn()
{
  if (midiIsOn()) 
    {
      debuginfo("midi_turnOn(): but midi IS already on!");
      return true;
    }
  if(tryToSuspendArts)
    {
      //      debuginfo("starting artsSuspendProcess");
      QProcess* artsSuspendProcess=new QProcess();
      artsSuspendProcess->clearArguments ();
      artsSuspendProcess->addArgument( "artsshell" );
      artsSuspendProcess->addArgument( "suspend" );
      if(!artsSuspendProcess->start())
	{
	  //	  debuginfo("artsSuspendProcess will not be started anymore");
	  tryToSuspendArts=false; // probably no artsshell in PATH
	}
      else
	{ //give 0.5s time for suspend
	  KLN_usleep(500000);
	}
      delete artsSuspendProcess;
    }
  if ((midifd = open(MIDI_DEV, O_WRONLY)) == -1)
    {
      debuginfo("midi_turnOn(): couldn't open midi device!");
      return false;     //  Can't open MIDI device
    }
  //  MIDI device is open:
  SEQ_START_TIMER();
  SEQ_SET_TEMPO(100);
  midi_setupPatches();
  if( (mixerfd = open("/dev/mixer", O_WRONLY, 0))==-1 )
    {
      debuginfo("midi_turnOn(): couldn't open mixer device!");
      return true; // can't open mixer but /dev/sequencer is open!
    }
  mixerSetMasterVolume(midiCurrentMasterVolume);
  mixerSetMidiVolume(midiCurrentVolume);
  debuginfo("midi_turnOn(): midi and mixer open");
  return true;
}

void midi_turnOff()
{
  close(midifd);
  midifd=-1;
  if (mixerfd != -1)
    {
      close(mixerfd);
      mixerfd=-1;
    }
}

bool midiIsOn()
{
  if(midifd==-1)
    {
      return false;
    }
  return true;
}

bool mixerIsOpen()
{
  if(mixerfd==-1)
    {
      return false;
    }
  return true;
}

void mixerSetMasterVolume(int newvol)
{
  midiCurrentMasterVolume=newvol;
  if(midiCurrentMasterVolume>100) midiCurrentMasterVolume=100;
  if(midiCurrentMasterVolume<0) midiCurrentMasterVolume=0;
  if(mixerfd!=-1)
    {
      int level = (midiCurrentMasterVolume << 8) + midiCurrentMasterVolume;
      ioctl( mixerfd, MIXER_WRITE(SOUND_MIXER_VOLUME),   &level );
      midiCurrentMasterVolume=level & 0xff;
      // above = returned value for left voulume;
      // right = (level & 0xff00) >> 8;
    }
}

void mixerSetMidiVolume(int newvol)
{
  midiCurrentVolume=newvol;
  if (midiCurrentVolume>100) midiCurrentVolume=100;
  if (midiCurrentVolume<0) midiCurrentVolume=0;
  if(mixerfd!=-1)
    {
      int level = (midiCurrentVolume << 8) + midiCurrentVolume;
      ioctl( mixerfd, MIXER_WRITE(SOUND_MIXER_SYNTH),   &level );
      midiCurrentMasterVolume=level & 0xff;
      // above = returned value for left voulume;
      // right = (level & 0xff00) >> 8;
    }
}

int  mixerMasterVolume()
{
  if(mixerIsOpen())
    {
      int level;
      ioctl( mixerfd, MIXER_READ(SOUND_MIXER_VOLUME), &level );
      if((level& 0xff) != midiCurrentMasterVolume)
	{
	  //	  printerror("Master volume changed by some other program!\n using new settings");
	  midiCurrentMasterVolume=level& 0xff;
	}
    }
  return midiCurrentMasterVolume;
}

int  mixerMidiVolume()
{
  if(mixerIsOpen())
    {
      int level;
      ioctl( mixerfd, MIXER_READ(SOUND_MIXER_SYNTH), &level );
      if((level& 0xff) != midiCurrentMasterVolume)
	{
	  //	  printerror("Midi volume changed by some other program!\n using new settings");
	  midiCurrentMasterVolume=level& 0xff;
	}
    }
  return midiCurrentVolume;
}
