/***************************************************************************
 ** $Id: main.cpp,v 1.8 2004/01/17 01:17:48 wiecko Exp $
                          klearnnotes2
                          main.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/


/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <qtranslator.h>
#include <qtextcodec.h>
#include <qapplication.h>
#include <qfile.h>
#include <qdir.h>
#include <qstringlist.h>

#include "klearnnotes2.h"  // this includes kln-defs.h (SC!)

static const char *shortdescription =
QT_TR_NOOP("KLearnNotes2: Learn music notes' names fast!");
static const char *description =
QT_TR_NOOP("Includes:\n"
	   "* wise learning algorithm, \n"
	   "* treble and bass clefs,\n"
	   "* convenient notes-to-learn selection,\n"
	   "* voice recognition (answer with your mic!)");

KAboutData aboutData( "klearnnotes2", QT_TR_NOOP("KLearnNotes2"),
		      VERSION, shortdescription, KAboutData::License_GPL,
		      "(c) 2003, Marek Wieckowski", description, 0, 
		      "wiecko AT users.sourceforge.net");	

int SC;

static KCmdLineOptions options[] = 
  {
    { "scale <scale>", QT_TR_NOOP("a scale for graphical objects; default: 10 "
				 ),"defSC"},
    { 0, 0, 0 } // End of options.
  };


int main(int argc, char *argv[])
{
  fprintf(stderr,"%s",
	  "\n KLearnNotes2 1.1 Copyright (C) 2003 Marek Wieckowski\n\n"
	  "KLearnNotes2 comes with ABSOLUTELY NO WARRANTY; \n"
	  "either expressed or implied, including, but not limited to, \n"
	  "the implied warranties of merchantability and fitness for a \n"
	  "particular purpose.\n\n"
	  "For details view file COPYING.\n"
	  "This is free software. You are welcome to redistribute it \n"
	  "under terms of GNU Public Licence 2.0 or later (you choose).\n\n"
	  );

  aboutData.addAuthor("Marek Wieckowski",0, 
		      "wiecko AT users.sourceforge.net");
  aboutData.addAuthor("Dominik Seichter",
		      QT_TR_NOOP("1st author of an underlying klearnnotes"
			       "0.1 project"),"domseichter AT web.de");
  aboutData.addAuthor("Daniel Kiecza",
		      QT_TR_NOOP("the author of voice recognition engine"
			       ),"daniel AT kiecza.de");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );
  KApplication a;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  QString QSargSC = args->getOption("scale");
  bool ok;
  SC=QSargSC.toInt(&ok,10);
  if ((SC<1)||(!ok)) SC=defSC;

  args->clear();

  static QTranslator *translator = 0;
  translator = new QTranslator( 0 );
  QStringList localesToCheck;
  localesToCheck.push_back(QTextCodec::locale());
// DEBUG: next localesToCheck[]: ru_RU
// DEBUG: next localesToCheck[]: ru
// DEBUG: next localesToCheck[]: ru_*
// DEBUG: Searched: HERE/klearnnotes2_ru_RU.qm
// DEBUG: Searched: HERE/../po/klearnnotes2_ru_RU.qm
// DEBUG: Searched: SHARE/klearnnotes2_ru_RU.qm
// DEBUG: Searched: HERE/klearnnotes2_ru.qm
// DEBUG: Searched: HERE/../po/klearnnotes2_ru.qm
// DEBUG: Searched: SHARE/klearnnotes2_ru.qm
// DEBUG: Searched: HERE/klearnnotes2_ru_*.qm
// DEBUG: Searched: HERE/../po/klearnnotes2_ru_*.qm
// DEBUG: Searched: SHARE/klearnnotes2_ru_*.qm
  if(!(*localesToCheck.begin()).isEmpty())
    {
      int position=(*localesToCheck.begin()).find('_');
      if (position != -1) // '_' was found : we have "es_MX" kind locale
	{
	  QString tmpString(*localesToCheck.begin()) ;
	  tmpString.truncate(position);
	  localesToCheck.push_back(tmpString);
	}
      // now the last in localesToCheck is without a dash; it is likie "es"
      QStringList::iterator langName=localesToCheck.end();
      langName--; // now it is the last element!
      localesToCheck.push_back(*langName+"_*");
      QStringList dirsToCheck;
      dirsToCheck.append("./");
      if(QDir("../po/").exists())
	dirsToCheck.append("../po/");
      if(QDir("/usr/share/apps/klearnnotes2/locale/").exists())
	dirsToCheck.append("/usr/share/apps/klearnnotes2/locale/");

      QStringList listOfFiles;
      QString dirName;
      QStringList::iterator i;
      QStringList::iterator j;
      for (i = localesToCheck.begin(); i!=localesToCheck.end() ; i++)
	{
	  for( j=dirsToCheck.begin(); j!=dirsToCheck.end(); j++)
	    {
	      listOfFiles=QDir(*j).entryList(QString("klearnnotes2_") +
					     *i+ ".qm");
	      if (listOfFiles.size()>0)
		{
		  dirName=*j;
		  break;
		}
	    }
	}
      if (listOfFiles.size()>0)
	{
	  debuginfo("Loading translations");
	  translator->load(*listOfFiles.begin(),dirName);
	  a.installTranslator(translator );
	}
    }

  KLearnNotes2 *klearnnotes2 = new KLearnNotes2();
  a.setMainWidget(klearnnotes2);
  klearnnotes2->show();  
  
  return a.exec();
}
