/***************************************************************************
 ** $Id: klearnnotes2.h,v 1.10 2003/12/20 03:31:03 wiecko Exp $
                          klearnnotes2
                          klearnnotes2.h  -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**************************************************************************
 * 
 * a general idea, names of some functions/slots (checkanswer/redraw)
 * and the way notes/lines are numbered comes from 
 * 
 *          Dominik Seichter's       klearnnotes 
 *
 **************************************************************************/

#ifndef KLEARNNOTES_H
#define KLEARNNOTES_H
//#define _KLN_SHOW_SCHEDULE
#define _WITH_VOICE_CONTROL
#include "klearnnotes2-defs.h"
#include <config.h>   
#include <qwidget.h>
#include <qcanvas.h>
#include <qpushbutton.h>
#include <qvariant.h>
#include <qmainwindow.h>
#include <qaction.h>


#include "midi.h"

class QTimer;
class QLCDNumber;
class QTimer;
class QSlider;
class QComboBox;
class QLabel;
class QCheckBox;
class QProcess;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class QToolButton;
class QActionGroup;
class QStatusBar;
class QSpinBox;
class QFile;
class QGroupBox;
class QTextEdit;

class clickableView;
class staffLine;
class aNote;

class actionWithIconSwitch;
class fancyButton;
class fancyQLCDNumber;
class KHelpMenu;

///////////// GLOBALS
#include "globals.h"

extern char orderOfNotes [8] ; //int(name) => char(cname)
// used both by all aNote-s and main KLN2 to set buttons' names

///////////////end GLOBALS


class KLearnNotes2 : public QMainWindow
{
  Q_OBJECT
    public:
  KLearnNotes2(QWidget* parent=0,const char *name=0,WFlags fl=WType_TopLevel);
  ~KLearnNotes2();

  bool isStarted();
  void PBchangeColorTmp(int buttonNo,int time=INTERVAL);
  void setVoiceModelFilename(QString newName);// note: this adds this to the
  //           voiceProcess arguments!




  protected slots:
    void nextNote();		// question --^
  // MENU/TOOLBAR SLOTS:
  void dialogTestLengthFactor();
  void dialogSetupMidi();
#ifdef _WITH_VOICE_CONTROL
  void dialogVoiceMircoSetup();
  void dialogVoiceModelEditor();
#endif
  void setGermanHNotation(bool notationH);
  void mH_doesntWork_about_activated();
  void mH_doesntWork_index_activated();
  void mH_doesntWork_quickStart_activated();
  void mH_doesntWork_voiceQuickStart_activated();
  void mH_KHelp_activated();
  void mH_quickStart_activated();
  void mH_voiceQuickStart_activated();
  void mH_about_activated();
  void turnSoundOnOff(bool onOrOff);
#ifdef _WITH_VOICE_CONTROL
  void voiceTurnSoundOnOff(bool onoroff);
#endif
  void setClefTreble(bool treble);// by action
  void setClef(int indeks);
  void setLevelByAction(QAction*);
  void setLevelByCombo(int);
  void a_mo_setLevelCustom_activated();// to show custom dialog when activated and not toggled!
  void saveOptions();
  void loadOptions();
  void endKLearnNotes2();

  void activeNotesChangedByExercise(int indeks);
  void activeNotesChangedManual(int notimportant); 
  //                     i.e. by sliders or checkboxes


  void startstop();
  void nextExercise();

  //  void setTestLengthFactor(int number);

  // ANSWER SLOTS: 
  void keyPressEvent( QKeyEvent *k );
  void noteC();
  void noteD();
  void noteE();
  void noteF();
  void noteG();
  void noteA();
  void noteH();

  // TIMER SLOTS:
  void growtime();
  void resetComments(); 
  void redraw(); // this is just "sleep" after answer has been checked
  //                signal because called after a timeout:
  //                it is in fact part of "checkanswer()"

#ifdef _WITH_VOICE_CONTROL
  // voice recognition slots:
  void readFromVoice(); // cvoicecontrol inputs
  void voiceStartStop(bool); // cvoicecontrol starts
  void voiceExited(); // when cvoicecontrol exits
#endif

 protected:
  void setupExercises();	// now called only once, by the creator,
  //                            but potentially useful to setup different
  //                            exercises e.g. for different clefs or different
  //                            levels
  int HBexeNums[8]; // in each region there are 2 exes with H/B note; their txt
  // should change, depending on whether one uses German or English notation

  bool noteNameIsActive(char); //should we consider a keyboard answer at all?
  void setupActiveNotes(); //when sliders/checkboxes change:
  //             setups noOfActiveNotes, actNot[] and  makes actNot[] visible
  void checkanswer(char);	//            _-- answer

#ifdef _KLN_SHOW_SCHEDULE
  void debugShowSuggestions(int activequenum=-1);
#endif
  // ACTIONS, MENUS
  bool dialogCustom_show();
  void setupSpeedGoal();
  int speed2(int level);
  int speed7(int level);
  void setupLevelCustom_withoutDialog();

  void calculateTestLength();
  
  void comment(QString txt,  QColor commentsBgColor = QColor(255,255,255));
  //           adds a comment to commentsText

  bool restoring; // when custom level is set by load it should not 
  //                 lead to opening a dialog
  QMenuBar     *menubar;
  QPopupMenu   *MenuPractice;
  QPopupMenu   *MenuOptions;
  QPopupMenu   *MenuHelp;
  KHelpMenu    *MenuHelpK;

  QPopupMenu    *mp_Cleves_menu;
  QActionGroup  *mp_Cleves_grp;
  actionWithIconSwitch    *a_mp_SetClefTreble;
  actionWithIconSwitch    *a_mp_SetClefBass;
  QAction              *a_mp_Quit;

  QPopupMenu   *mo_Levels_menu;
  QActionGroup  *mo_Levels_grp;
  actionWithIconSwitch    *a_mo_setLevel[4];
  actionWithIconSwitch    *a_mo_setNotationGE;
  QAction     *a_mo_setTestLength;
  actionWithIconSwitch    *a_mo_soundOnOff;
  QAction    *a_mo_soundSetup;

#ifdef _WITH_VOICE_CONTROL
  QPopupMenu   *mo_Voice_menu;
  QAction    *a_mo_voiceMicroSetup;
  actionWithIconSwitch    *a_mo_voiceOnOff;
  QProcess   *voiceProcess;
  QFile      *voiceModelFile;
  QAction    *a_mo_startVoiceEditor;
#endif

  QAction    *a_mo_save;
  QAction    *a_mo_load;

  QAction    *a_mH_KHelp;
  int id_mH_help;
  QAction    *a_mH_KQuickStart;
  QAction    *a_mH_KVoiceQuickStart;
  QPopupMenu *mH_doesntwork_menu;
  int id_mH_doesnt;
  QAction    *a_mH_about_doesntwork;
  QAction    *a_mH_index;
  QAction    *a_mH_quickStart;
  QAction    *a_mH_voiceQuickStart;
  QAction    *a_mH_about;


  QStatusBar  *statbar;


  QToolBar    *programToolBar;
  QToolBar    *exerciseToolBar;
  QToolButton *tbWhat;
  QPushButton* bStartStop ;
  QAction*     aStartStop ;
  QAction*     aNextExercise;
  QComboBox*   CB_exercise ;
  int lastExercise;
  QComboBox*   CB_clef ;
  QComboBox*   CB_level ;
  //  QSpinBox*    SB_testLength;

  // buttons, canvas, sliders, labels:
  QCanvas* c;
  clickableView* drawArea;
  QSlider* minmax1;
  QSlider* minmax2;
  bool autochange;// if true changes in sliders are done by exercise
  //                 and shouldn't change exercises back to "custom"

  QLabel* nameKeys[7]; // labels showing alternative key input
  fancyButton* namePBs[7];
  QCheckBox*   nameCHKs[7];
  //  QLabel*      labelComments ;
  QGroupBox*   commentsGroup;
  QTextEdit*   commentsText;
  QLabel*      labelQueNum ;
  QLCDNumber*  LCD_queTime;

  // total statistics:
  QLCDNumber* LCD_numOK;
  QLCDNumber* LCD_numWR;
  fancyQLCDNumber* LCD_speed;
  QLCDNumber* LCD_yourGoal;
  int timespent; //time spent on all question since start()
  QTimer* clocky;
	

  staffLine* linesabove [defNOofLINESabove];
  staffLine* linesbelow [defNOofLINESbelow];
  staffLine* guidelines [defNOofLINESabove+defNOofLINESbelow];


  QCanvasPolygonalItem* clefItem[2]; //clefs' pictures

  aNote* allNotes [defMAXall];
  aNote* activeNotes[defMAXall];
  int numActiveNotes;
  aNote* note;	// this question
  int quenum;	// which question is this?
  int onetime;  // time spent on 1 question; it is not needed, because
  // one could do LCD_onetime++ rather than onetime++;
  // but maybe this makes code a bit simpler

  aNote* suggestion[defMAXseria]; // forced schedule for future questions


  // corrected (lowered if inconsistent) values of maxabove, maxall, 
  // nooflinesabove and nooflinesbelow:
  int numNotesABOVE;
  int numNotesALL;
  int numLinesABOVE;
  int numLinesBELOW;

  int posOfTopLine; // y-position of the toppest of the 5 main lines
  int testLength;
  int testLengthFactor;

  aNote* nullNote; // used just as a note previous to the toppest one
  QColor bgcolor; // used to switch back bgcolor of LCD_numWR
  int customSpeedGoal2;
  int customSpeedGoal7;
  int lastLevel; // if user has chosen "custom level" and then clicked 
  //                "cancel" we should go back to the previous level;
  //                 lastLevel remembers it's number
};

#endif
