/***************************************************************************
 ** $Id: klearnnotes2.cpp,v 1.15 2003/12/30 23:54:15 wiecko Exp $
                          klearnnotes2
                          klearnnotes2.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**************************************************************************
 * 
 * a general idea, names of some functions/slots (checkanswer/redraw)
 * and the way notes/lines are numbered comes from 
 * 
 *          Dominik Seichter's       klearnnotes
 *
 ***************************************************************************/

//#define _KLN_GENERAL_DEBUG


#include <kaboutapplication.h>
#include <kaboutdata.h>
#include <kapp.h>
#include <qtranslator.h>
#include <khelpmenu.h>

#include <qstring.h>
#include <qtimer.h>
#include <qevent.h> 	// keyboard handlers
#include <ctype.h> 	//tolower etc.

// extra info displayed:
#include <qlayout.h> 
#include <qpushbutton.h>
#include <qlabel.h> 
#include <qlcdnumber.h>
#include <qslider.h> 
#include <qcombobox.h>
#include <qcheckbox.h> 
#include <qimage.h>
#include <qpainter.h>

// for helpbox: delete once proper help is done
#include <qmessagebox.h> 

#include <qpixmap.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qhbox.h> 
#include <qstatusbar.h>
#include <qinputdialog.h>
#include <qspinbox.h>
#include <qdir.h> 
#include <qregexp.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qdatastream.h>
#include <qgroupbox.h>
#include <qtextedit.h>
#include <qapplication.h> 

#include <qprocess.h> 



#include "klearnnotes2.h"

#include "midi.cpp"

#include "pics.h"
#include "midi_setup.h"
#include "customlevel.h"
#include "helpwindow.h"
#include "KLNcanvasitems.h"
#include "KLNfancywidgets.h"

#include "imageitem.h"
#include "quickstartfile.h" //def. of QUICKstartFILE

#ifdef _WITH_VOICE_CONTROL
#include "voice_recognition.h"
#endif


int OCTAVEbias=defOCTAVEbias;
char orderOfNotes[8]="HAGFEDC"; // if one uses English notation
// 'H' will be replaced by 'B' in KLN creator
// + one can change it in menu Options


extern KAboutData aboutData;


static uint mainCount = 0;
static QImage *clefImageTreble;
static QImage *clefImageBass;
QPixmap* PIX_note_red;
QPixmap* PIX_note_green;
QPixmap* PIX_note_blue;
QPixmap* PIX_note_brown;
QPixmap* PIX_note_black;


double scalefactor; // some things (like clef pictures) are prepared for 
//                     SC==10; if this is not true, they have to be scaled


//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********             START OF THE CONSTRUCTOR
//********************************************************
KLearnNotes2::KLearnNotes2( QWidget* parent,  const char* name, WFlags fl )
  : QMainWindow( parent, name, fl )
{
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - start");
#endif
  mainCount++; // used by the destructor; things should be deleted only when
  //              last forked copy of KLN is destroyed; REALLY??????????
  setCaption( "KLearnNotes2" );

  //********************************************************
  //********** KLearnNotes2 constructor:
  //**********
  //**********             CONSISTENCY of kln2-defs.h defs
  //********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - consistency");
#endif

  // now we check if the values of defMAXabove,defMAXbelow
  // and defnoOFlinesAB_BE are consistent
  numLinesABOVE = KLNmath_floor(double((defMAXabove+1))/double(2));
  if (numLinesABOVE == defNOofLINESabove) { //CONSISTENT
    numNotesABOVE=defMAXabove;
  } else { //                                INCONSISTENT
    if (numLinesABOVE>defNOofLINESabove) {  //keep defNoLa, lower defMAXnotes
      numLinesABOVE=defNOofLINESabove;
      numNotesABOVE=1+(2*numLinesABOVE);    // (*)
    } else {//                               keep defMAXnotes, lower defNoLa
      numNotesABOVE=defMAXabove;
    }
  }
  // defNOofLINESabove is used as an array index in kln2.h; the compiler
  // should bail out if it was set negative;
  // therefore (*) will always be positive;
  // for negative defMAXabove numLinesABOVE would be <0 and above code
  // would keep the negative value of numLinesABOVE and numNotesABOVE
  if (numNotesABOVE<0)
    {
      numNotesABOVE=0;
      numLinesABOVE=0;// which IS consistent - no need to bail out here
    }

  numNotesALL=defMAXall;
  if (numNotesALL<(10+numNotesABOVE)) // there is even no room for
    //          the notes of the main 5 lines + those above the staff
    {
      printerror(tr(" inconsistent settings in klearnnotes2.h :\n"
		    "           * too small value of defMAXall"));
      // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      exit(1); // BAILING OUT!!!!!!!!!!!!!!!!!!!!!!!!
      // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    }
  numLinesBELOW = KLNmath_floor((double(numNotesALL - numNotesABOVE -10)+0.01)
				/double(2));
  // 0.01 just to prevent flooring 0^- to -1
  if (numLinesBELOW==defNOofLINESbelow) //        CONSISTENT
    {
      // all set as above
    }else{ //                                    INCONSISTENT
      if(numLinesBELOW>defNOofLINESbelow) //keep defNoLb, ignore defMAXall
	{
	  numLinesBELOW=defNOofLINESbelow;
	  numNotesALL=2*numLinesBELOW+numNotesABOVE+10
	    +((2*numLinesBELOW+numNotesABOVE+10)%2);
	}else{//                            keep defMAXall, ignore defNoLb
	  // all set as above
	}
    }
  // the only inconsistency could come from defNOofLINESbelow<0, but this
  // would define negative-size array in kln2.h and kill compilation anyway


  //********************************************************
  //********** KLearnNotes2 constructor:
  //**********
  //**********             LAYOUTS / POSITIONS
  //********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - layouts");
#endif

  posOfTopLine=(numNotesABOVE+3)*SC;// 1*SC(=spacing) +
  //                                  1*SC(=G1 is not counted as a NoteAbove) +
  //                                  1*SC(=width of the toppest note)

  setCentralWidget( new QWidget( this, "qt_central_widget" ) );

  QWidget * cw;
  cw=centralWidget ();
  // setup h-v
  QBoxLayout * LAYmain = new QHBoxLayout( cw );
  LAYmain->setMargin(2*SC);
  LAYmain->setSpacing(3*SC);
  QBoxLayout * LAYmainLEFT = new QVBoxLayout( LAYmain );
  LAYmainLEFT->setSpacing(SC);
  QBoxLayout * LAYmainRIGHT = new QVBoxLayout( LAYmain );
  LAYmainRIGHT->setSpacing(SC);

  // NOTE: comments in () refer to a command above the comment:

  // setup of the ****LEFT**** column:
  QBoxLayout * LAYleft10 = new QHBoxLayout( LAYmainLEFT );
  QBoxLayout * LAYleft1 = new QHBoxLayout( LAYleft10 );
  // (there will be drawarea and range in it)
  LAYleft10->addSpacing(SC);
  LAYleft1->setSpacing(0);
  QBoxLayout * LAYleft2 = new QHBoxLayout( LAYmainLEFT );
  // (a row with CDEFGAH buttons and their enablers)
  QBoxLayout * LAYbut[8];
  for (int i =0; i<8; i++)
    {
      LAYbut[i] = new QVBoxLayout( LAYleft2 );
      LAYbut[i]->setSpacing(0);
    }

  // setup of the ****RIGHT**** column:
  QBoxLayout * LAYright3 = new QVBoxLayout( LAYmainRIGHT );
  // (commentsText + label question # of #)


  //********************************************************
  //********** KLearnNotes2 constructor:
  //**********
  //**********             WIDGETS
  //********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - widgets");
#endif

  // **************** LEFT WIDGETS:
  c = new QCanvas( 34*SC, (3+numNotesALL)*SC );
  drawArea = new clickableView( c, cw ,this);
  drawArea->setVScrollBarMode(QScrollView::AlwaysOff);
  drawArea->setHScrollBarMode(QScrollView::AlwaysOff);
  drawArea->setFixedWidth(32*SC);
  drawArea->setFixedHeight((3+numNotesALL)*SC); 
  // = allnotes + 1*SC for the upper half of the toppest note + 
  //   + 1*SC space above + 1*SC space below
  QWhatsThis::add( drawArea, 
		   tr("<B><U>Staff:</U></B><UL>"
		      "<LI>at TEST : you will see here one note which is "
		      "a question: choose it's name from the active "
		      "<EM>namebuttons</EM> below the <EM>staff</EM>"
		      "<LI>at STOP : you will see here all "
		      "<EM>testnotes</EM>; click a note in the "
		      "<EM>staff</EM> to see it's <EM>namebutton</EM>"
		      " highlighted </UL>"));
  QToolTip::add(drawArea,tr("the staff"));

  QBoxLayout * LAYscr = new QVBoxLayout( LAYleft1 );  
  LAYscr->addStretch(10); // used if the minmaxes are taller than the staff
  //                         which can happen for small SC
  LAYscr->addWidget(drawArea);
  LAYscr->addStretch(10);
  c->setDoubleBuffering(true);

  // and 2 sliders for min/max active range
  minmax1 = new QSlider( -numNotesABOVE, numNotesALL - numNotesABOVE -1, 1, 
			 -numNotesABOVE, Qt::Vertical,cw );
  minmax1->setTickmarks(QSlider::Both);
  minmax1->setFixedHeight( (numNotesALL-1)*SC+16);
  minmax2 = new QSlider( -numNotesABOVE, numNotesALL - numNotesABOVE -1, 1, 
			 numNotesALL-numNotesABOVE-1, Qt::Vertical,cw );
  minmax2->setTickmarks(QSlider::Both);
  minmax2->setFixedHeight( (numNotesALL-1)*SC+16);
  QWhatsThis::add(minmax1 , 
		  tr("<B><U>Range sliders</U></B> :<BR>"
		     "choose range of <EM>testnotes</EM> <BR>"
		     "hint: choose Exercise %1 and play for a moment with "
		     "the <EM>range sliders</EM> to get an idea how they "
		     "work").arg(defALLnotesEXEnum));
  QToolTip::add( minmax1,tr("Range slider 1"));
  QWhatsThis::add(minmax2,
		  tr("<B><U>Range sliders</U></B> :<BR>"
		     "choose range of <EM>testnotes</EM> <BR>"
		     "hint: choose Exercise %1 and play for a moment with "
		     "the <EM>range sliders</EM> to get an idea how they "
		     "work").arg(defALLnotesEXEnum));
  QToolTip::add( minmax2,tr("Range slider 2"));


  LAYscr = new QVBoxLayout( LAYleft1 );  
  LAYscr->addStretch(10); // used if the staff is taller than the minmaxes
  LAYscr->addWidget(minmax1);
  LAYscr->addStretch(10);
  LAYscr = new QVBoxLayout( LAYleft1 );  
  LAYscr->addStretch(10);
  LAYscr->addWidget(minmax2);
  LAYscr->addStretch(10);

  for (int i =0; i<7; i++)
    {
      namePBs[i] = new fancyButton( QString(QChar(orderOfNotes[i])), cw );
      QFont qf(namePBs[i]->font());
      qf.setBold(true);
      qf.setStyleHint(QFont::SansSerif,
		      QFont::StyleStrategy(QFont::PreferAntialias |
					   QFont::PreferQuality));
      qf.setPointSize(4 * SC);
      namePBs[i]->setFont(qf);
      namePBs[i]->setFixedWidth(5*SC);
      namePBs[i]->setFixedHeight(5*SC);
      nameCHKs[i] = new QCheckBox(cw);
      nameKeys[i]=new QLabel(QString("%1").arg(9-i),cw);
      qf.setPointSize(int(0.5* SC));
      nameKeys[i]->setFont(qf);
      LAYbut[6-i]->addWidget(nameKeys[i],0,Qt::AlignHCenter);
      LAYbut[6-i]->addWidget(namePBs[i],0,Qt::AlignHCenter);
      LAYbut[6-i]->addWidget(nameCHKs[i],0,Qt::AlignHCenter);
      QWhatsThis::add(namePBs[i], 
		      tr("<U><B>namebutton</B></U><UL>"
			 "<LI>at TEST : use it to give an answer - the "
			 "name of a displayed note "
			 "<LI>at STOP : click to highlight in the "
			 "<EM>staff</EM> all testnotes with the name "
			 "shown on the <EM>namebutton</EM></UL>"));
      QWhatsThis::add(nameCHKs[i], 
		      tr("<U><B>name checkbox</B></U> :<BR>choose which "
			 "notes should be <EM>testnotes</EM><BR>"
			 "hint: choose Exercise %1, press a "
			 "<EM>namebutton</EM> (to see which notes it "
			 "corresponds to) and then a <EM>name "
			 "checkbox</EM> below it; play for a moment "
			 "with these <EM>checkboxes</EM> to get an idea "
			 "how they work").arg(defALLnotesEXEnum));
    }

  LAYmainLEFT->addSpacing(8*SC);// which should keep things of size 1.0-2
  
  // **************** RIGHT WIDGETS:
  commentsGroup=new QGroupBox (1, Qt::Vertical ,cw);
  commentsGroup->setTitle(tr("Comments"));
  commentsText=new QTextEdit ( commentsGroup) ;
  commentsText->setReadOnly ( true );
  commentsText->setTextFormat(Qt::RichText);
  commentsText->setWrapColumnOrWidth ( 30 );
  commentsText->setWrapPolicy (QTextEdit::AtWhiteSpace );
  LAYright3->addWidget(commentsGroup,10);

  labelQueNum  = new QLabel(" ",cw) ;
  // this should take up all the space
  LAYscr = new QHBoxLayout( LAYright3 ); 
  LAYscr->addWidget(labelQueNum);
  LCD_queTime=new QLCDNumber(4,cw,"quet");
  LCD_queTime->display(0);
  LCD_queTime->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_queTime,tr("time spent on the last question"));
  LAYscr->addWidget(LCD_queTime);


  QGroupBox* resultsGroup=new QGroupBox (tr(" your results "),cw);
  QGridLayout* resultsDisplay= new QGridLayout(resultsGroup);
  resultsDisplay->setMargin(10);
  resultsDisplay->setSpacing(5);
  resultsDisplay->addRowSpacing (0, 15 ) ; // extra space for group header

  QLabel* labi = new QLabel(tr("correct"),resultsGroup);
  LCD_numOK=new QLCDNumber(3,resultsGroup,"lcd1");
  LCD_numOK->display(0);
  LCD_numOK->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_numOK,tr("number of right answers in this/last test"));
  QWhatsThis::add(LCD_numOK,tr("number of right answers in this/last test"));
  resultsDisplay->addWidget(labi,1,0);
  resultsDisplay->addWidget(LCD_numOK,1,1);
  
  labi = new QLabel(tr("wrong"),resultsGroup);
  LCD_numWR=new QLCDNumber(3,resultsGroup,"lcd2");
  LCD_numWR->display(0);
  LCD_numWR->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_numWR,tr("number of wrong answers in this/last test"));
  QWhatsThis::add( LCD_numWR,tr("number of wrong answers in this/last test"));
  resultsDisplay->addWidget(labi,2,0);
  resultsDisplay->addWidget(LCD_numWR,2,1);
  bgcolor=LCD_numWR->paletteBackgroundColor();
  
  labi = new QLabel(tr("speed"),resultsGroup);
  LCD_speed=new fancyQLCDNumber(3,resultsGroup,"lcd3");
  LCD_speed->display(0);
  LCD_speed->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_speed,tr("your speed in this/last test"));
  QWhatsThis::add(LCD_speed, 
		  tr("your overall answering <B><U>speed</U></B>"
		     "<UL><LI>if it is below your <EM>speed goal</EM> "
		     " it will have <FONT COLOR=RED>red</FONT> frame"
		     "<LI> if it is above your <EM>speed goal</EM>"
		     " it will have <FONT COLOR=GREEN>green</FONT> frame</UL>")
		  );
  resultsDisplay->addWidget(labi,3,0);
  resultsDisplay->addWidget(LCD_speed,3,1);
  labi = new QLabel(tr("answ/(10 min)"),resultsGroup);
  resultsDisplay->addWidget(labi,3,2);


  labi = new QLabel(tr("your goal"),resultsGroup);
  LCD_yourGoal= new QLCDNumber(3,resultsGroup,"yrG");
  LCD_yourGoal->display(defSPEEDgoal02);
  LCD_yourGoal->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_yourGoal,tr("your speed goal"));
  QWhatsThis::add( LCD_yourGoal, 
		   tr("your <B><U>speed goal</U></B> :<BR>"
		      " it depends on the level you choose and number of"
		      " active <EM>namebuttons</EM>"));
  resultsDisplay->addWidget(labi,4,0);
  resultsDisplay->addWidget(LCD_yourGoal,4,1);
  labi = new QLabel(tr("answ/(10 min)"),resultsGroup);
  resultsDisplay->addWidget(labi,4,2);

  resultsGroup->adjustSize();
  LAYmainRIGHT->addWidget(resultsGroup);


  // ********END OF CENTRAL WIDGET SETUP
  statbar=new QStatusBar(this);

//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********             ACTIONS
//********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - actions");
#endif
  a_mH_KHelp = new QAction( this, "a_mH_KHelp" );
  a_mH_KHelp->setText( tr( "Help index","menu txt in the statusbar" ) );
  a_mH_KHelp->setMenuText( tr( "&Help index..." ) );
  a_mH_KHelp->setAccel(Key_F1 );

  a_mH_KQuickStart = new QAction( this, "a_mH_KQS" );
  a_mH_KQuickStart->setText( tr( "Quick Start","menu txt in the statusbar" ) );
  a_mH_KQuickStart->setMenuText( tr( "Quick &Start..." ) );
  a_mH_KQuickStart->setAccel(0);

  a_mH_KVoiceQuickStart = new QAction( this, "a_mH_KVQS" );
  a_mH_KVoiceQuickStart->setText( tr( "Voice Recognition quick start"
				      ,"menu txt in the statusbar"));
  a_mH_KVoiceQuickStart->setMenuText(tr("&Voice Recognition quick start..."));
  a_mH_KVoiceQuickStart->setAccel(0);

  a_mH_about_doesntwork = new QAction( this, "a_mH_about_doesntwork" );
  a_mH_about_doesntwork->setText( tr( "What's in this menu?" 
				      ,"menu txt in the statusbar") );
  a_mH_about_doesntwork->setMenuText( tr( "ABOUT THIS HELP SUBMENU..." ) );
  a_mH_about_doesntwork->setAccel( 0 );
  a_mH_index = new QAction( this, "a_mH_index" );
  a_mH_index->setText(a_mH_KHelp->text()+"   "+
		      tr( "(no KDE help)" )   );
  a_mH_index->setMenuText(a_mH_KHelp->menuText()+"   "+
			  tr( "(no KDE help)" )  );
  a_mH_index->setAccel( 0 );
  a_mH_quickStart = new QAction( this, "a_mH_quickStart" );
  a_mH_quickStart->setText( a_mH_KQuickStart->text()+"   "+
			    tr( "(no KDE help)" ) );
  a_mH_quickStart->setMenuText( a_mH_KQuickStart->menuText()+"   "+
				tr( "(no KDE help)" ) );
  a_mH_quickStart->setAccel( 0 );
  a_mH_voiceQuickStart = new QAction( this, "a_mH_voiceQuickStart" );
  a_mH_voiceQuickStart->setText(a_mH_KVoiceQuickStart->text()+"   "+
				tr( "(no KDE help)" ) );
  a_mH_voiceQuickStart->setMenuText(a_mH_KVoiceQuickStart->menuText()+"   "+
				    tr( "(no KDE help)" ) );
  a_mH_voiceQuickStart->setAccel( 0 );
  a_mH_about = new QAction( this, "a_mH_about" );
  a_mH_about->setText( tr( "About" ,"menu txt in the statusbar") );
  a_mH_about->setMenuText( tr( "&About..." ) );
  a_mH_about->setAccel( 0 );

  mp_Cleves_grp = new QActionGroup( this );
  mp_Cleves_grp->setExclusive( TRUE );
  a_mp_SetClefTreble= new actionWithIconSwitch(mp_Cleves_grp,
					       (const char**) clefT_icon_xpm,
					       (const char**) empty_xpm);
  a_mp_SetClefTreble->setText( tr( "choose treble clef"
				   ,"menu txt in the statusbar") );
  a_mp_SetClefTreble->setMenuText( tr( "&Treble clef" ) );
  a_mp_SetClefTreble->setAccel( 0 );
  a_mp_SetClefTreble->setToggleAction(true);
  a_mp_SetClefTreble->setOn(true);
  a_mp_SetClefBass= new actionWithIconSwitch(mp_Cleves_grp,
					     (const char**) clefB_icon_xpm,
					     (const char**) empty_xpm);
  a_mp_SetClefBass->setText( tr( "choose bass clef" 
				 ,"menu txt in the statusbar") );
  a_mp_SetClefBass->setMenuText( tr( "&Bass clef" ) );
  a_mp_SetClefBass->setAccel( 0 );
  a_mp_SetClefBass->setToggleAction(true);



  aStartStop=new QAction(this,"");
  aStartStop->setText(tr("start","menu txt in the statusbar"));
  aStartStop->setMenuText(tr("&Start"));
  aStartStop->setAccel( ALT+Key_S );
  a_mp_Quit= new QAction( this, "" );
  a_mp_Quit->setText( tr( "quit","menu txt in the statusbar" ) );
  a_mp_Quit->setMenuText( tr( "&Quit" ) );
  a_mp_Quit->setAccel( ALT+Key_Q );


  mo_Levels_grp = new QActionGroup( this );
  mo_Levels_grp->setExclusive( TRUE );
  a_mo_setLevel[0]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) level_0_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[0]->setText( tr( "speed goal: easy"
				 ,"menu txt in the statusbar") );
  a_mo_setLevel[0]->setMenuText( tr( "&Prentice" ) );
  a_mo_setLevel[0]->setAccel( 0 );
  a_mo_setLevel[0]->setToggleAction(true);
  a_mo_setLevel[0]->setOn(true);
  a_mo_setLevel[1]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) level_1_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[1]->setText( tr( "speed goal: intermediate"
				 ,"menu txt in the statusbar" ) );
  a_mo_setLevel[1]->setMenuText( tr( "&Journeyman" ) );
  a_mo_setLevel[1]->setAccel( 0 );
  a_mo_setLevel[1]->setToggleAction(true);
  a_mo_setLevel[1]->setOn(false);
  a_mo_setLevel[2]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) level_2_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[2]->setText( tr( "speed goal: hard"
				 ,"menu txt in the statusbar" ) );
  a_mo_setLevel[2]->setMenuText( tr( "&Wizard" ) );
  a_mo_setLevel[2]->setAccel( 0 );
  a_mo_setLevel[2]->setToggleAction(true);
  a_mo_setLevel[2]->setOn(false);
  a_mo_setLevel[3]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) empty_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[3]->setText( tr( "speed goal: custom"
				 ,"menu txt in the statusbar" ) );
  a_mo_setLevel[3]->setMenuText( tr( "custom..." ) );
  a_mo_setLevel[3]->setAccel( 0 );
  a_mo_setLevel[3]->setToggleAction(true);
  a_mo_setLevel[3]->setOn(false);




  a_mo_setNotationGE= new actionWithIconSwitch(this,
					       ( const char** ) notationH_xpm,
					       ( const char** ) notationB_xpm);
  //  a_mo_setNotationGE->setText( tr( "change to English notation "
  //				   "'H'->'B'" ) );
  //  a_mo_setNotationGE->setMenuText(tr("German n&otation "
  //				     "(GA-H-CD)"));
  a_mo_setNotationGE->setAccel( 0 );
  //  setGermanHNotation(true); // orderofnotes, namePBs[] and clefs 
  //                               have to be defined!

//   // just to get a screenshot with these pictures/labels:
//    QBoxLayout * LAYrightTMP = new QHBoxLayout( LAYmainRIGHT );
//    labi=new QLabel("",cw);
//    labi->setPixmap(a_mo_setNotationGE->getSmallPixmap(1));
//    LAYrightTMP->addWidget(labi);
//    labi=new QLabel("German notation (GA-H-CD)",cw);
//    LAYrightTMP->addWidget(labi,10,Qt::AlignLeft);
//    LAYrightTMP = new QHBoxLayout( LAYmainRIGHT );

//    LAYrightTMP = new QHBoxLayout( LAYmainRIGHT );
//    labi=new QLabel("",cw);
//    labi->setPixmap(a_mo_setNotationGE->getSmallPixmap(0));
//    LAYrightTMP->addWidget(labi);
//    labi=new QLabel("English notation (GA-B-CD)",cw);
//    LAYrightTMP->addWidget(labi,10,Qt::AlignLeft);



  a_mo_setTestLength= new QAction( this, "" );
  a_mo_setTestLength->setText( tr( "make tests longer/shorter"
				   ,"menu txt in the statusbar" ) );
  a_mo_setTestLength->setMenuText( tr( "&Test length factor..." ) );
  a_mo_setTestLength->setAccel( 0 );
  a_mo_soundOnOff= new actionWithIconSwitch(this,
					    ( const char** ) sound_on_xpm,
					    ( const char** ) sound_off_xpm);
  a_mo_soundOnOff->setText( tr( "turn midi sound on/off"
				,"menu txt in the statusbar" ) );
  a_mo_soundOnOff->setMenuText( tr( "Midi soun&d : on/off" ) );
  a_mo_soundOnOff->setAccel( 0 );
  a_mo_soundOnOff->setOn(true);
  a_mo_soundOnOff->setToolTip(tr("turn midi sound on/off"
				 ,"tooltip"));
  a_mo_soundSetup= new QAction( this, "" );
  a_mo_soundSetup->setText( tr( "setup midi sound"
				,"menu txt in the statusbar") );
  a_mo_soundSetup->setMenuText( tr( "Midi sound setup..." ) );
  a_mo_soundSetup->setAccel( 0 );

  QDir* dir=new QDir(QDir::homeDirPath ()+ "/.klearnnotes2_d" );
  if(! dir->exists())
    {
      debuginfo(tr("%1 doesn't exist; creating!","directory"
		   ).arg(dir->path()));
      dir->mkdir(dir->path());
    }
  delete dir;

#ifdef _WITH_VOICE_CONTROL
  a_mo_voiceMicroSetup= new QAction( this, "" );
  a_mo_voiceMicroSetup->setText( tr( "setup microphone for voice input"
				     ,"menu txt in the statusbar"));
  a_mo_voiceMicroSetup->setMenuText( tr( "Microphone setup..." ) );
  a_mo_voiceMicroSetup->setAccel( 0 );
  a_mo_voiceOnOff= new actionWithIconSwitch(this,
					    ( const char** ) micOn_xpm,
					    ( const char** ) micOff_xpm);
  a_mo_voiceOnOff->setText( tr( "Voice input is off; turn it on" 
				,"menu txt in the statusbar") );
  a_mo_voiceOnOff->setMenuText( tr( "Voice input: off" ) );
  a_mo_voiceOnOff->setAccel( 0 );
  a_mo_voiceOnOff->setOn(true);
  a_mo_voiceOnOff->setOn(false);// don't know why 'false' without true first
  //                               doesn't work...
  a_mo_voiceOnOff->setToolTip(tr("voice recognition on/off"
				 ,"tooltip"));
  a_mo_startVoiceEditor=new QAction(this,"");
  a_mo_startVoiceEditor->setText(tr("setup speaker model for voice input"
				    ,"menu txt in the statusbar"));
  a_mo_startVoiceEditor->setMenuText( tr( "Speaker model setup..." ) );
  a_mo_startVoiceEditor->setAccel( 0 );
  

  dir=new QDir(QDir::homeDirPath ()+ "/.klearnnotes2_d/voice_models");
  if(! dir->exists())
    {
      debuginfo(tr("%1 doesn't exist; creating!",
		   "directory").arg(dir->path()));
      dir->mkdir(dir->path());
    }

  voiceModelFile=NULL;
  voiceProcess=new QProcess(this);
  setVoiceModelFilename(QDir::homeDirPath ()+
			"/.klearnnotes2_d/voice_models/"
			"my_voice_model.cvc");
  voiceProcess->setCommunication(QProcess::Stdout|QProcess::Stderr);
  connect( voiceProcess, SIGNAL(readyReadStdout()),
	   this, SLOT(readFromVoice()) );
#endif


  a_mo_save=new QAction(this,"");
  a_mo_save->setText( tr( "Save options" ) );
  a_mo_save->setMenuText( tr( "Save options" ) );
  a_mo_save->setAccel( 0 );
  a_mo_load=new QAction(this,"");
  a_mo_load->setText( tr( "Restore options" ) );
  a_mo_load->setMenuText( tr( "Restore options" ) );
  a_mo_load->setAccel( 0 );


//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********             TOOLBARS
//********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - toolbars");
#endif
  programToolBar = new QToolBar( this, "programToolBar" ); 
  programToolBar->setLabel(  "KLearnNotes2" );

  exerciseToolBar = new QToolBar( this, "exerciseToolBar" ); 
  exerciseToolBar->setLabel( tr( "Exercise" ) );
  exerciseToolBar->setNewLine ( true );

  labi = new QLabel(tr("&E:","_E_xercise"),exerciseToolBar) ;
  CB_exercise = new QComboBox( FALSE, exerciseToolBar);
  CB_exercise->setFixedWidth(280);
  labi->setBuddy(CB_exercise);
  QWhatsThis::add(CB_exercise, 
		  tr("<B><U>choose Exercise</B></U> from the list;<BR>"
		     "this chooses a predefined set of"
		     " <EM>testnotes</EM>"));
  QToolTip::add( CB_exercise,tr("choose Exercise"));
  aNextExercise=new QAction(tr("Next exercise","menu txt in the statusbar"),
			    QPixmap( (const char**)next_xpm ),
			    tr("Next &exercise"), ALT+Key_N, this,
			    "exercise++" );
  aNextExercise->addTo(exerciseToolBar);
  aNextExercise->setToolTip(tr("next Exercise","tooltip"));


  labi = new QLabel(tr("&C:","_C_lef"),exerciseToolBar) ;
  CB_clef = new QComboBox( FALSE, exerciseToolBar );
  CB_clef->insertItem(a_mp_SetClefTreble->getSmallPixmap(1),
		      "" );
  CB_clef->insertItem(a_mp_SetClefBass->getSmallPixmap(1),
		      "" );
  QToolTip::add( CB_clef,tr("choose Clef: bass or treble","tooltip"));
  labi->setBuddy(CB_clef);


  labi = new QLabel(tr("&L:","_L_evel (for speedgoal)"),exerciseToolBar) ;
  CB_level = new QComboBox( FALSE, exerciseToolBar );
  CB_level->insertItem(a_mo_setLevel[0]->getSmallPixmap(1),
		       a_mo_setLevel[0]->menuText().replace( QRegExp("&"), 
							     "" ));
  CB_level->insertItem(a_mo_setLevel[1]->getSmallPixmap(1),
		       a_mo_setLevel[1]->menuText().replace( QRegExp("&"), 
							     "" ));
  CB_level->insertItem(a_mo_setLevel[2]->getSmallPixmap(1),
		       a_mo_setLevel[2]->menuText().replace( QRegExp("&"), 
							     "" ));
  CB_level->insertItem(a_mo_setLevel[3]->getSmallPixmap(1),
		       a_mo_setLevel[3]->menuText().replace( QRegExp("&"), 
							     "" ));
  labi->setBuddy(CB_level);
  QToolTip::add( CB_level,tr("choose Level: this affects "
			     "your <EM>speed goal</EM>","tooltip"));
  lastLevel=0;

  //  SB_testLength = new QSpinBox(40,400,1,exerciseToolBar);
  //  SB_testLength->setValue(100);
  testLengthFactor=100;
  //QToolTip::add( SB_testLength,tr("test length (number of questions) as a \n"
  //				  "% of default test length"));

  bStartStop = new QPushButton( tr("&Start"), exerciseToolBar );
  // note there is also action aStartStop (for menu); but I want a button
  // with TEXT and it's hard to get from Action
  QToolTip::add( bStartStop,tr("Start a test","tooltip"));

  a_mo_soundOnOff->addTo(programToolBar);
  a_mo_voiceOnOff->addTo(programToolBar);

  tbWhat=QWhatsThis::whatsThisButton(programToolBar);
  QToolTip::add(tbWhat,tr("What's this?","tooltip"));

//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********             MENUS
//********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - menus");
#endif
  menubar = new QMenuBar( this, "menubar" );

  MenuPractice = new QPopupMenu( this ); 
  aNextExercise->addTo(MenuPractice);
  mp_Cleves_menu = new QPopupMenu(this);
  mp_Cleves_menu->insertTearOffHandle();

  a_mp_SetClefTreble->addTo(mp_Cleves_menu);
  a_mp_SetClefBass->addTo(mp_Cleves_menu);
  MenuPractice->insertItem(tr("Choose clef","submenu"),mp_Cleves_menu);
  aStartStop->addTo(MenuPractice);
  MenuPractice->insertSeparator();
  a_mp_Quit->addTo(MenuPractice);
  menubar->insertItem( tr( "&Practice" ,"menu"), MenuPractice );

  MenuOptions = new QPopupMenu( this ); 
  a_mo_setTestLength->addTo(MenuOptions);
  mo_Levels_menu = new QPopupMenu(this);
  mo_Levels_menu->insertTearOffHandle();
  a_mo_setLevel[0]->addTo(mo_Levels_menu);
  a_mo_setLevel[1]->addTo(mo_Levels_menu);
  a_mo_setLevel[2]->addTo(mo_Levels_menu);
  a_mo_setLevel[3]->addTo(mo_Levels_menu);
  MenuOptions->insertItem(tr("Choose level","submenu"),mo_Levels_menu);
  a_mo_setNotationGE->addTo(MenuOptions);
  MenuOptions->insertSeparator();
  a_mo_soundOnOff->addTo(MenuOptions);
  a_mo_soundSetup->addTo(MenuOptions);
#ifdef _WITH_VOICE_CONTROL
  mo_Voice_menu = new QPopupMenu(this);
  mo_Voice_menu->insertTearOffHandle();
  a_mo_voiceOnOff->addTo(mo_Voice_menu);
  a_mo_voiceMicroSetup->addTo(mo_Voice_menu);
  a_mo_startVoiceEditor->addTo(mo_Voice_menu);
  MenuOptions->insertItem(tr("Voice input","submenu"),mo_Voice_menu);
#endif
  menubar->insertItem( tr( "&Options" ,"menu"), MenuOptions );
  MenuOptions->insertSeparator();
  a_mo_save->addTo(MenuOptions);
  a_mo_load->addTo(MenuOptions);

  MenuHelp = new QPopupMenu( this ); 
  //  a_mH_KHelp->addTo(MenuHelp);
  id_mH_help=MenuHelp->insertItem(tr( "&Help index..." ),this,
				  SLOT( mH_KHelp_activated()),Key_F1 );
  a_mH_KQuickStart->addTo(MenuHelp);
  a_mH_KVoiceQuickStart->addTo(MenuHelp);
  mH_doesntwork_menu=new QPopupMenu(this);
  a_mH_about_doesntwork->addTo(mH_doesntwork_menu);
  a_mH_index->addTo(mH_doesntwork_menu);
  a_mH_quickStart->addTo(mH_doesntwork_menu);
  a_mH_voiceQuickStart->addTo(mH_doesntwork_menu);
  if(QFile::exists("/usr/share/doc/HTML/en/klearnnotes2/klearnnotes2.html"))
    id_mH_doesnt=MenuHelp->insertItem(tr("If KDE help doesn't work","submenu"),
				      mH_doesntwork_menu);
  MenuHelp->insertSeparator();
  a_mH_about->addTo( MenuHelp );
  menubar->insertItem( tr( "&Help" ,"menu"), MenuHelp );

  MenuHelpK=new KHelpMenu(this);


//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********               SIGNALS   <--->   SLOTS
//********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - signals");
#endif

  connect( namePBs[0], SIGNAL(clicked()), this, SLOT( noteH() ));
  connect( namePBs[1], SIGNAL(clicked()), this, SLOT( noteA() ));
  connect( namePBs[2], SIGNAL(clicked()), this, SLOT( noteG() ));
  connect( namePBs[3], SIGNAL(clicked()), this, SLOT( noteF() ));
  connect( namePBs[4], SIGNAL(clicked()), this, SLOT( noteE() ));
  connect( namePBs[5], SIGNAL(clicked()), this, SLOT( noteD() ));
  connect( namePBs[6], SIGNAL(clicked()), this, SLOT( noteC() ));
  connect( a_mH_about,SIGNAL(activated()),this,SLOT(mH_about_activated()));
  // connect( a_mH_KHelp,SIGNAL(activated()),this,SLOT( mH_KHelp_activated()));
  connect( a_mH_KQuickStart,SIGNAL(activated()),this,
	   SLOT( mH_quickStart_activated()));
  connect( a_mH_KVoiceQuickStart,SIGNAL(activated()),this,
	   SLOT( mH_voiceQuickStart_activated()));

  connect( a_mH_about_doesntwork,SIGNAL(activated()),this,
	   SLOT(mH_doesntWork_about_activated ()));
  connect( a_mH_index,SIGNAL(activated()),this,
	   SLOT(mH_doesntWork_index_activated ()));
  connect( a_mH_quickStart,SIGNAL(activated()),this,
	   SLOT(mH_doesntWork_quickStart_activated()));
  connect( a_mH_voiceQuickStart,SIGNAL(activated()),this,
	   SLOT(mH_doesntWork_voiceQuickStart_activated()));

  connect( aStartStop, SIGNAL(activated()), this, SLOT( startstop()) );
  connect( bStartStop, SIGNAL(clicked()), this, SLOT( startstop()) );
  connect( aNextExercise, SIGNAL(activated()), this, SLOT( nextExercise()) );
  connect(a_mo_setNotationGE,SIGNAL(toggled(bool)),this,
	  SLOT(setGermanHNotation(bool)));
  connect( a_mo_soundOnOff,SIGNAL(toggled(bool)),this,
	   SLOT(turnSoundOnOff(bool)));
  connect( a_mo_setTestLength, SIGNAL(activated()), this,
	   SLOT(dialogTestLengthFactor()));
  connect( a_mo_soundSetup,SIGNAL(activated()),this,
	   SLOT(dialogSetupMidi()));
#ifdef _WITH_VOICE_CONTROL
  connect( a_mo_voiceMicroSetup,SIGNAL(activated()),this,
	   SLOT(dialogVoiceMircoSetup()));
  connect( a_mo_voiceOnOff,SIGNAL(toggled(bool)),this,
	   SLOT(voiceStartStop(bool)));
  connect( a_mo_startVoiceEditor,SIGNAL(activated()),this,
	   SLOT(dialogVoiceModelEditor()));
#endif

  connect( a_mo_save,SIGNAL(activated()),this,
	   SLOT(saveOptions()));
  connect( a_mo_load,SIGNAL(activated()),this,
	   SLOT(loadOptions()));

  connect(minmax1,SIGNAL(valueChanged( int)),this,
	  SLOT(activeNotesChangedManual( int)));
  connect(minmax2,SIGNAL(valueChanged(int)),this,
	  SLOT(activeNotesChangedManual(int)));
  for(int i=0;i<7;i++)
    {
      connect(nameCHKs[i],SIGNAL(stateChanged(int)),this,
	      SLOT(activeNotesChangedManual(int)));
    }
  connect(CB_exercise,SIGNAL(activated(int)),this,
	  SLOT(activeNotesChangedByExercise(int)));
  connect(CB_clef,SIGNAL(activated(int)),this,SLOT(setClef(int)));
  connect(CB_level,SIGNAL(activated(int)),this,SLOT(setLevelByCombo(int)));
  connect(mo_Levels_grp,SIGNAL(selected(QAction*)),this,
	  SLOT(setLevelByAction(QAction*)));
  connect(a_mo_setLevel[3],SIGNAL(activated ()),this,
	  SLOT(a_mo_setLevelCustom_activated()));
  // DIFFERENT SIGNAL: IF ACTIVATED NOT TOGGLED (because if we are at custom,
  // and user clicks 'custom' we want the custom dialgog be shown)

  //  connect(SB_testLength,SIGNAL(valueChanged(int)),this,
  //        SLOT(setTestLengthFactor(int)));
  connect(a_mp_SetClefTreble,SIGNAL(toggled ( bool )),this,
	  SLOT(setClefTreble(bool)));
  connect( a_mp_Quit,SIGNAL(activated()),this,SLOT(endKLearnNotes2()) );
  connect( qApp, SIGNAL(lastWindowClosed()),this, SLOT(endKLearnNotes2()) );
  // 'cause closing by windows' titlebar widgets should run endKLearnNotes2 too
  

  clocky = new QTimer (this);
  timespent=0;
  connect( clocky, SIGNAL(timeout()), this, SLOT( growtime() ));
   
  

//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********                 EXTRA SETUP OF THINGS *** IN CANVAS ***
//********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - canvasitems");
#endif

  // ****** LINES: ******

  staffLine* line;
  // NOTE: 0 is on the TOP !
  for( int i = 0; i < 5; i++ ) {
    line = new staffLine( c,posOfTopLine+2*SC*i,1 );
    line->show();
  }
  // lines above the five are shorter:
  for( int i = -numLinesABOVE; i < 0; i++ ) {
    line = new staffLine( c, posOfTopLine+2*SC*i,2 );
    line->hide();
    linesabove[-1-i]=line ;
    // note, that these lines are counted in order reverse to 
    // notes enumeration; i.e. line A1 is [0], C2 is [1] etc.

    //+ we draw also short lines to guide the choice of range of notes:
    line = new staffLine( c, posOfTopLine+2*SC*i,3);
    line->show();
    guidelines[-i-1]=line; // this fills guidelines[0...(#liAB-1)]
  }
  // so are those below:
  for( int i = 5; i < 5+numLinesBELOW; i++ ) {
    line = new staffLine( c,posOfTopLine+2*SC*i,2 );
    line->hide();
    linesbelow[i-5]=line;

    line = new staffLine( c,posOfTopLine+2*SC*i,3 );
    line->show();
    guidelines[numLinesABOVE+i-5]=line; // this fills guidelines[#liAB...(
    //  #liAB+#liBE -1)]
  }


  // ****** CLEVES: ******

  clefImageTreble=0;
  clefImageBass=0;

  scalefactor=double(SC)/double(10);
  QImage* clefImageTreble[2];
  clefImageTreble[0]=new QImage(clefT_xpm);
  clefImageTreble[1]=new 
    QImage(clefImageTreble[0]->smoothScale(int(clefImageTreble[0]->width()
					       *scalefactor),
					   int(clefImageTreble[0]->height()
					       *scalefactor)));
  clefItem[0] = new ImageItem(*clefImageTreble[1],c);
  clefItem[0]->move(2*SC,posOfTopLine-(26*scalefactor));
  clefItem[0]->setZ(-2000);//under lines

  QImage* clefImageBass [2];
  clefImageBass[0]=  new QImage(clefB_xpm);
  clefImageBass[1]=new 
    QImage(clefImageBass[0]->smoothScale(int(clefImageBass[0]->width()
					     *scalefactor),
					 int(clefImageBass[0]->height()
					     *scalefactor)));
  clefItem[1] = new ImageItem(*clefImageBass[1],c);
  clefItem[1]->move(2*SC,posOfTopLine-(26*scalefactor));
  clefItem[1]->setZ(-2000);//under lines

  // ******* and NOTES: ******

  //RED
  QImage* IMG_note_red [2];
  IMG_note_red[1]= new QImage(noteRED_xpm);
  IMG_note_red[0]=new 
    QImage(IMG_note_red[1]->smoothScale(int(IMG_note_red[1]->width()
					    *scalefactor),
					int(IMG_note_red[1]->height()
					    *scalefactor)));
  PIX_note_red=new QPixmap();
  PIX_note_red->convertFromImage(*IMG_note_red[0], OrderedAlphaDither);
  delete IMG_note_red[0];
  delete IMG_note_red[1];
  //GREEN
  QImage* IMG_note_green [2];
  IMG_note_green[1] = new QImage(noteGRE_xpm);
  IMG_note_green[0]=new 
    QImage(IMG_note_green[1]->smoothScale(int(IMG_note_green[1]->width()
					      *scalefactor),
					  int(IMG_note_green[1]->height()
					      *scalefactor)));
  PIX_note_green=new QPixmap();
  PIX_note_green->convertFromImage(*IMG_note_green[0], OrderedAlphaDither);
  delete IMG_note_green[0];
  delete IMG_note_green[1];
  //BLUE
  QImage* IMG_note_blue[2];
  IMG_note_blue[1] = new QImage(noteBLU_xpm);
  IMG_note_blue[0]=new 
    QImage(IMG_note_blue[1]->smoothScale(int(IMG_note_blue[1]->width()
					     *scalefactor),
					 int(IMG_note_blue[1]->height()
					     *scalefactor)));
  PIX_note_blue=new QPixmap();
  PIX_note_blue->convertFromImage(*IMG_note_blue[0], OrderedAlphaDither);
  delete IMG_note_blue[0];
  delete IMG_note_blue[1];
  //BROWN
  QImage* IMG_note_brown[2];
  IMG_note_brown[1] = new QImage(noteBRO_xpm);
  IMG_note_brown[0]=new 
    QImage(IMG_note_brown[1]->smoothScale(int(IMG_note_brown[1]->width()
					      *scalefactor),
					  int(IMG_note_brown[1]->height()
					      *scalefactor)));
  PIX_note_brown=new QPixmap();
  PIX_note_brown->convertFromImage(*IMG_note_brown[0], OrderedAlphaDither);
  delete IMG_note_brown[0];
  delete IMG_note_brown[1];
  //BLACK
  QImage* IMG_note_black [2];
  IMG_note_black[1] = new QImage(noteBLA_xpm);
  IMG_note_black[0]=new 
    QImage(IMG_note_black[1]->smoothScale(int(IMG_note_black[1]->width()
					      *scalefactor),
					  int(IMG_note_black[1]->height()
					      *scalefactor)));
  PIX_note_black=new QPixmap();
  PIX_note_black->convertFromImage(*IMG_note_black[0], OrderedAlphaDither);
  delete IMG_note_black[0];
  delete IMG_note_black[1];



  nullNote=new aNote(posOfTopLine, c, -numNotesABOVE,
		     linesabove, linesbelow,cw,0);
  nullNote->hide(); // and not hideNote 'cause it shouldn't touch lines
  // nullNote is used only as a note previous to the toppest one;
  // this way toppest note position can be determined the same way as
  // other notes' positions (previous is hidden => toppest should not
  // be moveit-ed)
  

  aNote* tmpNote=nullNote;
  for(int i = 0; i<numNotesALL; i++)
    {
      allNotes[i]=new aNote(posOfTopLine, c, i-numNotesABOVE,
			    linesabove, linesbelow,cw,tmpNote);
      tmpNote=allNotes[i];
    }

  // allNotes[] can have indexes from 0 to numNotesALL-1
  // we will always call it by allNotes[num+numNotesABOVE]
  // therefore 'num' can change 
  //     from      -numNotesABOVE         meaning the top note
  //     through   0             meaning the note just above the top of 
  //                             the 5 standard lines (G in the treble clef)
  //     through   10            meaning the note just below the lowest of
  //                             the 5 standard lines (D in the treble clef)
  //     to        numNotesALL-numNotesABOVE-1



//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********                 INITIAL EXERCISE SETUP
//********************************************************
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: constructor - initial exe setup");
#endif

  // Now, all graphics is set (except from inserting exercises into 'exercise')
  // we start setting up initial values

  // variables which rule the world:
  restoring=false;  // when loading changes in sliders/checkboxes etc. shoud 
  //                   NOT run auto-adjustment slots
  autochange=false;// generally sliding a slider activates notesChangedManually
  //                  ; this should NOT happen, if sliders/checkboxes are 
  //                  auto-adjusted by a preset exercise

  setupExercises();//setClef setups notes' names and may in future run 
  //                 setupExercises() itself ...
  lastExercise=-1;
  CB_exercise->setCurrentItem(0);
  setClef(1);//<-just to ensurre toggling(which is required to set notes names)
  setClef(0);     // ... but until then I call setupExercises() manually above

  CB_exercise->setCurrentItem(2);
  activeNotesChangedByExercise(2);

  testLength=defTESTlength;
  if(toupper(defHname)=='H')
    {
      setGermanHNotation(true);
      a_mo_setNotationGE->setOn(true);
    }else{
      setGermanHNotation(false);
      a_mo_setNotationGE->setOn(false);
    }
  customSpeedGoal2=0;
  customSpeedGoal7=0; //this means, when custom level will be selected for
  //                    the first time, cSG's will be copied dep. on level
  //                    at this moment
  adjustSize ();
  setMinimumHeight ( sizeHint().height()+ 80);
  a_mo_soundOnOff->setOn(false); //2B sure, 'true' in the next line will toggle
  a_mo_soundOnOff->setOn(true);
  loadOptions();

  //  dialogVoiceModelEditor();     // just for debugging::::::::
  //  dialogVoiceMircoSetup();  // just for debugging::::::::
  //  exit(0);                      // just for debugging::::::::


}
//********************************************************
//********** KLearnNotes2 constructor:
//**********
//**********                 END
//********************************************************



KLearnNotes2::~KLearnNotes2()
{
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: destructor");
#endif
  saveOptions(); // I don't know why this doesn't work here, in the destructor.
  midi_turnOff();
  if ( !--mainCount ) {
    delete[] clefImageTreble;
    clefImageTreble = 0;
    delete[] clefImageBass;
    clefImageBass = 0;
    for (int i =0; i<numNotesALL;i++)
      delete allNotes[i];
    delete c;
    delete PIX_note_red;
    delete PIX_note_green;
    delete PIX_note_blue;
    delete PIX_note_black;
  }
}



void KLearnNotes2::checkanswer(char ans)
{
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: checkanswer()");
#endif

  // if question is asked checks if answer is right and asks another
  // if we are idle shows all active notes of this kind
  if(clocky->isActive()==false)
    { // either "Stop" position or multiple answers
      if (!isStarted()) // we are at Stop
	{
	  int tmpBN=-1;//tmp: name of the note played
	  for(int i =0; i<numActiveNotes;i++)
	    if(activeNotes[i]->getCname()==ans)
	      {
		activeNotes[i]->setColorTmp('B');
		//i.e. show all notes with the clicked name
		activeNotes[i]->play();
		tmpBN=activeNotes[i]->getName();
	      }
	  c->update();
	  if(tmpBN>-1)
	    {
	      namePBs[tmpBN]->setColorTmp(defNiceBlue,INTERVAL);
	    }
	}
      midi_playChord();
      return;
    }

  // we are at Start position
  // there is a question asked and we should check the answer
  clocky->stop();
  char rightanswer = note->getCname() ;
  if ( ans ==  rightanswer ) {
    note->setColorTmp('G');
    comment("<FONT COLOR=\"#009900\">"+ 
	    QString( tr("<B>%1</B> is correct") 
		     ).arg(QString(QChar(ans)))
	    +"</FONT>");
    LCD_numOK->display(LCD_numOK->intValue()+1);
    note->addCorrect(onetime);
  } else {
    note->setColorTmp('R');
    comment("<FONT COLOR=RED>"+
	    QString( tr("<B>Wrong!</B> Correct would be: <B>%1</B>") 
		     ).arg(QString(QChar(rightanswer)))
	    +"</FONT>");    
    LCD_numWR->display(LCD_numWR->intValue()+1);
    LCD_numWR->setPaletteBackgroundColor(QColor(255,0,0));
    note->addWrong(onetime);

    aNote* tmpNotes[1];
    tmpNotes[0]=note;
    RandomObject_schedule(quenum,(RandomObject**) tmpNotes,
			  (RandomObject**)suggestion, defMAXseria);
#ifdef _KLN_SHOW_SCHEDULE
    debuginfo("DONE UPDATING SCHEDULE TABLE; it is now:");
    debugShowSuggestions(quenum);
#endif
  }

  // update LCD_speed
  int answ=(LCD_numOK->intValue()) + (LCD_numWR->intValue());
  if ( answ > 0 )
    {
      LCD_speed->display((200*60*answ)/(timespent));
      if (LCD_speed->intValue()>LCD_yourGoal->intValue())
	LCD_speed->setOK();
      else
	LCD_speed->setOK(false);
    }
  c->update();

  for(int i = 0; i < 7; i++ )
    namePBs[i]->setEnabled( false );

  QTimer::singleShot( INTERVAL, this, SLOT(redraw()) );
} // well, one could sleep(INTERVAL) instead;
// the advantage of singleShot is that user can e.g. close the window
// or press 'stop' while the answer is displayed

bool KLearnNotes2::isStarted()
{ 
  // THIS IS TRICKY - make sure there is no mistake made by inconsistent 
  // translations!
  if (aStartStop->text()==tr("stop"))
    return true;
  return false;
}
  


bool KLearnNotes2::noteNameIsActive(char letter)
{
  for(int i=0;i<7;i++)
    if((namePBs[i]->text().latin1()[0]==letter)&&(nameCHKs[i]->isChecked()))
      return true;
  return false;
}


void KLearnNotes2::setupActiveNotes()
{
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: setupActiveNotes()");
#endif
  for(int i=0;i<numNotesALL;i++)
    {
      allNotes[i]->hideNote();
    }
  numActiveNotes=0;
  for(int i = -numNotesABOVE; i< numNotesALL-numNotesABOVE;i++)
    {
      if (((i-minmax1->value()) *(i-minmax2->value()))<= 0)
	{
	  if (nameCHKs[allNotes[i+numNotesABOVE]->getName()]->isChecked())
	    {
	      activeNotes[numActiveNotes]=allNotes[i+numNotesABOVE];
	      activeNotes[numActiveNotes]->showNote();
	      // now, there is a problem: if a note is displayed while another
	      // is near new lines are displayed longer; but those already
	      // displayed do not change; thus a loop below ($%$%$%)
	      numActiveNotes++;
	    }
	}
    }

  // it would be enough to do 
  // for(int i=0;i<numActiveNotes; i++) activeNotes[i]->showNote(); //($%$%$%)
  // but it's a terrible waste: it re-shows some lines multiple times, moves
  // some notes few times (with no resulting change) etc.
  // therefore:
  for(int i=0;i<numLinesABOVE;i++) 
    if (linesabove[i]->isVisible())
      linesabove[i]->show(); // :)))) ; but the size can be new
  for(int i=0;i<numLinesABOVE;i++) 
    if(linesbelow[i]->isVisible())
      linesbelow[i]->show();
  setupSpeedGoal();
  calculateTestLength();
}



void KLearnNotes2::setupExercises()
{
  // I will keep the same names for exercises on the treble and
  // bass clefs, but "region" means sth different: these regions
  // are different for treble and bass - they are adjusted to get
  // most important notes in

  // but if desirable one *could* insert here:
  // * remove all items
  // * if clef->currentItem()==0 => insert exercises for treble
  // * if clef->currentItem()==1 => insert exercises for bass
  // and run it whenever clef changes;
  // this is why I extracted setupExercises() as a separate slot, 
  // rather then inserting it in the constructor for KLN::KLN()

  CB_exercise->insertItem(tr("*** custom ***",
			     "custom exercise(a set of testnotes)" ));

  CB_exercise->insertItem(QPixmap( (const char**)twolines_xpm));

  CB_exercise->insertItem("01: "+tr("C and G")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("02: "+tr("C and D")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));
  HBexeNums[0]=CB_exercise->count();
  CB_exercise->insertItem("03: ");// +tr("H and C") set in setGermanHNotation()
  HBexeNums[1]=CB_exercise->count();
  CB_exercise->insertItem("04: ");// +tr("H C D")
  CB_exercise->insertItem("05: "+tr("C and G")
			  +tr(" in the main region",
			      "a space needed  before 'in' ")
			  +tr(" (repeat.)" ,
			      "a space needed  before '(' "));
  CB_exercise->insertItem("06: "+tr("G and A")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("07: "+tr("F and G")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("08: "+tr("F G A")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("09: "+tr("C E G")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("10: "+tr("D E F")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("11: "+tr("all notes")
			  +tr(" in the main region",
			      "a space needed  before 'in' "));

  CB_exercise->insertItem(QPixmap( (const char**)twolines_xpm));


  CB_exercise->insertItem("12: "+tr("C and G")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("13: "+tr("C and D")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));
  HBexeNums[2]=CB_exercise->count();
  CB_exercise->insertItem("14: ");// +tr("H and C")
  HBexeNums[3]=CB_exercise->count();
  CB_exercise->insertItem("15: ");// +tr("H C D")
  CB_exercise->insertItem("16: "+tr("C and G")
			  +tr(" in the upper region",
			      "a space needed  before 'in' ")
			  +tr(" (repeat.)" ,
			      "a space needed  before '(' "));
  CB_exercise->insertItem("17: "+tr("G and A")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("18: "+tr("F and G")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("19: "+tr("F G A")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("20: "+tr("C E G")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("21: "+tr("D E F")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("22: "+tr("all notes")
			  +tr(" in the upper region",
			      "a space needed  before 'in' "));

  CB_exercise->insertItem(QPixmap( (const char**)twolines_xpm));


  CB_exercise->insertItem("23: "+tr("C and G")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("24: "+tr("C and D")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));
  HBexeNums[4]=CB_exercise->count();
  CB_exercise->insertItem("25: ");// +tr("H and C")
  HBexeNums[5]=CB_exercise->count();
  CB_exercise->insertItem("26: ");// +tr("H C D")
  CB_exercise->insertItem("27: "+tr("C and G")
			  +tr(" in the lower region",
			      "a space needed  before 'in' ")
			  +tr(" (repeat.)",
			      "a space needed  before '(' "));
  CB_exercise->insertItem("28: "+tr("G and A")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("29: "+tr("F and G")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("30: "+tr("F G A")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("31: "+tr("C E G")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("32: "+tr("D E F")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));
  CB_exercise->insertItem("33: "+tr("all notes")
			  +tr(" in the lower region",
			      "a space needed  before 'in' "));

  CB_exercise->insertItem(QPixmap( (const char**)twolines_xpm));

  CB_exercise->insertItem("34: "+tr("C and G" ));
  CB_exercise->insertItem("35: "+tr("C and D" ));
  HBexeNums[6]=CB_exercise->count();
  CB_exercise->insertItem("36: ");// +tr("H and C" ));
  HBexeNums[7]=CB_exercise->count();
  CB_exercise->insertItem("37: ");// +tr("H C D" ));
  CB_exercise->insertItem("38: "+tr("C and G")
			  +tr(" (repeat.)",
			      "a space needed  before '(' "));
  CB_exercise->insertItem("39: "+tr("G and A" ));
  CB_exercise->insertItem("40: "+tr("F and G" ));
  CB_exercise->insertItem("41: "+tr("F G A" ));
  CB_exercise->insertItem("42: "+tr("C E G" ));
  CB_exercise->insertItem("43: "+tr("D E F" ));
  CB_exercise->insertItem("44: "+tr("all notes" ));

}

bool KLearnNotes2::dialogCustom_show()
{
  if( restoring) return true; // this new setting is loaded; but it still
  //                             should be in future considered a source
  //                             for dialogCustom
  customLevel* customdialog;
  QPixmap tmpPixmap=tbWhat->iconSet().pixmap(QIconSet::Small,
					     QIconSet::Normal);
  if((customSpeedGoal2==0)&&(customSpeedGoal7==0))
    // there was no custom so far; as starting point we choose lastLevel's
    // data
    customdialog=new customLevel(tmpPixmap,this,speed2(lastLevel),
				 speed7(lastLevel));
  else
    // there was a custom before; as starting point we choose customs
    customdialog=new customLevel(tmpPixmap,this,
				 customSpeedGoal2,customSpeedGoal7,
				 customSpeedGoal2,customSpeedGoal7);
  if(customdialog->exec() !=QDialog::Accepted )
    {
      // Cancel: fall back to previous level!
      //      debuginfo(QString("Falling back: lastlevel=%1").arg(lastLevel));
      a_mo_setLevel[lastLevel]->setOn(true);// changing action changes level!
      delete customdialog;
      if(lastLevel==3)
	setupLevelCustom_withoutDialog();
      return false; // let's hope this does NOT loop forever if user cancels
      //               all the time :(
    }else{ //OK
      //      debuginfo("ACCEPTED");
      customSpeedGoal2=(customdialog->SB_speed2)->value();
      customSpeedGoal7=(customdialog->SB_speed7)->value();
      if(customSpeedGoal2==speed2(0) && customSpeedGoal7==speed7(0) )
	{
	  a_mo_setLevel[0]->setOn(true);  // changing action changes level!
	  delete customdialog;
	  return (lastLevel!=0);
	}
      if(customSpeedGoal2==speed2(1) && customSpeedGoal7==speed7(1) )
	{
	  a_mo_setLevel[1]->setOn(true);  // changing action changes level!
	  delete customdialog;
	  return (lastLevel!=1);
	}
      if(customSpeedGoal2==speed2(2) && customSpeedGoal7==speed7(2) )
	{
	  a_mo_setLevel[2]->setOn(true);  // changing action changes level!
	  delete customdialog;
	  return (lastLevel!=2);
	}
    }
  delete customdialog;
  
  return true;
}

int KLearnNotes2::speed2(int level)
{
  switch(level)
    {
    case 0:
      return defSPEEDgoal02;
    case 1:
      return defSPEEDgoal12;
    case 2:
      return defSPEEDgoal22;
    case 3:
      return customSpeedGoal2;
    }
  return -1;
}

int KLearnNotes2::speed7(int level)
{
  switch(level)
    {
    case 0:
      return defSPEEDgoal07;
    case 1:
      return defSPEEDgoal17;
    case 2:
      return defSPEEDgoal27;
    case 3:
      return customSpeedGoal7;
    }
  return -1;
}

void KLearnNotes2::setupSpeedGoal()
{
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: setupSpeedGoal()");
#endif
  // let's hope numActiveNotes is set right (=>>>>> check it!)
  double nba=0;
  for(int i=0;i<7;i++)
    if(nameCHKs[i]->isChecked()) nba++;
  if (nba>0)
    {
      int sp2=speed2(CB_level->currentItem());
      int sp7=speed7(CB_level->currentItem());
      nba=((sp7-sp2)*nba+7*sp2-2*sp7)/5;
      LCD_yourGoal->display(nba);
    }
}



#ifdef _KLN_SHOW_SCHEDULE
void KLearnNotes2::debugShowSuggestions(int activequenum)
  // default -1
{
  // debug: show what's scheduled
  QString deb=QString("defMAXseria=%1 noOfTestnotes=%2 \n"
		      "scheduled notes: \n"
		      ).arg(defMAXseria).arg(numActiveNotes);
  for(int i=0;i<defMAXseria;i++)
    {
      deb+=" (";
      if (suggestion[i]==NULL)
	deb+="  X,";
      else
	for(int j=0;j<numNotesALL;j++)
	  if (suggestion[i]==allNotes[j])
	    {
	      if(j<10) deb+=" ";
	      deb+=QString("%1%2,").arg(QChar(suggestion[i]->getCname())
					).arg(j);
	    }
      if((activequenum>0)&&(activequenum%defMAXseria == i))
	deb+="*)";
      else 
	deb+=" )";
      if(i%10==9) deb+="\n";
    }
  debuginfo(deb);
}
#endif //_KLN_SHOW_SCHEDULE

void KLearnNotes2::PBchangeColorTmp(int buttonNo,int time)
  //                default: time=INTERVAL
{
  namePBs[buttonNo]->setColorTmp(defNiceBlue,time);
}




//================== UI


struct loadSet2{
  // a structure used to load/save data in ~/.klearnnotes2
  //==== MIDI:
  bool midi_open; //was it opened?
  int midi_device;
  int midi_numChannels;
  int midi_volume;
  int midi_noteLength;
  int midi_patch;
  int midi_octaveBias;
  //==============
  bool H_nameMode;
  int testLengthFactor;
  int level;
  int speedGoal2; // custom speed goal for 2 namebuttons active
  int speedGoal7; // custom speed goal for 7 namebuttons active

  //======= EXERCISE clef, etc
  int clef;
  int exercise;
  int notesRange1;
  int notesRange2;
  bool nameIsActive0;
  bool nameIsActive1;
  bool nameIsActive2;
  bool nameIsActive3;
  bool nameIsActive4;
  bool nameIsActive5;
  bool nameIsActive6;
};

struct loadSet3{
  // a structure used to load/save data in ~/.klearnnotes2_d/config/
  //==== MIDI:
  bool midi_open; //was it opened?
  int midi_device;
  int midi_numChannels;
  int midi_masterVolume;  // NEW in v3
  int midi_midiVolume;    // NEW in v3
  int midi_noteLength;
  int midi_patch;
  int midi_octaveBias;
  //==============
  bool H_nameMode;
  int testLengthFactor;
  int level;
  int speedGoal2; // custom speed goal for 2 namebuttons active
  int speedGoal7; // custom speed goal for 7 namebuttons active

  //======= Voice Recognition
  bool vr_on; // is voiceRecognion turned on?

  //======= EXERCISE clef, etc
  int clef;
  int typeOfExe;     // NEW: type of exercise (note2name or name2note or...)
  int exercise;
  int numCustom;     // NEW: number of custom exercises saved

  // the following fields will NOT be used once customExes are savable
  int notesRange1;
  int notesRange2;
  bool nameIsActive0;
  bool nameIsActive1;
  bool nameIsActive2;
  bool nameIsActive3;
  bool nameIsActive4;
  bool nameIsActive5;
  bool nameIsActive6;
};




void KLearnNotes2::endKLearnNotes2()
{
#ifdef _KLN_GENERAL_DEBUG
  debuginfo("KLN2: endKLearnNotes2()");
#endif
  saveOptions(); // I don't know why this doesn't work in the destructor.
  midi_turnOff();
#ifdef _WITH_VOICE_CONTROL
  if(voiceProcess->isRunning ())
    {
      debuginfo(tr("Stopping cvoicecontrol"));
      voiceStartStop(false);
      if(voiceProcess->isRunning ())
	{
	  KLN_usleep(1000000); // 1s, 'cause tryTerminate returns immediately
	  if(voiceProcess->isRunning ())
	    {
	      debuginfo(tr("Killing cvoicecontrol"));
	      voiceProcess->kill(); // tired of waiting...
	    }
	}
    }
#endif
  kapp->quit();
}

void KLearnNotes2::resetComments()   {comment("<BR>");}


void KLearnNotes2::startstop()
{
  bStartStop->setFocus (); // if focus is in the spinbox keyboard input
  if (!isStarted())
    {
      setupActiveNotes();
      if (numActiveNotes<2)
	{
	  comment(QString("<FONT COLOR=RED><B>") + 
		  tr("There are less then 2 notes active;\n"
		     "check more notes or wider region to "
		     "start!")+
		  QString("</B></FONT>") );
	  //  QTimer::singleShot( 5*INTERVAL, this, SLOT(resetComments()) );
	  return;
	}
      //      comment(tr("==================","this should be 'comments' width"),
      //	      QColor(180,180,180));
      comment("= "+tr("starting new exercise")+" =",
	      QColor(180,180,180));
      //      comment(tr("==================","this should be 'comments' width"),
      //	      QColor(180,180,180));

      QToolTip::setGloballyEnabled(false);
      // hide guidelines
      for (int i=0; i<(numLinesABOVE+numLinesBELOW); i++)
	guidelines[i]->hide();

      for (int i=0;i<numActiveNotes;i++)
	{
	  activeNotes[i]->hideNote();	//'cause setupAN sets them visible
	  activeNotes[i]->resetStats();
	}
      for(int i=0;i<numNotesALL;i++)
	allNotes[i]->setColor('0');
      LCD_numWR->display(0);
      LCD_numWR->setPaletteBackgroundColor(bgcolor);
      LCD_numOK->display(0);
      LCD_speed->display(0);
      timespent=0;


      for(int i=0;i<7;i++)
	nameCHKs[i]->setEnabled(false);
      minmax1->setEnabled(false);
      minmax2->setEnabled(false);
      CB_exercise->setEnabled(false);
      CB_clef->setEnabled(false);
      a_mp_SetClefTreble->setEnabled(false);
      a_mp_SetClefBass->setEnabled(false);
      aNextExercise->setEnabled(false);
      CB_level->setEnabled(false);
      for(int i=0;i<4;i++)
	a_mo_setLevel[i]->setEnabled(false);
      a_mo_setNotationGE->setEnabled(false);
      a_mo_setTestLength->setEnabled(false);
      a_mo_save->setEnabled(false);
      a_mo_load->setEnabled(false);
      bStartStop->setText(tr("&Stop"));
      aStartStop->setText(tr("stop"));
      aStartStop->setMenuText(tr("&Stop"));

      RandomObject_init((RandomObject**)suggestion, defMAXseria,
			(RandomObject**)activeNotes, numActiveNotes);
#ifdef _KLN_SHOW_SCHEDULE
      debuginfo("INITIALIZED SCHEDULE TABLE; it is now:");
      debugShowSuggestions(quenum);
#endif
      quenum=0;
      note=NULL;
      bStartStop->setFocus (); // if focus is in the spinbox keyboard input
      //                          would not work
      bStartStop->setEnabled(false); // otherwise everything gets crazy
      aStartStop->setEnabled(false); // if user clicks start/stop during 
      //                                the interval (we get to STOP, but 
      //                                nextnote singleShot below still get 
      //                                executed!)
      QTimer::singleShot( INTERVAL, this, SLOT( nextNote()) ); // leave some
      //                       time for mouse movement!
    }else{  //"Stop" pressed
      clocky->stop();
      QToolTip::setGloballyEnabled(true);
      note->hideNote();

      // COMMENTS:
      // 1. comment if exercise was not finished
      // 2. if at least four answers:
      // * if there were mistakes: 
      //    -list them, 
      //    -mark notes in red
      //    -comment to be carefull (one mistake acceptable)
      // * if there is one mistake or none:
      //    -find the two slowest and one fastests notes
      //    -if fast/slow>1.5 
      //        = list the slowest notes
      //        = comment on being careful about them
      //    -consider overall speed:
      //        = if bigger than speed goal -suggest changing exe or speed goal
      //        = smaller than speed goal - suggest continuing

      if (quenum<(testLength+1))
	comment(tr("Unfinished exercise!"));
      // ERROR COMMENTS:
      if(LCD_numWR->value()>1)
	{
	  QString txt(tr("MISTAKES about notes: "));
	  for(int i=0;i<numActiveNotes; i++)
	    if(activeNotes[i]->getWrong()>0)
	      {
		txt+=QString(QChar(activeNotes[i]->getCname()))+" ";
		activeNotes[i]->setColor('R');
	      }
	    else
	      {
		activeNotes[i]->setColor('0');
	      }
	  comment(txt+tr("- they are marked in red now."));
	  comment(tr("Answer slower. but try to make "
		     "less mistakes! :("));
	}
      else if(LCD_numWR->value()==1)
	{
	  for(int i=0;i<numActiveNotes; i++)
	    if(activeNotes[i]->getWrong()>0)
	      {
		comment(tr("One mistake may be acceptable for "
			   "a while, but pay special attention "
			   "to the red note %1 !"
			   ).arg(QChar(activeNotes[i]->getCname())));
		activeNotes[i]->setColor('R');
	      }
	    else
	      activeNotes[i]->setColor('0');
	}
      if(LCD_numOK->value()+LCD_numWR->value() >= 4)
	{
	  // SPEED COMMENTS:
	  
	  if (LCD_numWR->value()<=1)
	    { 
	      // FIND THE SLOWEST AND THE FASTEST NOTE:
	      aNote* minNote1;
	      aNote* minNote2;
	      aNote* maxNote;
	      if(activeNotes[0]->getSpeed()>activeNotes[1]->getSpeed())
		{
		  minNote1=activeNotes[1];
		  minNote2=activeNotes[0];
		}else{
		  minNote1=activeNotes[0];
		  minNote2=activeNotes[1];
		}
	      for(int i=2;i<numActiveNotes;i++)
		{
		  if(activeNotes[i]->getSpeed()<minNote1->getSpeed())
		    // slower than slower of the two
		    {
		      minNote2=minNote1;
		      minNote1=activeNotes[i];
		    }else if(activeNotes[i]->getSpeed()<minNote2->getSpeed())
		      minNote2=activeNotes[i];
		}
	      maxNote=activeNotes[0];
	      for(int i=1;i<numActiveNotes;i++)
		if(activeNotes[i]->getSpeed()>maxNote->getSpeed())
		  maxNote=activeNotes[i];

	    
	      // ARE THERE BIG DIFFERENCES BETWEEN THE SLOWEST AND THE FASTEST?
	      if((maxNote->getSpeed()/minNote1->getSpeed()>4 )&&
		 (LCD_numWR->value()<=1))
		{
		  comment(tr("There is a big difference between the note you "
			     "answer the fastest and the slowest! "));
		  if(maxNote->getSpeed()/minNote2->getSpeed()>4 )
		    {
		      comment(tr("Pay special attention to the two slowest "
				 "notes (%1 and %2  marked in brown)."
				 ).arg(QChar(minNote1->getCname())
				       ).arg(QChar(minNote2->getCname())));
		      minNote1->setColor('S');
		      minNote2->setColor('S');
		    }else{ // only one note really slow:
		      comment(tr("Pay special attention to the slowest "
				 "note (%1 marked in brown)."
				 ).arg(QChar(minNote1->getCname())));
		      minNote1->setColor('S');
		    }
		}
	    }
	  // "NOW WHAT?" COMMENTS:
	  if(LCD_numWR->value()>1)
	    comment("<B>"+
		    tr("%1 mistakes. Keep practicing this exercise."
		       ).arg(LCD_numWR->value())+
		    "</B>");
	  else
	    if(LCD_speed->value()>LCD_yourGoal->intValue())
	      {
		if(LCD_numWR->value()==0)
		  {
		    comment("<B>"+tr("Great! Try next exercise. :)")+"</B>");
		    CB_exercise->setFocus ();
		  }
		else
		  {
		    comment("<B>"+tr("OK. Consider changing exercise."
				     )+"</B>");
		    CB_exercise->setFocus ();
		  }
	      }
	    else
	      {
		comment("<B>"+
			tr("You have not achieved your speed goal. "
			   "Keep practicing at this exercise.")+"</B>");
		bStartStop->setFocus();
	      }
	  comment("==================",QColor(180,180,180));
	}
      for (int i=0; i<(numLinesABOVE+numLinesBELOW); i++)
	guidelines[i]->show();
      for(int i=0;i<7;i++)
	nameCHKs[i]->setEnabled(true);
      minmax1->setEnabled(true);
      minmax2->setEnabled(true);
      CB_exercise->setEnabled(true);
      CB_clef->setEnabled(true);
      a_mp_SetClefTreble->setEnabled(true);
      a_mp_SetClefBass->setEnabled(true);
      aNextExercise->setEnabled(true);
      CB_level->setEnabled(true);
      for(int i=0;i<4;i++)
	a_mo_setLevel[i]->setEnabled(true);
      a_mo_setNotationGE->setEnabled(true);
      a_mo_setTestLength->setEnabled(true);
      a_mo_save->setEnabled(true);
      a_mo_load->setEnabled(true);
      bStartStop->setText(tr("&Start"));
      aStartStop->setText(tr("start"));
      aStartStop->setMenuText(tr("&Start"));
      setupActiveNotes(); //to show what's active
      c->update();
    }
}

void KLearnNotes2::nextNote()
{
  bStartStop->setEnabled(true);// 'cause we turned if off for the start pause
  aStartStop->setEnabled(true);

  quenum++;
  if (quenum==(testLength+1))
    {
      startstop();//=stop
      return;
    }

  labelQueNum->setText(tr("question %1 out of %2"
			  ).arg(quenum).arg(testLength));
  aNote* lastNote[1];
  lastNote[0]=note;
  aNote* newNote[1];
  newNote[0]=NULL;


  RandomObject_next(quenum, (RandomObject**) lastNote, 
		    (RandomObject**) newNote,
		    (RandomObject**)suggestion, defMAXseria,
		    (RandomObject**)activeNotes, numActiveNotes);
  note=newNote[0];
#ifdef _KLN_SHOW_SCHEDULE
  debuginfo("NEW NOTE from force-scheduling OR random draw");
  debugShowSuggestions(quenum);
#endif
  note->showNote(); 
  c->update();
  note->play();
  midi_playChord();
  onetime=0;
  LCD_queTime->display(onetime);
  clocky->start(50,FALSE);
}


void KLearnNotes2::noteA(){  checkanswer('A');  return; }
void KLearnNotes2::noteC(){  checkanswer('C');  return; }
void KLearnNotes2::noteD(){  checkanswer('D');  return; }
void KLearnNotes2::noteE(){  checkanswer('E');  return; }
void KLearnNotes2::noteF(){  checkanswer('F');  return; }
void KLearnNotes2::noteG(){  checkanswer('G');  return; }
void KLearnNotes2::noteH(){  
  checkanswer(namePBs[0]->text().latin1()[0]);  return; }
// NOTE: this is either B or H - only ONE slot!

void KLearnNotes2::redraw()
{
  // this is run by checkanswer()


  //  resetComments(); // this just adds a newline; it would be better if
  //                  this changed last paragraph's color back 
  
  for(int i=0;i<7;i++)
    namePBs[i]->setEnabled(nameCHKs[i]->isChecked());
  
  note->hideNote();

  bStartStop->setFocus (); // if focus is in the spinbox keyboard input

  // if one pressed Stop while we were waiting for redraw()
  // next note should NOT be selected:
  if (isStarted())
    nextNote();
}

void KLearnNotes2::keyPressEvent( QKeyEvent *k )
{
  bStartStop->setFocus (); // refocus!
  char key = toupper(k->ascii());
  for(int i=0; i<7; i++)
    if(QString(QChar(key))==nameKeys[i]->text())
      key=orderOfNotes[i];
  if ((key <= 'Z') && ( key >='A') )
    // without above condition this reacts to e.g.. alt; 
    // this could lead to segfault even when pressing alt+q = quit !
    if (noteNameIsActive(key))
      checkanswer( key );
}

void KLearnNotes2::growtime()
{
  onetime++;
  LCD_queTime->display(onetime);
  timespent++;
}

void KLearnNotes2::setClef(int indeks)
{
  if ( indeks==0) {                 //TREBLE CLEF
    a_mp_SetClefTreble->setOn(true);
  } else {                            //BASS CLEF
    a_mp_SetClefBass->setOn(true);
  }
}

void KLearnNotes2::setClefTreble(bool treble)
{
   if ( treble) {                 //TREBLE CLEF
     CB_clef->setCurrentItem(0);
    allNotes[0+numNotesABOVE]->setName(2);
    // i.e. the note just above the five lines (=0) is G (=2)
    allNotes[0+numNotesABOVE]->setPitch(60+12+7+OCTAVEbias*12);
    //60=middle C;+12=C1;+7=G1
    clefItem[0]->show();
    clefItem[1]->hide();
  } else {                            //BASS CLEF
     CB_clef->setCurrentItem(1);
    allNotes[0+numNotesABOVE]->setName(0);
    // i.e. the note just above the five lines (=0) is H(=0)
    allNotes[0+numNotesABOVE]->setPitch(60-1+OCTAVEbias*12);
    //60=middle C; -1=H0
    clefItem[1]->show();
    clefItem[0]->hide();
  }


  // now, starting from this note we setup all other
  for (int i =1; i < numNotesALL - numNotesABOVE; i++)
    { // down the clef:
      allNotes[i+numNotesABOVE]->setName((allNotes[i+numNotesABOVE-
						   1]->getName() +1)%7) ;
      int pitchdiff=-2;
      if((allNotes[i+numNotesABOVE-1]->getCname()=='C')||
	 (allNotes[i+numNotesABOVE-1]->getCname()=='F'))
	pitchdiff=-1;
      allNotes[i+numNotesABOVE]->setPitch(allNotes[i+numNotesABOVE-
						   1]->getPitch() +pitchdiff) ;
    }
  for (int i =-1; i > - numNotesABOVE -1 ; i--)
    { // up the clef
      allNotes[i+numNotesABOVE]->setName((700+allNotes[i+numNotesABOVE+
						       1]->getName()-1)%7) ;
      // note for the last line: % does not work on negative integers
      // therefore subtracting 1 is dangerous, and adding 700 makes it safe
      // - one can put here any integer of a form 7*something, just such that
      // (...) be positive
      int pitchdiff=2;
      if((allNotes[i+numNotesABOVE+1]->getCname()=='H')||
	 (allNotes[i+numNotesABOVE+1]->getCname()=='B')||
	 (allNotes[i+numNotesABOVE+1]->getCname()=='E'))
	pitchdiff=1;
      allNotes[i+numNotesABOVE]->setPitch(allNotes[i+numNotesABOVE+
						   1]->getPitch() +pitchdiff) ;

    }
  // here one might want to run setupExercises() if it depended on the clef

  activeNotesChangedByExercise(CB_exercise->currentItem());//to change regions etc.
  // but:
  if(CB_exercise->currentItem()==0)// exercises==custom does nothing; new clef would not
    // be seen:( and different notes are active with the same checkboxes
    // checked (e.g. for 'G'==checked note#0 would be active for treble 
    // clef, while not active for the bass clef!)
    {
      setupActiveNotes(); 
      c->update();
    }
  // erring in different clef shouldn't matter
  for(int i = 0;i<numNotesALL;i++)
    allNotes[i]->setColor('0');
  bStartStop->setFocus ();
}



void KLearnNotes2::activeNotesChangedManual(const int notimportant =0)
{ //  when one slides sliders or checks checkboxes
  int nothing=notimportant; // just to get rid of a warning about unused argument;
  nothing++;//           'notimportant' was introduced just to match some signals!
  for(int i=0;i<7;i++)
    namePBs[i]->setEnabled(nameCHKs[i]->isChecked());

  if (! autochange)
    {
      CB_exercise->setCurrentItem(0);//"custom"
      bStartStop->setFocus (); // if focus is in the spinbox keyboard input
      setupActiveNotes();
      c->update();
    }
}




void KLearnNotes2::activeNotesChangedByExercise(int indeks )
{  // when one changes exercise to one of the presets
  if (indeks==0)
    {
      lastExercise=0;
      return; //"custom"
    }
  if (CB_exercise->count()==0)
    return; // no exercises set yet

  if (indeks==1 || indeks==13 || indeks==25||indeks==37)
    {// a separator!
      if(lastExercise==indeks+1)
	{// user might have used arrow up!
	  CB_exercise->setCurrentItem(indeks-1);
	  activeNotesChangedByExercise(indeks-1);
	}else{
	  CB_exercise->setCurrentItem(indeks+1);
	  activeNotesChangedByExercise(indeks+1);
	}
      return;
    }

  if (indeks>37) indeks--;
  if (indeks>25) indeks--;
  if (indeks>13) indeks--;
  if (indeks>1)  indeks--;
  // from now on, indeks= exercise number

  autochange=true;
  switch (indeks) {
  case 1:  //C,G
  case 12:
  case 23:
  case 34:
  case 5:
  case 16:
  case 27:
  case 38:
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  case 2:  //C,D
  case 13:
  case 24:
  case 35:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(false);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(true);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 3:  //H,C
  case 14:
  case 25:
  case 36:{
    nameCHKs[0]->setChecked(true);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(false);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 4:  //H,C,D
  case 15:
  case 26:
  case 37:{
    nameCHKs[0]->setChecked(true);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(false);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(true);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 6:  //G,A
  case 17:
  case 28:
  case 39:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(true);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(false);	//C
    break;
  }
  case 7:  //F,G
  case 18:
  case 29:
  case 40:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(true);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(false);	//C
    break;
  }
  case 8:  //F,G,A
  case 19:
  case 30:
  case 41:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(true);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(true);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(false);	//C
    break;
  }
  case 9:  //C,E,G
  case 20:
  case 31:
  case 42:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(true);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 10:  // DEF
  case 21:
  case 32:
  case 43:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(false);	//G
    nameCHKs[3]->setChecked(true);	//F
    nameCHKs[4]->setChecked(true);	//E
    nameCHKs[5]->setChecked(true);	//D
    nameCHKs[6]->setChecked(false);	//C
    break;
  }
  case 11:  // ALL
  case 22:
  case 33:
  case 44:{
    nameCHKs[0]->setChecked(true);	//H
    nameCHKs[1]->setChecked(true);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(true);	//F
    nameCHKs[4]->setChecked(true);	//E
    nameCHKs[5]->setChecked(true);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  }
  // Now, main, upper and lower regions have different meaning
  // for bass and treble clefs; also very high and very low notes
  // are rarely used in bass clef, so "all notes" will mean less in this case
  if(CB_clef->currentItem()==0)			//TREBLE
    {
      if(indeks<12)
	{
	  // (-1...12) but max/min just in case
	  minmax1->setValue(KLNmath_max(-1,-numNotesABOVE));//A1
	  minmax2->setValue(KLNmath_min(12,numNotesALL-numNotesABOVE-1));//H0
	}
      if((indeks>=12)&&(indeks<23))
	{
	  minmax1->setValue(-numNotesABOVE);//E2?
	  minmax2->setValue(8);//F
	}
      // exception: for indeks=20 there is one sepeate G-note which looks strange
      if((indeks==20)||(indeks==21))
      	minmax2->setValue(4);
      if((indeks>=23)&&(indeks<34))
	{
	  minmax1->setValue(4);//C
	  minmax2->setValue(numNotesALL-numNotesABOVE-1);//D0?
	}
      // exception: exe 24 has a widow C
      if(indeks==24)
	minmax1->setValue(5);
      if(indeks>=34)
	{
	  minmax1->setValue(-numNotesABOVE);//E2?
	  minmax2->setValue(numNotesALL-numNotesABOVE-1);//D0?
	}
    }else{ 					// BASS
      if(indeks<12)
	{
	  minmax1->setValue(KLNmath_max(-2,-numNotesABOVE));//D"1"
	  minmax2->setValue(KLNmath_min(10,numNotesALL-numNotesABOVE-1));//F
	}
      if((indeks>=12)&&(indeks<23))
	{
	  minmax1->setValue(KLNmath_max(-5,-numNotesABOVE));//G"2"
	  minmax2->setValue(7);//H
	}
      if (indeks==17)
	minmax2->setValue(4);
      if((indeks>=23)&&(indeks<34))
	{
	  minmax1->setValue(5);//D
	  minmax2->setValue(KLNmath_min(17,numNotesALL-numNotesABOVE-1));//it was 13 C"0"
	}
      if(indeks>=34)
	{
	  minmax1->setValue(KLNmath_max(-5,-numNotesABOVE));//G"2"
	  minmax2->setValue(KLNmath_min(17,numNotesALL-numNotesABOVE-1));//it was 13 C"0"
	}

    }
  autochange=false;
  setupActiveNotes();
  c->update();
  bStartStop->setFocus ();
  // remember thisExe as lastExe:
  lastExercise=indeks;
  if (lastExercise>=1)  lastExercise++;
  if (lastExercise>=13) lastExercise++;
  if (lastExercise>=25) lastExercise++;
  if (lastExercise>=37) lastExercise++;
}


void KLearnNotes2::nextExercise()	
{
  if (CB_exercise->currentItem()<(CB_exercise->count()-1))
    {
      CB_exercise->setCurrentItem(CB_exercise->currentItem()+1);
      activeNotesChangedByExercise(CB_exercise->currentItem());
    }
  bStartStop->setFocus ();
}

#ifdef _WITH_VOICE_CONTROL
void KLearnNotes2::voiceTurnSoundOnOff(bool onoroff)
{
  if(a_mo_soundOnOff->isOn()==onoroff)
    {
      return;
    }
  a_mo_soundOnOff->setOn(onoroff);
}
#endif

void KLearnNotes2::turnSoundOnOff(bool onoroff)
{
  // this should be run ONLY by an action toggling (because this does not 
  // change action state if turning on/off goes well)
  if (onoroff) //on
    {
#ifdef _WITH_VOICE_CONTROL
      bool wasrunning;
      wasrunning=false;
      if(voiceProcess->isRunning())
	{
	  statbar->message(tr("turning voiceControl OFF for a moment..."),
			   5*INTERVAL);
	  wasrunning=true;
	  a_mo_voiceOnOff->setOn(false); 
	  //extra usleep 1s :
	  KLN_usleep(1000000);
	}
#endif
      if(! midi_turnOn()) // dev. is NOT open
	{
	  a_mo_soundOnOff->setOn(false);
	  statbar->message(tr("Can't open midi device!"),5*INTERVAL);
	}else{
	  a_mo_soundOnOff->setOn(true); // if turnSoundOnOff was run by
	  //                        a__OnOff toggle, this should do nothing
	  statbar->message(tr("Midi device opened."),5*INTERVAL);
	}
#ifdef _WITH_VOICE_CONTROL
      if(wasrunning)
	{
	  //extra usleep .5s :
	  statbar->message(tr("turning voiceControl back ON..."),
			   5*INTERVAL);
	  KLN_usleep(500000);
	  a_mo_voiceOnOff->setOn(true); 
	}
#endif
    }
  else //off
    {
      midi_turnOff();
      statbar->message(tr("Midi device closed."),5*INTERVAL);
      a_mo_soundOnOff->setOn(false); // hopefully: nop
    }
  bStartStop->setFocus ();
}


void KLearnNotes2::dialogTestLengthFactor()
{
  bool ok = FALSE;
  int newnum=
    QInputDialog::getInteger(tr("Test length factor"),
			     tr("Choose 'test length factor' which will "
				"be used to determine test length \n"
				"(number of questions in one test) as "
				"a percent of a default test length \n"
				"(which is calculated automatically based "
				"on number of active testnotes etc.)\n\n"

				"Setting test length factor \n"
				"* to 100(%) makes tests of default length,\n"
				"* to 50(%) makes tests two times shorter,\n"
				"etc. \n\n"

				"Available range: (40-400)\nChoose : \n"
				"* lower values if you just start learning\n"
				"* higher values if you know things well,"
				" and just train for speed"),
			     testLengthFactor,40,400,1,&ok);
  if ( ok)
    {    // user entered something and pressed OK
      testLengthFactor=newnum;
      //      SB_testLength->setValue(newnum);
      //   setTestLengthFactor(newnum);// should be run by SB_valuechanged();
      //                            but just in case ...
      calculateTestLength();
    }
}


void KLearnNotes2::mH_KHelp_activated()
{
  MenuHelpK->appHelpActivated ();
}

void KLearnNotes2::mH_quickStart_activated()
{
  // let's lie to KDE:
  // we create fake KDialogBase:
  KDialogBase* fakeKDialog=new KDialogBase(this);
  fakeKDialog->setHelp ( "chap-quick-start", "klearnnotes2" );
  fakeKDialog->helpClickedSlot("");
}
void KLearnNotes2::mH_voiceQuickStart_activated()
{
  KDialogBase* fakeKDialog=new KDialogBase(this);
  fakeKDialog->setHelp ( "voice-input", "klearnnotes2" );
  fakeKDialog->helpClickedSlot("");
}




void KLearnNotes2::mH_about_activated()
{
  KAboutApplication * d = new KAboutApplication( &aboutData, this );
  d->show(this);
}

void KLearnNotes2::mH_doesntWork_about_activated ()
{
  static QMessageBox* helpBox = new QMessageBox
    (tr("KLearnNotes2"),
     tr("<h3>Problem:</h3>"
	"I was not able to prepare install in such a way that on all systems "
	"KDE help-file was found by KDE help browser. Therefore, I included "
	"in this distribution a HTML copy of index.docbook. You can access "
	"HTML version of KLearnNotes2 help-files through items in this "
	"(\"<EM>%1</EM>\") submenu."
	"<h3>Notes:</h3><UL>"
	"<LI>KLearnNotes2 help-files were optimized for KDE help browser; if "
	" it is available (\"<EM>%2</EM>\" in the main Help menu) "
	"you should use it rather then \"<EM>%3</EM>\" "
	"submenu."
	"<LI>If you have <B>root</B> access to your computer you may try to "
	" correct it manually after installation. See INSTALL_PROBLEMS "
	" file in KLearnNotes2 package."
	"</UL>"
	).arg(MenuHelp->text(id_mH_doesnt)
	      ).arg(MenuHelp->text(id_mH_help)
		    ).arg(MenuHelp->text(id_mH_doesnt))
     , QMessageBox::Information, 1, 0, 0, this, 0, FALSE );
  helpBox->setButtonText( 1, tr("Dismiss") );
  helpBox->show();
}

void KLearnNotes2::mH_doesntWork_index_activated ()
{
  HelpWindow* hepi = new HelpWindow("klearnnotes2.html",
				    "/usr/share/doc/HTML/en/klearnnotes2/" );
  hepi->show();
}
void KLearnNotes2::mH_doesntWork_quickStart_activated()
{
  HelpWindow* hepi = new HelpWindow(QUICKstartFILE, 
				    "/usr/share/doc/HTML/en/klearnnotes2/"); 
  hepi->show();
}
void KLearnNotes2::mH_doesntWork_voiceQuickStart_activated()
{
  HelpWindow* hepi = new HelpWindow(VOICEqstartFILE, 
				    "/usr/share/doc/HTML/en/klearnnotes2/"); 
  hepi->show();
}


void KLearnNotes2::dialogSetupMidi()
{
  QPixmap tmpPixmap=tbWhat->iconSet().pixmap(QIconSet::Small,QIconSet::Normal);
  //
  // 1. for mixer in mididialog to work, we need sound turned on:
  //
  bool wasItOn;
  wasItOn=midiIsOn();
  if(!wasItOn)
    {
      a_mo_soundOnOff->setOn(true);
    }

  MIDI_setup* mididialog=new MIDI_setup(tmpPixmap,this);
  // midi settings are global, so they are changed directly by mididialog
  // the only thing which needs doing below is:
  // * if octavebias changed we have to redefine notes' pitches
  int tmpint=OCTAVEbias;
  if (mididialog->exec() == QDialog::Accepted )
    {
      if((mididialog->SpinBox5)->value()!=tmpint)
	setClef(CB_clef->currentItem());
    }
  //
  // 2. now: if midi was NOT on - we turn it back off here
  // 3. if it was ON it should stay on; but to ensure new settings are
  //    reset we turn midi off anyway and only then on:
  a_mo_soundOnOff->setOn(false);
  // .5s to settle things down:
  KLN_usleep(500000);
  if(wasItOn)
      a_mo_soundOnOff->setOn(true);
  delete mididialog;
}


void KLearnNotes2::setGermanHNotation(bool notationH)
{
  if(notationH)
    {
      orderOfNotes[0]='H';
      a_mo_setNotationGE->setText( tr( "change to English notation "
				       "'H'->'B'"
				       ,"menu txt in the statusbar" ) );
      a_mo_setNotationGE->setMenuText(tr("German n&otation "
					 "(GA-H-CD)"));
  
      CB_exercise->changeItem("03: "+tr("H and C")
			      +tr(" in the main region",
			      "a space needed  before 'in' "),HBexeNums[0]);
      CB_exercise->changeItem("04: "+tr("H C D")
			      +tr(" in the main region" ,
			      "a space needed  before 'in' "),HBexeNums[1]);
      CB_exercise->changeItem("14: "+tr("H and C")
			      +tr(" in the upper region" ,
			      "a space needed  before 'in' "),HBexeNums[2]);
      CB_exercise->changeItem("15: "+tr("H C D")
			      +tr(" in the upper region" ,
			      "a space needed  before 'in' "),HBexeNums[3]);
      CB_exercise->changeItem("25: "+tr("H and C")
			      +tr(" in the lower region" ,
			      "a space needed  before 'in' "),HBexeNums[4]);
      CB_exercise->changeItem("26: "+tr("H C D")
			      +tr(" in the lower region" ,
			      "a space needed  before 'in' "),HBexeNums[5]);
      CB_exercise->changeItem("36: "+tr("H and C" ),HBexeNums[6]);
      CB_exercise->changeItem("37: "+tr("H C D" ),HBexeNums[7]);
    }else{
      orderOfNotes[0]='B';
      a_mo_setNotationGE->setText( tr( "change to German notation "
				       "'B'->'H'"
				       ,"menu txt in the statusbar" ) );
      a_mo_setNotationGE->setMenuText(tr("English n&otation "
					 "(GA-B-CD)"));

      CB_exercise->changeItem("03: "+tr("B and C")
			      +tr(" in the main region" ,
			      "a space needed  before 'in' "),HBexeNums[0]);
      CB_exercise->changeItem("04: "+tr("B C D")
			      +tr(" in the main region" ,
			      "a space needed  before 'in' "),HBexeNums[1]);
      CB_exercise->changeItem("14: "+tr("B and C")
			      +tr(" in the upper region" ,
			      "a space needed  before 'in' "),HBexeNums[2]);
      CB_exercise->changeItem("15: "+tr("B C D")
			      +tr(" in the upper region" ,
			      "a space needed  before 'in' "),HBexeNums[3]);
      CB_exercise->changeItem("25: "+tr("B and C")
			      +tr(" in the lower region" ,
			      "a space needed  before 'in' "),HBexeNums[4]);
      CB_exercise->changeItem("26: "+tr("B C D")
			      +tr(" in the lower region" ,
			      "a space needed  before 'in' "),HBexeNums[5]);
      CB_exercise->changeItem("36: "+tr("B and C" ),HBexeNums[6]);
      CB_exercise->changeItem("37: "+tr("B C D" ),HBexeNums[7]);
    }
  namePBs[0]->setText(QChar(orderOfNotes[0]));
  setClefTreble(CB_clef->currentItem()==0);// 'cause allNotes[] cNames change
  for(int i=0;i<7;i++)
    {
      QToolTip::add( namePBs[i],
		     tr("namebutton %1").arg(QChar(orderOfNotes[i])));
      QToolTip::add( nameKeys[i],
		     tr("alternative keyboard binding\n"
			"for namebutton %1").arg(QChar(orderOfNotes[i])));
      QToolTip::add( nameCHKs[i],
		     tr("name checkbox %1").arg(QChar(orderOfNotes[i])));
    }
}


void KLearnNotes2::saveOptions()
{
  loadSet3* loadSaveData=new loadSet3;
  // ========= MIDI
  loadSaveData->midi_open=midiIsOn() ; //was it opened?
  loadSaveData->midi_device=midiCurrentDevice ;
  loadSaveData->midi_numChannels=midiMaxChan ;
  loadSaveData->midi_masterVolume=mixerMasterVolume();
  loadSaveData->midi_midiVolume=mixerMidiVolume();
  loadSaveData->midi_noteLength=midiNoteLength ;
  loadSaveData->midi_patch=midiPatch ;
  loadSaveData->midi_octaveBias=OCTAVEbias ;
  //==============
  loadSaveData->H_nameMode=a_mo_setNotationGE->isOn() ;
  loadSaveData->testLengthFactor=testLengthFactor ;
  loadSaveData->level=CB_level->currentItem() ;
  loadSaveData->speedGoal2=customSpeedGoal2;
  loadSaveData->speedGoal7=customSpeedGoal7;

#ifdef _WITH_VOICE_CONTROL
  loadSaveData->vr_on=voiceProcess->isRunning ();
  if(voiceModelFile->exists())
    {
      QFile fileWithModelName(QDir::homeDirPath ()+
			      "/.klearnnotes2_d/current_voice_model");
      fileWithModelName.open( IO_WriteOnly );
      QTextStream t( &fileWithModelName ); // use a text stream
      t << voiceModelFile->name();
      fileWithModelName.close();
      debuginfo("Saved current voice model file name");
    }
#else
  loadSaveData->vr_on=false;
#endif

  //======= EXERCISE clef, etc
  loadSaveData->clef=CB_clef->currentItem() ;
  loadSaveData->typeOfExe=0;// not used for now
  loadSaveData->exercise=CB_exercise->currentItem() ;
  loadSaveData->numCustom=0;// not used for now

  // the following stuff will not be used once customExes are savable
  loadSaveData->notesRange1=minmax1->value() ;
  loadSaveData->notesRange2=minmax2->value() ;
  loadSaveData->nameIsActive0=nameCHKs[0]->isChecked() ;
  loadSaveData->nameIsActive1=nameCHKs[1]->isChecked() ;
  loadSaveData->nameIsActive2=nameCHKs[2]->isChecked() ;
  loadSaveData->nameIsActive3=nameCHKs[3]->isChecked() ;
  loadSaveData->nameIsActive4=nameCHKs[4]->isChecked() ;
  loadSaveData->nameIsActive5=nameCHKs[5]->isChecked() ;
  loadSaveData->nameIsActive6=nameCHKs[6]->isChecked() ;

  QDir* dir=new QDir(QDir::homeDirPath ()+ "/.klearnnotes2_d" );
  if(! dir->exists())
    {
      debuginfo(tr("%1 doesn't exist; creating!").arg(dir->path()));
      dir->mkdir(dir->path());
    }
  delete dir;
  QFile f(QDir::homeDirPath ()+"/.klearnnotes2_d/klearnnotes2_config");
  f.open( IO_WriteOnly );
  QDataStream s( &f );
  s << (Q_UINT32)0xfa0fa0f; //magic number
  s << (Q_INT32)3; //version
  s.writeRawBytes((char*)loadSaveData,sizeof(loadSet3));
  f.close();


  delete loadSaveData;
  statbar->message(tr("wrote settings to %1").arg((QDir::homeDirPath ()+
						   "/.klearnnotes2_d/"
						   "klearnnotes2_config"
						   ).latin1()),
		   5*INTERVAL);
  return;
}


void KLearnNotes2::loadOptions()
{
  loadSet2* loadSaveData2=new loadSet2;
  loadSet3* loadSaveData3=new loadSet3;
  Q_UINT32 magic;
  Q_INT32 version;

  if ( QFile::exists( QDir::homeDirPath ()+
		      "/.klearnnotes2_d/klearnnotes2_config" ) ) {
    QFile f( QDir::homeDirPath ()+"/.klearnnotes2_d/klearnnotes2_config" );
    f.open( IO_ReadOnly );
    QDataStream s( &f );
    s>>magic;
    if ( magic != 0xfa0fa0f )
      {
	printerror (tr("File %1 has wrong magic number! \n"
		       "Using default program settings. \n "
		       "A new %2 will be created on exit."
		       ).arg((QDir::homeDirPath ()+
			      "/.klearnnotes2_d/klearnnotes2_config"
			      ).latin1()
			     ).arg((QDir::homeDirPath ()+
				    "/.klearnnotes2_d/"
				    "klearnnotes2_config"
				    ).latin1()));
	// note, that as /.klearnnotes2_d/klearnnotes2_config existed we
	// will not even try to read ~/.klearnnotes2 !
	delete loadSaveData2;
	delete loadSaveData3;
	f.close();
	return;
      }
    s >> version;
    if ( version != 3 ) // note, that in this directory, only version 3 files
      // should be stored!
      {
 	printerror (tr("File %1 has wrong version! \n"
		       "Using default program settings. \n "
		       "A new %2 will be created on exit."
		       ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
			      "klearnnotes2_config"
			      ).latin1()
			     ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
				    "klearnnotes2_config"
				    ).latin1()));
	delete loadSaveData2;
	delete loadSaveData3;
	f.close();
	return;
      }
    s.readRawBytes((char*)loadSaveData3,sizeof(loadSet3));
    f.close();
  }else{
    // there is no ~/.klearnnotes2_d/klearnnotes2_config
    if ( QFile::exists( QDir::homeDirPath ()+"/.klearnnotes2" ) ) {
      QFile f( QDir::homeDirPath ()+"/.klearnnotes2" );
      f.open( IO_ReadOnly );
      QDataStream s( &f );
      s>>magic;
      if ( magic != 0xfa0fa0f )
	{
	  printerror (tr("File %1 has wrong magic number! \n"
			 "Using default program settings. \n "
			 "A new %2 will be created on exit."
			 ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
				).latin1()
			       ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
				      "klearnnotes2_config"
				      ).latin1()));
	  delete loadSaveData2;
	  delete loadSaveData3;
	  f.close();
	  return;
	}
      s >> version;
      if ( (version != 1)&& (version !=2) )
	{
	  printerror (tr("File %1 has wrong version! \n"
			 "Using default program settings. \n "
			 "A new %2 will be created on exit."
			 ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
				).latin1()
			       ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
				      "klearnnotes2_config"
				      ).latin1()));
	  delete loadSaveData2;
	  delete loadSaveData3;
	  f.close();
	  return;
	}
      s.readRawBytes((char*)loadSaveData2,sizeof(loadSet2));
      f.close();
      debuginfo(tr("File %1 has been successfully loaded! \n"
		   "You may safely delete it now, because \n"
		   "settings will be saved on exit to %2."
		   ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
			  ).latin1()
			 ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
				"klearnnotes2_config"
				).latin1()));
    }else{
      printerror (tr("There are no %1 \n or %2 files! \n"
		     "Using default program settings. \n "
		     "%2 will be created on exit."
		     ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
			    "klearnnotes2_config"
			    ).latin1()
			   ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
				  ).latin1()
				 ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
					"klearnnotes2_config"
					).latin1()));
      delete loadSaveData2;
      delete loadSaveData3;
      return;
    }
  }

  // OK - loadsavedata has been loaded
  restoring=true;
  if(version==3)
    {
      
      // ========= MIDI
      midiCurrentDevice=loadSaveData3->midi_device ;
      midiMaxChan = loadSaveData3->midi_numChannels;
      mixerSetMidiVolume(loadSaveData3->midi_midiVolume);
      mixerSetMasterVolume(loadSaveData3->midi_masterVolume);


      midiNoteLength =  loadSaveData3->midi_noteLength;
      midiPatch =  loadSaveData3->midi_patch;
      OCTAVEbias =  loadSaveData3->midi_octaveBias;
      a_mo_soundOnOff->setOn(loadSaveData3->midi_open) ;//was it opened?
      // it was:    turnSoundOnOff(loadSaveData3->midi_open);
      a_mo_soundOnOff->setOn(loadSaveData3->midi_open);
      //==============
      a_mo_setNotationGE->setOn(  loadSaveData3->H_nameMode);
      testLengthFactor =  loadSaveData3->testLengthFactor;
      //      SB_testLength->setValue(testLengthFactor);

      //======= EXERCISE clef, etc
      minmax1->setValue( loadSaveData3->notesRange1);
      minmax2->setValue( loadSaveData3->notesRange2);
      nameCHKs[0]->setChecked( loadSaveData3->nameIsActive0);
      nameCHKs[1]->setChecked( loadSaveData3->nameIsActive1);
      nameCHKs[2]->setChecked( loadSaveData3->nameIsActive2);
      nameCHKs[3]->setChecked( loadSaveData3->nameIsActive3);
      nameCHKs[4]->setChecked( loadSaveData3->nameIsActive4);
      nameCHKs[5]->setChecked( loadSaveData3->nameIsActive5);
      nameCHKs[6]->setChecked( loadSaveData3->nameIsActive6);

      customSpeedGoal2=loadSaveData3->speedGoal2 ;
      customSpeedGoal7=loadSaveData3->speedGoal7 ;

  
      CB_exercise->setCurrentItem(0);
      CB_clef->setCurrentItem( loadSaveData3->clef);
      setClef(loadSaveData3->clef);
      // typeOfExe and numCustom ignored for now
      CB_exercise->setCurrentItem(loadSaveData3->exercise);
      activeNotesChangedByExercise(loadSaveData3->exercise);

      CB_level->setCurrentItem(loadSaveData3->level) ;
      a_mo_setLevel[loadSaveData3->level]->setOn(true);
      setupSpeedGoal();

#ifdef _WITH_VOICE_CONTROL
      QFile fileWithModelName(QDir::homeDirPath ()+
			      "/.klearnnotes2_d/current_voice_model");
      if(fileWithModelName.exists())
	{
	  fileWithModelName.open( IO_ReadOnly );
	  QTextStream t( &fileWithModelName ); // use a text stream
	  QString s;
	  t >> s;
	  fileWithModelName.close();
	  setVoiceModelFilename(s);
	}
      a_mo_voiceOnOff->setOn(loadSaveData3->vr_on);
      // it was:      voiceStartStop(loadSaveData3->vr_on);
#endif

      delete loadSaveData3;
      statbar->message(tr("loaded settings from %1"
			  ).arg((QDir::homeDirPath ()+"/.klearnnotes2_d/"
				 "klearnnotes2_config"
				 ).latin1()),
		       5*INTERVAL);
      restoring=false;
      return;
    }


  // we are at version !=3, and therefore 1 or 2:

  // ========= MIDI
  midiCurrentDevice=loadSaveData2->midi_device ;
  midiMaxChan = loadSaveData2->midi_numChannels;
  int level =  loadSaveData2->midi_volume;
  if (version == 1)
    {
      mixerSetMidiVolume(100);
      mixerSetMasterVolume(100);
    }else{
      mixerSetMidiVolume(level & 0xff);
      mixerSetMasterVolume((level&0xff00)>>8);
    }
  // like left-right; both are less than 100
  // therefore both can be stored in one variable; it would be clearer 
  // to use them separately, but I 
  // don't want to change ~/.klearnnotes2 format if I don't have to (and 
  // I kept place for only one int :( )

  midiNoteLength =  loadSaveData2->midi_noteLength;
  midiPatch =  loadSaveData2->midi_patch;
  OCTAVEbias =  loadSaveData2->midi_octaveBias;
  a_mo_soundOnOff->setOn(loadSaveData2->midi_open) ;//was it opened?
  // it was:  turnSoundOnOff(loadSaveData2->midi_open);//was it opened?
  a_mo_soundOnOff->setOn(loadSaveData2->midi_open);
  //==============
  a_mo_setNotationGE->setOn(  loadSaveData2->H_nameMode);
  testLengthFactor =  100;
  //  SB_testLength->setValue(testLengthFactor);

  //======= EXERCISE clef, etc
  minmax1->setValue( loadSaveData2->notesRange1);
  minmax2->setValue( loadSaveData2->notesRange2);
  nameCHKs[0]->setChecked( loadSaveData2->nameIsActive0);
  nameCHKs[1]->setChecked( loadSaveData2->nameIsActive1);
  nameCHKs[2]->setChecked( loadSaveData2->nameIsActive2);
  nameCHKs[3]->setChecked( loadSaveData2->nameIsActive3);
  nameCHKs[4]->setChecked( loadSaveData2->nameIsActive4);
  nameCHKs[5]->setChecked( loadSaveData2->nameIsActive5);
  nameCHKs[6]->setChecked( loadSaveData2->nameIsActive6);

  customSpeedGoal2=loadSaveData2->speedGoal2 ;
  customSpeedGoal7=loadSaveData2->speedGoal7 ;

  
  CB_exercise->setCurrentItem(0);
  CB_clef->setCurrentItem( loadSaveData2->clef);
  setClef(loadSaveData2->clef);
  // numbers of exercises in version>=1.1 differ!
  // to get user where she ended last:
  if(loadSaveData2->exercise>= 1) loadSaveData2->exercise++; //separator
  if(loadSaveData2->exercise>=11) loadSaveData2->exercise++; // extra FED exe
  if(loadSaveData2->exercise>=13) loadSaveData2->exercise++; //separator
  if(loadSaveData2->exercise>=23) loadSaveData2->exercise++; // extra FED exe
  if(loadSaveData2->exercise>=25) loadSaveData2->exercise++; //separator
  if(loadSaveData2->exercise>=35) loadSaveData2->exercise++; // extra FED exe
  if(loadSaveData2->exercise>=37) loadSaveData2->exercise++; //separator
  if(loadSaveData2->exercise>=47) loadSaveData2->exercise++; // extra FED exe


  CB_exercise->setCurrentItem(loadSaveData2->exercise);
  activeNotesChangedByExercise(loadSaveData2->exercise);

  CB_level->setCurrentItem(loadSaveData2->level) ;
  a_mo_setLevel[loadSaveData2->level]->setOn(true);
  setupSpeedGoal();

  delete loadSaveData2;
  delete loadSaveData3;
  statbar->message(tr("loaded settings from %1"
		      ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
			     ).latin1()),
		   5*INTERVAL);
  restoring=false;
  return;
}

//void KLearnNotes2::setTestLengthFactor(int number)
//{
//  testLengthFactor=number;
//  calculateTestLength();
//}

void KLearnNotes2::setupLevelCustom_withoutDialog()
{
  // run when bailing out from customDialog to previous customLevel
  // - contrary to activating a_mo_setLevelCustom, this should NOT
  // show customDialog:
  CB_level->setCurrentItem(3);
  setupSpeedGoal();
  lastLevel=3;
  //  debuginfo(QString("Last level changed back to 3."));
}

void  KLearnNotes2::a_mo_setLevelCustom_activated()
{
  // SPECIAL HANDLING OF level3: dialog has to be shown whenever activated,
  // not only toggled
  CB_level->setCurrentItem(3);
  bool changed=dialogCustom_show();
  setupSpeedGoal();
  if(changed)
    {
      lastLevel=3;
      //      debuginfo(QString("Last level changed. It is now %1"
      //			).arg(3));
    }
}

void KLearnNotes2::setLevelByAction(QAction* a)
{
  for(int i=0;i<3;i++) // for i=3 NOP -> a_mo_setLevelCustom_activated()
    //                        is run anyway
    if(a==a_mo_setLevel[i])
      {
	CB_level->setCurrentItem(i);
	setupSpeedGoal(); // NOT in runDialCas(), 'cause it should
	//                   be run for non-custom levels too!
	lastLevel=i;//i.e. for changes to preset 0/1/2 and for 
	//                        accepted changes to 3(custom)
	//	debuginfo(QString("Last level changed. It is now %1"
	//			  ).arg(i));
      }
}


void KLearnNotes2::setLevelByCombo(int i)
{
  a_mo_setLevel[i]->setOn(true); // this does anything only for i != 3
  if(i==3)
    {
      a_mo_setLevelCustom_activated(); // to activate level 3 even if action
      //                                  does not toggle
    }
  bStartStop->setFocus ();
}

void KLearnNotes2::calculateTestLength()
{
  double result;
  result=defTESTlength;
  if(numActiveNotes > 0)
    {
      result=(double(defTESTlength)/double(9))*double(numActiveNotes+3);
      // defTESTlength = length for 6 notes active;
      // for defTESTlength=60 result changes from 33.333 for 2 notes 
      // to 180 for 24 notes active
      
      // take testLengthFactor into account:
      result*=testLengthFactor;
      result/=double(100);
      
    }
  if(result<5)
    result=5;
  testLength=int(result);
  labelQueNum->setText(tr("question 0 out of %1").arg(testLength));
}



#ifdef _WITH_VOICE_CONTROL
void KLearnNotes2::dialogVoiceModelEditor()
{
  // save voice recognition state: was it running?
  bool wasrunning=false;
  if(voiceProcess->isRunning ())
    {
      // if 'yes' - stop it
      a_mo_voiceOnOff->setOn(false); 
      wasrunning=true;
    }
  dModelEditor* modelEditor;
  if(voiceModelFile->exists())
    modelEditor= new dModelEditor(voiceModelFile->name(), this);
  else
    modelEditor= new dModelEditor("", this);
  modelEditor->setHelp("voice-input", "klearnnotes2" );
  modelEditor->exec();
  delete modelEditor;
  // run voice recognition if it was running before ModelEditor setup
  if(wasrunning)
    a_mo_voiceOnOff->setOn(true); 
}

void KLearnNotes2::setVoiceModelFilename(QString newName)
{
  voiceProcess->clearArguments ();
  if(voiceModelFile!=NULL)
    {
      //      debuginfo("Deleting old voiceModelFile name");
      delete voiceModelFile;
    }
  if(newName!=QString::null)
    {
      //      debuginfo("Setting new voiceModelFile name");
      voiceModelFile = new QFile(newName);
      if (voiceModelFile->exists())
	{
	  voiceProcess->addArgument( "cvoicecontrolkln2" );
	  voiceProcess->addArgument(voiceModelFile->name());
	  debuginfo(tr("voice recognition will be started by\n"
		       "cvoicecontrolkln2 %1"
		       ).arg(voiceModelFile->name()));
	}
      else
	{
	  printerror(tr("There is no file %1. \n"
			"Disabling voice recognition."
			).arg(voiceModelFile->name()));
	}
    }
}

void KLearnNotes2::dialogVoiceMircoSetup()
{
  // save voice recognition state: was it running?
  bool wasrunning=false;
  if(voiceProcess->isRunning ())
    {
      // if 'yes' - stop it
      a_mo_voiceOnOff->setOn(false); 
      wasrunning=true;
    }
  dVoiceMicroSetup* microsetup = new dVoiceMicroSetup(this);
  microsetup->exec();
  delete microsetup;
  // run voice recognition if it was running before ModelEditor setup
  if(wasrunning)
    a_mo_voiceOnOff->setOn(true); 
}

void KLearnNotes2::voiceStartStop(bool onoff)
{
  // NOTE: it leaves .5s time before starting and .5s time after stopping
  if(onoff)
    {// turn voice recogn. on
      if(voiceModelFile!=0)
	if(voiceModelFile->exists())
	  if(!voiceProcess->isRunning ())
	    {
	      debuginfo("Starting voice control...");
	      connect( voiceProcess, SIGNAL(processExited()),
		       this, SLOT(voiceExited()) );
	      //KLN_usleep(500000); //.5s: if it's run after 'sound off' there 
	      //                  can be time needed before /dev/? is available
	      if(tryToSuspendArts)
		{
		  //		  debuginfo("starting artsSuspendProcess");
		  QProcess* artsSuspendProcess=new QProcess();
		  artsSuspendProcess->clearArguments ();
		  artsSuspendProcess->addArgument( "artsshell" );
		  artsSuspendProcess->addArgument( "suspend" );
		  if(!artsSuspendProcess->start())
		    {
		      // debuginfo("artsSuspendProcess will not be started "
		      //	"anymore");
		      tryToSuspendArts=false; // probably no artsshell in PATH
		    }
		  else
		    { //give 0.5s time for suspend
		      KLN_usleep(500000);
		    }
		  delete artsSuspendProcess;
		}
	      
	      if(!voiceProcess->start())
		{
		  QMessageBox::warning(this,tr("Couldn't start voice control"),
				       tr("Couldn't start cvoicecontrolkln2.\n"
					  "Please, check if it is in your "
					  "PATH." ));
		}
	    }
      if(! voiceProcess->isRunning())
	{
	  a_mo_voiceOnOff->setOn(false); // for one of the reasons voice was
	  //                                  NOT started
	    a_mo_voiceOnOff->setText( tr( "Voice input is off; turn it on" 
				,"menu txt in the statusbar") );
	    a_mo_voiceOnOff->setMenuText( tr( "Voice input: off" ) );
	}else{
	    a_mo_voiceOnOff->setText( tr( "Voice input is on; turn it off" 
				,"menu txt in the statusbar") );
	    a_mo_voiceOnOff->setMenuText( tr( "Voice input: on" ) );
	}
    }
  else //turn voice recogn. off
    {
      if(voiceProcess->isRunning ())
	{
	  QApplication::setOverrideCursor( Qt::WaitCursor );
	  debuginfo("Stopping voice control...");
	  disconnect( voiceProcess, SIGNAL(processExited()),
		      this, SLOT(voiceExited()) );
	  int i = 0;
	  while( (i < 10) && voiceProcess->isRunning ())
	    {
	      //debuginfo(QString("Stopping voice control... try #%1"
	      //                  ).arg(i+1));
	      voiceProcess->tryTerminate();
	      KLN_usleep(500000); //.5s
	      i++;
	    }
	  if(voiceProcess->isRunning ())
	    {
	      debuginfo("KILLING voice control...");
	      voiceProcess->kill();
	      KLN_usleep(500000); //.5s
	    }
	  a_mo_voiceOnOff->setOn(false);/////??????????????????????????????
	  a_mo_voiceOnOff->setText( tr( "Voice input is off; turn it on" 
					,"menu txt in the statusbar") );
	  a_mo_voiceOnOff->setMenuText( tr( "Voice input: off" ) );
	  QApplication::restoreOverrideCursor();
	}
    }
}

void KLearnNotes2::readFromVoice()
{
  while(voiceProcess->canReadLineStdout())
    {
      QString voiceInput=voiceProcess->readLineStdout ();
      debuginfo(tr("CVoiceControl said: %1").arg(voiceInput));
      
      // COMMANDS:
      if(voiceInput== QString( cmd_quit )) {
	if(QMessageBox::warning(this, tr("Exit KLearnNotes2"),
				tr("Do you really want to quit?"),
				QMessageBox::Yes|QMessageBox::Default,
				QMessageBox::No|QMessageBox::Escape)==
	   QMessageBox::Yes)
	  endKLearnNotes2();
      }else if(voiceInput==QString( cmd_help )){
	mH_KHelp_activated();
      }else if(voiceInput==QString( cmd_quieter )){
	mixerSetMidiVolume(KLNmath_max(0,midiCurrentVolume-10));
      }else if(voiceInput==QString( cmd_louder )){
	mixerSetMidiVolume(KLNmath_min(100,midiCurrentVolume+10));
      }else if(voiceInput==QString( cmd_sndSetup )){
	dialogSetupMidi();
      }else if(voiceInput==QString( cmd_sndOn )){
	voiceTurnSoundOnOff(true);
      }else if(voiceInput==QString( cmd_sndOff )){
	voiceTurnSoundOnOff(false);
      }else if(voiceInput==QString( cmd_none )){
	for(int i=0;i<7;i++)
	  {
	    nameCHKs[i]->setChecked(false);
	  }
	activeNotesChangedManual(0);
      }else if(voiceInput==QString( cmd_all )){
	for(int i=0;i<7;i++)
	  {
	    nameCHKs[i]->setChecked(true);
	  }
	activeNotesChangedManual(0);
      }else if(voiceInput==QString( cmd_length )){
	dialogTestLengthFactor();
      }else if(voiceInput==QString( cmd_next )){
	nextExercise();
      }else if(voiceInput==QString( cmd_treble )){
	setClefTreble(true);
      }else if(voiceInput==QString( cmd_bass )){
	setClefTreble(false);
      }else if(voiceInput==QString( cmd_stop )){
	if (isStarted())
	  startstop();
      }else if(voiceInput==QString( cmd_start )){
	if (!isStarted())
	  startstop();
	// NOTES WITH ACCIDENTALS - NOT USED YET!
      }else if(voiceInput==QString( cmd_csharp )){
      }else if(voiceInput==QString( cmd_dsharp )){
      }else if(voiceInput==QString( cmd_fsharp )){
      }else if(voiceInput==QString( cmd_gsharp )){
      }else if(voiceInput==QString( cmd_asharp )){
      }else if(voiceInput==QString( cmd_dflat )){
      }else if(voiceInput==QString( cmd_eflat )){
      }else if(voiceInput==QString( cmd_gflat )){
      }else if(voiceInput==QString( cmd_aflat )){
      }else if(voiceInput==QString( cmd_hflat )){
      }else if(voiceInput==QString( cmd_bflat )){
      }else {
	// NOTES
	for(int i =0 ; i<7;i++)
	  if(voiceInput==QString(QChar(orderOfNotes [i])))
	    {
	      checkanswer(orderOfNotes[i]);
	    }
      }
    }
}

void KLearnNotes2::voiceExited()
{
  if(voiceProcess->normalExit ())
    QMessageBox::information(this,tr("Voice control: off"),
			     tr("Voice control exited!"
				//"without \n"
				//"reporting an error."
				"Suspect:\nnon existing model file \n%1\n"
				"or other program blocking the "
				"microphone\n"
				"(usually /dev/dsp)." 
				).arg(voiceModelFile->name()));
  else
    {
      statbar->message(tr("voice input turned off"));
      //     QMessageBox::warning(this,"Voice control: off",
      // 			 "Voice control exited with an error!\n"
      // 			 "Strangly, this probably means, you \n"
      //			 "turned it off yourself;)");
    }
  a_mo_voiceOnOff->setOn(false);
}
#endif // _WITH_VOICE_CONTROL

void KLearnNotes2::comment(QString txt, QColor commentsBgColor)
{
  int current=commentsText->paragraphs();
  commentsText->append(txt+"<BR>");
  // if txt has <BR> there can be more than one para added; they all have
  // to have changed bgcolor:
  for(int i = current-1;i<commentsText->paragraphs();i++)
    commentsText->setParagraphBackgroundColor ( i, commentsBgColor);
  commentsText->scrollToBottom ();
}

