/***************************************************************************
 ** $Id: klearnnotes2-defs.h,v 1.2 2003/12/20 03:31:03 wiecko Exp $
                          klearnnotes2
                          klearnnotes2-defs.h  -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLEARNNOTES_DEFS
#define KLEARNNOTES_DEFS
//#define  _KLN_SHOW_SCHEDULE

// ######################## CLEF   SETTINGS ######################## 
#define defHname 'H'
//      a name of a note between 'A' and 'C';
// in English notation a note between 'A' and 'C' is 'B' ;
// in German notation a note between 'A' and 'C' is 'H',
// and 'B' means 'H flat';
//
// set defHname to 'H' or 'B'
//
// but in fact: if it is `H' then the program uses German notation,
// and if it is anything other then `H' the program uses
// English notation

#define defMAXabove 5   
//     max no. of NOTES above the five LINES+1 (i.e. above G2 in a treble clef)
// note: this will be subtracted from an index to get G2 = note_0
// default: 5  ( gives right range for treble clef for guitar)

#define defMAXall 23    
//      max no. of all NOTES
// default: 23 ( gives right range for treble clef for guitar)

#define defNOofLINESabove 3
//       = int( (MAXabove+1)/2 )
// for 5,23 above here set 3
#define defNOofLINESbelow 4
//       = int( (MAXall-MAXabove-10)/2 )
// for 5,23 above here set 4 
//
// there is a check of consistency of last four definitions: if they are inconsistent
// the program tries to lower one of the numbers (not to exceed arrays' sizes);
// if this cannot be done program exits


#define defSC 10 
//      this sets scale for all graphics in canvas;
// SC*2 == spacing between 2 lines
// default: 10  (for 1024x768 screen)

#define defNiceBlue QColor(16,34,188)

// ###################### BEHAVIOR SETTINGS ###################### 
#define INTERVAL 1000  	
//      time [in ms] to wait before asking another question
// and how long a note has a changed  color after hint-button click
// and 1/5 of time before statusbar and labelComments are reset to " "
// default: 1000

#define defMAXseria 30
//      when one makes a mistake, the same question is scheduled for
// future frequent use;
// MAXseria keeps max no. of future questions for which 
// an ahead-plan can be scheduled; i.e. if it is impossible to
// schedule a forced question within next MAXseria questions the
// question will not be scheduled
// default: 30
#define defTESTlength 60
//	 number of notes in one test
//       initial value of max no. of questions in one series of questions;
// one can click ``Stop''  anytime; otherwise ``nextNote'' loop will be
// stopped after MAXque questions
// default: 60

#define defSPEEDgoal02 100
#define defSPEEDgoal12 300
#define defSPEEDgoal22 500
//      min no.of correct answ/(10 min) to receives suggestion 
// "go to next exercise"  and a green frame around "speed";
// below this number one gets "keep practicing" and a red frame

// 600 answ/10min=60answ/min=1answ/sec which is a good goal
// but if you add time needed to find with your mouse a button this
// is almost impossible even for 2 kinds of notes;

// above values are just for 2-notes' exercises, for level0/1/2,
// values for 7-notes' exercises are:
#define defSPEEDgoal07  80
#define defSPEEDgoal17 200
#define defSPEEDgoal27 300


#define defALLnotesEXEnum 44

// ######################## MUSIC  SETTINGS ######################## 
#define defOCTAVEbias -1
//      if you set this to zero you get standard tuning;
// but for example guitar notes are usually written in treble clef, while the
// guitar is tuned one octave lower; if you learn notes to play guitar
// set OCTAVEbias to '-1' - notes in the treble clef will sound like those
// played on the guitar
// this is just an initial value
// default: -1  (for guitar notes on treble clef - bass clef is too low :( )
// default: 0   (for standard tunes)
extern int OCTAVEbias;

#define defMIDIpatch 24
//      initial value; the same patch is used for all notes;
// 0=piano; 24=nylonGuitar etc. (standard Midi instrument numbers)
extern int midiPatch;

#define defNOTElength 60
//      in milliseconds;
// default: 120
extern int midiNoteLength;


#endif
