/***************************************************************************
 ** $Id: imageitem.h,v 1.1.1.1 2003/10/15 23:40:54 wiecko Exp $
                          klearnnotes2
                          imageitem.h  -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcanvas.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpixmap.h>

class ImageItem: public QCanvasRectangle
{// for drawing clefs
 public:
  ImageItem( QImage img, QCanvas *canvas );
 protected:
  void drawShape( QPainter & );
 private:
  QImage image;
  QPixmap pixmap;
};

ImageItem::ImageItem( QImage img, QCanvas *canvas )
  : QCanvasRectangle( canvas ), image(img)
{
  setSize( image.width(), image.height() );
  pixmap.convertFromImage(image, OrderedAlphaDither);
}


void ImageItem::drawShape( QPainter &p ) // overridden to draw the pixmap!
{
  p.drawPixmap( int(x()), int(y()), pixmap );
}
