/***************************************************************************
 ** $Id: globals.cpp,v 1.9 2004/01/17 02:24:20 wiecko Exp $
                          klearnnotes2
                          globals.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qstring.h>
#include <stdio.h>
#include <kdebug.h>
#include <qtranslator.h>
#include <qapplication.h>
#include <unistd.h> // usleep

//////////////////////////////////// GLOBALS
// int KLNmath_min(int a, int b)
// {
//   if (a >b) return b;
//   return a;
// }

// int KLNmath_max(int a, int b)
// {
//   if (a >b) return a;
//   return b;
// }

double KLNmath_power(double base,int exponent)
{
  // note, that for integers, this makes sense only for positive
  // exponents
  int e=0;
  double result=1.;
  while (e<exponent) {//very ineffective :(
    result*=base;
    e++;
  }
  return result;
}

int KLNmath_floor(double number)
{
  int result=int(number);
  if (result>number) result--;
  return result;
}

void debuginfo(QString tekst)
  // print debug info to stdout
{
//    cout<<qApp->tr("DEBUG: ")<<tekst<<endl;
    tekst=qApp->tr("DEBUG: ")+tekst;
    tekst+="\n";
    printf("%s",tekst.latin1());
}

void printerror(QString tekst)
  // print error to stderr
{
//    cerr<<"KLearnNotes2: "<<tekst<<endl;
    tekst=qApp->tr("KLearnNotes2: ")+tekst;
    tekst+="\n";
    fprintf(stderr,"%s",tekst.latin1());
//    kdDebug() << tekst.latin1() <<endl;
}

void KLN_usleep(unsigned long usec)
{
  // sleep for usec microsecons, but allow processing qEvents every 300mic.s
  unsigned long num;
  num=usec;
  while(num>300001)
    {
      qApp->processEvents () ;
      usleep(300000);
      num-=300000;
    }
  qApp->processEvents () ;
  usleep(num); // num >0, but smaller than 301
  qApp->processEvents () ;
}
