/***************************************************************************
 ** $Id: customlevel.ui.h,v 1.4 2003/12/03 17:30:08 wiecko Exp $
                          klearnnotes2
                          customlevel.ui.h -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klearnnotes2-defs.h"
#include <qtranslator.h>

void debuginfo(QString txt);

void customLevel::PB_lev0_clicked()
{
  SB_speed2->setValue(defSPEEDgoal02);
  SB_speed7->setValue(defSPEEDgoal07);
  setupSpeeds36();
}

void customLevel::PB_lev1_clicked()
{
  SB_speed2->setValue(defSPEEDgoal12);
  SB_speed7->setValue(defSPEEDgoal17);
  setupSpeeds36();
}

void customLevel::PB_lev2_clicked()
{
  SB_speed2->setValue(defSPEEDgoal22);
  SB_speed7->setValue(defSPEEDgoal27);
  setupSpeeds36();
}

void customLevel::PB_lastCustom_clicked()
{
  if((lastSpeed2>0 )&&(lastSpeed7>0 ))
    {
      SB_speed2->setValue(lastSpeed2);
      SB_speed7->setValue(lastSpeed7);
      setupSpeeds36();
    }else{
      labelComments->setText(tr("You have never setup custom speeds yet!"));
    }
}





void customLevel::PB_what_clicked()
{
  QWhatsThis::enterWhatsThisMode();
}

void customLevel::PB_OK_clicked()
{
  accept();
}

void customLevel::PB_cancel_clicked()
{
  reject();
}


void customLevel::setupSpeeds36( int ignore)
{
  int nothing=ignore; //just to get rid of stupid warnings;
  nothing++;//'ignore' was introduced just to match some signals
  int w2=SB_speed2->value();
  int w7=SB_speed7->value();
  for(int i=3;i<7;i++)
    speed36[i-3]->setText(QString("%1").arg(((w7-w2)*i+7*w2-2*w7)/5));
  if(w2<defSPEEDgoal12)
    comments2->setText(tr("easy"));
  else 
    if(w2<defSPEEDgoal22)
      comments2->setText(tr("reasonable"));
    else 
      comments2->setText(tr("HARD"));

  if(w7<defSPEEDgoal17)
    comments7->setText(tr("easy"));
  else 
    if(w7<defSPEEDgoal27)
      comments7->setText(tr("reasonable"));
    else 
      comments7->setText(tr("HARD"));

  if(w2<w7)
    labelComments->setText(tr("As you wish. But you set easier goal "
				   "(%1>%2) for harder exercises (with 7 "
				   "active buttons!).").arg(w7).arg(w2));
  else
    labelComments->setText("");
  update();
}
