/***************************************************************************
 ** $Id: customlevel.cpp,v 1.3 2003/11/27 00:43:42 wiecko Exp $
                          klearnnotes2
                          customlevel.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "customlevel.h"

#include <qvariant.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include "customlevel.ui.h"

customLevel::customLevel( QPixmap pmapForWhatsThisButton, QWidget* parent,
			  int val2, int val7,
			  int last2, int last7,
			  const char* name, bool modal, WFlags fl )
  : QDialog( parent, name, modal, fl )
{
  if ( !name ) setName( "customLevel" );

  lastSpeed2=last2;//last custom speed for 2 namebuttons
  lastSpeed7=last7;//last custom speed for 7 namebuttons

  resize( 700, 234 ); 
  setCaption( tr( "setup custom level" ) );

  customLevel* privateLayoutWidget=this;

  QVBoxLayout* Layout11 = new QVBoxLayout( privateLayoutWidget, 20, 6, "Layout11"); 

  // ************ GRID SETUP
  QGridLayout* Layout1 = new QGridLayout( 0, 1, 1, 0, 10, "Layout1"); 

  QLabel* TextLabel0 = new QLabel( privateLayoutWidget, "TextLabel0" );
  TextLabel0->setText( tr( "for the following number of "
			       "active namebuttons..." ) );
  Layout1->addWidget( TextLabel0, 0, 0 );
  QLabel* TextLabel1 = new QLabel( privateLayoutWidget, "TextLabel1" );
  TextLabel1->setText( tr( "... custom speed goal will be:" ) );
  TextLabel1->setAlignment( QLabel::AlignVCenter |QLabel::AlignRight );
  Layout1->addWidget( TextLabel1, 1, 0 );

  QLabel* TextLabel27[6]; // text labels 2-7 with numbers of buttons	
  for(int i=0;i<6;i++)
    {
      TextLabel27[i] = new QLabel( privateLayoutWidget );
      QFont tmpfont(  TextLabel27[i]->font() );
      tmpfont.setBold( true );
      TextLabel27[i]->setFont( tmpfont ); 
      TextLabel27[i]->setFrameShape( QLabel::Box );
      TextLabel27[i]->setFrameShadow( QLabel::Raised );
      TextLabel27[i]->setText( QString("%1").arg(i+2) );
      TextLabel27[i]->setAlignment( QLabel::AlignVCenter |QLabel::AlignRight);
      Layout1->addWidget( TextLabel27[i], 0, i+1 );
    }
  SB_speed2 = new QSpinBox( privateLayoutWidget, "SB_speed2" );
  SB_speed2->setMaxValue( 700 );
  SB_speed2->setMinValue( 50 );
  SB_speed2->setValue( val2 );
  QToolTip::add( SB_speed2, tr( "speed goal for 2 namebuttons" ) );
  QWhatsThis::add( SB_speed2 , tr("choose <B><U>speed "
				      "goal </B></U> for 2 namebuttons active (in answers per 10 minutes); "
				      "this is in range "
				      "50 (very easy) to 700 (impossible with mouse, maybe achievable "
				      "with keyboard)"));
  Layout1->addWidget( SB_speed2, 1, 1 );

  comments2 = new QLabel( privateLayoutWidget, "comments2" );
  comments2->setText( tr( "Easy" ) );
  comments2->setAlignment( QLabel::AlignRight );
  Layout1->addMultiCellWidget( comments2, 2, 2, 0, 1 );


  SB_speed7 = new QSpinBox( privateLayoutWidget, "SB_speed7" );
  SB_speed7->setMaxValue( 700 );
  SB_speed7->setMinValue( 50 );
  SB_speed7->setValue( val7 );
  QToolTip::add( SB_speed7, tr( "speed goal for 7 namebuttons" ) );
  QWhatsThis::add( SB_speed7 , tr("choose <B><U>speed "
				      "goal </B></U> for 7 namebuttons active (in answers per 10 minutes); "
				      "this is in range "
				      "50 (very easy) to 700 (note, that already 400 impossible with mouse, maybe achievable "
				      "with keyboard)"));
  Layout1->addWidget( SB_speed7, 1, 6 );

  comments7 = new QLabel( privateLayoutWidget, "comments7" );
  comments7->setText( tr( "Easy" ) );
  comments7->setAlignment(QLabel::AlignRight );
  Layout1->addMultiCellWidget( comments7, 2, 2, 5, 6 );

  for(int i=0;i<4;i++)
    {
      speed36[i] = new QLabel( privateLayoutWidget );
      speed36[i]->setFrameShape( QLabel::Box );
      speed36[i]->setFrameShadow( QLabel::Raised );
      speed36[i]->setText( "500" );
      speed36[i]->setAlignment( QLabel::AlignVCenter |QLabel::AlignRight );
      QToolTip::add( speed36[i],tr("speed for %1 namebuttons "
					       "active").arg(i+3));
      QWhatsThis::add( speed36[i], tr("speed for %1 namebuttons "
						  "active; "
                       "<BR>this is interpolated from speeds for 2 and 7 "
					  "namebuttons active").arg(i+3));
      Layout1->addWidget( speed36[i], 1, 2+i );
    }

  labelComments = new QLabel( privateLayoutWidget, "labelComments" );
  labelComments->setText( "" );
  Layout1->addMultiCellWidget( labelComments, 3, 3, 0, 6 );


  Layout11->addLayout( Layout1 );



  QHBoxLayout* Layout10 = new QHBoxLayout( 0, 0, 6, "Layout10"); 

  GroupBox2 = new QGroupBox( privateLayoutWidget, "GroupBox2" );
  GroupBox2->setFrameShape( QGroupBox::Box );
  GroupBox2->setTitle( tr( "Use defaults for:" ) );

  PB_lev0 = new QPushButton( GroupBox2, "PB_lev0" );
  PB_lev0->setGeometry( QRect( 11, 21, 92, 24 ) ); 
  PB_lev0->setCursor( QCursor( 13 ) );
  PB_lev0->setText( tr( "&Prentice" ) );
  QWhatsThis::add( PB_lev0 , tr("click this button to copy preset "
				    "<U><B>easy</B></U> speed "
				    "goals for 2 and 7 namebuttons active to the fields above; you can then modify these "
				    "values"));

  PB_lev1 = new QPushButton( GroupBox2, "PB_lev1" );
  PB_lev1->setGeometry( QRect( 109, 21, 92, 24 ) ); 
  PB_lev1->setCursor( QCursor( 13 ) );
  PB_lev1->setText( tr( "&Journeyman" ) );
  QWhatsThis::add( PB_lev1 , tr("click this button to copy preset "
				    "<U><B>intermediate</B></U> speed "
				    "goals for 2 and 7 namebuttons active to the fields above; you can then modify these "
				    "values"));

  PB_lev2 = new QPushButton( GroupBox2, "PB_lev2" );
  PB_lev2->setGeometry( QRect( 207, 21, 92, 24 ) ); 
  PB_lev2->setCursor( QCursor( 13 ) );
  PB_lev2->setText( tr( "&Wizard" ) );
  QWhatsThis::add( PB_lev2 , tr("click this button to copy preset "
				    "<U><B>hard</B></U> speed "
				    "goals for 2 and 7 namebuttons active to the fields above; you can then modify these "
				    "values"));

  PB_lastCustom = new QPushButton( GroupBox2, "PB_lastCustom" );
  PB_lastCustom->setGeometry( QRect( 305, 21, 92, 24 ) ); 
  PB_lastCustom->setCursor( QCursor( 13 ) );
  PB_lastCustom->setText( tr( "&last custom" ) );
  QWhatsThis::add( PB_lastCustom , tr("click this button to restore last "
					  "custom speed goals set by you"));



  Layout10->addWidget( GroupBox2 );
  QVBoxLayout* Layout6 = new QVBoxLayout( 0, 0, 6, "Layout6"); 

  empty_label = new QLabel( privateLayoutWidget, "empty_label" );
  empty_label->setText( "" );
  Layout6->addWidget( empty_label );

  QHBoxLayout* Layout5 = new QHBoxLayout( 0, 0, 6, "Layout5"); 

  PB_what = new QPushButton( privateLayoutWidget, "PB_what" );
  PB_what->setPixmap(pmapForWhatsThisButton);
  QToolTip::add(PB_what,tr("What's this?"));
  Layout5->addWidget( PB_what ,0,Qt::AlignLeft);


  PB_ok = new QPushButton( privateLayoutWidget, "PB_ok" );
  PB_ok->setText( tr( "OK" ) );
  PB_ok->setDefault( TRUE );
  Layout5->addWidget( PB_ok );

  PB_cancel = new QPushButton( privateLayoutWidget, "PB_cancel" );
  PB_cancel->setText( tr( "Cancel" ) );
  Layout5->addWidget( PB_cancel );
  Layout6->addLayout( Layout5 );
  Layout10->addLayout( Layout6 );
  Layout11->addLayout( Layout10 );

  // signals and slots connections
  connect( PB_lev0, SIGNAL( clicked() ), this, SLOT( PB_lev0_clicked() ) );
  connect( PB_lev1, SIGNAL( clicked() ), this, SLOT( PB_lev1_clicked() ) );
  connect( PB_lev2, SIGNAL( clicked() ), this, SLOT( PB_lev2_clicked() ) );
  connect( PB_lastCustom, SIGNAL( clicked() ), this, SLOT( PB_lastCustom_clicked() ) );
  connect( PB_what, SIGNAL( clicked() ), this, SLOT( PB_what_clicked() ) );
  connect( PB_ok, SIGNAL( clicked() ), this, SLOT( PB_OK_clicked() ) );
  connect( PB_cancel, SIGNAL( clicked() ), this, SLOT( PB_cancel_clicked()));
  connect( SB_speed7, SIGNAL( valueChanged(int) ), this, 
	   SLOT( setupSpeeds36(int) ) );
  connect( SB_speed2, SIGNAL( valueChanged(int) ), this, 
	   SLOT( setupSpeeds36(int) ) );
  setupSpeeds36();
}

customLevel::~customLevel(){}

