/***************************************************************************
 ** $Id: KLNfancywidgets.h,v 1.1.1.1 2003/10/15 23:40:54 wiecko Exp $
                          klearnnotes2
                          KLNfancywidgets.h -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qaction.h>
#include <qpushbutton.h>
#include <qlcdnumber.h>

class QObject;
class QPixmap;
class QColor;

class actionWithIconSwitch:public QAction
// toggle action's icon does not change in menu; this class is a brutal remedy
{
  Q_OBJECT
    public:
  actionWithIconSwitch(QObject * parent, 
		       const char* pix0[],
		       const char* pix1[]);
  QPixmap getSmallPixmap(int iconSetNo);

 private:
  QIconSet* iconSet1 ;
  QIconSet* iconSet2 ;
  private slots:
    void iconswitch(bool state);
};


class fancyButton : public QPushButton
{// a button with a resetColor() slot
  Q_OBJECT
    public:
  fancyButton(QString tekst, QWidget* parent);
  ~fancyButton();
  
  public slots:
    void resetColor();
  void setColorTmp(QColor color, int time);
  void drawButton ( QPainter * );
 private:
  QColor defaultcolor;
  QColor framecolor;
  bool colorchanged;
};

class fancyQLCDNumber : public QLCDNumber
{
  Q_OBJECT
    public:
  fancyQLCDNumber( uint numDigits, QWidget * parent = 0,
		   const char * name = 0 ) ;
  ~fancyQLCDNumber();
  
  public slots:
    void setOK(bool isItOK=true);
 private:
  QColor color;
};
