/***************************************************************************
 ** $Id: KLNfancywidgets.cpp,v 1.1.1.1 2003/10/15 23:40:54 wiecko Exp $
                          klearnnotes2
                          KLNfancywidgets.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qobject.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qtimer.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qfont.h>

#include "KLNfancywidgets.h"

void debuginfo(QString tekst); // my debug function: 2B eventually deleted



// fancyButton and actionWithIconSwitch

fancyButton::fancyButton(QString tekst, QWidget* parent)
  :QPushButton(tekst, parent)
{
  defaultcolor=paletteForegroundColor();
  colorchanged=false;
}

fancyButton::~fancyButton() {};

void fancyButton::drawButton ( QPainter * p)
{
  if(colorchanged)
    setPaletteForegroundColor (framecolor);
  else
    setPaletteForegroundColor (defaultcolor);
  QPushButton::drawButton(p);
  if(colorchanged)
    {
      p->setPen( QPen( framecolor,3 ) );
      p->drawRoundRect(rect ());
    }
}

void fancyButton::setColorTmp(QColor color, int time)
{
  framecolor=color;
  colorchanged=true;
  QTimer::singleShot( time, this,SLOT(resetColor()));
  update();
}
  
void fancyButton::resetColor()
{
  colorchanged=false;
  update();
}
//////////////////////////////

fancyQLCDNumber::fancyQLCDNumber( uint numDigits, QWidget * parent,
				  const char * name ) 
  :QLCDNumber(numDigits, parent, name ) 
{
  color=QColor(0,0,0);
}
 
fancyQLCDNumber::~fancyQLCDNumber() {};
  
void fancyQLCDNumber::setOK(bool isItOK)  // isItOK=> green, !isItOK=>red
{
  QPalette qp(palette());
  if(isItOK)
    {
      qp.setColor(QPalette::Normal,QColorGroup::Light,QColor(0,180,0));
      qp.setColor(QPalette::Normal,QColorGroup::Midlight,QColor(0,150,0));
      //qp->setColor(QPalette::Normal,QColorGroup::Button,QColor(0,255,0));
      qp.setColor(QPalette::Normal,QColorGroup::Mid,QColor(0,120,0));
      qp.setColor(QPalette::Normal,QColorGroup::Dark,QColor(0,90,0));
      qp.setColor(QPalette::Normal,QColorGroup::Shadow,QColor(0,60,0));
    }else{
      qp.setColor(QPalette::Normal,QColorGroup::Light,QColor(180,0,0));
      qp.setColor(QPalette::Normal,QColorGroup::Midlight,QColor(150,0,0));
      //qp->setColor(QPalette::Normal,QColorGroup::Button,QColor(255,0,0));
      qp.setColor(QPalette::Normal,QColorGroup::Mid,QColor(120,0,0));
      qp.setColor(QPalette::Normal,QColorGroup::Dark,QColor(90,0,0));
      qp.setColor(QPalette::Normal,QColorGroup::Shadow,QColor(60,0,0));
    }
  setPalette(qp);
  update();
}

/////////////////////////////////


actionWithIconSwitch::actionWithIconSwitch(QObject * parent, 
					   const char* pix1[],
					   const char* pix2[])
  :QAction(parent,0,true)
{
  iconSet1=new QIconSet(pix1);
  iconSet2=new QIconSet(pix2);
  connect( this, SIGNAL(toggled(bool)), this, SLOT( iconswitch(bool)) );
}


void actionWithIconSwitch::iconswitch(bool state)
{
  if(state)
    setIconSet(*iconSet1);
  else
    setIconSet(*iconSet2);
}

QPixmap actionWithIconSwitch::getSmallPixmap(int iconSetNo)
{ // this will be used to get small pixmap from the action to 
  // a corresponding combobox
  QPixmap answ;
  if(iconSetNo==1)
    answ=iconSet1->pixmap(QIconSet::Small,QIconSet::Normal);
  else
    answ=iconSet2->pixmap(QIconSet::Small,QIconSet::Normal);
  return answ;
}
