/***************************************************************************
 ** $Id: KLNcanvasitems.h,v 1.3 2003/12/06 18:52:36 wiecko Exp $
                          klearnnotes2
                          KLNcanvasitem.h -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLNcanvasitems_H
#define KLNcanvasitems_H


#include <qcanvas.h>
#include "klearnnotes2.h"
#include "randomobject.h"

class KLearnNotes2;
class QPainter;

// clickableView, staffLine and aNote
class clickableView: public QCanvasView
{ // only redefined MousePressEvent; but is aware of KLearnNotes2::
  // this way a mouse click can e.g. change color of a note
  Q_OBJECT
    public:
  clickableView(QCanvas * cnvs, QWidget* parent, KLearnNotes2 * mainwidget);
  public slots:
    void contentsMousePressEvent ( QMouseEvent * );
 private:
  KLearnNotes2* papcio;
};








class staffLine : public QCanvasLine
{
 public:
  staffLine (QCanvas*,int ypos,int linetype);
  ~staffLine();

  void show();
  void hide();

  void setLonger();

 private:
  int type;   
  // 1=one of the 5 staff lines
  // 2= extra staff line above or below the five
  // 3= guideline

  int y; //y position of the line; ==endPoint().y() and ==startPoint().y()

  static bool longer;  // important only for lines of type 2:
  // if two adjacent notes are displayed they are shifted left-right; 
  // in this case extra lines should be longer
};






extern QPixmap* PIX_note_red;
extern QPixmap* PIX_note_green;
extern QPixmap* PIX_note_blue;
extern QPixmap* PIX_note_brown;
extern QPixmap* PIX_note_black;


class aNote : public QObject, public QCanvasEllipse, public  RandomObject
	      // a one note: its picture (ellipse), properties (name...),
	      // and statistics
{
  Q_OBJECT
    public:
  aNote(int zeroheight, QCanvas* mycanvas, int mynumber, 
	staffLine* la[], staffLine* lb[],QObject * parent,aNote* prevN);
  ~aNote();

  void moveit();
	
  void showNote(); // show this note and its lines
  void hideNote(); // hide this note and its lines
  void setColorTmp(char newcolor, int time=INTERVAL); // changes
  //                       notes color for 'time' milliseconds
  void setColor(char newcolor); // changes color permanently



  void setName(int newname);  
  // notes are identified by their POSITION in clef; 
  // for different clef the same note can have different name;
  // therefore, this has to be run whenever the clef changes;
  int getName();   //in (0,.....,6)
  char getCname(); //in (`H',....,'C')
 
  int getNum(); // position of the note in the clef; 
  // set only once when aNote is created;
  // in (-MAXabove,......,MAXall-MAXabove-1)
  
  void setPitch(int newpitch); // a sound the note will make;
  // has to be re-run whenever the clef changes
  int getPitch();
  void play();


  protected slots:
    void resetColor();
  void drawShape ( QPainter & p );

 protected:
  void move(double newx, double newy);
  void setCnameLetterColor(char newcolor);
  int textshift; // =0 if text on the right; =1 if text on the left
  int name;   // in (0,...,6)
  char cname; // in(`C'...'H')
  QCanvasText* cnameLetter;
  QCanvasRectangle* cnameLetterBG; // background for the letter
  int num;    // in (-MAXabove,......,MAXall-MAXabove-1)

  int noOfMyLines;
  staffLine* myLines[defMAXall];  //it's a little waste, but it's hard to
  // determine which of MAXabove and MAXbelow is greater 
  QCanvas* canv;
  aNote* previousNote;
  int pitch;

  char color;   // R, G, B, 0 (ZERO)        B=blue    0=black
  char resetcolor; // a permanent color to which resetColor() changes
};
#endif
