/***************************************************************************
 ** $Id: KLNcanvasitems.cpp,v 1.6 2003/12/06 18:52:36 wiecko Exp $
                          klearnnotes2
                          KLNcanvasitems.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "KLNcanvasitems.h"
#include <qtimer.h>
#include <qevent.h>
#include <qwmatrix.h> 
#include <qpainter.h> 
#include <qtranslator.h>


//////////// ********** aNOTE  *************

aNote::aNote (int zeroH, QCanvas* mycanvas, int mynumber, 
	      staffLine* la[], staffLine* lb[],
	      QObject* parent,aNote* prevN) 
  :  QObject(parent) , QCanvasEllipse ( 4*SC, 2*SC, mycanvas ),
     RandomObject()
{
  canv=mycanvas;
  num=mynumber;
  previousNote=prevN;

  //QCanvasEllipse setup:
  hide();
  color='0';
  resetcolor='0';

  QCanvasEllipse::move( 15*SC, ((num-1)*SC)+zeroH);
  // now this is fun: there has to be order of Z-s
  // each note is antialiased and fills all region between lines
  // it has to be over a line which crosses it in the middle,
  // but below line touched above (otherwise antialias prepared
  // for white background will look stupid on a black line);
  // therefore there has to be Z-order:
  // a line with smallest Z
  // then a note over this line (*)
  // then a note just above the line
  // then a line one step above
  // then the note over this line (*) and so on


  // OOPS, eventually I made smaller note-pictures so above remarks
  // DO NOT APPLY!; but I don't delete them, because it may be important
  // in the future


  int k = int(y()/double(SC)); //how many steps are we from tops of the canvas
  setZ(128-(2*k)+1);// +1 will put it over "it's" line but below
  //                   items higher at the stave

  noOfMyLines=0;
  //extra lines:
  if (num<0){ // we are above note G2
    noOfMyLines=(1-num)/2; //which hopefully is floored for an odd numerator
    for (int i =0 ; i<noOfMyLines; i++)
      myLines[i]=la[i];
  }
  if (num>10){ //we are below D
    noOfMyLines=(num-9)/2;
    for(int i = 0; i<noOfMyLines; i++)
      myLines[i]=lb[i];
  }

  cnameLetter=new QCanvasText(" ", mycanvas );
  cnameLetter->setFont( QFont( "Arial", int(1.5*SC), QFont::Bold ) );
  cnameLetter->setColor( QColor( 0, 0, 0 ) );
  cnameLetter->hide();
  cnameLetter->setZ(200);

  cnameLetterBG=new QCanvasRectangle(mycanvas);
  cnameLetterBG->setSize(cnameLetter->boundingRect().width()+2,
			 cnameLetter->boundingRect().height()-2);
  cnameLetterBG->setBrush(QBrush(QColor(255,255,255)));
  cnameLetterBG->setPen(QPen (QColor (255,255,255),0));
  cnameLetterBG->setZ(cnameLetter->z()-1);
  cnameLetterBG->hide();
  textshift=0;
  move(x(),y());// to update cnameLetter position
}

void aNote::move(double newx,double newy)
{
  // redefined just to move the cnameLetter too!
  QCanvasEllipse::move( newx,newy);  
  cnameLetter->move( newx+2.5*SC -7*SC*textshift,newy-SC+1);
  cnameLetterBG->move(cnameLetter->x()-1,cnameLetter->y()+1);
}


aNote::~aNote() {}

void aNote::setCnameLetterColor(char newcolor)
{
  switch (newcolor){
  case 'R':
    cnameLetter->setColor( QColor( 127, 0, 0 ) );
    break;
  case 'G':
    cnameLetter->setColor( QColor( 0, 127, 0 ) );
    break;
  case 'B':
    cnameLetter->setColor( QColor( 16, 34, 188 ) );
    break;
  case 'S':
    cnameLetter->setColor( QColor( 187,102, 0 ) );
    break;
  case '0':
    cnameLetter->setColor( QColor( 0, 0, 0 ) );
    break;
  }
}

void aNote::setColorTmp(char newcolor,int time)
{
  color=newcolor;
  setCnameLetterColor(newcolor);
  update();
  cnameLetter->show();
  cnameLetterBG->show();
  QTimer::singleShot( time, this, SLOT(resetColor()) );
  return;
}

void aNote::setColor(char newcolor)
{
  color=newcolor;
  setCnameLetterColor(newcolor);
  resetcolor=newcolor;
  update();
  return;
}


void aNote::resetColor()
{
  color=resetcolor;
  setCnameLetterColor(resetcolor);
  update();
  cnameLetter->hide();
  cnameLetterBG->hide();
  canv->update();
}

void aNote::showNote()
{
  show();
  if (previousNote->isVisible())
    {
      moveit();
      previousNote->moveit();
    }
  for (int i=0;i<noOfMyLines;i++)
    myLines[i]->show();
}


void aNote::hideNote()
{
  hide();
  for (int i=0;i<noOfMyLines;i++)
    {
      myLines[i]->hide();
    }
  textshift=0;
  move( 15*SC, y());//move it back
}

void aNote::setName(int newname)
{
  name=newname;
  cname=orderOfNotes[name];
  cnameLetter->setText(QString(QChar(cname)));
  cnameLetterBG->setSize(cnameLetter->boundingRect().width()+2,
			 cnameLetter->boundingRect().height()-3);
}

int  aNote::getName()	{return name;}
char aNote::getCname()	{return cname;}
int  aNote::getNum()	{return num;}

void aNote::moveit()
{
  if(noOfMyLines>0)
    myLines[0]->setLonger(); // all extra lines longer
  if(num%2)
    {
      textshift=1;
      move( 13.25*float(SC), y());
    }
  else
    move( 16.75*float(SC), y());
}


void aNote::setPitch(int newpitch)
{
  pitch=newpitch;
}

int aNote::getPitch() {return pitch;}

void aNote::play(){ midi_addANote2chord(pitch);}//addAnote checks if device is open

void aNote::drawShape ( QPainter & p )
{
  switch (color){
  case 'R':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_red);
    break;
  case 'G':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_green);
    break;
  case 'B':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_blue);
    break;
  case 'S':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_brown);
    break;
  case '0':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_black);
    break;
  }
}


//////////////////////////////////

bool staffLine::longer = false;


staffLine::staffLine (QCanvas* can,int ypos,int linetype)
  :QCanvasLine(can)// , QObject(can)
{
  y=ypos;
  type=linetype;
  setPen( QPen( black, 1 ) );
  int k =int(y/double(SC)); //how many steps are we from tops of the canvas
  setZ(128-(2*k));// without +1 this will put it under "it's" note

  switch (type)
    {
    case 1: // one of 5 staff lines
      setPoints( 2*SC, y, 33*SC, y);
      break;
    case 2: // one of the extra lines above or below
      setPoints( 10*SC, y, 20*SC, y);
      break;
    case 3: // guidelines
      setPoints( 30*SC, y, 33*SC, y);
    }

}
staffLine::~staffLine(){}

void staffLine::show()
{
  if (type==2) // extra lines above/below may need resizing:
    if(longer)
      setPoints( 10*SC, y, 20*SC, y);
    else
      setPoints( 12*SC, y, 18*SC, y);
  QCanvasLine::show();
}

void staffLine::hide()
{
  QCanvasLine::hide();
  longer=false;
}

void staffLine::setLonger(){longer=true;} // ==there are some adjacent notes


///////////////////////////////////

clickableView::clickableView(QCanvas* cnvs,QWidget* prnt, KLearnNotes2* prog)
  :QCanvasView(cnvs,prnt)
{
  papcio=prog;
}

void clickableView::contentsMousePressEvent ( QMouseEvent * e)
{
  QPoint p = inverseWorldMatrix().map(e->pos());
  QCanvasItemList l=canvas()->collisions(p);
  for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it) {
    if ( (*it)->rtti() == QCanvasItem::Rtti_Ellipse ){
      aNote *noti= (aNote*)(*it);
      noti->setColorTmp('B');
      QCanvasView::canvas()->update();
      noti->play();
      midi_playChord();
      if(!(papcio->isStarted()))
	{
	  papcio->PBchangeColorTmp(noti->getName());//changes button color
	}
      return;
    }
  }
}
