#!/bin/sh
if [ ! -f index.cache.bz2 ] ; then
	echo making new index.cache.bz2 ...
	/usr/bin/meinproc --check --cache index.cache.bz2 ./index.docbook
#	/opt/kde/bin/meinproc --check --cache index.cache.bz2 ./index.docbook
else
	if [ index.cache.bz2  -ot index.docbook ] ; then
		echo making newer index.cache.bz2 ...
		/usr/bin/meinproc --check --cache index.cache.bz2 ./index.docbook
#		/opt/kde/bin/meinproc --check --cache index.cache.bz2 ./index.docbook
	fi
fi

if [ ! -e dtd ] ; then
	echo linking dtd/kdex.dtd directory ...
	kdexfile=`locate dtd/kdex.dtd|head -1`
	export kdexfile
	dn=`dirname $kdexfile`
	if [ ! -z $dn ] ; then ln -s $dn ; fi
fi

dirname=`pwd`

cd ../HTML
if [ -e $dirname/dtd ]; then
	if [  ! -f klearnnotes2.html  -o  klearnnotes2.html -ot $dirname/index.docbook  ] ; then
		echo making html files ...
		rm -f *.html
		docbook2html $dirname/index.docbook
		cp book1.html klearnnotes2.html

		echo making Makefile.am

		echo KDE_DOCS = klearnnotes2 			>Makefile.am
		echo KDE_LANG = en 				>>Makefile.am
		echo "data_DATA = \\" 				>>Makefile.am
		files=`ls *.html`
		num=0;
		for afile in $files ; do
                        num=$(($num+1))
                done
		num2=0;
		for afile in $files ; do
			num2=$(($num2+1));
			if [ $num2 -eq $num ] ; then ending="" ; else ending=" \\" ; fi
			echo "    "$afile$ending		>>Makefile.am
		done
		echo 'datadir = $(kde_htmldir)/en/klearnnotes2' >>Makefile.am
		echo 'EXTRA_DIST = $(data_DATA)' 		>>Makefile.am
		echo Remember to update quickstartfile.h !
	fi
fi

