/***************************************************************************
 ** $Id: midi_setup.h,v 1.2 2003/10/13 09:38:23 marek Exp $
                          klearnnotes2
                          midi_setup.h -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIDI_SETUP_H
#define MIDI_SETUP_H

#include <qvariant.h>
#include <qdialog.h>
#include <qpixmap.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QLabel;
class QPushButton;
class QSpinBox;

class MIDI_setup : public QDialog
{ 
  Q_OBJECT

    public:
  MIDI_setup(QPixmap pmapForWhatsThisButton, QWidget* parent = 0,
	     const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~MIDI_setup();

  QSpinBox* SpinBox2; // midi device
  QSpinBox* SpinBox6; // num of channels
  QSpinBox* SpinBox3; // note length
  QSpinBox* SpinBox4; // midi patch
  QSpinBox* SpinBox5; // octave bias

  public slots:
    virtual void PB_guitar_clicked();
  virtual void PB_nonguitar_clicked();
  virtual void PB_OK_clicked();
  virtual void PB_cancel_clicked();
  virtual void SB_device_changed( int newDevice );
  virtual void SB_channels_changed(int newChan);
  //    virtual void SB_volume_changed( int );
  virtual void SB_notelength_changed( int newLength);
  virtual void SB_midi_patch_changed( int newPatch);
  virtual void SB_octave_changed( int newBias);
  virtual void PB_test_clicked();
  virtual void PB_what_clicked();

 protected:
  QGridLayout* MIDI_setupLayout;

 private:
  QLabel* TextLabel1;
  QLabel* TextLabel2;
  QLabel* TextLabel10;
  QLabel* TextLabel4;
  QLabel* TextLabel5;
  QLabel* TextLabel6;
  QLabel* TextLabel7;
  QLabel* TextLabel9;

  QPushButton* PushButton1; // "Test"
  QPushButton* PushButton6; // What is
  QPushButton* PushButton2; // guitar defaults
  QPushButton* PushButton3; // non-guitar defaults
  QPushButton* PushButton4; // OK
  QPushButton* PushButton5; // Cancel

  // values saved in case sb. cancels
  int olddevice;
  int oldchan;
  //  int oldvolume;
  int oldlength;
  int oldpatch;
  int oldoctave;
};

#endif // MIDI_SETUP_H
