/***************************************************************************
 ** $Id: midi.cpp,v 1.2 2003/10/13 09:38:23 marek Exp $
                          klearnnotes2
                          midi.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// standard code from <linux/soundcard.h>
int midifd = -1;
SEQ_DEFINEBUF(1024);
void seqbuf_dump()
{
  if (_seqbufptr)
    write (midifd, _seqbuf, _seqbufptr);
  _seqbufptr = 0;
}
// std.code - END

#define maxNotesInAChord 40 
//                       ^ this size should be >= no. of channels
int notesToPlay[maxNotesInAChord]; // notes in one chord;
int noOfNotesToPlay;

int midiMaxChan=defMIDIchan; // channel modulus

int midiCurrentDevice=defMIDIdevNum;
//int midiCurrentVolume=defMIDIvol; // HOW TO IMPLEMENT VOLUME???????
int midiNoteLength=defNOTElength;
int midiPatch=defMIDIpatch;




void midi_addANote2chord(int note)  // this only adds a note to notesToPlay
{
  if(midifd==-1)//device is NOT opened
    return;
  notesToPlay[noOfNotesToPlay]=note;
  noOfNotesToPlay=(noOfNotesToPlay+1)%maxNotesInAChord;
}

void midi_playChord() // ... and this plays them all
{
  if((noOfNotesToPlay>0)&&midiIsOn())
    {
      int mypid; // FORK FORK FORK 
      if ((mypid=fork())==0)
	{  
	  int newVel=60;
	  int midiCurrentChannel=0;
	  for(int i=0;i<noOfNotesToPlay;i++)
	    {
	      SEQ_START_NOTE(midiCurrentDevice, midiCurrentChannel,
			     notesToPlay[i], newVel);
	      midiCurrentChannel=(midiCurrentChannel+1)%midiMaxChan;
	      // notes are added to different channels
	    }
	  SEQ_DELTA_TIME(midiNoteLength);
	  seqbuf_dump();        
	  ioctl(midifd, SNDCTL_SEQ_SYNC);
	  midiCurrentChannel=0;
	  for(int i=0;i<noOfNotesToPlay;i++)
	    {
	      SEQ_STOP_NOTE(midiCurrentDevice, midiCurrentChannel,
			    notesToPlay[i], 64);
	      // Uses 0x80, true MIDI note-off 
	      midiCurrentChannel=(midiCurrentChannel+1)%midiMaxChan;
	    }
	  seqbuf_dump();
	  ioctl(midifd, SNDCTL_SEQ_SYNC);
	  _exit(0);  // EXIT CHILD PROCESS AFTER PLAYING A CHORD
	}
    }
  noOfNotesToPlay=0;
}


void midi_setupPatches()
{
  for(int i =0; i< midiMaxChan; i++)
    SEQ_SET_PATCH(midiCurrentDevice,i,midiPatch);
}

bool midi_turnOn()
{
  if (midiIsOn()) 
    return true;
  if ((midifd = open(MIDI_DEV, O_WRONLY)) == -1)
    return false;     //  Can't open MIDI device

  //  MIDI device is open:
  SEQ_START_TIMER();
  SEQ_SET_TEMPO(100);
  midi_setupPatches();
  return true;
}

void midi_turnOff()
{
  close(midifd);
  midifd=-1;
}

bool midiIsOn()
{
  if(midifd==-1)
    return false;
  return true;
}
