/***************************************************************************
 ** $Id: main.cpp,v 1.2 2003/10/13 09:38:23 marek Exp $
                          klearnnotes2
                          main.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/


/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>


#include "klearnnotes2.h"  // this includes kln-defs.h (SC!)

static const char *shortdescription =
I18N_NOOP("KLearnNotes2: Learn notes' names fast!");
static const char *description =
I18N_NOOP("Includes wise learning algorithm. \n"
	  "Treble and Bass lclefs\n"
	  "Convenient notes-to-learn selection");

KAboutData aboutData( "klearnnotes2", I18N_NOOP("KLearnNotes2"),
		      VERSION, shortdescription, KAboutData::License_GPL,
		      "(c) 2003, Marek Wieckowski", description, 0, 
		      "wiecko AT users.sourceforge.net");	

int SC;

static KCmdLineOptions options[] = 
  {
    { "scale <scale>", I18N_NOOP("scale for graphical objects;  default: 10 "
				 ),"defSC"},
    { 0, 0, 0 } // End of options.
  };


int main(int argc, char *argv[])
{
  aboutData.addAuthor("Marek Wieckowski",0, 
		      "wiecko AT users.sourceforge.net");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );
  KApplication a;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  QString QSargSC = args->getOption("scale");
  bool ok;
  SC=QSargSC.toInt(&ok,10);
  if ((SC<1)||(!ok)) SC=defSC;

  args->clear();

  KLearnNotes2 *klearnnotes2 = new KLearnNotes2();
  a.setMainWidget(klearnnotes2);
  klearnnotes2->show();  
  
  return a.exec();
}
