/***************************************************************************
 ** $Id: klearnnotes2.cpp,v 1.7 2003/10/13 20:02:54 marek Exp $
                          klearnnotes2
                          klearnnotes2.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**************************************************************************
 * 
 * a general idea, names of some functions/slots (checkanswer/redraw)
 * and the way notes/lines are numbered comes from 
 * 
 *          Dominik Seichter's       klearnnotes
 *
 ***************************************************************************/



#include <kaboutapplication.h>
#include <kaboutdata.h>
#include <kapp.h>
#include <klocale.h>
#include <khelpmenu.h>

#include <qstring.h>
#include <qtimer.h>
#include <qevent.h> 	// keyboard handlers
#include <ctype.h> 	//tolower etc.

// extra info displayed:
#include <qlayout.h> 
#include <qpushbutton.h>
#include <qlabel.h> 
#include <qlcdnumber.h>
#include <qslider.h> 
#include <qcombobox.h>
#include <qcheckbox.h> 
#include <qimage.h>
#include <qpainter.h>

// for helpbox: delete once proper help is done
#include <qmessagebox.h> 

#include <qpixmap.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qhbox.h> 
#include <qstatusbar.h>
#include <qinputdialog.h>
#include <qspinbox.h>
#include <qdir.h> 
#include <qregexp.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qdatastream.h>


#include "klearnnotes2.h"
#include "midi.cpp"
#include "pics.h"
#include "midi_setup.h"
#include "customlevel.h"
#include "helpwindow.h"
#include "KLNcanvasitems.h"
#include "KLNfancywidgets.h"

#include "imageitem.h"
#include "quickstartfile.h" //def. of QUICKstartFILE

int OCTAVEbias=defOCTAVEbias;
char orderOfNotes[8]="HAGFEDC"; // if one uses English notation
// 'H' will be replaced by 'B' in KLN creator
// + one can change it in menu Options


extern KAboutData aboutData;


static uint mainCount = 0;
static QImage *clefImageTreble;
static QImage *clefImageBass;
QPixmap* PIX_note_red;
QPixmap* PIX_note_green;
QPixmap* PIX_note_blue;
QPixmap* PIX_note_black;


double scalefactor; // some things (like clef pictures) are prepared for 
//                     SC==10; if this is not true, they have to be scaled


KLearnNotes2::KLearnNotes2( QWidget* parent,  const char* name, WFlags fl )
  : QMainWindow( parent, name, fl )
{

  mainCount++; // used by the destructor; things should be deleted only when
  //              last forked copy of KLN is destroyed; REALLY??????????

  setCaption( i18n( "KLearnNotes2" ) );

  // now we check if the values of defMAXabove,defMAXbelow
  // and defnoOFlinesAB_BE are consistent
  numLinesABOVE = floor(double((defMAXabove+1))/double(2));
  if (numLinesABOVE == defNOofLINESabove) { //CONSISTENT
    numNotesABOVE=defMAXabove;
  } else { //                                INCONSISTENT
    if (numLinesABOVE>defNOofLINESabove) {  //keep defNoLa, lower defMAXnotes
      numLinesABOVE=defNOofLINESabove;
      numNotesABOVE=1+(2*numLinesABOVE);    // (*)
    } else {//                               keep defMAXnotes, lower defNoLa
      numNotesABOVE=defMAXabove;
    }
  }
  // defNOofLINESabove is used as an array index in kln2.h; the compiler
  // should bail out if it was set negative;
  // therefore (*) will always be positive;
  // for negative defMAXabove numLinesABOVE would be <0 and above code
  // would keep the negative value of numLinesABOVE and numNotesABOVE
  if (numNotesABOVE<0)
    {
      numNotesABOVE=0;
      numLinesABOVE=0;// which IS consistent - no need to bail out here
    }

  numNotesALL=defMAXall;
  if (numNotesALL<(10+numNotesABOVE)) // there is even no room for
    //          the notes of the main 5 lines + those above the staff
    {
      printerror(" inconsistent settings in klearnnotes2.h :\n"
		 "           * too small value of defMAXall");
      // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      exit(1); // BAILING OUT!!!!!!!!!!!!!!!!!!!!!!!!
      // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    }
  numLinesBELOW = floor((double(numNotesALL - numNotesABOVE -10)+0.01)
			/double(2));
  // 0.01 just to prevent flooring 0^- to -1
  if (numLinesBELOW==defNOofLINESbelow) //        CONSISTENT
    {
      // all set as above
    }else{ //                                    INCONSISTENT
      if(numLinesBELOW>defNOofLINESbelow) //keep defNoLb, ignore defMAXall
	{
	  numLinesBELOW=defNOofLINESbelow;
	  numNotesALL=2*numLinesBELOW+numNotesABOVE+10
	    +((2*numLinesBELOW+numNotesABOVE+10)%2);
	}else{//                            keep defMAXall, ignore defNoLb
	  // all set as above
	}
    }
  // the only inconsistency could come from defNOofLINESbelow<0, but this
  // would define negative-size array in kln2.h and kill compilation anyway


  // variables which rule the world:
  restoring=false;

  // START OF WIDGET POSITIONING/SETUP
  posOfTopLine=(numNotesABOVE+5)*SC;

  statbar=new QStatusBar(this);
  setCentralWidget( new QWidget( this, "qt_central_widget" ) );

  QWidget * cw;
  cw=centralWidget ();
  // setup h-v
  QBoxLayout * LAYmain = new QHBoxLayout( cw );
  LAYmain->setMargin(2*SC);
  LAYmain->setSpacing(3*SC);
  QBoxLayout * LAYmainLEFT = new QVBoxLayout( LAYmain );
  LAYmainLEFT->setSpacing(SC);
  QBoxLayout * LAYmainRIGHT = new QVBoxLayout( LAYmain );
  LAYmainRIGHT->setSpacing(SC);

  // NOTE: comments in () refer to a command above the comment:

  // setup of the ****LEFT**** row:
  QBoxLayout * LAYleft10 = new QHBoxLayout( LAYmainLEFT );
  QBoxLayout * LAYleft1 = new QHBoxLayout( LAYleft10 );
  // (there will be drawarea and range in it)
  LAYleft10->addSpacing(SC);
  LAYleft1->setSpacing(0);
  QBoxLayout * LAYleft2 = new QHBoxLayout( LAYmainLEFT );
  // (a row with CDEFGAH buttons and their enablers)
  QBoxLayout * LAYbut[8];
  for (int i =0; i<8; i++)
    {
      LAYbut[i] = new QVBoxLayout( LAYleft2 );
      LAYbut[i]->setSpacing(0);
    }


  // setup of the ****RIGHT**** row:


  QBoxLayout * LAYright3 = new QVBoxLayout( LAYmainRIGHT );
  // (labelComments + label question # of #)
  QBoxLayout * LAYright4 = new QHBoxLayout( LAYmainRIGHT );
  // ("RESULTS")
  QGridLayout* resultsDisplay= new QGridLayout( LAYmainRIGHT);
  // (OK)  // (WRO)  // (LCD_speed)  // (goal)


  // now the widgets come
  // **************** LEFT WIDGETS:
  c = new QCanvas( 34*SC, (10+numNotesALL)*SC );
  drawArea = new clickableView( c, cw ,this);
  drawArea->setVScrollBarMode(QScrollView::AlwaysOff);
  drawArea->setHScrollBarMode(QScrollView::AlwaysOff);
  drawArea->setFixedWidth(32*SC);
  drawArea->setFixedHeight((10+numNotesALL)*SC);
  QWhatsThis::add( drawArea, 
		   trUtf8("<B><U>Staff:</U></B><UL>"
			  "<LI>at TEST : you will see here one note which is "
			  "a question: choose it's name from the active "
			  "<EM>namebuttons</EM> below the <EM>staff</EM>"
			  "<LI>at STOP : you will see here all "
			  "<EM>testnotes</EM>; click a note in the "
			  "<EM>staff</EM> to see it's <EM>namebutton</EM>"
			  " highlighted </UL>"));
  QToolTip::add(drawArea,trUtf8("the staff"));
  LAYleft1->addWidget(drawArea);
  c->setDoubleBuffering(true);

  // and 2 sliders for min/max active range
  minmax1 = new QSlider( -numNotesABOVE, numNotesALL - numNotesABOVE -1, 1, 
			 -numNotesABOVE, Qt::Vertical,cw );
  minmax1->setTickmarks(QSlider::Both);
  minmax1->setFixedHeight( (numNotesALL-1)*SC+16);
  minmax2 = new QSlider( -numNotesABOVE, numNotesALL - numNotesABOVE -1, 1, 
			 numNotesALL-numNotesABOVE-1, Qt::Vertical,cw );
  minmax2->setTickmarks(QSlider::Both);
  minmax2->setFixedHeight( (numNotesALL-1)*SC+16);
  QWhatsThis::add(minmax1 , 
		  trUtf8("<B><U>Range sliders</U></B> :<BR>"
			 "choose range of <EM>testnotes</EM> <BR>"
			 "hint: choose Exercise 40 and play for a moment with "
			 "the <EM>range sliders</EM> to get an idea how they "
			 "work"));
  QToolTip::add( minmax1,trUtf8("Range slider 1"));
  QWhatsThis::add(minmax2,
		  trUtf8("<B><U>Range sliders</U></B> :<BR>"
			 "choose range of <EM>testnotes</EM> <BR>"
			 "hint: choose Exercise 40 and play for a moment with "
			 "the <EM>range sliders</EM> to get an idea how they "
			 "work"));
  QToolTip::add( minmax2,trUtf8("Range slider 2"));

  QBoxLayout * LAYscr = new QVBoxLayout( LAYleft1 );  
  LAYscr->addSpacing(posOfTopLine-(numNotesABOVE+1)*SC-8);
  LAYscr->addWidget(minmax1);
  LAYscr->addSpacing(7*SC-8);
  LAYscr = new QVBoxLayout( LAYleft1 );  
  LAYscr->addSpacing(posOfTopLine-(numNotesABOVE+1)*SC-8);
  LAYscr->addWidget(minmax2);
  LAYscr->addSpacing(7*SC-8);

  for (int i =0; i<7; i++)
    {
      namePBs[i] = new fancyButton( QString(QChar(orderOfNotes[i])), cw );
      QFont qf(namePBs[i]->font());
      qf.setBold(true);
      qf.setStyleHint(QFont::SansSerif,QFont::StyleStrategy(
							    QFont::PreferAntialias|QFont::PreferQuality));
      qf.setPointSize(4 * SC);
      namePBs[i]->setFont(qf);
      namePBs[i]->setFixedWidth(5*SC);
      namePBs[i]->setFixedHeight(5*SC);
      nameCHKs[i] = new QCheckBox(cw);
      LAYbut[i]->addWidget(namePBs[i]);
      LAYbut[i]->addWidget(nameCHKs[i],0,Qt::AlignHCenter);
      QWhatsThis::add(namePBs[i], 
		      trUtf8("<U><B>namebutton</B></U><UL>"
			     "<LI>at TEST : use it to give an answer - the "
			     "name of a displayed note "
			     "<LI>at STOP : click to highlight in the "
			     "<EM>staff</EM> all testnotes with the name "
			     "shown on the <EM>namebutton</EM></UL>"));
      QToolTip::add( namePBs[i],trUtf8(QString("namebutton ")+QChar(orderOfNotes[i])));
      QWhatsThis::add(nameCHKs[i], 
		      trUtf8("<U><B>name checkbox</B></U> :<BR>choose which "
			     "notes should be <EM>testnotes</EM><BR>"
			     "hint: choose Exercise 40, press a "
			     "<EM>namebutton</EM> (to see which notes it "
			     "corresponds to) and then a <EM>name "
			     "checkbox</EM> below it; play for a moment "
			     "with these <EM>checkboxes</EM> to get an idea "
			     "how they work"));
      QToolTip::add( nameCHKs[i],trUtf8(QString("name checkbox ")+QChar(orderOfNotes[i])));
    }

  
  // **************** RIGHT WIDGETS:

  labelComments=new QLabel(QString(" \n "),cw);
  QFont boldFont(labelComments->font());
  boldFont.setBold(true);
  labelComments->setFont(boldFont);
  labelQueNum  = new QLabel(" ",cw) ;
  LAYright3->addWidget(labelComments,10,Qt::AlignTop);
  // this should take up all the space
  LAYscr = new QHBoxLayout( LAYright3 ); 
  LAYscr->addWidget(labelQueNum);
  LCD_queTime=new QLCDNumber(4,cw,"quet");
  LCD_queTime->display(0);
  QToolTip::add( LCD_queTime,trUtf8("time spent on last question"));
  LAYscr->addWidget(LCD_queTime);

  QLabel* labi = new QLabel("YOUR RESULTS",cw) ;
  labi->setFont(boldFont);
  LAYright4->addWidget(labi, 0, Qt::AlignCenter);


  labi = new QLabel("correct",cw);
  LCD_numOK=new QLCDNumber(3,cw,"lcd1");
  LCD_numOK->display(0);
  LCD_numOK->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_numOK,trUtf8("number of right answers in this/last test"));
  QWhatsThis::add(LCD_numOK,trUtf8("number of right answers in this/last test"));
  resultsDisplay->addWidget(labi,0,0);
  resultsDisplay->addWidget(LCD_numOK,0,1);
  
  labi = new QLabel("wrong",cw);
  LCD_numWR=new QLCDNumber(3,cw,"lcd2");
  LCD_numWR->display(0);
  LCD_numWR->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_numWR,trUtf8("number of wrong answers in this/last test"));
  QWhatsThis::add( LCD_numWR,trUtf8("number of wrong answers in this/last test"));
  resultsDisplay->addWidget(labi,1,0);
  resultsDisplay->addWidget(LCD_numWR,1,1);
  bgcolor=LCD_numWR->paletteBackgroundColor();
  
  labi = new QLabel("speed",cw);
  LCD_speed=new fancyQLCDNumber(3,cw,"lcd3");
  LCD_speed->display(0);
  LCD_speed->setSegmentStyle(QLCDNumber::Flat);
  //  LCD_speed->setColor(QColor(0,0,0));
  QToolTip::add( LCD_speed,trUtf8("your speed in this/last test"));
  QWhatsThis::add(LCD_speed, 
		  trUtf8("your overall answering <B><U>speed</U></B>"
			 "<UL><LI>if it is below your <EM>speed goal</EM> "
			 " it will have <RED>red</RED> frame"
			 "<LI> if it is above your <EM>speed goal</EM>"
			 " it will have <GREEN>green</GREEN> frame</UL>"));
  resultsDisplay->addWidget(labi,2,0);
  resultsDisplay->addWidget(LCD_speed,2,1);
  labi = new QLabel("answ/(10 min)",cw);
  resultsDisplay->addWidget(labi,2,2);


  labi = new QLabel("your goal",cw);
  LCD_yourGoal= new QLCDNumber(3,cw,"yrG");
  LCD_yourGoal->display(defSPEEDgoal02);
  LCD_yourGoal->setSegmentStyle(QLCDNumber::Flat);
  QToolTip::add( LCD_yourGoal,trUtf8("your speed goal"));
  QWhatsThis::add( LCD_yourGoal, 
		   trUtf8("your <B><U>speed goal</U></B> :<BR>"
			  " it depends on the level you choose and number of"
			  " active <EM>namebuttons</EM>"));
  resultsDisplay->addWidget(labi,3,0);
  resultsDisplay->addWidget(LCD_yourGoal,3,1);
  labi = new QLabel("answ/(10 min)",cw);
  resultsDisplay->addWidget(labi,3,2);



  // ********END OF CENTRAL WIDGET SETUP

  // actions
  a_mH_KHelp = new QAction( this, "a_mH_KHelp" );
  a_mH_KHelp->setText( trUtf8( "KDE Help for KLearnNotes2"));
  a_mH_KHelp->setMenuText( trUtf8( "&KDE Help for KLearnNotes2" ) );
  a_mH_KHelp->setAccel( Key_F1 );
  a_mH_about_doesntwork = new QAction( this, "a_mH_about_doesntwork" );
  a_mH_about_doesntwork->setText( trUtf8( "What's in this menu?" ) );
  a_mH_about_doesntwork->setMenuText( trUtf8( "WHAT'S IN THIS MENU..." ) );
  a_mH_about_doesntwork->setAccel( 0 );
  a_mH_quickStart = new QAction( this, "a_mH_quickStart" );
  a_mH_quickStart->setText( trUtf8( "Quick Start" ) );
  a_mH_quickStart->setMenuText( trUtf8( "Quick &Start..." ) );
  a_mH_quickStart->setAccel( 0 );
  a_mH_index = new QAction( this, "a_mH_index" );
  a_mH_index->setText( trUtf8( "Help index" ) );
  a_mH_index->setMenuText( trUtf8( "&Help index..." ) );
  a_mH_index->setAccel( 0 );
  a_mH_about = new QAction( this, "a_mH_about" );
  a_mH_about->setText( trUtf8( "About" ) );
  a_mH_about->setMenuText( trUtf8( "&About..." ) );
  a_mH_about->setAccel( 0 );

  mp_Cleves_grp = new QActionGroup( this );
  mp_Cleves_grp->setExclusive( TRUE );
  a_mp_SetClefTreble= new actionWithIconSwitch(mp_Cleves_grp,
					       (const char**) clefT_icon_xpm,
					       (const char**) empty_xpm);
  a_mp_SetClefTreble->setText( trUtf8( "choose treble clef" ) );
  a_mp_SetClefTreble->setMenuText( trUtf8( "&Treble clef" ) );
  a_mp_SetClefTreble->setAccel( 0 );
  a_mp_SetClefTreble->setToggleAction(true);
  a_mp_SetClefTreble->setOn(true);
  a_mp_SetClefBass= new actionWithIconSwitch(mp_Cleves_grp,
					     (const char**) clefB_icon_xpm,
					     (const char**) empty_xpm);
  a_mp_SetClefBass->setText( trUtf8( "choose bass clef" ) );
  a_mp_SetClefBass->setMenuText( trUtf8( "&Bass clef" ) );
  a_mp_SetClefBass->setAccel( 0 );
  a_mp_SetClefBass->setToggleAction(true);



  aStartStop=new QAction(this,"");
  aStartStop->setText("start");
  aStartStop->setMenuText("&Start");
  aStartStop->setAccel( ALT+Key_S );
  a_mp_Quit= new QAction( this, "" );
  a_mp_Quit->setText( trUtf8( "quit" ) );;
  a_mp_Quit->setMenuText( trUtf8( "&Quit" ) );
  a_mp_Quit->setAccel( ALT+Key_Q );


  mo_Levels_grp = new QActionGroup( this );
  mo_Levels_grp->setExclusive( TRUE );
  a_mo_setLevel[0]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) level_0_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[0]->setText( trUtf8( "speed goal: easy" ) );
  a_mo_setLevel[0]->setMenuText( trUtf8( "&Prentice" ) );
  a_mo_setLevel[0]->setAccel( 0 );
  a_mo_setLevel[0]->setToggleAction(true);
  a_mo_setLevel[0]->setOn(true);
  a_mo_setLevel[1]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) level_1_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[1]->setText( trUtf8( "speed goal: intermediate" ) );
  a_mo_setLevel[1]->setMenuText( trUtf8( "&Journeyman" ) );
  a_mo_setLevel[1]->setAccel( 0 );
  a_mo_setLevel[1]->setToggleAction(true);
  a_mo_setLevel[1]->setOn(false);
  a_mo_setLevel[2]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) level_2_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[2]->setText( trUtf8( "speed goal: hard" ) );
  a_mo_setLevel[2]->setMenuText( trUtf8( "&Wizard" ) );
  a_mo_setLevel[2]->setAccel( 0 );
  a_mo_setLevel[2]->setToggleAction(true);
  a_mo_setLevel[2]->setOn(false);
  a_mo_setLevel[3]= new actionWithIconSwitch(mo_Levels_grp,
					     (const char**) empty_xpm,
					     (const char**) empty_xpm);
  a_mo_setLevel[3]->setText( trUtf8( "speed goal: custom" ) );
  a_mo_setLevel[3]->setMenuText( trUtf8( "custom..." ) );
  a_mo_setLevel[3]->setAccel( 0 );
  a_mo_setLevel[3]->setToggleAction(true);
  a_mo_setLevel[3]->setOn(false);




  a_mo_setNotationGE= new actionWithIconSwitch(this,
					       ( const char** ) notationH_xpm,
					       ( const char** ) notationB_xpm);
  a_mo_setNotationGE->setText( trUtf8( "change to English notation "
				       "'H'->'B'" ) );
  a_mo_setNotationGE->setMenuText(trUtf8("German n&otation "
					 "(GA-H-CD)"));
  a_mo_setNotationGE->setAccel( 0 );

  // just to get a screenshot with these pictures/labels:
  //   QBoxLayout * LAYrightTMP = new QHBoxLayout( LAYmainRIGHT );
  //   labi=new QLabel("",cw);
  //   labi->setPixmap(a_mo_setNotationGE->getSmallPixmap(1));
  //   LAYrightTMP->addWidget(labi);
  //   labi=new QLabel("German notation (GA-H-CD)",cw);
  //   LAYrightTMP->addWidget(labi,10,Qt::AlignLeft);
  //   LAYrightTMP = new QHBoxLayout( LAYmainRIGHT );
  //   labi=new QLabel("",cw);
  //   labi->setPixmap(a_mo_setNotationGE->getSmallPixmap(0));
  //   LAYrightTMP->addWidget(labi);
  //   labi=new QLabel("English notation (GA-B-CD)",cw);
  //   LAYrightTMP->addWidget(labi,10,Qt::AlignLeft);



  a_mo_setTestLength= new QAction( this, "" );
  a_mo_setTestLength->setText( trUtf8( "set no. of questions in one test" ) );
  a_mo_setTestLength->setMenuText( trUtf8( "&Test length..." ) );
  a_mo_setTestLength->setAccel( 0 );
  a_mo_soundOnOff= new actionWithIconSwitch(this,
					    ( const char** ) sound_on_xpm,
					    ( const char** ) sound_off_xpm);
  a_mo_soundOnOff->setText( trUtf8( "turn midi on/off" ) );
  a_mo_soundOnOff->setMenuText( trUtf8( "Soun&d : on/off" ) );
  a_mo_soundOnOff->setAccel( 0 );
  a_mo_soundOnOff->setOn(true);
  a_mo_soundOnOff->setToolTip(trUtf8("turn sound on/off"));
  a_mo_soundSetup= new QAction( this, "" );
  a_mo_soundSetup->setText( trUtf8( "setup midi" ) );
  a_mo_soundSetup->setMenuText( trUtf8( "Sound setup..." ) );
  a_mo_soundSetup->setAccel( 0 );
  a_mo_save=new QAction(this,"");
  a_mo_save->setText( trUtf8( "save options" ) );
  a_mo_save->setMenuText( trUtf8( "Save options" ) );
  a_mo_save->setAccel( 0 );
  a_mo_load=new QAction(this,"");
  a_mo_load->setText( trUtf8( "restore options" ) );
  a_mo_load->setMenuText( trUtf8( "Restore options" ) );
  a_mo_load->setAccel( 0 );


  // toolbars
  toolBar = new QToolBar( "", this, DockTop ); 

  toolBar->setLabel( trUtf8( "Tools" ) );


  labi = new QLabel("&E:",toolBar) ;
  CB_exercise = new QComboBox( FALSE, toolBar);
  CB_exercise->setFixedWidth(280);
  labi->setBuddy(CB_exercise);
  QWhatsThis::add(CB_exercise, 
		  trUtf8("<B><U>choose Exercise</B></U> from the list;<BR>"
			 "this chooses a predefined set of"
			 " <EM>testnotes</EM>"));
  QToolTip::add( CB_exercise,trUtf8("choose Exercise"));
  aNextExercise=new QAction("Next exercise",QPixmap( (const char**)next_xpm ),
			    "Next &exercise", ALT+Key_N, this, "exercise++" );
  aNextExercise->addTo(toolBar);
  aNextExercise->setToolTip(trUtf8("next Exercise"));


  labi = new QLabel("&C:",toolBar) ;
  CB_clef = new QComboBox( FALSE, toolBar );
  CB_clef->insertItem(a_mp_SetClefTreble->getSmallPixmap(1),
		      "" );
  CB_clef->insertItem(a_mp_SetClefBass->getSmallPixmap(1),
		      "" );
  QToolTip::add( CB_clef,trUtf8("choose Clef: bass or treble"));
  labi->setBuddy(CB_clef);


  labi = new QLabel("&L:",toolBar) ;
  CB_level = new QComboBox( FALSE, toolBar );
  CB_level->insertItem(a_mo_setLevel[0]->getSmallPixmap(1),
		       a_mo_setLevel[0]->menuText().replace( QRegExp("&"), "" ));
  CB_level->insertItem(a_mo_setLevel[1]->getSmallPixmap(1),
		       a_mo_setLevel[1]->menuText().replace( QRegExp("&"), "" ));
  CB_level->insertItem(a_mo_setLevel[2]->getSmallPixmap(1),
		       a_mo_setLevel[2]->menuText().replace( QRegExp("&"), "" ));
  CB_level->insertItem(a_mo_setLevel[3]->getSmallPixmap(1),
		       a_mo_setLevel[3]->menuText().replace( QRegExp("&"), "" ));
  labi->setBuddy(CB_level);
  QToolTip::add( CB_level,trUtf8("choose Level: this affects "
				 "your <EM>speed goal</EM>"));
  lastLevel=0;

  SB_testLength = new QSpinBox(40,200,1,toolBar);
  SB_testLength->setValue(defTESTlength);
  QToolTip::add( SB_testLength,trUtf8("change test length (number of questions)"));

  bStartStop = new QPushButton( "&Start", toolBar );
  // note there is also action aStartStop (for menu); but I want a button
  // with TEXT and it's hard to get from Action
  QToolTip::add( bStartStop,trUtf8("Start a test"));

  a_mo_soundOnOff->addTo(toolBar);

  tbWhat=QWhatsThis::whatsThisButton(toolBar);


  // menubar
  menubar = new QMenuBar( this, "menubar" );

  MenuPractice = new QPopupMenu( this ); 
  aNextExercise->addTo(MenuPractice);
  mp_Cleves_menu = new QPopupMenu(this);
  mp_Cleves_menu->insertTearOffHandle();

  a_mp_SetClefTreble->addTo(mp_Cleves_menu);
  a_mp_SetClefBass->addTo(mp_Cleves_menu);
  MenuPractice->insertItem("Choose clef",mp_Cleves_menu);
  aStartStop->addTo(MenuPractice);
  MenuPractice->insertSeparator();
  a_mp_Quit->addTo(MenuPractice);
  menubar->insertItem( trUtf8( "&Practice" ), MenuPractice );

  MenuOptions = new QPopupMenu( this ); 
  a_mo_setTestLength->addTo(MenuOptions);
  mo_Levels_menu = new QPopupMenu(this);
  mo_Levels_menu->insertTearOffHandle();
  a_mo_setLevel[0]->addTo(mo_Levels_menu);
  a_mo_setLevel[1]->addTo(mo_Levels_menu);
  a_mo_setLevel[2]->addTo(mo_Levels_menu);
  a_mo_setLevel[3]->addTo(mo_Levels_menu);
  MenuOptions->insertItem("Choose level",mo_Levels_menu);
  a_mo_setNotationGE->addTo(MenuOptions);
  MenuOptions->insertSeparator();
  a_mo_soundOnOff->addTo(MenuOptions);
  a_mo_soundSetup->addTo(MenuOptions);
  menubar->insertItem( trUtf8( "&Options" ), MenuOptions );
  MenuOptions->insertSeparator();
  a_mo_save->addTo(MenuOptions);
  a_mo_load->addTo(MenuOptions);

  MenuHelp = new QPopupMenu( this ); 
  a_mH_KHelp->addTo(MenuHelp);
  mH_doesntwork_menu=new QPopupMenu(this);
  a_mH_about_doesntwork->addTo(mH_doesntwork_menu);
  a_mH_index->addTo(mH_doesntwork_menu);
  a_mH_quickStart->addTo(mH_doesntwork_menu);
  if(QFile::exists("/usr/share/doc/HTML/en/klearnnotes2/klearnnotes2.html"))
    MenuHelp->insertItem("If KDE help doesn't work",mH_doesntwork_menu);
  MenuHelp->insertSeparator();
  a_mH_about->addTo( MenuHelp );
  menubar->insertItem( trUtf8( "&Help" ), MenuHelp );

  MenuHelpK=new KHelpMenu(this);


  // SIGNALS   <--->   SLOTS

  connect( namePBs[0], SIGNAL(clicked()), this, SLOT( noteH() ));
  connect( namePBs[1], SIGNAL(clicked()), this, SLOT( noteA() ));
  connect( namePBs[2], SIGNAL(clicked()), this, SLOT( noteG() ));
  connect( namePBs[3], SIGNAL(clicked()), this, SLOT( noteF() ));
  connect( namePBs[4], SIGNAL(clicked()), this, SLOT( noteE() ));
  connect( namePBs[5], SIGNAL(clicked()), this, SLOT( noteD() ));
  connect( namePBs[6], SIGNAL(clicked()), this, SLOT( noteC() ));
  connect( a_mH_about,SIGNAL(activated()),this,SLOT(mH_about_activated()));
  connect( a_mH_KHelp,SIGNAL(activated()),MenuHelpK,SLOT(appHelpActivated ()));

  connect( a_mH_about_doesntwork,SIGNAL(activated()),this,
	   SLOT(mH_doesntWork_about_activated ()));
  connect( a_mH_index,SIGNAL(activated()),this,
	   SLOT(mH_doesntWork_index_activated ()));
  connect( a_mH_quickStart,SIGNAL(activated()),this,
	   SLOT(mH_doesntWork_quickStart_activated()));

  connect( aStartStop, SIGNAL(activated()), this, SLOT( startstop()) );
  connect( bStartStop, SIGNAL(clicked()), this, SLOT( startstop()) );
  connect( aNextExercise, SIGNAL(activated()), this, SLOT( nextExercise()) );
  connect(a_mo_setNotationGE,SIGNAL(toggled(bool)),this,SLOT(setGermanHNotation(bool)));
  connect( a_mo_soundOnOff,SIGNAL(toggled(bool)),this,SLOT(turnSoundOnOff(bool)));
  connect( a_mo_setTestLength, SIGNAL(activated()), this,
	   SLOT(dialogMaxQue()));
  connect( a_mo_soundSetup,SIGNAL(activated()),this,
	   SLOT(dialogSetupMidi()));
  connect( a_mo_save,SIGNAL(activated()),this,
	   SLOT(saveOptions()));
  connect( a_mo_load,SIGNAL(activated()),this,
	   SLOT(loadOptions()));

  turnSoundOnOff(true);

  connect(minmax1,SIGNAL(valueChanged( int)),this,
	  SLOT(activeNotesChangedManual( int)));
  connect(minmax2,SIGNAL(valueChanged(int)),this,
	  SLOT(activeNotesChangedManual(int)));
  for(int i=0;i<7;i++)
    {
      connect(nameCHKs[i],SIGNAL(stateChanged(int)),this,
	      SLOT(activeNotesChangedManual(int)));
    }
  connect(CB_exercise,SIGNAL(activated(int)),this,
	  SLOT(activeNotesChangedByExercise(int)));
  connect(CB_clef,SIGNAL(activated(int)),this,SLOT(setClef(int)));
  connect(CB_level,SIGNAL(activated(int)),this,SLOT(setLevelByCombo(int)));
  connect(mo_Levels_grp,SIGNAL(selected(QAction*)),this,
	  SLOT(setLevelByAction(QAction*)));
  connect(a_mo_setLevel[3],SIGNAL(activated ()),this,
	  SLOT(a_mo_setLevelCustom_activated()));
  connect(SB_testLength,SIGNAL(valueChanged(int)),this,SLOT(setTestLength(int)));
  connect(a_mp_SetClefTreble,SIGNAL(toggled ( bool )),this,
	  SLOT(setClefTreble(bool)));
  connect( a_mp_Quit,SIGNAL(activated()),this,SLOT(endKLearnNotes2()) );
  connect( qApp, SIGNAL(lastWindowClosed()),this, SLOT(endKLearnNotes2()) );
  // 'cause closing by windows' titlebar widgets should run endKLearnNotes2 too
  

  clocky = new QTimer (this);
  timespent=0;
  connect( clocky, SIGNAL(timeout()), this, SLOT( growtime() ));
   
  
  // EXTRA SETUP OF THINGS ******IN CANVAS*****

  // ****** LINES:

  staffLine* line;
  // NOTE: 0 is on the TOP !
  for( int i = 0; i < 5; i++ ) {
    line = new staffLine( c,posOfTopLine+2*SC*i,1 );
    line->show();
  }
  // lines above the five are shorter:
  for( int i = -numLinesABOVE; i < 0; i++ ) {
    line = new staffLine( c, posOfTopLine+2*SC*i,2 );
    line->hide();
    linesabove[-1-i]=line ;
    // note, that these lines are counted in order reverse to 
    // notes enumeration; i.e. line A1 is [0], C2 is [1] etc.

    //+ we draw also short lines to guide the choice of range of notes:
    line = new staffLine( c, posOfTopLine+2*SC*i,3);
    line->show();
    guidelines[-i-1]=line; // this fills guidelines[0...(#liAB-1)]
  }
  // so are those below:
  for( int i = 5; i < 5+numLinesBELOW; i++ ) {
    line = new staffLine( c,posOfTopLine+2*SC*i,2 );
    line->hide();
    linesbelow[i-5]=line;

    line = new staffLine( c,posOfTopLine+2*SC*i,3 );
    line->show();
    guidelines[numLinesABOVE+i-5]=line; // this fills guidelines[#liAB...(
    //  #liAB+#liBE -1)]
  }


  // ****** CLEVES:

  clefImageTreble=0;
  clefImageBass=0;

  scalefactor=double(SC)/double(10);
  QImage* clefImageTreble[2];
  clefImageTreble[0]=new QImage(clefT_xpm);
  clefImageTreble[1]=new QImage(clefImageTreble[0]->smoothScale(int(clefImageTreble[0]->width()
								    *scalefactor),
								int(clefImageTreble[0]->height()
								    *scalefactor)));
  clefItem[0] = new ImageItem(*clefImageTreble[1],c);
  clefItem[0]->move(2*SC,posOfTopLine-(26*scalefactor));
  clefItem[0]->setZ(-2000);//under lines

  QImage* clefImageBass [2];
  clefImageBass[0]=  new QImage(clefB_xpm);
  clefImageBass[1]=new QImage(clefImageBass[0]->smoothScale(int(clefImageBass[0]->width()
								*scalefactor),
							    int(clefImageBass[0]->height()
								*scalefactor)));
  clefItem[1] = new ImageItem(*clefImageBass[1],c);
  clefItem[1]->move(2*SC,posOfTopLine-(26*scalefactor));
  clefItem[1]->setZ(-2000);//under lines

  // ******* and NOTES:

  //RED
  QImage* IMG_note_red [2];
  IMG_note_red[1]= new QImage(noteRED_xpm);
  IMG_note_red[0]=new QImage(IMG_note_red[1]->smoothScale(int(IMG_note_red[1]->width()
							      *scalefactor),
							  int(IMG_note_red[1]->height()
							      *scalefactor)));
  PIX_note_red=new QPixmap();
  PIX_note_red->convertFromImage(*IMG_note_red[0], OrderedAlphaDither);
  delete IMG_note_red[0];
  delete IMG_note_red[1];
  //GREEN
  QImage* IMG_note_green [2];
  IMG_note_green[1] = new QImage(noteGRE_xpm);
  IMG_note_green[0]=new QImage(IMG_note_green[1]->smoothScale(int(IMG_note_green[1]->width()
								  *scalefactor),
							      int(IMG_note_green[1]->height()
								  *scalefactor)));
  PIX_note_green=new QPixmap();
  PIX_note_green->convertFromImage(*IMG_note_green[0], OrderedAlphaDither);
  delete IMG_note_green[0];
  delete IMG_note_green[1];
  //BLUE
  QImage* IMG_note_blue[2];
  IMG_note_blue[1] = new QImage(noteBLU_xpm);
  IMG_note_blue[0]=new QImage(IMG_note_blue[1]->smoothScale(int(IMG_note_blue[1]->width()
								*scalefactor),
							    int(IMG_note_blue[1]->height()
								*scalefactor)));
  PIX_note_blue=new QPixmap();
  PIX_note_blue->convertFromImage(*IMG_note_blue[0], OrderedAlphaDither);
  delete IMG_note_blue[0];
  delete IMG_note_blue[1];
  //BLACK
  QImage* IMG_note_black [2];
  IMG_note_black[1] = new QImage(noteBLA_xpm);
  IMG_note_black[0]=new QImage(IMG_note_black[1]->smoothScale(int(IMG_note_black[1]->width()
								  *scalefactor),
							      int(IMG_note_black[1]->height()
								  *scalefactor)));
  PIX_note_black=new QPixmap();
  PIX_note_black->convertFromImage(*IMG_note_black[0], OrderedAlphaDither);
  delete IMG_note_black[0];
  delete IMG_note_black[1];



  nullNote=new aNote(posOfTopLine, c, -numNotesABOVE,
		     linesabove, linesbelow,cw,0);
  nullNote->hide(); // and not hideNote 'cause it shouldn't touch lines

  aNote* tmpNote=nullNote;
  for(int i = 0; i<numNotesALL; i++)
    {
      allNotes[i]=new aNote(posOfTopLine, c, i-numNotesABOVE,
			    linesabove, linesbelow,cw,tmpNote);
      tmpNote=allNotes[i];
    }
  // allNotes[] can have indexes from 0 to numNotesALL-1
  // we will always call it by allNotes[num+numNotesABOVE]
  // therefore 'num' can change 
  //     from      -numNotesABOVE         meaning the top note
  //     through   0             meaning the note just above the top of 
  //                             the 5 standard lines (G in the treble clef)
  //     through   10            meaning the note just below the lowest of
  //                             the 5 standard lines (D in the treble clef)
  //     to        numNotesALL-numNotesABOVE-1


  // Now, all graphics is set (except from inserting exercises into 'exercise')
  // we start setting up initial values

  autochange=false;

  setupExercises();//setClef setups notes' names and may in future run setupExercises
  CB_exercise->setCurrentItem(0);
  setClef(0);   // but until then I call setupExercises() manually here

  CB_exercise->setCurrentItem(1);
  activeNotesChangedByExercise(1);

  testLength=defTESTlength;
  if(toupper(defHname)=='H')
    {
      setGermanHNotation(true);
      a_mo_setNotationGE->setOn(true);
    }else{
      setGermanHNotation(false);
      a_mo_setNotationGE->setOn(false);
    }
  customSpeedGoal2=0;
  customSpeedGoal7=0; //this means, when custom level will be selected for
  //                    the first time, cSG's will be copied dep. on level
  //                    at this moment
  loadOptions();
}

KLearnNotes2::~KLearnNotes2()
{
  saveOptions(); // I don't know why this doesn't work in the destructor.
  midi_turnOff();
  if ( !--mainCount ) {
    delete[] clefImageTreble;
    clefImageTreble = 0;
    delete[] clefImageBass;
    clefImageBass = 0;
    for (int i =0; i<numNotesALL;i++)
      delete allNotes[i];
    delete c;
    delete PIX_note_red;
    delete PIX_note_green;
    delete PIX_note_blue;
    delete PIX_note_black;
  }
}



void KLearnNotes2::checkanswer(char ans)
{// if question is asked checks if answer is right and asks another
  // if we are idle shows all active notes of this kind
  if(clocky->isActive()==false)
    { // either "Stop" position or multiple answers
      if (aStartStop->text()=="start") // we are at Stop
	{
	  int tmpBN=-1;//tmp: name of the note played
	  for(int i =0; i<numActiveNotes;i++)
	    if(activeNotes[i]->getCname()==ans)
	      {
		activeNotes[i]->setColorTmp('B');
		//i.e. show all notes with the clicked name
		activeNotes[i]->play();
		tmpBN=activeNotes[i]->getName();
	      }
	  c->update();
	  if(tmpBN>-1)
	    {
	      namePBs[tmpBN]->setColorTmp(defNiceBlue,INTERVAL);
	    }
	}
      midi_playChord();
      return;
    }

  // we are at Start position
  // there is a question asked and we should check the answer
  clocky->stop();
  char rightanswer = note->getCname() ;
  if ( ans ==  rightanswer ) {
    note->setColorTmp('G');
    t = new QCanvasText( QString( i18n("%1 is correct") 
				  ).arg(QString(QChar(ans))) , c );
    t->setFont( QFont( "Arial", int((1.5)*SC), QFont::Bold ) );
    t->setColor( QColor( 0, 255, 0 ) );
    t->move( (32*SC-t->boundingRect().width())/2, (numNotesALL+6)*SC );
    LCD_numOK->display(LCD_numOK->intValue()+1);
    note->addCorrect(onetime);
  } else {
    note->setColorTmp('R');
    t = new QCanvasText( QString( i18n("Wrong! Correct would be: %1") 
				  ).arg(QString(QChar(rightanswer))), c );
    t->setFont( QFont( "Arial", int((1.5)*SC), QFont::Bold ) );
    t->setColor( QColor( 255, 0, 0 ) );
    t->move( (32*SC-t->boundingRect().width())/2, (numNotesALL+6)*SC );
    LCD_numWR->display(LCD_numWR->intValue()+1);
    LCD_numWR->setPaletteBackgroundColor(QColor(255,0,0));
    note->addWrong(onetime);

    // scheduling up2 3 same questions:
    int prop=2;//the first after 2 questions from now
    while((!(suggestion[(quenum+prop)%defMAXseria]==nullNote))&&(prop<defMAXseria))
      prop++;//but if sth. else is scheduled for `now+2' we schedule
    //for next available free slot
    if (prop<defMAXseria) //did `until' broke NOT because excess of defMAXseria?
      // if yes, it found a free slot
      {
	suggestion[(quenum+prop)%defMAXseria]=note;
	prop+=3;
	while((!(suggestion[(quenum+prop)%defMAXseria]==nullNote))&&(prop<defMAXseria))
	  prop++;
	if (prop<defMAXseria)
	  {
	    suggestion[(quenum+prop)%defMAXseria]=note;
	    prop+=3;
	    while((!(suggestion[(quenum+prop)%defMAXseria]==nullNote))&&(prop<defMAXseria))
	      prop++;
	    if (prop<defMAXseria)
	      suggestion[(quenum+prop)%defMAXseria]=note;
	  }
      }
#ifdef _KLN_SHOW_SCHEDULE
    debuginfo("DONE UPDATING SCHEDULE TABLE; it is now:");
    debugShowSuggestions(quenum);
#endif
  }
  t->show();
  c->update();

  for(int i = 0; i < 7; i++ )
    namePBs[i]->setEnabled( false );

  QTimer::singleShot( INTERVAL, this, SLOT(redraw()) );
} // well, one could sleep(INTERVAL) instead;
// the advantage of singleShot is that user can e.g. close the window
// or press 'stop' while the answer is displayed

bool KLearnNotes2::isStarted()
{ 
  if (aStartStop->text()=="stop")
    return true;
  return false;
}
  


bool KLearnNotes2::noteNameIsActive(char letter)
{
  for(int i=0;i<7;i++)
    if((namePBs[i]->text().latin1()[0]==letter)&&(nameCHKs[i]->isChecked()))
      return true;
  return false;
}


void KLearnNotes2::setupActiveNotes()
{
  for(int i=0;i<numNotesALL;i++)
    {
      allNotes[i]->hideNote();
    }
  numActiveNotes=0;
  for(int i = -numNotesABOVE; i< numNotesALL-numNotesABOVE;i++)
    {
      if (((i-minmax1->value()) *(i-minmax2->value()))<= 0)
	{
	  if (nameCHKs[allNotes[i+numNotesABOVE]->getName()]->isChecked())
	    {
	      activeNotes[numActiveNotes]=allNotes[i+numNotesABOVE];
	      activeNotes[numActiveNotes]->showNote();
	      // now, there is a problem: if a note is displayed while another
	      // is near new lines are displayed longer; but those already
	      // displayed do not change; thus a loop below ($%$%$%)
	      numActiveNotes++;
	    }
	}
    }

  // it would be enough to do 
  // for(int i=0;i<numActiveNotes; i++) activeNotes[i]->showNote(); //($%$%$%)
  // but it's a terrible waste: it re-shows some lines multiple times, moves
  // some notes few times (with no resulting change) etc.
  // therefore:
  for(int i=0;i<numLinesABOVE;i++) 
    if (linesabove[i]->isVisible())
      linesabove[i]->show(); // :)))) ; but the size can be new
  for(int i=0;i<numLinesABOVE;i++) 
    if(linesbelow[i]->isVisible())
      linesbelow[i]->show();
  setupSpeedGoal();
}




void KLearnNotes2::setupExercises()
{
  // I will keep the same names for exercises on the treble and
  // bass clefs, but "region" means sth different: these regions
  // are different for treble and bass - they are adjusted to get
  // most important notes in

  // but if desirable one *could* insert here:
  // * remove all items
  // * if clef->currentItem()==0 => insert exercises for treble
  // * if clef->currentItem()==1 => insert exercises for bass
  // and run it whenever clef changes;
  // this is why I extracted setupExercises() as a separate slot, 
  // rather then inserting it in the constructor for KLN::KLN()

  CB_exercise->insertItem( "*** custom ***" );
  CB_exercise->insertItem( "01: C and G in the main region" );
  CB_exercise->insertItem( "02: C and D in the main region" );
  CB_exercise->insertItem( "03: H and C in the main region" );
  CB_exercise->insertItem( "04: H C D in the main region" );
  CB_exercise->insertItem( "05: C and G in the main region (repeat.)" );
  CB_exercise->insertItem( "06: G and A in the main region" );
  CB_exercise->insertItem( "07: F and G in the main region" );
  CB_exercise->insertItem( "08: F G A in the main region" );
  CB_exercise->insertItem( "09: C E G in the main region" );
  CB_exercise->insertItem( "10: all notes in the main region" );

  CB_exercise->insertItem( "11: C and G in the upper region" );
  CB_exercise->insertItem( "12: C and D in the upper region" );
  CB_exercise->insertItem( "13: H and C in the upper region" );
  CB_exercise->insertItem( "14: H C D in the upper region" );
  CB_exercise->insertItem( "15: C and G in the upper region (repeat.)" );
  CB_exercise->insertItem( "16: G and A in the upper region" );
  CB_exercise->insertItem( "17: F and G in the upper region" );
  CB_exercise->insertItem( "18: F G A in the upper region" );
  CB_exercise->insertItem( "19: C E G in the upper region" );
  CB_exercise->insertItem( "20: all notes in the upper region" );

  CB_exercise->insertItem( "21: C and G in the lower region" );
  CB_exercise->insertItem( "22: C and D in the lower region" );
  CB_exercise->insertItem( "23: H and C in the lower region" );
  CB_exercise->insertItem( "24: H C D in the lower region" );
  CB_exercise->insertItem( "25: C and G in the lower region (repeat.)" );
  CB_exercise->insertItem( "26: G and A in the lower region" );
  CB_exercise->insertItem( "27: F and G in the lower region" );
  CB_exercise->insertItem( "28: F G A in the lower region" );
  CB_exercise->insertItem( "29: C E G in the lower region" );
  CB_exercise->insertItem( "30: all notes in the lower region" );


  CB_exercise->insertItem( "31: C and G" );
  CB_exercise->insertItem( "32: C and D" );
  CB_exercise->insertItem( "33: H and C" );
  CB_exercise->insertItem( "34: H C D" );
  CB_exercise->insertItem( "35: C and G (repeat.)" );
  CB_exercise->insertItem( "36: G and A" );
  CB_exercise->insertItem( "37: F and G" );
  CB_exercise->insertItem( "38: F G A" );
  CB_exercise->insertItem( "39: C E G" );
  CB_exercise->insertItem( "40: all notes" );

}

bool KLearnNotes2::dialogCustom_show()
{
  if( restoring) return true; // this new setting is loaded; but it still
  //                             should be in future considered a source
  //                             for dialogCustom
  customLevel* customdialog;
  QPixmap tmpPixmap=tbWhat->iconSet().pixmap(QIconSet::Small,
					     QIconSet::Normal);
  if((customSpeedGoal2==0)&&(customSpeedGoal7==0))
    // there was no custom so far; as starting point we choose lastLevel's
    // data
    customdialog=new customLevel(tmpPixmap,this,speed2(lastLevel),
				 speed7(lastLevel));
  else
    // there was a custom before; as starting point we choose customs
    customdialog=new customLevel(tmpPixmap,this,
				 customSpeedGoal2,customSpeedGoal7,
				 customSpeedGoal2,customSpeedGoal7);
  if(customdialog->exec() !=QDialog::Accepted )
    {// Cancel: fall back to previous level!
      a_mo_setLevel[lastLevel]->setOn(true);// changing action changes level!
      return false; // let's hope this does NOT loop forever if user cancels
      //               all the time :(
    }else{ //OK
      customSpeedGoal2=(customdialog->SB_speed2)->value();
      customSpeedGoal7=(customdialog->SB_speed7)->value();
      if(customSpeedGoal2==speed2(0) && customSpeedGoal7==speed7(0) )
	{
	  a_mo_setLevel[0]->setOn(true);  // changing action changes level!
	  return (lastLevel!=0);
	}
      if(customSpeedGoal2==speed2(1) && customSpeedGoal7==speed7(1) )
	{
	  a_mo_setLevel[1]->setOn(true);  // changing action changes level!
	  return (lastLevel!=1);
	}
      if(customSpeedGoal2==speed2(2) && customSpeedGoal7==speed7(2) )
	{
	  a_mo_setLevel[2]->setOn(true);  // changing action changes level!
	  return (lastLevel!=2);
	}
    }
  delete customdialog;
    
  return true;
}

int KLearnNotes2::speed2(int level)
{
  switch(level)
    {
    case 0:
      return defSPEEDgoal02;
    case 1:
      return defSPEEDgoal12;
    case 2:
      return defSPEEDgoal22;
    case 3:
      return customSpeedGoal2;
    }
  return -1;
}

int KLearnNotes2::speed7(int level)
{
  switch(level)
    {
    case 0:
      return defSPEEDgoal07;
    case 1:
      return defSPEEDgoal17;
    case 2:
      return defSPEEDgoal27;
    case 3:
      return customSpeedGoal7;
    }
  return -1;
}

void KLearnNotes2::setupSpeedGoal()
{
  // let's hope numActiveNotes is set right (=>>>>> check it!)
  double nba=0;
  for(int i=0;i<7;i++)
    if(nameCHKs[i]->isChecked()) nba++;
  if (nba>0)
    {
      int sp2=speed2(CB_level->currentItem());
      int sp7=speed7(CB_level->currentItem());
      nba=((sp7-sp2)*nba+7*sp2-2*sp7)/5;
      LCD_yourGoal->display(nba);
    }
}



#ifdef _KLN_SHOW_SCHEDULE
void KLearnNotes2::debugShowSuggestions(int activequenum)
  // default -1
{
  // debug: show what's scheduled
  QString deb=QString("defMAXseria=%1 noOfTestnotes=%2 \n"
		      "scheduled notes: \n"
		      ).arg(defMAXseria).arg(numActiveNotes);
  for(int i=0;i<defMAXseria;i++)
    {
      deb+=" (";
      if (suggestion[i]==nullNote)
	deb+="  X,";
      else
	for(int j=0;j<numNotesALL;j++)
	  if (suggestion[i]==allNotes[j])
	    {
	      if(j<10) deb+=" ";
	      deb+=QString("%1%2,").arg(QChar(allNotes[j]->getCname())).arg(j);
	    }
      if((activequenum>0)&&(activequenum%defMAXseria == i))
	deb+="*)";
      else 
	deb+=" )";
      if(i%10==9) deb+="\n";
    }
  debuginfo(deb);
}
#endif //_KLN_SHOW_SCHEDULE

void KLearnNotes2::PBchangeColorTmp(int buttonNo,int time)
  //                default: time=INTERVAL
{
  namePBs[buttonNo]->setColorTmp(defNiceBlue,time);
}




//================== UI


struct loadSet{
  // a structure used to load/save data in ~/.klearnnotes2
  //==== MIDI:
  bool midi_open; //was it opened?
  int midi_device;
  int midi_numChannels;
  int midi_volume;// for future, so that user's ~/.klearnnotes wouldn't have to change 
  int midi_noteLength;
  int midi_patch;
  int midi_octaveBias;
  //==============
  bool H_nameMode;
  int testLength;
  int level;
  int speedGoal2; // custom speed goal for 2 namebuttons active
  int speedGoal7; // custom speed goal for 7 namebuttons active

  //======= EXERCISE clef, etc
  int clef;
  int exercise;
  int notesRange1;
  int notesRange2;
  bool nameIsActive0;
  bool nameIsActive1;
  bool nameIsActive2;
  bool nameIsActive3;
  bool nameIsActive4;
  bool nameIsActive5;
  bool nameIsActive6;
};




void KLearnNotes2::endKLearnNotes2()
{
  saveOptions(); // I don't know why this doesn't work in the destructor.
  midi_turnOff();
  kapp->quit();
}

void KLearnNotes2::resetLabelCommentsGo() {labelComments->setText("GO!");}

void KLearnNotes2::resetLabelComments()   {labelComments->setText("");}


void KLearnNotes2::startstop()
{
  if (aStartStop->text()=="start")
    {
      setupActiveNotes();
      if (numActiveNotes<2)
	{
	  labelComments->setText("There are less then 2 notes active;\ncheck more notes or wider region to start!");
	  QTimer::singleShot( 5*INTERVAL, this, SLOT(resetLabelComments()) );
	  return;
	}

      QToolTip::setGloballyEnabled(false);
      // hide guidelines
      for (int i=0; i<(numLinesABOVE+numLinesBELOW); i++)
	guidelines[i]->hide();

      for (int i=0;i<numActiveNotes;i++)
	{
	  activeNotes[i]->hideNote();	//'cause setupAN sets them visible
	  activeNotes[i]->resetStats();
	}
      for(int i=0;i<numNotesALL;i++)
	allNotes[i]->setColor('0');

      LCD_numWR->display(0);
      LCD_numWR->setPaletteBackgroundColor(bgcolor);
      LCD_numOK->display(0);
      LCD_speed->display(0);
      timespent=0;


      for(int i=0;i<7;i++)
	nameCHKs[i]->setEnabled(false);
      minmax1->setEnabled(false);
      minmax2->setEnabled(false);
      CB_exercise->setEnabled(false);
      CB_clef->setEnabled(false);
      a_mp_SetClefTreble->setEnabled(false);
      a_mp_SetClefBass->setEnabled(false);
      aNextExercise->setEnabled(false);
      bStartStop->setText("&Stop");
      aStartStop->setText("stop");
      aStartStop->setMenuText("&Stop");


      for (int i=0;i<defMAXseria;i++)
	suggestion[i]=nullNote;
      // force-scheduling of first run of questions:
      int tmp[defMAXall]; // test it!
      int whichone;
      for(int i =0;i<numActiveNotes;i++) tmp[i]=i;
      for(int i =0;i<numActiveNotes;i++)
	{
	  whichone=KApplication::random() % (numActiveNotes-i);
	  suggestion[i+1]=activeNotes[tmp[whichone]];
	  // i+1 because it will be called sug[queNum],and queNum starts from 1
	  for(int j=whichone;j<numActiveNotes-i-1;j++)
	    tmp[j]=tmp[j+1];
	}

      quenum=0;
      note=nullNote;
      bStartStop->setFocus (); // if focus is in the spinbox keyboard input
      //                          would not work
      labelComments->setText(" READY.... 3... 2... 1...");
      update();
      QTimer::singleShot( 2*INTERVAL, this, SLOT( resetLabelCommentsGo()) );
      QTimer::singleShot( 3*INTERVAL, this, SLOT( resetLabelComments()) );
      QTimer::singleShot( 2*INTERVAL, this, SLOT( nextNote()) );
      bStartStop->setEnabled(false); // otherwise everything gets crazy
      aStartStop->setEnabled(false); // if user clicks it during 5*interval
      //                                pauses
    }else{  //"Stop" pressed
      clocky->stop();
      QToolTip::setGloballyEnabled(true);
      note->hideNote();
      if(LCD_numWR->value()>0)
	{
	  if(LCD_speed->value()<LCD_yourGoal->intValue() || LCD_numWR->value()>1)
	    labelComments->setText("Answer slower. but try to make\n"
				   "less mistakes! :(\n"
				   "Keep practicing at this exercise.");
	  else
	    labelComments->setText("One mistake may be acceptable for\n"
				   "a while, but pay special attention\n"
				   "to the red note! \n"
				   "Consider changing exercise.");
	  for(int i=0;i<numActiveNotes;i++)
	    if(activeNotes[i]->getWrong()>0)
	      activeNotes[i]->setColor('R');
	    else
	      activeNotes[i]->setColor('0');
	}
      else
	if(LCD_speed->value()>LCD_yourGoal->intValue())
	  {
	    labelComments->setText("Great! Try next exercise. :)");
	    CB_exercise->setFocus ();
	  }
        else
	  {
	    labelComments->setText("Keep practicing at this exercise.");
	    bStartStop->setFocus();
	  }
      QTimer::singleShot( 15*INTERVAL, this, SLOT(resetLabelComments()) );
      for (int i=0; i<(numLinesABOVE+numLinesBELOW); i++)
	guidelines[i]->show();
      for(int i=0;i<7;i++)
	nameCHKs[i]->setEnabled(true);
      minmax1->setEnabled(true);
      minmax2->setEnabled(true);
      CB_exercise->setEnabled(true);
      CB_clef->setEnabled(true);
      a_mp_SetClefTreble->setEnabled(true);
      a_mp_SetClefBass->setEnabled(true);
      aNextExercise->setEnabled(true);
      bStartStop->setText("&Start");
      aStartStop->setText("start");
      aStartStop->setMenuText("&Start");
      setupActiveNotes(); //to show what's active
      c->update();
    }
}

void KLearnNotes2::nextNote()
{
  bStartStop->setEnabled(true);// 'cause we turned if off for the start pause
  aStartStop->setEnabled(true);

  quenum++;
  if (quenum==(testLength+1))
    {
      startstop();//=stop
      return;
    }

  labelQueNum->setText(QString("question %1 out of %2").arg(quenum).arg(testLength));

#ifdef _KLN_SHOW_SCHEDULE
  debugShowSuggestions(quenum);
#endif
  if (suggestion[quenum%defMAXseria]!=nullNote)
    {
#ifdef _KLN_SHOW_SCHEDULE
      debuginfo("USING THE SCHEDULED NOTE");
#endif
      note=suggestion[quenum%defMAXseria];
      suggestion[quenum%defMAXseria]=nullNote;
    }
  else
    {
#ifdef _KLN_SHOW_SCHEDULE
      debuginfo("USING A RANDOM NOTE");
#endif
      int lastNote;
      if (note==nullNote)
	lastNote=-300;
      else
	lastNote =note->getNum();
      //
      //***** wise RANDOM start *****
      // 
      double weight=0;
      for (int i = 0 ; i< numActiveNotes; i++)
	weight+=activeNotes[i]->getProbab();
      regions[0]=activeNotes[0]->getProbab()/weight*10000;
      for (int i = 1; i <numActiveNotes; i++)
	regions[i]=regions[i-1]+
	  activeNotes[i]->getProbab()/weight*  10000;
      int noteindex;
      double tmpnum;
      do {
	tmpnum = KApplication::random() % 10000 ;
	noteindex=0;
	for (int i = 0; i <numActiveNotes-1; i++)
	  if (tmpnum>regions[i])
	    noteindex=i+1;
      } while( activeNotes[noteindex]->getNum() == lastNote );
      note=activeNotes[noteindex];
      //
      //***** wise RANDOM end *****
      //
    }
  
  note->showNote(); 
  c->update();
  note->play();
  midi_playChord();
  onetime=0;
  LCD_queTime->display(onetime);
  clocky->start(50,FALSE);
}


void KLearnNotes2::noteA(){  checkanswer('A');  return; }
void KLearnNotes2::noteC(){  checkanswer('C');  return; }
void KLearnNotes2::noteD(){  checkanswer('D');  return; }
void KLearnNotes2::noteE(){  checkanswer('E');  return; }
void KLearnNotes2::noteF(){  checkanswer('F');  return; }
void KLearnNotes2::noteG(){  checkanswer('G');  return; }
void KLearnNotes2::noteH(){  checkanswer('H');  return; }

void KLearnNotes2::redraw()
{
  // text:
  t->hide();
  delete t;
  
  for(int i=0;i<7;i++)
    namePBs[i]->setEnabled(nameCHKs[i]->isChecked());
  
  note->hideNote();

  // if one pressed Stop while we were waiting for redraw()
  // next note should NOT be selected:
  if (isStarted())
    nextNote();
}

void KLearnNotes2::keyPressEvent( QKeyEvent *k )
{
  char key = toupper(k->ascii());
  if ((key <= 'Z') && ( key >='A') )
    // without above condition this reacts to e.g.. alt; 
    // this could lead to segfault even when pressing alt+q = quit !
    if (noteNameIsActive(key))
      checkanswer( key );
}

void KLearnNotes2::growtime()
{
  onetime++;
  LCD_queTime->display(onetime);
  timespent++;
  int answ=(LCD_numOK->intValue()) + (LCD_numWR->intValue());
  if ( answ > 0 )
    {
      LCD_speed->display((200*60*answ)/(timespent));
      if (LCD_speed->intValue()>LCD_yourGoal->intValue())
	LCD_speed->setOK();
      else
	LCD_speed->setOK(false);
    }
}

void KLearnNotes2::setClefTreble(bool treble)
{// bool interface to setClef (for connecting to togglebutton events)
  int i =1;
  if(treble)
    i=0;
  CB_clef->setCurrentItem(i);
  setClef(i);
}

void KLearnNotes2::setClef(int indeks)
{

  if ( indeks==0) {                 //TREBLE CLEF
    a_mp_SetClefTreble->setOn(true);
    allNotes[0+numNotesABOVE]->setName(2);
    // i.e. the note just above the five lines (=0) is G (=2)
    allNotes[0+numNotesABOVE]->setPitch(60+12+7+OCTAVEbias*12);
    //60=middle C;+12=C1;+7=G1
    clefItem[0]->show();
    clefItem[1]->hide();
  } else {                            //BASS CLEF
    a_mp_SetClefBass->setOn(true);
    allNotes[0+numNotesABOVE]->setName(0);
    // i.e. the note just above the five lines (=0) is H(=0)
    allNotes[0+numNotesABOVE]->setPitch(60-1+OCTAVEbias*12);
    //60=middle C; -1=H0
    clefItem[1]->show();
    clefItem[0]->hide();
  }


  // now, starting from this note we setup all other
  for (int i =1; i < numNotesALL - numNotesABOVE; i++)
    { // down the clef:
      allNotes[i+numNotesABOVE]->setName((allNotes[i+numNotesABOVE-
						   1]->getName() +1)%7) ;
      int pitchdiff=-2;
      if((allNotes[i+numNotesABOVE-1]->getCname()=='C')||
	 (allNotes[i+numNotesABOVE-1]->getCname()=='F'))
	pitchdiff=-1;
      allNotes[i+numNotesABOVE]->setPitch(allNotes[i+numNotesABOVE-
						   1]->getPitch() +pitchdiff) ;
    }
  for (int i =-1; i > - numNotesABOVE -1 ; i--)
    { // up the clef
      allNotes[i+numNotesABOVE]->setName((700+allNotes[i+numNotesABOVE+
						       1]->getName()-1)%7) ;
      // note for the last line: % does not work on negative integers
      // therefore subtracting 1 is dangerous, and adding 700 makes it safe
      // - one can put here any integer of a form 7*something, just such that
      // (...) be positive
      int pitchdiff=2;
      if((allNotes[i+numNotesABOVE+1]->getCname()=='H')||
	 (allNotes[i+numNotesABOVE+1]->getCname()=='E'))
	pitchdiff=1;
      allNotes[i+numNotesABOVE]->setPitch(allNotes[i+numNotesABOVE+
						   1]->getPitch() +pitchdiff) ;

    }
  // here one might want to run setupExercises() if it depended on the clef

  activeNotesChangedByExercise(CB_exercise->currentItem());//to change regions etc.
  // but:
  if(CB_exercise->currentItem()==0)// exercises==custom does nothing; new clef would not
    // be seen:( and different notes are active with the same checkboxes
    // checked (e.g. for 'G'==checked note#0 would be active for treble 
    // clef, while not active for the bass clef!)
    {
      setupActiveNotes(); 
      c->update();
    }
  // erring in different clef shouldn't matter
  for(int i = 0;i<numNotesALL;i++)
    allNotes[i]->setColor('0');
  return;
}



void KLearnNotes2::activeNotesChangedManual(const int notimportant =0)
{ //  when one slides sliders or checks checkboxes
  int nothing=notimportant; // just to get rid of a warning about unused argument;
  nothing++;//           'notimportant' was introduced just to match some signals!
  for(int i=0;i<7;i++)
    namePBs[i]->setEnabled(nameCHKs[i]->isChecked());

  if (! autochange)
    {
      CB_exercise->setCurrentItem(0);//"custom"
      setupActiveNotes();
      c->update();
    }
}




void KLearnNotes2::activeNotesChangedByExercise(int indeks )
{  // when one changes exercise to one of the presets
  if (indeks==0)
    return; //"custom"
  if (CB_exercise->count()==0)
    return; // no exercises set yet
  autochange=true;
  switch (indeks) {
  case 1:  //C,G
  case 11:
  case 21:
  case 31:
  case 5:
  case 15:
  case 25:
  case 35:
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  case 2:  //C,D
  case 12:
  case 22:
  case 32:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(false);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(true);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 3:  //H,C
  case 13:
  case 23:
  case 33:{
    nameCHKs[0]->setChecked(true);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(false);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 4:  //H,C,D
  case 14:
  case 24:
  case 34:{
    nameCHKs[0]->setChecked(true);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(false);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(true);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 6:  //G,A
  case 16:
  case 26:
  case 36:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(true);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(false);	//C
    break;
  }
  case 7:  //F,G
  case 17:
  case 27:
  case 37:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(true);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(false);	//C
    break;
  }
  case 8:  //F,G,A
  case 18:
  case 28:
  case 38:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(true);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(true);	//F
    nameCHKs[4]->setChecked(false);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(false);	//C
    break;
  }
  case 9:  //C,E,G
  case 19:
  case 29:
  case 39:{
    nameCHKs[0]->setChecked(false);	//H
    nameCHKs[1]->setChecked(false);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(false);	//F
    nameCHKs[4]->setChecked(true);	//E
    nameCHKs[5]->setChecked(false);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  case 10:  // ALL
  case 20:
  case 30:
  case 40:{
    nameCHKs[0]->setChecked(true);	//H
    nameCHKs[1]->setChecked(true);	//A
    nameCHKs[2]->setChecked(true);	//G
    nameCHKs[3]->setChecked(true);	//F
    nameCHKs[4]->setChecked(true);	//E
    nameCHKs[5]->setChecked(true);	//D
    nameCHKs[6]->setChecked(true);	//C
    break;
  }
  }
  // Now, main, upper and lower regions have different meaning
  // for bass and treble clefs; also very high and very low notes
  // are rarely used in bass clef, so "all notes" will mean less in this case
  if(CB_clef->currentItem()==0)			//TREBLE
    {
      if(indeks<11)
	{
	  // (-1...12) but max/min just in case
	  minmax1->setValue(max(-1,-numNotesABOVE));//A1
	  minmax2->setValue(min(12,numNotesALL-numNotesABOVE-1));//H0
	}
      if((indeks>=11)&&(indeks<21))
	{
	  minmax1->setValue(-numNotesABOVE);//E2?
	  minmax2->setValue(5);//H
	}
      if((indeks>=21)&&(indeks<31))
	{
	  minmax1->setValue(6);//A
	  minmax2->setValue(numNotesALL-numNotesABOVE-1);//D0?
	}
      if(indeks>=31)
	{
	  minmax1->setValue(-numNotesABOVE);//E2?
	  minmax2->setValue(numNotesALL-numNotesABOVE-1);//D0?
	}
    }else{ 					// BASS
      if(indeks<11)
	{
	  minmax1->setValue(max(-2,-numNotesABOVE));//D"1"
	  minmax2->setValue(min(10,numNotesALL-numNotesABOVE-1));//F
	}
      if((indeks>=11)&&(indeks<21))
	{
	  minmax1->setValue(max(-5,-numNotesABOVE));//G"2"
	  minmax2->setValue(3);//F
	}
      if((indeks>=21)&&(indeks<31))
	{
	  minmax1->setValue(5);//D
	  minmax2->setValue(min(13,numNotesALL-numNotesABOVE-1));//C"0"
	}
      if(indeks>=31)
	{
	  minmax1->setValue(max(-5,-numNotesABOVE));//G"2"
	  minmax2->setValue(min(13,numNotesALL-numNotesABOVE-1));//C"0"
	}

    }
  autochange=false;
  setupActiveNotes();
  c->update();
}


void KLearnNotes2::nextExercise()	
{
  if (CB_exercise->currentItem()<(CB_exercise->count()-1))
    {
      CB_exercise->setCurrentItem(CB_exercise->currentItem()+1);
      activeNotesChangedByExercise(CB_exercise->currentItem());
    }
  bStartStop->setFocus ();
}


void KLearnNotes2::turnSoundOnOff(bool onoroff)
{
  if (onoroff) //on
    if(! midi_turnOn()) // dev. is NOT open
      {
	a_mo_soundOnOff->setOn(false);
	statbar->message("Can't open midi device!",5*INTERVAL);
      }else{
	statbar->message("Midi device opened.",5*INTERVAL);
      }
  else //off
    {
      midi_turnOff();
      statbar->message("Midi device closed.",5*INTERVAL);
    }
}


void KLearnNotes2::dialogMaxQue()
{
  bool ok = FALSE;
  int newnum=QInputDialog::getInteger("Number of questions in one series?",
				      "Set new number of questions in one"
				      "series (40-200)\nChoose \n"
				      "* lower values for "
				      "small-number-of-notes exercises\n"
				      "* higher values if big number of "
				      "notes is active:\n",
				      testLength,40,200,1,&ok);
  if ( ok)
    {    // user entered something and pressed OK
      testLength=newnum;
      SB_testLength->setValue(newnum);
    }
}


void KLearnNotes2::mH_about_activated()
{
  KAboutApplication * d = new KAboutApplication( &aboutData, this );
  d->show(this);
}

void KLearnNotes2::mH_doesntWork_about_activated ()
{
  static QMessageBox* helpBox = new QMessageBox
    ( "KLearnNotes2",
      "<h3>Problem:</h3>"
      "I was not able to prepare install in such a way that on all systems "
      "KDE helpfile was find by KDE help browser. Therefore, I included in "
      "this distribution a HTML copy of index.docbook. You can access HTML "
      "version of KLearnNotes2 helpfiles through items in this "
      "(\"<EM>If KDE help doesn't work</EM>\") menu."
      "<h3>Notes:</h3><UL>"
      "<LI>KLearnNotes2 helpfiles were optimized for KDE help browser; if "
      " it is available (\"<EM>KDE Help for KLearnNotes2</EM>\" menuitem) you "
      " should use it rather then \"<EM>If KDE help doesn't work</EM>\" menu."
      "<LI>if you have <B>root</B> access to your computer you can move "
      " KLearnNotes2 files to the place proper for your system; to do this:"
      "<OL><LI>find <B>konqueror/index.docbook</B> file; <BR>"
      "       for example type \"locate konqueror/index.docbook\""
      "    <LI>copy <B>/usr/share/doc/HTML/en/klearnnotes2</B> to the "
      "        directory where there is <B>konqueror/index.docbook</B>;"
      "        for example if locate returned<BR>"
      "        /opt/kde/doc/HTML/en/konqueror/index.docbook<BR>"
      "        you should type<BR>"
      "        <B>cp -R /usr/share/doc/HTML/en/klearnnotes2 \\<BR>"
      "        /opt/kde/doc/HTML/en/</B><BR>"
      "        From this moment KDE KLearnNotes help should work :)"
      "</OL></UL>", QMessageBox::Information, 1, 0, 0, this, 0, FALSE );
  helpBox->setButtonText( 1, "Dismiss" );
  helpBox->show();
}

void KLearnNotes2::mH_doesntWork_index_activated ()
{
  HelpWindow* hepi = new HelpWindow("klearnnotes2.html",
				    "/usr/share/doc/HTML/en/klearnnotes2/" );
  hepi->show();
}
void KLearnNotes2::mH_doesntWork_quickStart_activated()
{
  HelpWindow* hepi = new HelpWindow(QUICKstartFILE, 
				    "/usr/share/doc/HTML/en/klearnnotes2/"); 
  hepi->show();
}


void KLearnNotes2::dialogSetupMidi()
{
  QPixmap tmpPixmap=tbWhat->iconSet().pixmap(QIconSet::Small,QIconSet::Normal);
  MIDI_setup* mididialog=new MIDI_setup(tmpPixmap,this);
  // midi settings are global, so they are changed directly by mididialog
  // the only thing which needs doing below is:
  // * if octavebias changed we have to redefine notes' pitches
  int tmpint=OCTAVEbias;
  if (mididialog->exec() == QDialog::Accepted )
    {
      if((mididialog->SpinBox5)->value()!=tmpint)
	setClef(CB_clef->currentItem());
    }
  //  a_mo_soundOnOff->setOn(midiIsOn());
  delete mididialog;
}

void KLearnNotes2::setGermanHNotation(bool notationH)
{
  if(notationH)
    {
      orderOfNotes[0]='H';
      a_mo_setNotationGE->setText( trUtf8( "change to English notation "
					   "'H'->'B'" ) );
      a_mo_setNotationGE->setMenuText(trUtf8("German n&otation "
					     "(GA-H-CD)"));
    }else{
      orderOfNotes[0]='B';
      a_mo_setNotationGE->setText( trUtf8( "change to German notation "
					   "'B'->'H'" ) );
      a_mo_setNotationGE->setMenuText(trUtf8("English n&otation "
					     "(GA-B-CD)"));
    }
  namePBs[0]->setText(QChar(orderOfNotes[0]));
  setClef(CB_clef->currentItem());// 'cause allNotes[] cNames change
}


void KLearnNotes2::saveOptions()
{
  loadSet* loadSaveData=new loadSet;
  // ========= MIDI
  loadSaveData->midi_open=midiIsOn() ; //was it opened?
  loadSaveData->midi_device=midiCurrentDevice ;
  loadSaveData->midi_numChannels=midiMaxChan ;
  loadSaveData->midi_volume=0 ;// for future, so that .klearnnotes2 wouldn't have to change 
  loadSaveData->midi_noteLength=midiNoteLength ;
  loadSaveData->midi_patch=midiPatch ;
  loadSaveData->midi_octaveBias=OCTAVEbias ;
  //==============
  loadSaveData->H_nameMode=a_mo_setNotationGE->isOn() ;
  loadSaveData->testLength=testLength ;
  loadSaveData->level=CB_level->currentItem() ;
  loadSaveData->speedGoal2=customSpeedGoal2;
  loadSaveData->speedGoal7=customSpeedGoal7;

  //======= EXERCISE clef, etc
  loadSaveData->clef=CB_clef->currentItem() ;
  loadSaveData->exercise=CB_exercise->currentItem() ;
  loadSaveData->notesRange1=minmax1->value() ;
  loadSaveData->notesRange2=minmax2->value() ;
  loadSaveData->nameIsActive0=nameCHKs[0]->isChecked() ;
  loadSaveData->nameIsActive1=nameCHKs[1]->isChecked() ;
  loadSaveData->nameIsActive2=nameCHKs[2]->isChecked() ;
  loadSaveData->nameIsActive3=nameCHKs[3]->isChecked() ;
  loadSaveData->nameIsActive4=nameCHKs[4]->isChecked() ;
  loadSaveData->nameIsActive5=nameCHKs[5]->isChecked() ;
  loadSaveData->nameIsActive6=nameCHKs[6]->isChecked() ;

  QFile f(QDir::homeDirPath ()+"/.klearnnotes2");
  f.open( IO_WriteOnly );
  QDataStream s( &f );
  s << (Q_UINT32)0xfa0fa0f; //magic number
  s << (Q_INT32)1; //version
  s.writeRawBytes((char*)loadSaveData,sizeof(loadSet));
  f.close();


  delete loadSaveData;
  statbar->message(QString("wrote settings to %1").arg((QDir::homeDirPath ()+
							"/.klearnnotes2"
							).latin1()),
		   5*INTERVAL);
  return;
}


void KLearnNotes2::loadOptions()
{
  loadSet* loadSaveData=new loadSet;

  if ( QFile::exists( QDir::homeDirPath ()+"/.klearnnotes2" ) ) {
    QFile f( QDir::homeDirPath ()+"/.klearnnotes2" );
    f.open( IO_ReadOnly );
    QDataStream s( &f );
    Q_UINT32 magic;
    s>>magic;
    if ( magic != 0xfa0fa0f )
      {
	printerror (QString("File %1 has wrong magic number! \n"
			    "Using default program settings. \n "
			    "A new %2 will be created on exit."
			    ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
				   ).latin1()
				  ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
					 ).latin1()));
	delete loadSaveData;
	f.close();
	return;
      }

    Q_INT32 version;
    s >> version;
    if ( version != 1 )
      {
 	printerror (QString("File %1 has wrong version! \n"
			    "Using default program settings. \n "
			    "A new %2 will be created on exit."
			    ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
				   ).latin1()
				  ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
					 ).latin1()));
	delete loadSaveData;
	f.close();
	return;
      }

    s.readRawBytes((char*)loadSaveData,sizeof(loadSet));
    f.close();
  }else{
    printerror (QString("There's no %1 file! \n"
			"Using default program settings. \n "
			"%2 will be created on exit."
			).arg((QDir::homeDirPath ()+"/.klearnnotes2").latin1()
			      ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
				     ).latin1()));
    delete loadSaveData;
    return;
  }


  restoring=true;
  // ========= MIDI
  midiCurrentDevice=loadSaveData->midi_device ;
  midiMaxChan = loadSaveData->midi_numChannels;
  //  currentVoulume=loadSaveData->midi_volume ;
  // for future, so that user's  ~/.klearnnotes2 wouldn't have to change 
  midiNoteLength =  loadSaveData->midi_noteLength;
  midiPatch =  loadSaveData->midi_patch;
  OCTAVEbias =  loadSaveData->midi_octaveBias;
  turnSoundOnOff(loadSaveData->midi_open);//was it opened?
  a_mo_soundOnOff->setOn(loadSaveData->midi_open);
  //==============
  a_mo_setNotationGE->setOn(  loadSaveData->H_nameMode);
  testLength =  loadSaveData->testLength;
  SB_testLength->setValue(testLength);

  //======= EXERCISE clef, etc
  minmax1->setValue( loadSaveData->notesRange1);
  minmax2->setValue( loadSaveData->notesRange2);
  nameCHKs[0]->setChecked( loadSaveData->nameIsActive0);
  nameCHKs[1]->setChecked( loadSaveData->nameIsActive1);
  nameCHKs[2]->setChecked( loadSaveData->nameIsActive2);
  nameCHKs[3]->setChecked( loadSaveData->nameIsActive3);
  nameCHKs[4]->setChecked( loadSaveData->nameIsActive4);
  nameCHKs[5]->setChecked( loadSaveData->nameIsActive5);
  nameCHKs[6]->setChecked( loadSaveData->nameIsActive6);

  customSpeedGoal2=loadSaveData->speedGoal2 ;
  customSpeedGoal7=loadSaveData->speedGoal7 ;

  
  CB_exercise->setCurrentItem(0);
  CB_clef->setCurrentItem( loadSaveData->clef);
  setClef(loadSaveData->clef);
  CB_exercise->setCurrentItem(loadSaveData->exercise);
  activeNotesChangedByExercise(loadSaveData->exercise);

  CB_level->setCurrentItem(loadSaveData->level) ;
  a_mo_setLevel[loadSaveData->level]->setOn(true);
  setupSpeedGoal();

  delete loadSaveData;
  statbar->message(QString("loaded settings from %1"
			   ).arg((QDir::homeDirPath ()+"/.klearnnotes2"
				  ).latin1()),
		   5*INTERVAL);
  restoring=false;
  return;
}

void KLearnNotes2::setTestLength(int number)
{
  testLength=number;
}


void  KLearnNotes2::a_mo_setLevelCustom_activated()
{
  // EXACT COPY OF THE CODE BELOW, just called by different signal
  CB_level->setCurrentItem(3);
  bool changed=dialogCustom_show();
  setupSpeedGoal();
  if(changed) lastLevel=3;
}

void KLearnNotes2::setLevelByAction(QAction* a)
{
  for(int i=0;i<3;i++) // for i=3 NOP
    if(a==a_mo_setLevel[i])
      {
	CB_level->setCurrentItem(i);
	bool changed=true;
	if(i==3) changed=dialogCustom_show();
	setupSpeedGoal(); // NOT in runDialCas(), 'cause it should
	//                   be run for non-custom levels too!
	if(changed) lastLevel=i;//i.e. for changes to preset 0/1/2 and for 
	//                        accepted changes to 3(custom)
      }
}

void KLearnNotes2::setLevelByCombo(int i)
{
  if(i==3)// and (a_mo_setLevel[i]->isOn()))
    {
      a_mo_setLevelCustom_activated();
    }
  a_mo_setLevel[i]->setOn(true);
}
