/****************************************************************************
 ** $Id: helpwindow.h,v 1.3 2003/10/13 19:56:09 marek Exp $
 **
 ** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
 **
 ** This file is part of an example program for Qt.  This example
 ** program may be used, distributed and modified without limitation.
 **
 *****************************************************************************/
/***************************************************************************
                          modified  by Marek Wieckowski for klearnnotes2
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    email                : wiecko AT users.sourceforge.net
 ***************************************************************************/



#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#define HELP_PATH "./DOCs/"

#include <qmainwindow.h>
#include <qtextbrowser.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdir.h>

class QComboBox;
class QPopupMenu;

class HelpWindow : public QMainWindow
// QDialog
{
  Q_OBJECT
    public:
  HelpWindow( const QString& home_,  const QString& path, QWidget* parent = 0, const char *name=0 );
  ~HelpWindow();

  private slots:
    void setBackwardAvailable( bool );
  void setForwardAvailable( bool );

  void textChanged();
  void about();
  void aboutQt();
  void openFile();
  void newWindow();
  void print();

  void pathSelected( const QString & );
  void histChosen( int );
  void bookmChosen( int );
  void addBookmark();
    
 private:
  void readHistory();
  void readBookmarks();
    
  QTextBrowser* browser;
  QComboBox *pathCombo;
  int backwardId, forwardId;
  QString selectedURL;
  QStringList history, bookmarks;
  QMap<int, QString> mHistory, mBookmarks;
  QPopupMenu *hist, *bookm;
    
};

#endif

