/***************************************************************************
 ** $Id: KLNcanvasitems.cpp,v 1.2 2003/10/13 09:38:23 marek Exp $
                          klearnnotes2
                          KLNcanvasitems.cpp -  description
                             -------------------
    begin                : Wed Oct  8 15:32:54 CEST 2003
    copyright            : (C) 2003 by Marek Wieckowski
    email                : wiecko AT users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "KLNcanvasitems.h"
#include <qtimer.h>
#include <qevent.h>
#include <qwmatrix.h> 
#include <qpainter.h> 


//////////// ********** aNOTE  *************

aNote::aNote (int zeroH, QCanvas* mycanvas, int mynumber, 
	      staffLine* la[], staffLine* lb[],
	      QObject* parent,aNote* prevN) 
  :  QObject(parent) , QCanvasEllipse ( 4*SC, 2*SC, mycanvas )
{
  canv=mycanvas;
  num=mynumber;
  previousNote=prevN;

  //QCanvasEllipse setup:
  hide();
  color='0';
  resetcolor='0';
  move( 15*SC, ((num-1)*SC)+zeroH);
  // now this is fun: there has to be order of Z-s
  // each note is antialiased and fills all region between lines
  // it has to be over a line which crosses it in the middle,
  // but below line touched above (otherwise antialias prepared
  // for white background will look stupid on a black line);
  // therefore there has to be Z-order:
  // a line with smallest Z
  // then a note over this line (*)
  // then a note just above the line
  // then a line one step above
  // then the note over this line (*) and so on


  // OOPS, eventually I made smaller note-pictures so above remarks
  // DO NOT APPLY!; but I don't delete them, because it may be important
  // in the future


  int k = int(y()/double(SC)); //how many steps are we from tops of the canvas
  setZ(128-(2*k)+1);// +1 will put it over "it's" line but below
  //                   items higher at the stave

  noOfMyLines=0;
  //extra lines:
  if (num<0){ // we are above note G2
    noOfMyLines=(1-num)/2; //which hopefully is floored for an odd numerator
    for (int i =0 ; i<noOfMyLines; i++)
      myLines[i]=la[i];
  }
  if (num>10){ //we are below D
    noOfMyLines=(num-9)/2;
    for(int i = 0; i<noOfMyLines; i++)
      myLines[i]=lb[i];
  }
}


aNote::~aNote() {}


void aNote::setColorTmp(char newcolor,int time)
{
  color=newcolor;
  update();
  QTimer::singleShot( time, this, SLOT(resetColor()) );
  return;
}

void aNote::setColor(char newcolor)
{
  color=newcolor;
  resetcolor=newcolor;
  update();
  return;
}


void aNote::resetColor()
{
  color=resetcolor;
  update();
  canv->update();
}

void aNote::resetStats()
{
  statOK=0;
  statWR=0;
  statTIME=0;
  statSPEED=1;
  statPROBAB=1;
}
	
double aNote::getProbab() {  return statPROBAB;}

int aNote::getWrong()  {  return statWR;}
int aNote::getCorrect(){  return statOK;}
int aNote::getTime()   {  return statTIME;}


void aNote::addCorrect(int t)
{
  statOK++;
  statTIME+=t;
  updateStats();
}

void aNote::addWrong(int t)
{
  statWR++;
  statTIME+=t;
  updateStats();
}

void aNote::updateStats()
{
  // because of force scheduling each note is run at least once
  // before real random notes choice starts;
  // therefore overall factors do not count
  // (they would if there were both 'un-run' and 'run' notes)
  if (statTIME>0) 
    {
      statSPEED=double(statOK+statWR)/double(statTIME);
    }
  if (statSPEED>0)
    {
      statPROBAB=power(double(5),statWR)*power(double(0.75),statOK)/statSPEED;
    }else{
      printerror("Sth. wrong: note's speed==0  ?????");
      statPROBAB=power(double(5),statWR)*power(double(0.75),statOK);
    }
}

		
void aNote::showNote()
{
  show();
  if (previousNote->isVisible())
    {
      moveit();
      previousNote->moveit();
    }
  for (int i=0;i<noOfMyLines;i++)
    myLines[i]->show();
}


void aNote::hideNote()
{
  hide();
  for (int i=0;i<noOfMyLines;i++)
    {
      myLines[i]->hide();
    }
  move( 15*SC, y());//move it back
}

void aNote::setName(int newname)
{
  name=newname;
  cname=orderOfNotes[name];
}

int  aNote::getName()	{return name;}
char aNote::getCname()	{return cname;}
int  aNote::getNum()	{return num;}

void aNote::moveit()
{
  if(noOfMyLines>0)
    myLines[0]->setLonger(); // all extra lines longer
  if(num%2)
    move( 13.25*float(SC), y());
  else
    move( 16.75*float(SC), y());
}


void aNote::setPitch(int newpitch)
{
  pitch=newpitch;
}

int aNote::getPitch() {return pitch;}

void aNote::play(){ midi_addANote2chord(pitch);}//addAnote checks if device is open

void aNote::drawShape ( QPainter & p )
{
  switch (color){
  case 'R':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_red);
    break;
  case 'G':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_green);
    break;
  case 'B':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_blue);
    break;
  case '0':
    p.drawPixmap( int(x() - width()/2), int(y()-height()/2),*PIX_note_black);
    break;
  }
}


//////////////////////////////////

bool staffLine::longer = false;


staffLine::staffLine (QCanvas* can,int ypos,int linetype)
  :QCanvasLine(can)// , QObject(can)
{
  y=ypos;
  type=linetype;
  setPen( QPen( black, 1 ) );
  int k =int(y/double(SC)); //how many steps are we from tops of the canvas
  setZ(128-(2*k));// without +1 this will put it under "it's" note

  switch (type)
    {
    case 1: // one of 5 staff lines
      setPoints( 2*SC, y, 33*SC, y);
      break;
    case 2: // one of the extra lines above or below
      setPoints( 10*SC, y, 20*SC, y);
      break;
    case 3: // guidelines
      setPoints( 30*SC, y, 33*SC, y);
    }

}
staffLine::~staffLine(){}

void staffLine::show()
{
  if (type==2) // extra lines above/below may need resizing:
    if(longer)
      setPoints( 10*SC, y, 20*SC, y);
    else
      setPoints( 12*SC, y, 18*SC, y);
  QCanvasLine::show();
}

void staffLine::hide()
{
  QCanvasLine::hide();
  longer=false;
}

void staffLine::setLonger(){longer=true;} // ==there are some adjacent notes


///////////////////////////////////

clickableView::clickableView(QCanvas* cnvs,QWidget* prnt, KLearnNotes2* prog)
  :QCanvasView(cnvs,prnt)
{
  papcio=prog;
}

void clickableView::contentsMousePressEvent ( QMouseEvent * e)
{
  QPoint p = inverseWorldMatrix().map(e->pos());
  QCanvasItemList l=canvas()->collisions(p);
  for (QCanvasItemList::Iterator it=l.begin(); it!=l.end(); ++it) {
    if ( (*it)->rtti() == QCanvasItem::Rtti_Ellipse ){
      aNote *noti= (aNote*)(*it);
      noti->setColorTmp('B');
      QCanvasView::canvas()->update();
      noti->play();
      midi_playChord();
      if(!(papcio->isStarted()))
	{
	  papcio->PBchangeColorTmp(noti->getName());//changes button color
	}
      return;
    }
  }
}
