/****************************************************************************

    DRC: Digital Room Correction
    Copyright (C) 2002 Denis Sbragion

		This file is part of DRC, Digital Room Correction

		DRC  is  distributed  with  NO WARRANTY OF ANY KIND. No author or
		distributor accepts any responsibility for  the  consequences  of
		using  it,  or  for  whether  it serves any particular purpose or
		works at all, unless he or she says so in writing.  Refer to  the
		Aladdin Free Public License (the "License") for full details.

		Every copy of DRC must include a copy of the License, normally in
		a plain ASCII text file named PUBLIC. The License grants you  the
		right  to  copy, modify and redistribute DRC, but only under cer
		tain conditions described in the License.   Among  other  things,
		the License requires that the copyright notice and this notice be
		preserved on all copies.

		You can contact the author on Internet at the following address:

				d.sbragion@infotecna.it

		This program uses the parsecfg library from Yuuki  NINOMIYA.  De
		tails  on  this  library  can be found in the parsecfg.c and par
		secfg.h files.  Many thanks to Yuuki NINOMIYA for this useful li
		brary.

****************************************************************************/

/* Spline routines */

#ifndef Spline_h
	#define Spline_h

	/* Inclusioni */
	#include "drc.h"
  #include "boolean.h"

	/* Tipo spline da generare */
  typedef enum { SplineBDef, SplineBNat } SplineType;

	/* Prepara la base per la spline cubica interpolante, ponendola in SPD2YN */
	Boolean SplinePrepare(const DRCFloat * XN,const DRCFloat * YN,
		const int N,const DRCFloat SPD1Y1,const DRCFloat SPD1YN,
		const SplineType SPType,DRCFloat * SPD2YN);

	/* Valore della spline cubica interpolante nel punto X */
	DRCFloat SplineValue(const DRCFloat * XN,const DRCFloat * YN,
		const int N, const DRCFloat * SPD2YN, const DRCFloat X);

	/* Valore della B spline cubica uniforme nel punto X */
	DRCFloat B3SplineValue(const DRCFloat * XN,const DRCFloat * YN,
		const int N, const DRCFloat X);

	/* Valore della B spline cubica di tipo Catmull Rom nel punto X */
	DRCFloat B3CRSplineValue(const DRCFloat * XN,const DRCFloat * YN,
		const int N, const DRCFloat X);

	/* Valore della spline lineare nel punto X */
	DRCFloat L1SplineValue(const DRCFloat * XN,const DRCFloat * YN,
		const int N, const DRCFloat X);
#endif
