
#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qlined.h>
#include <qstring.h>
#include <qframe.h>
#include <qfiledlg.h>
#include <kapp.h>

#include "kpref.h"
#include "kpref.moc"

#define Inherited QDialog

kpref::kpref (QWidget* parent, const char* name)
     :QTabDialog( parent, name, TRUE)
{	
	
	KConfig *config=KApplication::getKApplication()->getConfig();
	
	resize( 385,265 );
	setMinimumSize( 385, 265 );
	setMaximumSize( 385, 265 );

	setCancelButton();
	aloneTab=new QWidget(this,"aloneTab");
	
	QFrame* Frame_1;
	Frame_1 = new QFrame( aloneTab, "Frame_1" );
	Frame_1->setGeometry( 10, 100, 350, 80 );
	Frame_1->setMinimumSize( 10, 10 );
	Frame_1->setMaximumSize( 32767, 32767 );
	Frame_1->setFrameStyle( 49 );

	QFrame* Frame_2;
	Frame_2 = new QFrame( aloneTab, "Frame_2" );
	Frame_2->setGeometry( 10, 10, 350, 80 );
	Frame_2->setMinimumSize( 10, 10 );
	Frame_2->setMaximumSize( 32767, 32767 );
	Frame_2->setFrameStyle( 49 );
		
	RadioButton_1 = new QRadioButton( aloneTab, "RadioButton_1" );
	RadioButton_1->setGeometry( 20, 110, 147, 19 );
	RadioButton_1->setMinimumSize( 10, 10 );
	RadioButton_1->setMaximumSize( 32767, 32767 );
	RadioButton_1->setText( i18n("Use 8hz-mp3 encoder") );
	RadioButton_1->setAutoRepeat( FALSE );
	RadioButton_1->setAutoResize( TRUE );

	QLabel* Label_3;
	Label_3 = new QLabel( aloneTab, "Label_3" );
	Label_3->setGeometry( 20, 140, 60, 30 );
	Label_3->setMinimumSize( 10, 10 );
	Label_3->setMaximumSize( 32767, 32767 );
	Label_3->setText( "location :" );
	Label_3->setAlignment( 289 );
	Label_3->setMargin( -1 );
	
	LineEdit_1 = new QLineEdit( aloneTab, "LineEdit_1" );
	LineEdit_1->setGeometry( 90, 140, 220, 30 );
	LineEdit_1->setMinimumSize( 10, 10 );
	LineEdit_1->setMaximumSize( 32767, 32767 );
	LineEdit_1->setText( "" );
	LineEdit_1->setMaxLength( 32767 );
	LineEdit_1->setEchoMode( QLineEdit::Normal );
	LineEdit_1->setFrame( TRUE );
	
	RadioButton_3 = new QRadioButton( aloneTab, "RadioButton_3" );
	RadioButton_3->setGeometry( 20, 20, 150, 20 );
	RadioButton_3->setMinimumSize( 10, 10 );
	RadioButton_3->setMaximumSize( 32767, 32767 );
	RadioButton_3->setText(i18n("Use l3cenc encoder"));
	RadioButton_3->setAutoRepeat( FALSE );
	RadioButton_3->setAutoResize( TRUE );
	
	QLabel* Label_5;
	Label_5 = new QLabel( aloneTab, "Label_5" );
	Label_5->setGeometry( 20, 50, 60, 30 );
	Label_5->setMinimumSize( 10, 10 );
	Label_5->setMaximumSize( 32767, 32767 );
	Label_5->setText( "Location :" );
	Label_5->setAlignment( 289 );
	Label_5->setMargin( -1 );
	
	LineEdit_3 = new QLineEdit( aloneTab, "LineEdit_3" );
	LineEdit_3->setGeometry( 90, 50, 220, 30 );
	LineEdit_3->setMinimumSize( 10, 10 );
	LineEdit_3->setMaximumSize( 32767, 32767 );
	LineEdit_3->setMaxLength( 255 );
	LineEdit_3->setEchoMode( QLineEdit::Normal );
	LineEdit_3->setFrame( TRUE );
	
	QPushButton* PushButton_1;
	PushButton_1 = new QPushButton( aloneTab, "PushButton_1" );
	PushButton_1->setGeometry( 320, 50, 30, 30 );
	PushButton_1->setMinimumSize( 10, 10 );
	PushButton_1->setMaximumSize( 32767, 32767 );
	PushButton_1->setText( "..." );
	PushButton_1->setAutoRepeat( FALSE );
	PushButton_1->setAutoResize( FALSE );
	connect(PushButton_1,SIGNAL(clicked()),this,SLOT(chooselocatel3enc()));
	
	QPushButton* PushButton_2;
	PushButton_2 = new QPushButton( aloneTab, "PushButton_2" );
	PushButton_2->setGeometry( 320, 140, 30, 30 );
	PushButton_2->setMinimumSize( 10, 10 );
	PushButton_2->setMaximumSize( 32767, 32767 );
	PushButton_2->setText( "..." );
	PushButton_2->setAutoRepeat( FALSE );
	PushButton_2->setAutoResize( FALSE );
	connect(PushButton_2,SIGNAL(clicked()),this,SLOT(chooselocate8hz()));
	
	// Button group (groupe de boutons pour les RadioButtons)	
	bg = new QButtonGroup(aloneTab);
	bg->setGeometry( 1, 0, 0, 1 ); 
	bg->setMinimumSize( 0, 0 );
	bg->setMaximumSize( 1, 1 );
	// bg->resize(0,0);
	// connect( bg, SIGNAL(clicked(int)), SLOT(updateIt(int)) );
	bg->insert(RadioButton_1);
	bg->insert(RadioButton_3);

	// add the tab, (ajoute l'onglet)
	addTab(aloneTab, "Options");
	
	// Config sections
	
	int lchek;
	
	config->setGroup("Options");
	LineEdit_1->setText(config->readEntry("location"));
	LineEdit_3->setText(config->readEntry("l3location"));
	
	lchek = config->readNumEntry("number");
	if ( lchek == 1 )
	{
		RadioButton_1->setChecked( TRUE );
	}
	else 
		RadioButton_3->setChecked( TRUE );
	
}


void kpref::chooselocate8hz()
{
	QFileDialog *dlg8hz = new QFileDialog(".","*",this,"dlg8hz",TRUE);
	dlg8hz->setCaption("Where is 8hz-mp3 ?");
	if (dlg8hz->exec()) LineEdit_1->setText(dlg8hz->selectedFile());
	delete dlg8hz;
}

void kpref::chooselocatel3enc()
{
	QFileDialog *dlgl3c = new QFileDialog(".","*",this,"dlgl3c",TRUE);
	dlgl3c->setCaption("Where is l3enc ?");
	if (dlgl3c->exec()) LineEdit_3->setText(dlgl3c->selectedFile());
	delete dlgl3c;
}

void kpref::done(int r)
{
	
	KConfig* config=KApplication::getKApplication()->getConfig();
	config->setGroup("Options");
	config->writeEntry("location", LineEdit_1->text());
	config->writeEntry("l3location", LineEdit_3->text());
	
	if ( RadioButton_1->isChecked() )
	{
		int rchek=1;
		config->setGroup("Options");
		config->writeEntry("encoder", LineEdit_1->text());
		config->writeEntry("number", rchek);
	}
	
	if ( RadioButton_3->isChecked() )
	{
		int rchek=0;
		config->setGroup("Options");
		config->writeEntry("encoder", LineEdit_3->text());
		config->writeEntry("number", rchek);
	}
	config->sync();
	
	QTabDialog::done(r);
	   
	
}
