#include <stdio.h>
#include <stdlib.h>
#include <qmsgbox.h>
#include <qaccel.h>
#include <qstring.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qlined.h>
#include <qframe.h>
#include <kmenubar.h>
#include <kconfig.h>
#include <qpopmenu.h>
#include <kprocess.h>
#include <kapp.h>

#include "kpref.h"
#include "kencoder.h"
#include "kencoder.moc"

#ifdef HAVE_CONFIG
#include <config.h>
#endif

kencoder::kencoder(QWidget* parent, const char* name)
	:QWidget( parent, name)
{
	// The Menubar
	QPopupMenu *file = new QPopupMenu();
        CHECK_PTR( file );
        file->insertItem( i18n("&Open"),  this, SLOT(openIn()), CTRL+Key_O );
        file->insertItem( i18n("&Encode As"),  this, SLOT(openOut()),CTRL+Key_E );         
	file->insertSeparator();
        file->insertItem( i18n("O&ptions"), this, SLOT(option()), CTRL+Key_P );
        file->insertSeparator(); 
	file->insertItem( i18n("E&xit"),KApplication::getKApplication(),SLOT(quit()), CTRL+Key_Q );

        QPopupMenu *help = new QPopupMenu;
        CHECK_PTR( help );
        help->insertItem( i18n("&About"), this, SLOT(about()), CTRL+Key_H ); 
	
	KMenuBar* MenuBar;
	MenuBar = new KMenuBar( this );
        CHECK_PTR( MenuBar );
	MenuBar->setMinimumSize( 420, 30 );
        MenuBar->setMaximumSize( 420, 30 );
        MenuBar->insertItem( i18n("&File"), file );
        MenuBar->insertSeparator();
        MenuBar->insertItem( i18n("&Help"), help );
        


	// Simple Label
	QLabel* Label_In;
	Label_In = new QLabel( this, "Label_In" );
	Label_In->setGeometry( 20, 40, 60, 20 );
	Label_In->setMinimumSize( 60, 20 );
	Label_In->setMaximumSize( 60, 20 );
	Label_In->setFrameStyle( 33 );
	Label_In->setText( i18n("Input :") );
	Label_In->setAlignment( 289 );
	Label_In->setMargin( -1 );

	// Simple Label
	LabelOut = new QLabel( this, "LabelOut" );
	LabelOut->setGeometry( 20, 120, 60, 20 );
	LabelOut->setMinimumSize( 60, 20 );
	LabelOut->setMaximumSize( 60, 20 );
	LabelOut->setFrameStyle( 33 );
	LabelOut->setText( i18n("Output :") );
	LabelOut->setAlignment( 289 );
	LabelOut->setMargin( -1 );

	// Line Edit for Input files
	
	LineEdIn = new QLineEdit( this, "LineEdIn" );
	LineEdIn->setGeometry( 20, 70, 310, 30 );
	LineEdIn->setMinimumSize( 310, 30 );
	LineEdIn->setMaximumSize( 310, 30 );
	LineEdIn->setText( "" );
	LineEdIn->setMaxLength( 32767 );
	LineEdIn->setEchoMode( QLineEdit::Normal );
	LineEdIn->setFrame( TRUE );

	// Line Edit for output files.
	
	LineEdOut = new QLineEdit( this, "LineEdOut" );
	LineEdOut->setGeometry( 20, 150, 310, 30 );
	LineEdOut->setMinimumSize( 310, 30 );
	LineEdOut->setMaximumSize( 310, 30 );
	LineEdOut->setText( "" );
	LineEdOut->setMaxLength( 32767 );
	LineEdOut->setEchoMode( QLineEdit::Normal );
	LineEdOut->setFrame( TRUE );

	// Browse Button for Input files
	browsein = new QPushButton( this, "browsein" );
	browsein->setGeometry( 340, 70, 60, 30 );
	browsein->setMinimumSize( 60, 30 );
	browsein->setMaximumSize( 60, 30 );
	browsein->setText( i18n("Browse") );
	browsein->setAutoRepeat( FALSE );
	browsein->setAutoResize( FALSE );
	connect(browsein,SIGNAL(clicked()),this,SLOT(openIn()));

	// Browse Button for Output files.
	browseout = new QPushButton( this, "browseout" );
	browseout->setGeometry( 340, 150, 60, 30 );
	browseout->setMinimumSize( 60, 30 );
	browseout->setMaximumSize( 60, 30 );
	browseout->setText( i18n("Browse") );
	browseout->setAutoRepeat( FALSE );
	browseout->setAutoResize( FALSE );
	connect(browseout,SIGNAL(clicked()),this,SLOT(openOut()));

	// Raised Frame
	QFrame* commandfram;
	commandfram = new QFrame( this, "commandfram" );
	commandfram->setGeometry( 10, 200, 390, 50 );
	commandfram->setMinimumSize( 390, 50 );
	commandfram->setMaximumSize( 390, 50 );
	commandfram->setFrameStyle( 33 );
	commandfram->setLineWidth( 2 );

	// Encode Button
	encodebton = new QPushButton( this, "encodebton" );
	encodebton->setGeometry( 20, 210, 90, 30 );
	encodebton->setMinimumSize( 90, 30 );
	encodebton->setMaximumSize( 90, 30 );
	encodebton->setText( "Encode" );
	encodebton->setAutoRepeat( FALSE );
	encodebton->setAutoResize( FALSE );
	connect(encodebton,SIGNAL(clicked()), this, SLOT(Encode())) ;

	// Quit Button
	QuitBton = new QPushButton( this, "QuitBton" );
	QuitBton->setGeometry( 300, 210, 90, 30 );
	QuitBton->setMinimumSize( 90, 30 );
	QuitBton->setMaximumSize( 90, 30 );
	QuitBton->setText( i18n("Quit") );
	QuitBton->setAutoRepeat( FALSE );
	QuitBton->setAutoResize( FALSE );
	connect(QuitBton,SIGNAL(clicked()),KApplication::getKApplication(),SLOT(quit()) );
	 	 	

	// Help Button
	HelpBton = new QPushButton( this, "HelpBton" );
	HelpBton->setGeometry( 170, 210, 90, 30 );
	HelpBton->setMinimumSize( 90, 30 );
	HelpBton->setMaximumSize( 90, 30 );
	HelpBton->setText( i18n("Help") );
	HelpBton->setAutoRepeat( FALSE );
	HelpBton->setAutoResize( FALSE );
	connect( HelpBton, SIGNAL(clicked()), this, SLOT(askHelp()) );

	// Main Widget size
	resize( 420,260 );
	setMinimumSize( 420, 260 );
	setMaximumSize( 420, 260 );
	
	// Drag&Drop action
	connect( new KDNDDropZone(LineEdIn, DndURL),
		SIGNAL( dropAction( KDNDDropZone *) ),
		SLOT( slotDropEvent(  KDNDDropZone *) ) );	

	connect( new KDNDDropZone(LineEdOut, DndURL),
		SIGNAL( dropAction( KDNDDropZone *) ),
		SLOT( slotDropEventOut(  KDNDDropZone *) ) );
}


kencoder::~kencoder()
{
}

void kencoder::slotDropEvent(KDNDDropZone *zone)
{
	
	QString captI= zone->getURLList().first(), s;
	if (KFM::download(captI,s))
	{
    		LineEdIn->setText(s);
    		KFM::removeTempFile(s); 
	}
}

void kencoder::slotDropEventOut(KDNDDropZone *zone2)
{
	
	QString captO= zone2->getURLList().first(), sO;
	if (KFM::download(captO,sO))
	{
    		LineEdOut->setText(sO);
    		KFM::removeTempFile(sO); 
	}
}

void kencoder::encodeNow()
{
	int exchek;

	KConfig* config=KApplication::getKApplication()->getConfig();
	config->setGroup("Options");
	QString s1 = LineEdIn->text();
	QString s2 = LineEdOut->text();
	
	/*** I remove this section until I fix it.	
	if ( (s1="")&&(s2="") )
	{
		QMessageBox* qmsgerror = new QMessageBox();
  		qmsgerror->setText(i18n("You MUST put an Input and an Output file!!!\n"  
					"Pres Ok now."));
  		qmsgerror->show();
  		delete qmsgerror;	
	}
	
	else
	{ 
	****/
		exchek = config->readNumEntry("number");
		if ( exchek == 1 )
		{
		
			process1.setExecutable(config->readEntry("encoder")) ;
	 	        process1 << LineEdIn->text() << LineEdOut->text() ;
	  	        connect(&process1, SIGNAL(processExited(KProcess *)),
    	                SLOT(slotProcessDead(KProcess *)));
   	             
                /*
                connect(&process1, SIGNAL(receivedStdout(KProcess *, char *, int)),
                this, SLOT(slotCmdStdout(KProcess *, char *, int)));
   	        connect(&process1, SIGNAL(receivedStderr(KProcess *, char *, int)),
                this, SLOT(slotCmdStdout(KProcess *, char *, int)));*/
                
        		process1.start(KProcess::NotifyOnExit, KProcess::AllOutput);
		
		}

		else 
		{
		
			process1.setExecutable(config->readEntry("encoder")) ;
			process1 << "-if" << LineEdIn->text() << "-of" << LineEdOut->text() ; 	   		 		 	
		        connect(&process1, SIGNAL(processExited(KProcess *)),
 	                SLOT(slotProcessDead(KProcess *)));
	  	        process1.start(KProcess::NotifyOnExit, KProcess::AllOutput);
		}	
		
		QMessageBox* qmsgbegin = new QMessageBox();
		qmsgbegin->setText(i18n("The Encoding is running.\n"
  			   "You'll be warned when it will finish.\n"
		  	   "Press Ok now"));
  		qmsgbegin->show();
		delete qmsgbegin;
	
	
	
	
}


void kencoder::slotProcessDead(KProcess *)
{


  // close the KProcesses
  /*
  disconnect(&process1, SIGNAL(receivedStdout(KProcess *, char *, int)),
             this, SLOT(slotShowStdout(KProcess *, char *, int)));
  disconnect(&process1, SIGNAL(receivedStderr(KProcess *, char *, int)),
             this, SLOT(slotShowStdout(KProcess *, char *, int)));
  */
  disconnect(&process1, SIGNAL(processExited(KProcess *)),
             this, SLOT(slotProcessDead(KProcess *)));
  
  // Advert the user that the Encoding is finished.
  		   
  QMessageBox* qmsgadv = new QMessageBox();
  qmsgadv->setText(i18n("The Encoding is now finished!\n"
  		   "Check if there were error message\n"
  		   "Have fun with Kencoder!"));
  qmsgadv->show();
  delete qmsgadv;
}

void kencoder::openIn() 
{
	QFileDialog* openI;
	openI = new QFileDialog(".","*.wav",this,"openI",TRUE);
	openI->setCaption(" Encode what ?");
	if (openI->exec()) LineEdIn->setText(openI->selectedFile());
	delete openI;
}

void kencoder::openOut() 
{
	QFileDialog* encodeas;
	encodeas = new QFileDialog(".","*.mp3",this,"encodeas",TRUE);
	encodeas->setCaption("Encode as ?");
	if (encodeas->exec()) LineEdOut->setText(encodeas->selectedFile());
	delete encodeas;
}



void kencoder::option()
{
	
        kpref *opdlg = new kpref(this,"opdlg");
        opdlg->exec();
        delete opdlg;
		
}

void kencoder::about()
{
        QMessageBox *qmsg3=new QMessageBox();
        qmsg3->setText("kencoder v0.1\n\n"
         "Written by COMMEROT Sami.\n"
         "<samlinux@france-mail.com>\n\n"
         "This program is covered by the GPL.");
        qmsg3->show();
	delete qmsg3;
}

void kencoder::askHelp()
{
	KApplication::getKApplication()->invokeHTMLHelp("","");
}

void kencoder::Encode()
{
	kencoder::encodeNow();
}



int main (int argc, char **argv)
{
        KApplication* a = new KApplication(argc, argv, QString("kencoder"));
        kencoder* k = new kencoder;
        k->setGeometry( 100, 100, 420, 260 );
        a->setMainWidget(k);
        k->show();
        return a->exec();
	delete a;
} 

