/*
    This file is part of CDLoop
    Copyright (C) 1997, 1998, 1999  Claus Brunzema (chb@ossi.fho-emden.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  -
  -  err.h
  -
  -  error handling
  -  Headerfile for err.c
  -
  -  Version 1.1
  -  Last change: 8-Mar-99
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#ifndef ERR_H_INCLUDED
#define ERR_H_INCLUDED

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  - void ERROR(const char *format, ...)
  -  prints ERROR: and the arguments (in a printf-like fashion) then exits
  -  with EXIT_FAILURE.
  -  in:  const char *format         - pointer to a format-string (see
  -                                    documentation of printf).
  -       ...                        - arguments to the format-string (see
  -                                    documentation of printf).
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void ERROR(const char *format, ...);

#endif
