/*
    This file is part of CDLoop
    Copyright (C) 1997, 1998, 1999  Claus Brunzema (chb@ossi.fho-emden.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  -
  -  err.c
  -
  -  error handling
  -
  -  Version 1.1
  -  Last change: 8-Mar-99
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include "err.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

void ERROR(const char *format, ...)
{  va_list arg;

   fprintf(stderr,"ERROR: ");
   va_start(arg,format);
   vfprintf(stderr,format,arg);
   va_end(arg);
   fprintf(stderr,"\n");
   _exit(EXIT_FAILURE);
}
