#!/usr/X11R6/bin/wish
#############################################################################
# Visual Tcl v1.20 Project
#

#################################
# GLOBAL VARIABLES
#
global GapLabelVar; 
global LocatorAPositionLabelVar; 
global LocatorBPositionLabelVar; 
global PositionLabelVar; 
global StatusLabelVar; 
global widget; 
    set widget(AboutWindow) {.top38}
    set widget(ClearFrame) {.top17.fra21}
    set widget(EjectCloseButton) {.top17.fra25.but30}
    set widget(GapFrame) {.top17.fra20}
    set widget(HelpWindow) {.top18}
    set widget(LocatorAFrame) {.top17.fra17}
    set widget(LocatorBFrame) {.top17.fra19}
    set widget(MainWindow) {.top17}
    set widget(PlayAtButtonsFrame) {.top17.fra31}
    set widget(PlayPauseButton) {.top17.fra25.but27}
    set widget(StatusLabel) {.top17.fra18.lab24}
    set widget(mgs) {.top19}
    set widget(rev,.top17) {MainWindow}
    set widget(rev,.top17.fra17) {LocatorAFrame}
    set widget(rev,.top17.fra18.lab22) {StatusLabel}
    set widget(rev,.top17.fra18.lab24) {StatusLabel}
    set widget(rev,.top17.fra19) {LocatorBFrame}
    set widget(rev,.top17.fra20) {GapFrame}
    set widget(rev,.top17.fra21) {ClearFrame}
    set widget(rev,.top17.fra25.but27) {PlayPauseButton}
    set widget(rev,.top17.fra25.but30) {EjectCloseButton}
    set widget(rev,.top17.fra31) {PlayAtButtonsFrame}
    set widget(rev,.top18) {HelpWindow}
    set widget(rev,.top19) {mgs}
    set widget(rev,.top38) {AboutWindow}

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
# $Id: cdloop.tcl,v 1.2 1999/06/04 13:10:46 chb Exp $
}

init $argc $argv


proc {MainWindow_resize_handler} {} {
global widget

set main_geom [ wm geometry $widget(MainWindow) ]
scan $main_geom "%dx%d%d%d" w h x y 

place $widget(PlayAtButtonsFrame) -height [ expr $h - 344 ]
place $widget(LocatorAFrame) -y [ expr $h - 169 ]
place $widget(LocatorBFrame) -y [ expr $h - 169 ]
place $widget(GapFrame) -y [ expr $h - 74 ]
place $widget(ClearFrame) -y [ expr $h - 74 ]
}

proc {destroyPlayAtButtons} {n} {
global widget

for { set i 1 } { $i <= $n } { incr i } {
  destroy $widget(PlayAtButtonsFrame).playAt$i
}
}

proc {initCDLoop} {} {
global argc
global argv

global geometry
global widget
global StatusLabelVar
global PositionLabelVar
global LocatorAPositionLabelVar
global LocatorBPositionLabelVar
global GapLabelVar
global Ticker
global n_track

global STATUSCHANGE
global TOCCHANGE
global POSCHANGE
global LOCACHANGE
global LOCBCHANGE
global GAPCHANGE


set CD_Device "/dev/cdrom"
set next_is_device 0
foreach arg $argv {
  if $next_is_device {
    set CD_Device $arg
    set next_is_device 0
  } else {
    switch -regexp -- $arg {
      -device  { set next_is_device 1 }
      -help    { puts stdout "CDLoop $Name: v1-2 $ by Claus Brunzema <chb@ossi.fho-emden.de>\n" 
                 puts stdout "Options: --help            display this message"
                 puts stdout "         --version         display version info"
                 puts stdout "         --device <device> set cd-drive special file"
                 puts stdout "                            default is /dev/cdrom\n"
                 exit
               }
      -version { puts stdout "CDLoop $Name: v1-2 $ by Claus Brunzema <chb@ossi.fho-emden.de>" 
                 exit 
               }
    }
  }
}

set STATUSCHANGE [ expr 1 << 0 ]
set TOCCHANGE    [ expr 1 << 1 ]
set POSCHANGE    [ expr 1 << 2 ]
set LOCACHANGE   [ expr 1 << 3 ]
set LOCBCHANGE   [ expr 1 << 4 ]
set GAPCHANGE    [ expr 1 << 5 ]

bind all <Key-1> { CD_play_at 1 }
bind all <Key-2> { CD_play_at 2 }
bind all <Key-3> { CD_play_at 3 }
bind all <Key-4> { CD_play_at 4 }
bind all <Key-5> { CD_play_at 5 }
bind all <Key-6> { CD_play_at 6 }
bind all <Key-7> { CD_play_at 7 }
bind all <Key-8> { CD_play_at 8 }
bind all <Key-9> { CD_play_at 9 }
bind all <Key-0> { CD_play_at 10 }
bind all <space> { CD_pause }
bind all <a> { CD_set_locator_a }
bind all <b> { CD_set_locator_b }
bind all <c> { CD_clear_locators }
bind all <n> { CD_play_next }
bind all <p> { CD_play }
bind all <v> { CD_play_prev }
bind all <r> { CD_restart }
bind all <s> { CD_stop }
bind all <q> { quitCDLoop }
bind $widget(MainWindow) <Configure> { MainWindow_resize_handler }

CD_init $CD_Device

wm title $widget(MainWindow) "CDLoop $CD_Device"
if [ info exists geometry ] {
  wm minsize $widget(MainWindow) 493 365
  wm maxsize $widget(MainWindow) 493 609
  wm geometry $widget(MainWindow) $geometry
}

set StatusLabelVar [ CD_get_status ]
if { [ string compare $StatusLabelVar "NO DISC" ] == 0 ||  [ string compare $StatusLabelVar "DATA" ] == 0 } {
  $widget(StatusLabel) config -foreground Red
} else {
  $widget(StatusLabel) config -foreground Black
}
set PositionLabelVar [ CD_get_pos ]
set LocatorAPositionLabelVar [ CD_get_locator_a ]
set LocatorBPositionLabelVar [ CD_get_locator_b ]
set GapLabelVar [ CD_get_gap ]

set Ticker 0
set n_track -1
}

proc {mainCDLoop} {} {
global STATUSCHANGE
global TOCCHANGE
global POSCHANGE
global LOCACHANGE
global LOCBCHANGE
global GAPCHANGE

global widget
global StatusLabelVar
global PositionLabelVar
global LocatorAPositionLabelVar
global LocatorBPositionLabelVar
global GapLabelVar

global Ticker
global n_track

while { 1 } {
  tkwait variable Ticker
  set changes [ CD_ask_changes ]
  if [ expr $changes & $TOCCHANGE ] {
    if $n_track>0 {
      destroyPlayAtButtons $n_track
    }
    set n_track [ CD_get_n_track ]
    if $n_track>0 {
      makePlayAtButtons $n_track
    }
  }
  if [ expr $changes & $STATUSCHANGE ] {
    set StatusLabelVar [ CD_get_status ]
    if { [ string compare $StatusLabelVar "NO DISC" ] == 0 ||  [ string compare $StatusLabelVar "DATA" ] == 0 } {
      $widget(StatusLabel) config -foreground Red
    } else {
      $widget(StatusLabel) config -foreground Black
    }
  }
  if [ expr $changes & $POSCHANGE ] {
    set PositionLabelVar [ CD_get_pos ]
  }  
  if [ expr $changes & $LOCACHANGE ] {
    set LocatorAPositionLabelVar [ CD_get_locator_a ]
  }
  if [ expr $changes & $LOCBCHANGE ] {
    set LocatorBPositionLabelVar [ CD_get_locator_b ]
  }
  if [ expr $changes & $GAPCHANGE ] {
    set GapLabelVar [ CD_get_gap ]
  }
}
}

proc {makePlayAtButtons} {n} {
global widget

set x 0
set y 0
for { set i 1 } { $i <= $n } { incr i } {
  set buttonpath $widget(PlayAtButtonsFrame).playAt$i
  button $buttonpath -text [ format "%02d" $i ] -font fixed -command "CD_play_at $i"
  place $buttonpath -in $widget(PlayAtButtonsFrame) -x $x -y $y -bordermode "inside"
  tkwait visibility $buttonpath
  set width [ XWinInteriorWidth $buttonpath ]
  set x [ expr $x + $width ]
  if { [ expr $x + $width ] > [ XWinInteriorWidth $widget(PlayAtButtonsFrame) ] } {
    set x 0
    set y [ expr $y + [ XWinInteriorHeight $buttonpath ]]
  } 
}
}

proc {quitCDLoop} {} {
CD_exit
exit
}

proc {main} {argc argv} {
#VTCL_PROTECT:initCDLoop
#VTCL_PROTECT:mainCDLoop
}

proc {Window} {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 1x1+0+0
    wm maxsize $base 1009 738
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "vt.tcl"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.top17 {base} {
    if {$base == ""} {
        set base .top17
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 493x405+281+208
    wm maxsize $base 1009 609
    wm minsize $base 1 365
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "CDLoop"
    frame $base.fra18 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    label $base.fra18.lab19 \
        -borderwidth 1 -font fixed -text Status 
    label $base.fra18.lab21 \
        -borderwidth 1 -font fixed -text Position 
    label $base.fra18.lab23 \
        -font fixed -relief ridge -text label -textvariable PositionLabelVar 
    label $base.fra18.lab24 \
        -font fixed -relief ridge -text label -textvariable StatusLabelVar 
    frame $base.fra25 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    button $base.fra25.but27 \
        -command CD_pause -font fixed -padx 9 -pady 3 -relief groove \
        -text Pause 
    button $base.fra25.but29 \
        -command CD_stop -font fixed -padx 9 -pady 3 -relief groove \
        -text Stop 
    button $base.fra25.but30 \
        -command CD_eject -font fixed -padx 9 -pady 3 -relief groove \
        -text Eject 
    button $base.fra25.but17 \
        -command {CD_search -100} -font fixed -padx 3 -pady 3 -relief groove \
        -text <<< 
    button $base.fra25.but18 \
        -command {CD_search -50} -font fixed -padx 3 -pady 3 -relief groove \
        -text << 
    button $base.fra25.but19 \
        -command {CD_search 50} -font fixed -padx 3 -pady 3 -relief groove \
        -text >> 
    button $base.fra25.but20 \
        -command {CD_search 100} -font fixed -padx 3 -pady 3 -relief groove \
        -text >>> 
    button $base.fra25.but21 \
        -command CD_close_tray -font fixed -padx 9 -pady 3 -relief groove \
        -text Close 
    button $base.fra25.but25 \
        -command CD_play -font fixed -padx 9 -pady 3 -relief groove \
        -text Play 
    button $base.fra25.but22 \
        -command CD_play_prev -font fixed -padx 9 -pady 3 -relief groove \
        -text Previous 
    button $base.fra25.but23 \
        -command CD_restart -font fixed -padx 9 -pady 3 -relief groove \
        -text Restart 
    button $base.fra25.but24 \
        -command CD_play_next -font fixed -padx 9 -pady 3 -relief groove \
        -text Next 
    frame $base.fra17 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    label $base.fra17.lab20 \
        -borderwidth 1 -font fixed -text {Locator A} 
    label $base.fra17.lab21 \
        -font fixed -relief ridge -text label \
        -textvariable LocatorAPositionLabelVar 
    button $base.fra17.but22 \
        -command CD_set_locator_a -font fixed -padx 9 -pady 3 -relief groove \
        -text Set 
    button $base.fra17.but18 \
        -borderwidth 1 -command {CD_move_locator_a -50} -font fixed -padx 3 \
        -pady 3 -relief groove -text <50 
    button $base.fra17.but20 \
        -borderwidth 1 -command {CD_move_locator_a -10} -font fixed -padx 3 \
        -pady 3 -relief groove -text <10 
    button $base.fra17.but21 \
        -borderwidth 1 -command {CD_move_locator_a -5} -font fixed -padx 3 \
        -pady 3 -relief groove -text <5 
    button $base.fra17.but23 \
        -borderwidth 1 -command {CD_move_locator_a -1} -font fixed -padx 3 \
        -pady 3 -relief groove -text <1 
    button $base.fra17.but24 \
        -borderwidth 1 -command {CD_move_locator_a 1} -font fixed -padx 3 \
        -pady 3 -text 1> 
    button $base.fra17.but25 \
        -borderwidth 1 -command {CD_move_locator_a 5} -font fixed -padx 3 \
        -pady 3 -relief groove -text 5> 
    button $base.fra17.but26 \
        -borderwidth 1 -command {CD_move_locator_a 10} -font fixed -padx 3 \
        -pady 3 -relief groove -text 10> 
    button $base.fra17.but27 \
        -borderwidth 1 -command {CD_move_locator_a 50} -font fixed -padx 3 \
        -pady 3 -relief groove -text 50> 
    frame $base.fra19 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    label $base.fra19.lab23 \
        -borderwidth 1 -font fixed -text {Locator B} 
    label $base.fra19.lab24 \
        -font fixed -relief ridge -text label \
        -textvariable LocatorBPositionLabelVar 
    button $base.fra19.but25 \
        -command CD_set_locator_b -font fixed -padx 9 -pady 3 -relief groove \
        -text Set 
    button $base.fra19.but29 \
        -borderwidth 1 -command {CD_move_locator_b -50} -font fixed -padx 3 \
        -pady 3 -relief groove -text <50 
    button $base.fra19.but30 \
        -borderwidth 1 -command {CD_move_locator_b -10} -font fixed -padx 3 \
        -pady 3 -relief groove -text <10 
    button $base.fra19.but31 \
        -borderwidth 1 -command {CD_move_locator_b -5} -font fixed -padx 3 \
        -pady 3 -relief groove -text <5 
    button $base.fra19.but32 \
        -borderwidth 1 -command {CD_move_locator_b -1} -font fixed -padx 3 \
        -pady 3 -relief groove -text <1 
    button $base.fra19.but33 \
        -borderwidth 1 -command {CD_move_locator_b 1} -font fixed -padx 3 \
        -pady 3 -text 1> 
    button $base.fra19.but34 \
        -borderwidth 1 -command {CD_move_locator_b 5} -font fixed -padx 3 \
        -pady 3 -relief groove -text 5> 
    button $base.fra19.but35 \
        -borderwidth 1 -command {CD_move_locator_b 10} -font fixed -padx 3 \
        -pady 3 -relief groove -text 10> 
    button $base.fra19.but36 \
        -borderwidth 1 -command {CD_move_locator_b 50} -font fixed -padx 3 \
        -pady 3 -relief groove -text 50> 
    button $base.fra19.but27 \
        -command CD_clear_locator_b -font fixed -padx 9 -pady 3 \
        -relief groove -text Clear 
    frame $base.fra21 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    button $base.fra21.but22 \
        -command CD_clear_locators -font fixed -padx 9 -pady 3 -relief groove \
        -text {Clear Locators} 
    button $base.fra21.but24 \
        -command {CD_set_gap 0} -font fixed -padx 9 -pady 3 -relief groove \
        -text {Clear Gap} 
    frame $base.fra20 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    label $base.fra20.lab21 \
        -borderwidth 1 -font fixed -text Gap 
    label $base.fra20.lab22 \
        -font fixed -relief ridge -text label -textvariable GapLabelVar 
    button $base.fra20.but23 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] + 50 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text +50 
    button $base.fra20.but32 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] +10 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text +10 
    button $base.fra20.but33 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] +5 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text +5 
    button $base.fra20.but35 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] +1 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text +1 
    button $base.fra20.but36 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] -1 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text -1 
    button $base.fra20.but37 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] -5 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text -5 
    button $base.fra20.but38 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] -10 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text -10 
    button $base.fra20.but39 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] -50 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text -50 
    button $base.fra20.but19 \
        -borderwidth 1 -command {CD_set_gap [ expr [ CD_get_gap ] + 50 ]} \
        -font fixed -padx 3 -pady 3 -relief groove -text +50 
    frame $base.fra22 \
        -borderwidth 2 -height 75 -relief groove -width 125 
    button $base.fra22.but23 \
        -command quitCDLoop -font fixed -padx 9 -pady 3 -relief groove \
        -text Quit 
    button $base.fra22.but24 \
        -command {Window show $widget(AboutWindow)} -font fixed -padx 9 \
        -pady 3 -relief groove -text About 
    button $base.fra22.but17 \
        -command {Window show $widget(HelpWindow)} -font fixed -padx 9 \
        -pady 3 -relief groove -text Help 
    frame $base.fra31 \
        -borderwidth 2 -height 75 -width 125 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.fra18 \
        -x 5 -y 50 -width 485 -height 40 -anchor nw -bordermode ignore 
    place $base.fra18.lab19 \
        -x 10 -y 10 -anchor nw -bordermode ignore 
    place $base.fra18.lab21 \
        -x 245 -y 10 -anchor nw -bordermode ignore 
    place $base.fra18.lab23 \
        -x 310 -y 10 -width 76 -height 18 -anchor nw -bordermode ignore 
    place $base.fra18.lab24 \
        -x 65 -y 10 -width 76 -height 18 -anchor nw -bordermode ignore 
    place $base.fra25 \
        -x 5 -y 95 -width 485 -height 70 -anchor nw -bordermode ignore 
    place $base.fra25.but27 \
        -x 210 -y 5 -width 56 -height 27 -anchor nw -bordermode ignore 
    place $base.fra25.but29 \
        -x 280 -y 5 -width 55 -height 27 -anchor nw -bordermode ignore 
    place $base.fra25.but30 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra25.but17 \
        -x 350 -y 5 -anchor nw -bordermode ignore 
    place $base.fra25.but18 \
        -x 385 -y 5 -anchor nw -bordermode ignore 
    place $base.fra25.but19 \
        -x 415 -y 5 -anchor nw -bordermode ignore 
    place $base.fra25.but20 \
        -x 445 -y 5 -anchor nw -bordermode ignore 
    place $base.fra25.but21 \
        -x 65 -y 5 -anchor nw -bordermode ignore 
    place $base.fra25.but25 \
        -x 140 -y 5 -width 55 -height 27 -anchor nw -bordermode ignore 
    place $base.fra25.but22 \
        -x 115 -y 35 -width 79 -height 27 -anchor nw -bordermode ignore 
    place $base.fra25.but23 \
        -x 205 -y 35 -width 68 -height 27 -anchor nw -bordermode ignore 
    place $base.fra25.but24 \
        -x 280 -y 35 -width 75 -height 27 -anchor nw -bordermode ignore 
    place $base.fra17 \
        -x 5 -y 235 -width 240 -height 90 -anchor nw -bordermode ignore 
    place $base.fra17.lab20 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra17.lab21 \
        -x 75 -y 5 -width 76 -height 18 -anchor nw -bordermode ignore 
    place $base.fra17.but22 \
        -x 5 -y 25 -anchor nw -bordermode ignore 
    place $base.fra17.but18 \
        -x 5 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.but20 \
        -x 35 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.but21 \
        -x 65 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.but23 \
        -x 90 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.but24 \
        -x 125 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.but25 \
        -x 150 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.but26 \
        -x 175 -y 55 -anchor nw -bordermode ignore 
    place $base.fra17.but27 \
        -x 205 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19 \
        -x 250 -y 235 -width 240 -height 90 -anchor nw -bordermode ignore 
    place $base.fra19.lab23 \
        -x 5 -y 5 -anchor nw -bordermode ignore 
    place $base.fra19.lab24 \
        -x 75 -y 5 -width 76 -height 18 -anchor nw -bordermode ignore 
    place $base.fra19.but25 \
        -x 5 -y 25 -anchor nw -bordermode ignore 
    place $base.fra19.but29 \
        -x 5 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but30 \
        -x 35 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but31 \
        -x 65 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but32 \
        -x 90 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but33 \
        -x 125 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but34 \
        -x 150 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but35 \
        -x 175 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but36 \
        -x 205 -y 55 -anchor nw -bordermode ignore 
    place $base.fra19.but27 \
        -x 75 -y 25 -anchor nw -bordermode ignore 
    place $base.fra21 \
        -x 250 -y 330 -width 240 -height 70 -anchor nw -bordermode ignore 
    place $base.fra21.but22 \
        -x 5 -y 5 -width 110 -height 27 -anchor nw -bordermode ignore 
    place $base.fra21.but24 \
        -x 5 -y 35 -width 110 -height 27 -anchor nw -bordermode ignore 
    place $base.fra20 \
        -x 5 -y 330 -width 240 -height 70 -anchor nw -bordermode ignore 
    place $base.fra20.lab21 \
        -x 5 -y 10 -anchor nw -bordermode ignore 
    place $base.fra20.lab22 \
        -x 75 -y 10 -width 76 -height 18 -anchor nw -bordermode ignore 
    place $base.fra20.but23 \
        -x 5 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but32 \
        -x 35 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but33 \
        -x 65 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but35 \
        -x 90 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but36 \
        -x 125 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but37 \
        -x 150 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but38 \
        -x 175 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but39 \
        -x 205 -y 35 -anchor nw -bordermode ignore 
    place $base.fra20.but19 \
        -x 5 -y 35 -anchor nw -bordermode ignore 
    place $base.fra22 \
        -x 5 -y 5 -width 485 -height 40 -anchor nw -bordermode ignore 
    place $base.fra22.but23 \
        -x 5 -y 5 -width 51 -height 28 -anchor nw -bordermode ignore 
    place $base.fra22.but24 \
        -x 60 -y 5 -anchor nw -bordermode ignore 
    place $base.fra22.but17 \
        -x 420 -y 5 -anchor nw -bordermode ignore 
    place $base.fra31 \
        -x 5 -y 165 -width 485 -height 70 -anchor nw -bordermode ignore 
}

proc vTclWindow.top18 {base} {
    if {$base == ""} {
        set base .top18
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 262x258+380+169
    wm maxsize $base 1009 738
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm title $base "Help"
    label $base.lab19 \
        -borderwidth 1 -font fixed -text {Keyboard shortcuts:} 
    label $base.lab20 \
        -borderwidth 1 -font fixed \
        -text {1,2,...,9,0  start playing the track} 
    label $base.lab21 \
        -borderwidth 1 -font fixed -text {(0 starts playing track 10)} 
    label $base.lab22 \
        -borderwidth 1 -font fixed -text {<space>      Pause} 
    label $base.lab23 \
        -borderwidth 1 -font fixed -text {a            set locator A} 
    label $base.lab24 \
        -borderwidth 1 -font fixed -text {b            set locator B} 
    label $base.lab25 \
        -borderwidth 1 -font fixed -text {c            clear locators} 
    label $base.lab26 \
        -borderwidth 1 -font fixed -text {n            play next track} 
    label $base.lab27 \
        -borderwidth 1 -font fixed -text {p            play} 
    label $base.lab28 \
        -borderwidth 1 -font fixed -text {q            quit CDLoop} 
    label $base.lab29 \
        -borderwidth 1 -font fixed -text {r            restart track/loop} 
    label $base.lab30 \
        -borderwidth 1 -font fixed -text {s            stop} 
    label $base.lab31 \
        -borderwidth 1 -font fixed -text {v            play previous track} 
    button $base.but32 \
        -command {Window hide $widget(HelpWindow)} -font fixed -padx 9 \
        -pady 3 -relief groove -text Close 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.lab19 \
        -x 10 -y 10 -anchor nw -bordermode ignore 
    place $base.lab20 \
        -x 10 -y 30 -anchor nw -bordermode ignore 
    place $base.lab21 \
        -x 85 -y 45 -anchor nw -bordermode ignore 
    place $base.lab22 \
        -x 10 -y 60 -anchor nw -bordermode ignore 
    place $base.lab23 \
        -x 10 -y 75 -anchor nw -bordermode ignore 
    place $base.lab24 \
        -x 10 -y 90 -anchor nw -bordermode ignore 
    place $base.lab25 \
        -x 10 -y 105 -anchor nw -bordermode ignore 
    place $base.lab26 \
        -x 10 -y 120 -anchor nw -bordermode ignore 
    place $base.lab27 \
        -x 10 -y 135 -anchor nw -bordermode ignore 
    place $base.lab28 \
        -x 10 -y 150 -anchor nw -bordermode ignore 
    place $base.lab29 \
        -x 10 -y 165 -anchor nw -bordermode ignore 
    place $base.lab30 \
        -x 10 -y 180 -anchor nw -bordermode ignore 
    place $base.lab31 \
        -x 10 -y 195 -anchor nw -bordermode ignore 
    place $base.but32 \
        -x 95 -y 220 -anchor nw -bordermode ignore 
}

proc vTclWindow.top38 {base} {
    if {$base == ""} {
        set base .top38
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 283x355+368+171
    wm maxsize $base 1009 738
    wm minsize $base 1 1
    wm overrideredirect $base 0
    wm resizable $base 0 0
    wm title $base "About CDLoop"
    label $base.lab42  -borderwidth 1 -font fixed -text {CDLoop $Name: v1-2 $} 
    label $base.lab43  -borderwidth 1 -font fixed -text {An Audio-CD-Player for Linux/X11} 
    label $base.lab44  -borderwidth 1 -font fixed  -text {Copyright (C) 1997-1999 by Claus Brunzema} 
    label $base.lab45  -borderwidth 1 -font fixed  -text {Comments, suggestions and donations to:} 
    label $base.lab46  -borderwidth 1 -font fixed -text chb@ossi.fho-emden.de 
    button $base.but47  -command {Window hide $widget(AboutWindow)} -font fixed -padx 9  -pady 3 -relief groove -text Close 
    label $base.lab36  -borderwidth 1 -font fixed -text {CDLoop comes with} 
    label $base.lab37  -borderwidth 1 -font fixed -text {ABSOLUTELY NO WARRANTY} 
    label $base.lab38  -borderwidth 1 -font fixed -text {This is free software distributed} 
    label $base.lab39  -borderwidth 1 -font fixed -text {under the terms of the GNU GENERAL} 
    label $base.lab40  -borderwidth 1 -font fixed -text {PUBLIC LICENSE Version 2. You are} 
    label $base.lab41  -borderwidth 1 -font fixed  -text {welcome to redistribute CDLoop under} 
    label $base.lab48  -borderwidth 1 -font fixed -text {certain conditions. Read the file} 
    label $base.lab49  -borderwidth 1 -font fixed  -text {COPYING included in the CDLoop-package} 
    label $base.lab50  -borderwidth 1 -font fixed -text {for more information.} 
    ###################
    # SETTING GEOMETRY
    ###################
    place $base.lab42  -x 70 -y 10 -width 134 -height 17 -anchor nw -bordermode ignore 
    place $base.lab43  -x 40 -y 35 -anchor nw -bordermode ignore 
    place $base.lab44  -x 15 -y 60 -anchor nw -bordermode ignore 
    place $base.lab45  -x 10 -y 265 -anchor nw -bordermode ignore 
    place $base.lab46  -x 10 -y 285 -anchor nw -bordermode ignore 
    place $base.but47  -x 110 -y 315 -anchor nw -bordermode ignore 
    place $base.lab36  -x 85 -y 95 -anchor nw -bordermode ignore 
    place $base.lab37  -x 75 -y 115 -anchor nw -bordermode ignore 
    place $base.lab38  -x 35 -y 145 -anchor nw -bordermode ignore 
    place $base.lab39  -x 35 -y 160 -anchor nw -bordermode ignore 
    place $base.lab40  -x 35 -y 175 -anchor nw -bordermode ignore 
    place $base.lab41  -x 35 -y 190 -anchor nw -bordermode ignore 
    place $base.lab48  -x 35 -y 205 -anchor nw -bordermode ignore 
    place $base.lab49  -x 35 -y 220 -anchor nw -bordermode ignore 
    place $base.lab50  -x 35 -y 235 -anchor nw -bordermode ignore
}

Window show .
Window show .top17

main $argc $argv
